/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.inversion;

import com.google.common.base.Preconditions;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.opensha.commons.util.IDPairing;
import org.opensha.sha.faultSurface.FaultSection;
import scratch.UCERF3.enumTreeBranches.DeformationModels;
import scratch.UCERF3.enumTreeBranches.FaultModels;
import scratch.UCERF3.inversion.OldSectionConnectionStrategy;
import scratch.UCERF3.inversion.SectionCluster;
import scratch.UCERF3.inversion.laughTest.OldPlausibilityConfiguration;
import scratch.UCERF3.utils.DeformationModelFetcher;

public class SectionClusterList
extends ArrayList<SectionCluster> {
    private static final long serialVersionUID = 1L;
    public static final boolean D = false;
    private List<List<Integer>> sectionConnectionsListList;
    private OldPlausibilityConfiguration plausibility;
    private List<? extends FaultSection> faultSectionData;
    private Map<IDPairing, Double> subSectionDistances;

    public SectionClusterList(FaultModels faultModel, DeformationModels defModel, File precomputedDataDir, OldSectionConnectionStrategy connectionStrategy, OldPlausibilityConfiguration plausibility) {
        this(new DeformationModelFetcher(faultModel, defModel, precomputedDataDir, 0.1), connectionStrategy, plausibility);
    }

    public SectionClusterList(DeformationModelFetcher defModelFetcher, OldSectionConnectionStrategy connectionStrategy, OldPlausibilityConfiguration plausibility) {
        this.faultSectionData = defModelFetcher.getSubSectionList();
        Map<IDPairing, Double> subSectionDistances = defModelFetcher.getSubSectionDistanceMap(plausibility.getMaxJumpDist());
        Map<IDPairing, Double> subSectionAzimuths = defModelFetcher.getSubSectionAzimuthMap(subSectionDistances.keySet());
        this.init(connectionStrategy, plausibility, this.faultSectionData, subSectionDistances, subSectionAzimuths);
    }

    public SectionClusterList(OldSectionConnectionStrategy connectionStrategy, OldPlausibilityConfiguration plausibility, List<? extends FaultSection> faultSectionData, Map<IDPairing, Double> subSectionDistances, Map<IDPairing, Double> subSectionAzimuths) {
        this.init(connectionStrategy, plausibility, faultSectionData, subSectionDistances, subSectionAzimuths);
    }

    private void init(OldSectionConnectionStrategy connectionStrategy, OldPlausibilityConfiguration plausibility, List<? extends FaultSection> faultSectionData, Map<IDPairing, Double> subSectionDistances, Map<IDPairing, Double> subSectionAzimuths) {
        this.plausibility = plausibility;
        this.subSectionDistances = subSectionDistances;
        this.faultSectionData = faultSectionData;
        for (int i = 0; i < faultSectionData.size(); ++i) {
            Preconditions.checkState((faultSectionData.get(i).getSectionId() == i ? 1 : 0) != 0, (Object)"RupsInFaultSystemInversion: Error - indices of faultSectionData don't match IDs");
        }
        this.makeClusterList(connectionStrategy, subSectionAzimuths, subSectionDistances);
        plausibility.buildPlausibilityFilters(subSectionAzimuths, subSectionDistances, this.sectionConnectionsListList, faultSectionData);
    }

    private void makeClusterList(OldSectionConnectionStrategy connectionStrategy, Map<IDPairing, Double> subSectionAzimuths, Map<IDPairing, Double> subSectionDistances) {
        int i;
        this.sectionConnectionsListList = connectionStrategy.computeCloseSubSectionsListList(this.faultSectionData, subSectionDistances);
        HashSet<Integer> subSectsToIgnore = null;
        if (this.plausibility.getParentSectsToIgnore() != null) {
            HashSet<Integer> parentSectsToIgnore = this.plausibility.getParentSectsToIgnore();
            subSectsToIgnore = new HashSet<Integer>();
            for (FaultSection faultSection : this.faultSectionData) {
                if (!parentSectsToIgnore.contains(faultSection.getParentSectionId())) continue;
                subSectsToIgnore.add(faultSection.getSectionId());
            }
            for (i = 0; i < this.sectionConnectionsListList.size(); ++i) {
                List<Integer> list = this.sectionConnectionsListList.get(i);
                if (subSectsToIgnore.contains(i)) {
                    list.clear();
                }
                int j = list.size();
                while (--j >= 0) {
                    if (!subSectsToIgnore.contains(list.get(j))) continue;
                    list.remove(j);
                }
            }
        }
        ArrayList<Integer> availableSections = new ArrayList<Integer>();
        for (i = 0; i < this.faultSectionData.size(); ++i) {
            if (subSectsToIgnore != null && subSectsToIgnore.contains(i)) continue;
            availableSections.add(i);
        }
        while (availableSections.size() > 0) {
            int firstSubSection = (Integer)availableSections.get(0);
            SectionCluster sectionCluster = new SectionCluster(this.plausibility, this.faultSectionData, connectionStrategy, this.sectionConnectionsListList, subSectionAzimuths, subSectionDistances);
            sectionCluster.add(firstSubSection);
            SectionClusterList.addClusterLinks(firstSubSection, sectionCluster, this.sectionConnectionsListList);
            for (int i2 = 0; i2 < sectionCluster.size(); ++i2) {
                availableSections.remove(sectionCluster.get(i2));
            }
            this.add(sectionCluster);
        }
    }

    static void addClusterLinks(int subSectIndex, SectionCluster list, List<List<Integer>> sectionConnectionsListList) {
        List<Integer> branches = sectionConnectionsListList.get(subSectIndex);
        for (int i = 0; i < branches.size(); ++i) {
            Integer subSect = branches.get(i);
            if (list.contains(subSect)) continue;
            list.add(subSect);
            SectionClusterList.addClusterLinks(subSect, list, sectionConnectionsListList);
        }
    }

    public static boolean isD() {
        return false;
    }

    public List<List<Integer>> getSectionConnectionsListList() {
        return this.sectionConnectionsListList;
    }

    public OldPlausibilityConfiguration getPlausibilityConfiguration() {
        return this.plausibility;
    }

    public List<? extends FaultSection> getFaultSectionData() {
        return this.faultSectionData;
    }

    public Map<IDPairing, Double> getSubSectionDistances() {
        return this.subSectionDistances;
    }
}

