/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.inversion;

import cern.colt.function.tdouble.IntIntDoubleFunction;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.opensha.commons.data.uncertainty.BoundedUncertainty;
import org.opensha.commons.eq.MagUtils;
import org.opensha.commons.geo.Location;
import org.opensha.commons.util.FileUtils;
import org.opensha.commons.util.IDPairing;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.inversion.InversionInputGenerator;
import org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.ConstraintWeightingType;
import org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.InversionConstraint;
import org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.impl.APrioriInversionConstraint;
import org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.impl.MFDInversionConstraint;
import org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.impl.MFDLaplacianSmoothingInversionConstraint;
import org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.impl.MFDParticipationSmoothnessInversionConstraint;
import org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.impl.PaleoProbabilityModel;
import org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.impl.PaleoRateInversionConstraint;
import org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.impl.PaleoSlipInversionConstraint;
import org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.impl.PaleoVisibleEventRateSmoothnessInversionConstraint;
import org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.impl.ParkfieldInversionConstraint;
import org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.impl.RupRateMinimizationConstraint;
import org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.impl.RupRateSmoothingInversionConstraint;
import org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.impl.SlipRateInversionConstraint;
import org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.impl.TotalMomentInversionConstraint;
import org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.impl.U3MFDSubSectNuclInversionConstraint;
import org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.impl.UncertainDataConstraint;
import org.opensha.sha.earthquake.faultSysSolution.inversion.sa.ConstraintRange;
import org.opensha.sha.earthquake.faultSysSolution.modules.InversionTargetMFDs;
import org.opensha.sha.earthquake.faultSysSolution.modules.ModSectMinMags;
import org.opensha.sha.faultSurface.FaultSection;
import org.opensha.sha.magdist.IncrementalMagFreqDist;
import scratch.UCERF3.analysis.FaultSystemRupSetCalc;
import scratch.UCERF3.enumTreeBranches.FaultModels;
import scratch.UCERF3.enumTreeBranches.InversionModels;
import scratch.UCERF3.inversion.CommandLineInversionRunner;
import scratch.UCERF3.inversion.InversionFaultSystemRupSet;
import scratch.UCERF3.inversion.InversionFaultSystemRupSetFactory;
import scratch.UCERF3.inversion.U3InversionConfigFactory;
import scratch.UCERF3.inversion.U3InversionTargetMFDs;
import scratch.UCERF3.inversion.UCERF3InversionConfiguration;
import scratch.UCERF3.logicTree.U3LogicTreeBranch;
import scratch.UCERF3.utils.U3SectionMFD_constraint;
import scratch.UCERF3.utils.aveSlip.U3AveSlipConstraint;
import scratch.UCERF3.utils.paleoRateConstraints.U3PaleoRateConstraint;
import scratch.UCERF3.utils.paleoRateConstraints.UCERF3_PaleoProbabilityModel;

public class UCERF3InversionInputGenerator
extends InversionInputGenerator {
    private static final boolean D = false;
    private static final boolean QUICK_GETS_SETS = true;
    private FaultSystemRupSet rupSet;
    private UCERF3InversionConfiguration config;
    private List<? extends UncertainDataConstraint.SectMappedUncertainDataConstraint> paleoRateConstraints;
    private List<? extends UncertainDataConstraint.SectMappedUncertainDataConstraint> aveSlipConstraints;
    private double[] improbabilityConstraint;
    private PaleoProbabilityModel paleoProbabilityModel;
    private static PaleoProbabilityModel defaultProbModel = null;
    private static boolean test_double_percision = true;

    public UCERF3InversionInputGenerator(FaultSystemRupSet rupSet, UCERF3InversionConfiguration config, List<? extends UncertainDataConstraint.SectMappedUncertainDataConstraint> paleoRateConstraints, List<? extends UncertainDataConstraint.SectMappedUncertainDataConstraint> aveSlipConstraints, double[] improbabilityConstraint, PaleoProbabilityModel paleoProbabilityModel) {
        super(rupSet, UCERF3InversionInputGenerator.buildConstraints(rupSet, config, paleoRateConstraints, aveSlipConstraints, paleoProbabilityModel), config.getInitialRupModel(), UCERF3InversionInputGenerator.buildWaterLevel(config, rupSet));
        this.rupSet = rupSet;
        this.config = config;
        this.paleoRateConstraints = paleoRateConstraints;
        this.improbabilityConstraint = improbabilityConstraint;
        this.aveSlipConstraints = aveSlipConstraints;
        this.paleoProbabilityModel = paleoProbabilityModel;
    }

    public static PaleoProbabilityModel loadDefaultPaleoProbabilityModel() throws IOException {
        if (defaultProbModel == null) {
            defaultProbModel = UCERF3_PaleoProbabilityModel.load();
        }
        return defaultProbModel;
    }

    public static List<InversionConstraint> buildConstraints(FaultSystemRupSet rupSet, UCERF3InversionConfiguration config, List<? extends UncertainDataConstraint.SectMappedUncertainDataConstraint> paleoRateConstraints, List<? extends UncertainDataConstraint.SectMappedUncertainDataConstraint> aveSlipConstraints, PaleoProbabilityModel paleoProbabilityModel) {
        ArrayList<InversionConstraint> constraints = new ArrayList<InversionConstraint>();
        if (config.getSlipRateConstraintWt_normalized() > 0.0) {
            constraints.add(new SlipRateInversionConstraint(config.getSlipRateConstraintWt_normalized(), ConstraintWeightingType.NORMALIZED, rupSet));
        }
        if (config.getSlipRateConstraintWt_unnormalized() > 0.0) {
            constraints.add(new SlipRateInversionConstraint(config.getSlipRateConstraintWt_unnormalized(), ConstraintWeightingType.UNNORMALIZED, rupSet));
        }
        if (config.getPaleoRateConstraintWt() > 0.0) {
            constraints.add(new PaleoRateInversionConstraint(rupSet, config.getPaleoRateConstraintWt(), paleoRateConstraints, paleoProbabilityModel));
        }
        if (config.getPaleoSlipConstraintWt() > 0.0) {
            constraints.add(new PaleoSlipInversionConstraint.UCERF3(rupSet, config.getPaleoSlipConstraintWt(), aveSlipConstraints, U3AveSlipConstraint.slip_prob_model));
        }
        if (config.getRupRateConstraintWt() > 0.0) {
            double zeroRupRateConstraintWt = 0.0;
            if (config.isAPrioriConstraintForZeroRates()) {
                zeroRupRateConstraintWt = config.getRupRateConstraintWt() * config.getAPrioriConstraintForZeroRatesWtFactor();
            }
            constraints.add(new APrioriInversionConstraint(config.getRupRateConstraintWt(), zeroRupRateConstraintWt, config.getA_PrioriRupConstraint()));
        }
        if (config.getRupRateSmoothingConstraintWt() > 0.0) {
            constraints.add(new RupRateSmoothingInversionConstraint(config.getRupRateSmoothingConstraintWt(), rupSet));
        }
        if (config.getMinimizationConstraintWt() > 0.0) {
            ModSectMinMags modMinMags = rupSet.requireModule(ModSectMinMags.class);
            Preconditions.checkNotNull((Object)modMinMags, (Object)"Rupture set must supply ModSectMinMags if minimization constraint is enabled");
            ArrayList<Integer> belowMinIndexes = new ArrayList<Integer>();
            for (int r = 0; r < rupSet.getNumRuptures(); ++r) {
                if (!FaultSystemRupSetCalc.isRuptureBelowSectMinMag(rupSet, r, modMinMags)) continue;
                belowMinIndexes.add(r);
            }
            constraints.add(new RupRateMinimizationConstraint(config.getMinimizationConstraintWt(), belowMinIndexes));
        }
        if (config.getMagnitudeEqualityConstraintWt() > 0.0) {
            HashSet<Integer> excludeRupIndexes = null;
            if (config.isExcludeParkfieldRupsFromMfdEqualityConstraints() && config.getParkfieldConstraintWt() > 0.0) {
                excludeRupIndexes = new HashSet<Integer>();
                int parkfieldParentSectID = 32;
                List<Integer> potentialRups = rupSet.getRupturesForParentSection(parkfieldParentSectID);
                block1: for (int i = 0; i < potentialRups.size(); ++i) {
                    List<Integer> list = rupSet.getSectionsIndicesForRup(potentialRups.get(i));
                    if (list.size() < 6 || list.size() > 8) continue;
                    for (int s = 0; s < list.size(); ++s) {
                        int parent = rupSet.getFaultSectionData(list.get(s)).getParentSectionId();
                        if (parent != parkfieldParentSectID) continue block1;
                    }
                    excludeRupIndexes.add(potentialRups.get(i));
                }
            }
            constraints.add(new MFDInversionConstraint(rupSet, config.getMagnitudeEqualityConstraintWt(), false, ConstraintWeightingType.NORMALIZED, config.getMfdEqualityConstraints(), excludeRupIndexes));
        }
        if (config.getMagnitudeInequalityConstraintWt() > 0.0) {
            constraints.add(new MFDInversionConstraint(rupSet, config.getMagnitudeInequalityConstraintWt(), true, ConstraintWeightingType.NORMALIZED, config.getMfdInequalityConstraints(), null));
        }
        if (config.getParticipationSmoothnessConstraintWt() > 0.0) {
            constraints.add(new MFDParticipationSmoothnessInversionConstraint(rupSet, config.getParticipationSmoothnessConstraintWt(), config.getParticipationConstraintMagBinSize()));
        }
        ArrayList<U3SectionMFD_constraint> MFDConstraints = null;
        if (config.getNucleationMFDConstraintWt() > 0.0) {
            MFDConstraints = FaultSystemRupSetCalc.getCharInversionSectMFD_Constraints(rupSet);
            constraints.add(new U3MFDSubSectNuclInversionConstraint(rupSet, config.getNucleationMFDConstraintWt(), MFDConstraints));
        }
        if (config.getMFDSmoothnessConstraintWt() > 0.0 || config.getMFDSmoothnessConstraintWtForPaleoParents() > 0.0) {
            int paleoParentID;
            int i;
            if (MFDConstraints == null) {
                MFDConstraints = FaultSystemRupSetCalc.getCharInversionSectMFD_Constraints(rupSet);
            }
            HashSet<Integer> paleoParentIDs = new HashSet<Integer>();
            if (config.getPaleoRateConstraintWt() > 0.0) {
                for (i = 0; i < paleoRateConstraints.size(); ++i) {
                    paleoParentID = rupSet.getFaultSectionDataList().get(paleoRateConstraints.get((int)i).sectionIndex).getParentSectionId();
                    paleoParentIDs.add(paleoParentID);
                }
            }
            if (config.getPaleoSlipConstraintWt() > 0.0) {
                for (i = 0; i < aveSlipConstraints.size(); ++i) {
                    paleoParentID = rupSet.getFaultSectionDataList().get(aveSlipConstraints.get((int)i).sectionIndex).getParentSectionId();
                    paleoParentIDs.add(paleoParentID);
                }
            }
            if (config.getMFDSmoothnessConstraintWt() > 0.0) {
                HashSet<Integer> nonPaleoParentIDs = null;
                if (config.getMFDSmoothnessConstraintWtForPaleoParents() > 0.0) {
                    nonPaleoParentIDs = new HashSet<Integer>();
                    for (FaultSection faultSection : rupSet.getFaultSectionDataList()) {
                        if (paleoParentIDs.contains(faultSection.getParentSectionId())) continue;
                        nonPaleoParentIDs.add(faultSection.getParentSectionId());
                    }
                }
                constraints.add(new MFDLaplacianSmoothingInversionConstraint(rupSet, config.getMFDSmoothnessConstraintWt(), nonPaleoParentIDs, MFDConstraints));
            }
            if (config.getMFDSmoothnessConstraintWtForPaleoParents() > 0.0) {
                constraints.add(new MFDLaplacianSmoothingInversionConstraint(rupSet, config.getMFDSmoothnessConstraintWtForPaleoParents(), paleoParentIDs, MFDConstraints));
            }
        }
        if (config.getMomentConstraintWt() > 0.0) {
            constraints.add(new TotalMomentInversionConstraint(rupSet, config.getMomentConstraintWt(), FaultSystemRupSetCalc.getTotalReducedMomentRate(rupSet)));
        }
        if (config.getParkfieldConstraintWt() > 0.0) {
            double ParkfieldConstraintWt = config.getParkfieldConstraintWt();
            double ParkfieldMeanRate = 0.04;
            List<Integer> parkfieldRups = UCERF3InversionInputGenerator.findParkfieldRups(rupSet);
            constraints.add(new ParkfieldInversionConstraint(ParkfieldConstraintWt, ParkfieldMeanRate, parkfieldRups));
        }
        if (config.getEventRateSmoothnessWt() > 0.0) {
            constraints.add(new PaleoVisibleEventRateSmoothnessInversionConstraint(rupSet, config.getEventRateSmoothnessWt(), paleoProbabilityModel));
        }
        return constraints;
    }

    private static double[] buildWaterLevel(UCERF3InversionConfiguration config, FaultSystemRupSet rupSet) {
        double minimumRuptureRateFraction = config.getMinimumRuptureRateFraction();
        if (minimumRuptureRateFraction > 0.0) {
            double[] minimumRuptureRateBasis = config.getMinimumRuptureRateBasis();
            Preconditions.checkNotNull((Object)minimumRuptureRateBasis, (Object)"minimum rate fraction specified but no minimum rate basis given!");
            boolean allZeros = true;
            int numRuptures = rupSet.getNumRuptures();
            for (int i = 0; i < numRuptures; ++i) {
                if (!(minimumRuptureRateBasis[i] > 0.0)) continue;
                allZeros = false;
                break;
            }
            Preconditions.checkState((!allZeros ? 1 : 0) != 0, (Object)"cannot set water level when water level rates are all zero!");
            double[] minimumRuptureRates = new double[numRuptures];
            for (int i = 0; i < numRuptures; ++i) {
                minimumRuptureRates[i] = minimumRuptureRateBasis[i] * minimumRuptureRateFraction;
            }
            return minimumRuptureRates;
        }
        return null;
    }

    @Override
    public void generateInputs() {
        this.generateInputs(null, false);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public void generateInputsOld(Class<? extends DoubleMatrix2D> clazz) {
        int rupIndex;
        int numPaleoRows;
        int numRows;
        Preconditions.checkState((boolean)(this.rupSet instanceof InversionFaultSystemRupSet));
        InversionFaultSystemRupSet rupSet = (InversionFaultSystemRupSet)this.rupSet;
        int numSections = rupSet.getNumSections();
        int numRuptures = rupSet.getNumRuptures();
        this.initialSolution = this.config.getInitialRupModel();
        this.waterLevelRates = null;
        if (this.initialSolution == null) {
            this.initialSolution = new double[numRuptures];
        }
        Preconditions.checkState((this.initialSolution.length == numRuptures ? 1 : 0) != 0);
        Preconditions.checkState((this.config.getA_PrioriRupConstraint() == null || this.config.getA_PrioriRupConstraint().length == numRuptures ? 1 : 0) != 0);
        Preconditions.checkState((this.config.getMinimumRuptureRateBasis() == null || this.config.getMinimumRuptureRateBasis().length == numRuptures ? 1 : 0) != 0);
        double minimumRuptureRateFraction = this.config.getMinimumRuptureRateFraction();
        if (minimumRuptureRateFraction > 0.0) {
            int i;
            double[] minimumRuptureRateBasis = this.config.getMinimumRuptureRateBasis();
            Preconditions.checkNotNull((Object)minimumRuptureRateBasis, (Object)"minimum rate fraction specified but no minimum rate basis given!");
            boolean allZeros = true;
            for (i = 0; i < numRuptures; ++i) {
                if (!(minimumRuptureRateBasis[i] > 0.0)) continue;
                allZeros = false;
                break;
            }
            Preconditions.checkState((!allZeros ? 1 : 0) != 0, (Object)"cannot set water level when water level rates are all zero!");
            this.waterLevelRates = new double[this.initialSolution.length];
            for (i = 0; i < numRuptures; ++i) {
                this.waterLevelRates[i] = minimumRuptureRateBasis[i] * minimumRuptureRateFraction;
            }
        }
        double[] sectSlipRateReduced = rupSet.getSlipRateForAllSections();
        double[] rupMeanMag = rupSet.getMagForAllRups();
        this.constraintRowRanges = new ArrayList();
        int numSlipRateConstraints = 0;
        if (this.config.getSlipRateConstraintWt_normalized() > 0.0) {
            numSlipRateConstraints += numSections;
        }
        if (this.config.getSlipRateConstraintWt_unnormalized() > 0.0) {
            numSlipRateConstraints += numSections;
        }
        if ((numRows = numSlipRateConstraints) > 0) {
            this.constraintRowRanges.add(new ConstraintRange("Slip Rate", "Slip Rate", 0, numRows, false, Double.NaN, null));
        }
        if ((numPaleoRows = (int)Math.signum(this.config.getPaleoRateConstraintWt()) * this.paleoRateConstraints.size()) > 0) {
            this.constraintRowRanges.add(new ConstraintRange("Paleo Event Rates", "Paleo Event Rates", ((ConstraintRange)this.constraintRowRanges.get((int)(this.constraintRowRanges.size() - 1))).endRow, numRows += numPaleoRows, false, Double.NaN, null));
        }
        if (this.config.getPaleoSlipConstraintWt() > 0.0) {
            int numPaleoSlipRows = this.aveSlipConstraints.size();
            this.constraintRowRanges.add(new ConstraintRange("Paleo Slips", "Paleo Slips", ((ConstraintRange)this.constraintRowRanges.get((int)(this.constraintRowRanges.size() - 1))).endRow, numRows += numPaleoSlipRows, false, Double.NaN, null));
        }
        if (this.config.getRupRateConstraintWt() > 0.0) {
            double[] aPrioriRupRates = this.config.getA_PrioriRupConstraint();
            int numRupRateRows = 0;
            for (int i = 0; i < numRuptures; ++i) {
                if (!(aPrioriRupRates[i] > 0.0)) continue;
                ++numRupRateRows;
            }
            if (this.config.isAPrioriConstraintForZeroRates()) {
                ++numRupRateRows;
            }
            this.constraintRowRanges.add(new ConstraintRange("Rupture Rate", "Rupture Rate", ((ConstraintRange)this.constraintRowRanges.get((int)(this.constraintRowRanges.size() - 1))).endRow, numRows += numRupRateRows, false, Double.NaN, null));
        }
        List<Object> smoothingConstraintRupPairings = Lists.newArrayList();
        if (this.config.getRupRateSmoothingConstraintWt() > 0.0) {
            smoothingConstraintRupPairings = RupRateSmoothingInversionConstraint.getRupSmoothingPairings(rupSet);
            int numRupRateSmoothingRows = smoothingConstraintRupPairings.size();
            this.constraintRowRanges.add(new ConstraintRange("Rupture Rate Smoothing", "Rupture Rate Smoothing", ((ConstraintRange)this.constraintRowRanges.get((int)(this.constraintRowRanges.size() - 1))).endRow, numRows += numRupRateSmoothingRows, false, Double.NaN, null));
        }
        int numMinimizationRows = 0;
        if (this.config.getMinimizationConstraintWt() > 0.0) {
            for (int rup = 0; rup < numRuptures; ++rup) {
                if (!rupSet.isRuptureBelowSectMinMag(rup)) continue;
                ++numMinimizationRows;
            }
            this.constraintRowRanges.add(new ConstraintRange("Minimization", "Minimization", ((ConstraintRange)this.constraintRowRanges.get((int)(this.constraintRowRanges.size() - 1))).endRow, numRows += numMinimizationRows, false, Double.NaN, null));
        }
        IncrementalMagFreqDist targetMagFreqDist = null;
        if (this.config.getMagnitudeEqualityConstraintWt() > 0.0) {
            int totalNumMagFreqConstraints = 0;
            Iterator<? extends IncrementalMagFreqDist> iterator = this.config.getMfdEqualityConstraints().iterator();
            while (iterator.hasNext()) {
                IncrementalMagFreqDist constr;
                targetMagFreqDist = constr = iterator.next();
                totalNumMagFreqConstraints += targetMagFreqDist.getClosestXIndex(rupSet.getMaxMag()) - targetMagFreqDist.getClosestXIndex(rupSet.getMinMag()) + 1;
            }
            this.constraintRowRanges.add(new ConstraintRange("MFD Equality", "MFD Equality", ((ConstraintRange)this.constraintRowRanges.get((int)(this.constraintRowRanges.size() - 1))).endRow, numRows += totalNumMagFreqConstraints, false, Double.NaN, null));
        }
        if (this.config.getParticipationSmoothnessConstraintWt() > 0.0) {
            int totalNumMagParticipationConstraints = 0;
            for (int sect = 0; sect < numSections; ++sect) {
                List<Integer> rupturesForSection = rupSet.getRupturesForSection(sect);
                double d = 10.0;
                double d2 = 0.0;
                for (int rupIndex2 = 0; rupIndex2 < rupturesForSection.size(); ++rupIndex2) {
                    if (rupMeanMag[rupturesForSection.get(rupIndex2)] < d) {
                        d = rupMeanMag[rupturesForSection.get(rupIndex2)];
                    }
                    if (!(rupMeanMag[rupturesForSection.get(rupIndex2)] > d2)) continue;
                    d2 = rupMeanMag[rupturesForSection.get(rupIndex2)];
                }
                block7: for (double m = d; m < d2; m += this.config.getParticipationConstraintMagBinSize()) {
                    for (int rupIndex3 = 0; rupIndex3 < rupturesForSection.size(); ++rupIndex3) {
                        if (!(rupMeanMag[rupturesForSection.get(rupIndex3)] >= m) || !(rupMeanMag[rupturesForSection.get(rupIndex3)] < m + this.config.getParticipationConstraintMagBinSize())) continue;
                        ++totalNumMagParticipationConstraints;
                        ++numRows;
                        continue block7;
                    }
                }
            }
            this.constraintRowRanges.add(new ConstraintRange("MFD Participation", "MFD Participation", ((ConstraintRange)this.constraintRowRanges.get((int)(this.constraintRowRanges.size() - 1))).endRow, numRows, false, Double.NaN, null));
        }
        ArrayList<U3SectionMFD_constraint> MFDConstraints = null;
        if (this.config.getNucleationMFDConstraintWt() > 0.0) {
            int totalNumNucleationMFDConstraints = 0;
            MFDConstraints = FaultSystemRupSetCalc.getCharInversionSectMFD_Constraints(rupSet);
            for (int sect = 0; sect < numSections; ++sect) {
                U3SectionMFD_constraint u3SectionMFD_constraint = MFDConstraints.get(sect);
                if (u3SectionMFD_constraint == null) continue;
                for (int i = 0; i < u3SectionMFD_constraint.getNumMags(); ++i) {
                    if (!(u3SectionMFD_constraint.getRate(i) > 0.0)) continue;
                    ++totalNumNucleationMFDConstraints;
                    ++numRows;
                }
            }
            this.constraintRowRanges.add(new ConstraintRange("MFD Nucleation", "MFD Nucleation", ((ConstraintRange)this.constraintRowRanges.get((int)(this.constraintRowRanges.size() - 1))).endRow, numRows, false, Double.NaN, null));
        }
        if (this.config.getMFDSmoothnessConstraintWt() > 0.0 || this.config.getMFDSmoothnessConstraintWtForPaleoParents() > 0.0) {
            int totalNumMFDSmoothnessConstraints = 0;
            MFDConstraints = FaultSystemRupSetCalc.getCharInversionSectMFD_Constraints(rupSet);
            ArrayList<Integer> paleoParents = new ArrayList<Integer>();
            if (this.config.getPaleoRateConstraintWt() > 0.0) {
                void var18_36;
                boolean bl = false;
                while (var18_36 < this.paleoRateConstraints.size()) {
                    int paleoParentID = rupSet.getFaultSectionDataList().get(this.paleoRateConstraints.get((int)var18_36).sectionIndex).getParentSectionId();
                    paleoParents.add(paleoParentID);
                    ++var18_36;
                }
            }
            if (this.config.getPaleoSlipConstraintWt() > 0.0) {
                void var18_38;
                boolean bl = false;
                while (var18_38 < this.aveSlipConstraints.size()) {
                    int paleoParentID2 = rupSet.getFaultSectionDataList().get(this.aveSlipConstraints.get((int)var18_38).sectionIndex).getParentSectionId();
                    paleoParents.add(paleoParentID2);
                    ++var18_38;
                }
            }
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (FaultSection faultSection : rupSet.getFaultSectionDataList()) {
                int parentID = faultSection.getParentSectionId();
                if (arrayList.contains(parentID)) continue;
                arrayList.add(parentID);
            }
            Iterator<FaultSection> paleoParentID2 = arrayList.iterator();
            while (paleoParentID2.hasNext()) {
                int n = (Integer)((Object)paleoParentID2.next());
                ArrayList<Integer> sectsForParent = new ArrayList<Integer>();
                for (FaultSection faultSection : rupSet.getFaultSectionDataList()) {
                    int sectParentID = faultSection.getParentSectionId();
                    if (sectParentID != n) continue;
                    sectsForParent.add(faultSection.getSectionId());
                }
                for (int j = 1; j < sectsForParent.size() - 2; ++j) {
                    int n2 = (Integer)sectsForParent.get(j);
                    U3SectionMFD_constraint sectMFDConstraint = MFDConstraints.get(n2);
                    if (sectMFDConstraint == null) continue;
                    int numMagBins = sectMFDConstraint.getNumMags();
                    if (!(this.config.getMFDSmoothnessConstraintWt() > 0.0) && paleoParents.indexOf(n) == -1) continue;
                    totalNumMFDSmoothnessConstraints += numMagBins;
                    numRows += numMagBins;
                }
            }
            this.constraintRowRanges.add(new ConstraintRange("MFD Smoothness", "MFD Smoothness", ((ConstraintRange)this.constraintRowRanges.get((int)(this.constraintRowRanges.size() - 1))).endRow, numRows, false, Double.NaN, null));
        }
        if (this.config.getMomentConstraintWt() > 0.0) {
            this.constraintRowRanges.add(new ConstraintRange("Moment", "Moment", ((ConstraintRange)this.constraintRowRanges.get((int)(this.constraintRowRanges.size() - 1))).endRow, ++numRows, false, Double.NaN, null));
        }
        if (this.config.getParkfieldConstraintWt() > 0.0) {
            this.constraintRowRanges.add(new ConstraintRange("Parkfield", "Parkfield", ((ConstraintRange)this.constraintRowRanges.get((int)(this.constraintRowRanges.size() - 1))).endRow, ++numRows, false, Double.NaN, null));
        }
        if (this.config.getEventRateSmoothnessWt() > 0.0) {
            ArrayList<Integer> parentIDs = new ArrayList<Integer>();
            for (FaultSection faultSection : rupSet.getFaultSectionDataList()) {
                int parentID = faultSection.getParentSectionId();
                if (parentIDs.contains(parentID)) continue;
                parentIDs.add(parentID);
            }
            int numParentSections = parentIDs.size();
            int n = rupSet.getNumSections() - numParentSections;
            this.constraintRowRanges.add(new ConstraintRange("Event-Rate Smoothness", "Event-Rate Smoothness", ((ConstraintRange)this.constraintRowRanges.get((int)(this.constraintRowRanges.size() - 1))).endRow, numRows += n, false, Double.NaN, null));
        }
        this.A = UCERF3InversionInputGenerator.buildMatrix(clazz, numRows, numRuptures);
        this.d = new double[numRows];
        int numMFDRows = 0;
        if (this.config.getMagnitudeInequalityConstraintWt() > 0.0) {
            Iterator<? extends IncrementalMagFreqDist> numParentSections = this.config.getMfdInequalityConstraints().iterator();
            while (numParentSections.hasNext()) {
                IncrementalMagFreqDist incrementalMagFreqDist;
                targetMagFreqDist = incrementalMagFreqDist = numParentSections.next();
                numMFDRows += targetMagFreqDist.getClosestXIndex(rupSet.getMaxMag()) - targetMagFreqDist.getClosestXIndex(rupSet.getMinMag()) + 1;
            }
            this.constraintRowRanges.add(new ConstraintRange("MFD Inequality", "MFD Inequality", 0, numMFDRows, true, Double.NaN, null));
            this.A_ineq = UCERF3InversionInputGenerator.buildMatrix(clazz, numMFDRows, numRuptures);
            this.d_ineq = new double[numMFDRows];
        }
        Object watch_total = null;
        Object var18_43 = null;
        int numNonZeroElements = 0;
        double d = this.config.getSlipRateConstraintWt_normalized();
        double slipRateConstraintWt_unnormalized = this.config.getSlipRateConstraintWt_unnormalized();
        for (int rup = 0; rup < numRuptures; ++rup) {
            double[] slips = rupSet.getSlipOnSectionsForRup(rup);
            List<Integer> sects = rupSet.getSectionsIndicesForRup(rup);
            for (int i = 0; i < slips.length; ++i) {
                int row = sects.get(i);
                int n = rup;
                if (slipRateConstraintWt_unnormalized > 0.0) {
                    this.A.setQuick(row, n, slipRateConstraintWt_unnormalized * slips[i]);
                }
                if (!(d > 0.0)) continue;
                if (slipRateConstraintWt_unnormalized > 0.0) {
                    row += numSections;
                }
                double val = sectSlipRateReduced[sects.get(i)] < 1.0E-4 || Double.isNaN(sectSlipRateReduced[sects.get(i)]) ? slips[i] / 1.0E-4 : slips[i] / sectSlipRateReduced[sects.get(i)];
                this.A.setQuick(row, n, d * val);
            }
        }
        for (int sect = 0; sect < numSections; ++sect) {
            int row = sect;
            if (slipRateConstraintWt_unnormalized > 0.0) {
                this.d[row] = slipRateConstraintWt_unnormalized * sectSlipRateReduced[sect];
            }
            if (d > 0.0) {
                if (slipRateConstraintWt_unnormalized > 0.0) {
                    row += numSections;
                }
                this.d[row] = sectSlipRateReduced[sect] < 1.0E-4 ? d * sectSlipRateReduced[sect] / 1.0E-4 : d;
            }
            if (Double.isNaN(sectSlipRateReduced[sect])) {
                this.d[sect] = 0.0;
            }
            if (!Double.isNaN(this.d[sect]) && !(this.d[sect] < 0.0)) continue;
            throw new IllegalStateException("d[" + sect + "] is NaN or 0!  sectSlipRateReduced[" + sect + "] = " + sectSlipRateReduced[sect]);
        }
        if (this.config.getPaleoRateConstraintWt() > 0.0) {
            double paleoRateConstraintWt = this.config.getPaleoRateConstraintWt();
            numNonZeroElements = 0;
            for (int i = numSlipRateConstraints; i < numSlipRateConstraints + this.paleoRateConstraints.size(); ++i) {
                UncertainDataConstraint.SectMappedUncertainDataConstraint constraint = this.paleoRateConstraints.get(i - numSlipRateConstraints);
                this.d[i] = paleoRateConstraintWt * constraint.bestEstimate / constraint.getPreferredStdDev();
                List<Integer> rupsForSect = rupSet.getRupturesForSection(constraint.sectionIndex);
                for (int j = 0; j < rupsForSect.size(); ++j) {
                    int rup = rupsForSect.get(j);
                    double d3 = this.paleoProbabilityModel.getProbPaleoVisible(rupSet, rup, constraint.sectionIndex);
                    double setVal = paleoRateConstraintWt * d3 / constraint.getPreferredStdDev();
                    this.A.setQuick(i, rup, setVal);
                }
            }
        }
        int rowIndex = numSlipRateConstraints + numPaleoRows;
        if (this.config.getPaleoSlipConstraintWt() > 0.0) {
            double paleoSlipConstraintWt = this.config.getPaleoSlipConstraintWt();
            numNonZeroElements = 0;
            for (int i = 0; i < this.aveSlipConstraints.size(); ++i) {
                UncertainDataConstraint.SectMappedUncertainDataConstraint constraint = this.aveSlipConstraints.get(i);
                int n = constraint.sectionIndex;
                double meanRate = sectSlipRateReduced[n] / constraint.bestEstimate;
                double d4 = sectSlipRateReduced[n] / ((BoundedUncertainty)constraint.uncertainties[0]).upperBound;
                double highRateBound = sectSlipRateReduced[n] / ((BoundedUncertainty)constraint.uncertainties[0]).lowerBound;
                double constraintError = highRateBound - d4;
                this.d[rowIndex] = paleoSlipConstraintWt * meanRate / constraintError;
                List<Integer> rupsForSect = rupSet.getRupturesForSection(n);
                for (rupIndex = 0; rupIndex < rupsForSect.size(); ++rupIndex) {
                    int rup = rupsForSect.get(rupIndex);
                    int sectIndexInRup = rupSet.getSectionsIndicesForRup(rup).indexOf(n);
                    double slipOnSect = rupSet.getSlipOnSectionsForRup(rup)[sectIndexInRup];
                    double probVisible = U3AveSlipConstraint.getProbabilityOfObservedSlip(slipOnSect);
                    double setVal = paleoSlipConstraintWt * probVisible / constraintError;
                    this.A.setQuick(rowIndex, rup, setVal);
                    ++numNonZeroElements;
                }
                ++rowIndex;
            }
        }
        if (this.config.getRupRateConstraintWt() > 0.0) {
            int rup;
            double rupRateConstraintWt = this.config.getRupRateConstraintWt();
            double zeroRupRateConstraintWt = this.config.getRupRateConstraintWt() * this.config.getAPrioriConstraintForZeroRatesWtFactor();
            double[] dArray = this.config.getA_PrioriRupConstraint();
            numNonZeroElements = 0;
            for (rup = 0; rup < numRuptures; ++rup) {
                if (!(dArray[rup] > 0.0)) continue;
                this.A.setQuick(rowIndex, rup, rupRateConstraintWt);
                this.d[rowIndex] = dArray[rup] * rupRateConstraintWt;
                ++numNonZeroElements;
                ++rowIndex;
            }
            if (this.config.isAPrioriConstraintForZeroRates()) {
                for (rup = 0; rup < numRuptures; ++rup) {
                    if (dArray[rup] != 0.0) continue;
                    this.A.setQuick(rowIndex, rup, zeroRupRateConstraintWt);
                    ++numNonZeroElements;
                }
                this.d[rowIndex] = 0.0;
                ++rowIndex;
            }
        }
        if (this.config.getRupRateSmoothingConstraintWt() > 0.0) {
            double rupRateSmoothingConstraintWt = this.config.getRupRateSmoothingConstraintWt();
            numNonZeroElements = 0;
            for (int i = 0; i < smoothingConstraintRupPairings.size(); ++i) {
                IDPairing rupPairings = (IDPairing)smoothingConstraintRupPairings.get(i);
                this.A.setQuick(rowIndex, rupPairings.getID1(), rupRateSmoothingConstraintWt);
                this.A.setQuick(rowIndex, rupPairings.getID2(), -rupRateSmoothingConstraintWt);
                this.d[rowIndex] = 0.0;
                ++rowIndex;
                ++numNonZeroElements;
            }
        }
        if (this.config.getMinimizationConstraintWt() > 0.0) {
            double minimizationConstraintWt = this.config.getMinimizationConstraintWt();
            numNonZeroElements = 0;
            for (int rup = 0; rup < numRuptures; ++rup) {
                if (!rupSet.isRuptureBelowSectMinMag(rup)) continue;
                this.A.setQuick(rowIndex, rup, minimizationConstraintWt);
                this.d[rowIndex] = 0.0;
                ++numNonZeroElements;
                ++rowIndex;
            }
        }
        if (this.config.getMagnitudeEqualityConstraintWt() > 0.0) {
            void var29_122;
            double magnitudeEqualityConstraintWt = this.config.getMagnitudeEqualityConstraintWt();
            List<? extends IncrementalMagFreqDist> mfdEqualityConstraints = this.config.getMfdEqualityConstraints();
            numNonZeroElements = 0;
            ArrayList<Integer> parkfieldRups = new ArrayList<Integer>();
            if (this.config.getParkfieldConstraintWt() > 0.0) {
                void var31_149;
                int n = 32;
                List<Integer> potentialRups = rupSet.getRupturesForParentSection(n);
                boolean bl = false;
                while (var31_149 < potentialRups.size()) {
                    block136: {
                        List<Integer> list = rupSet.getSectionsIndicesForRup(potentialRups.get((int)var31_149));
                        if (list.size() >= 6 && list.size() <= 8) {
                            for (int s = 0; s < list.size(); ++s) {
                                int parent = rupSet.getFaultSectionData(list.get(s)).getParentSectionId();
                                if (parent == n) {
                                    continue;
                                }
                                break block136;
                            }
                            parkfieldRups.add(potentialRups.get((int)var31_149));
                        }
                    }
                    ++var31_149;
                }
            }
            boolean bl = false;
            while (var29_122 < mfdEqualityConstraints.size()) {
                int n;
                double[] fractRupsInside = rupSet.getFractRupsInsideRegion(mfdEqualityConstraints.get((int)var29_122).getRegion(), false);
                targetMagFreqDist = mfdEqualityConstraints.get((int)var29_122);
                for (n = 0; n < numRuptures; ++n) {
                    double d5 = rupMeanMag[n];
                    double fractRupInside = fractRupsInside[n];
                    if (!(fractRupInside > 0.0) || !(d5 > targetMagFreqDist.getMinX() - targetMagFreqDist.getDelta() / 2.0) || !(d5 < targetMagFreqDist.getMaxX() + targetMagFreqDist.getDelta() / 2.0) || this.config.isExcludeParkfieldRupsFromMfdEqualityConstraints() && parkfieldRups.contains(n)) continue;
                    this.A.setQuick(rowIndex + targetMagFreqDist.getClosestXIndex(d5) - targetMagFreqDist.getClosestXIndex(rupSet.getMinMag()), n, magnitudeEqualityConstraintWt * fractRupInside / targetMagFreqDist.getClosestYtoX(d5));
                    if (targetMagFreqDist.getClosestYtoX(d5) == 0.0) {
                        this.A.setQuick(rowIndex + targetMagFreqDist.getClosestXIndex(d5) - targetMagFreqDist.getClosestXIndex(rupSet.getMinMag()), n, 0.0);
                    }
                    ++numNonZeroElements;
                }
                for (n = targetMagFreqDist.getClosestXIndex(rupSet.getMinMag()); n <= targetMagFreqDist.getClosestXIndex(rupSet.getMaxMag()); ++n) {
                    this.d[rowIndex] = magnitudeEqualityConstraintWt;
                    if (targetMagFreqDist.getY(n) == 0.0) {
                        this.d[rowIndex] = 0.0;
                    }
                    ++rowIndex;
                }
                ++var29_122;
            }
        }
        if (this.config.getMagnitudeInequalityConstraintWt() > 0.0) {
            void var29_124;
            double magnitudeInequalityConstraintWt = this.config.getMagnitudeInequalityConstraintWt();
            List<? extends IncrementalMagFreqDist> mfdInequalityConstraints = this.config.getMfdInequalityConstraints();
            int rowIndex_ineq = 0;
            boolean bl = false;
            while (var29_124 < mfdInequalityConstraints.size()) {
                int n;
                double[] fractRupsInside = rupSet.getFractRupsInsideRegion(mfdInequalityConstraints.get((int)var29_124).getRegion(), false);
                targetMagFreqDist = mfdInequalityConstraints.get((int)var29_124);
                for (n = 0; n < numRuptures; ++n) {
                    double d6 = rupMeanMag[n];
                    double fractRupInside = fractRupsInside[n];
                    if (!(fractRupInside > 0.0) || !(d6 > targetMagFreqDist.getMinX() - targetMagFreqDist.getDelta() / 2.0) || !(d6 < targetMagFreqDist.getMaxX() + targetMagFreqDist.getDelta() / 2.0)) continue;
                    this.A_ineq.setQuick(rowIndex_ineq + targetMagFreqDist.getClosestXIndex(d6), n, magnitudeInequalityConstraintWt * fractRupInside / targetMagFreqDist.getClosestYtoX(d6));
                    if (targetMagFreqDist.getClosestYtoX(d6) != 0.0) continue;
                    this.A.setQuick(rowIndex_ineq + targetMagFreqDist.getClosestXIndex(d6), n, 0.0);
                }
                for (n = targetMagFreqDist.getClosestXIndex(rupSet.getMinMag()); n <= targetMagFreqDist.getClosestXIndex(rupSet.getMaxMag()); ++n) {
                    this.d_ineq[rowIndex_ineq] = magnitudeInequalityConstraintWt;
                    if (targetMagFreqDist.getY(n) == 0.0) {
                        this.d_ineq[rowIndex_ineq] = 0.0;
                    }
                    ++rowIndex_ineq;
                }
                ++var29_124;
            }
        }
        if (this.config.getParticipationSmoothnessConstraintWt() > 0.0) {
            double participationSmoothnessConstraintWt = this.config.getParticipationSmoothnessConstraintWt();
            numNonZeroElements = 0;
            ArrayList<Integer> numRupsForMagBin = new ArrayList<Integer>();
            for (int sect = 0; sect < numSections; ++sect) {
                List<Integer> list = rupSet.getRupturesForSection(sect);
                double minMag = 10.0;
                double d7 = 0.0;
                for (int rupIndex5 = 0; rupIndex5 < list.size(); ++rupIndex5) {
                    if (rupMeanMag[list.get(rupIndex5)] < minMag) {
                        minMag = rupMeanMag[list.get(rupIndex5)];
                    }
                    if (!(rupMeanMag[list.get(rupIndex5)] > d7)) continue;
                    d7 = rupMeanMag[list.get(rupIndex5)];
                }
                if (minMag == 10.0 || minMag == 0.0) {
                    System.out.println("NO RUPTURES FOR SECTION #" + sect);
                    continue;
                }
                numRupsForMagBin.clear();
                double participationConstraintMagBinSize = this.config.getParticipationConstraintMagBinSize();
                int numNonzeroMagBins = 0;
                for (double m = minMag; m < d7; m += participationConstraintMagBinSize) {
                    numRupsForMagBin.add(0);
                    for (rupIndex = 0; rupIndex < list.size(); ++rupIndex) {
                        if (!(rupMeanMag[list.get(rupIndex)] >= m) || !(rupMeanMag[list.get(rupIndex)] < m + participationConstraintMagBinSize)) continue;
                        numRupsForMagBin.set(numRupsForMagBin.size() - 1, (Integer)numRupsForMagBin.get(numRupsForMagBin.size() - 1) + 1);
                    }
                    if ((Integer)numRupsForMagBin.get(numRupsForMagBin.size() - 1) <= 0) continue;
                    ++numNonzeroMagBins;
                }
                int magBinIndex = 0;
                for (double m = minMag; m < d7; m += participationConstraintMagBinSize) {
                    if ((Integer)numRupsForMagBin.get(magBinIndex) > 0) {
                        for (int rupIndex6 = 0; rupIndex6 < list.size(); ++rupIndex6) {
                            int col = list.get(rupIndex6);
                            double val = participationSmoothnessConstraintWt / (double)numNonzeroMagBins;
                            ++numNonZeroElements;
                            if (rupMeanMag[list.get(rupIndex6)] >= m && rupMeanMag[list.get(rupIndex6)] < m + participationConstraintMagBinSize) {
                                val -= participationSmoothnessConstraintWt;
                            }
                            this.A.setQuick(rowIndex, col, val);
                        }
                        this.d[rowIndex] = 0.0;
                        ++rowIndex;
                    }
                    ++magBinIndex;
                }
            }
        }
        if (this.config.getNucleationMFDConstraintWt() > 0.0) {
            double nucleationMFDConstraintWt = this.config.getNucleationMFDConstraintWt();
            numNonZeroElements = 0;
            for (int sect = 0; sect < numSections; ++sect) {
                U3SectionMFD_constraint sectMFDConstraint = MFDConstraints.get(sect);
                if (sectMFDConstraint == null) continue;
                int n = sectMFDConstraint.getNumMags();
                List<Integer> rupturesForSect = rupSet.getRupturesForSection(sect);
                for (int i = 0; i < n; ++i) {
                    int i2;
                    if (!(sectMFDConstraint.getRate(i) > 0.0)) continue;
                    ArrayList<Integer> arrayList = new ArrayList<Integer>();
                    for (i2 = 0; i2 < rupturesForSect.size(); ++i2) {
                        double mag = rupSet.getMagForRup(rupturesForSect.get(i2));
                        if (!sectMFDConstraint.isMagInBin(mag, i)) continue;
                        arrayList.add(rupturesForSect.get(i2));
                    }
                    for (i2 = 0; i2 < arrayList.size(); ++i2) {
                        int rup = (Integer)arrayList.get(i2);
                        double rupArea = rupSet.getAreaForRup(rup);
                        double sectArea = rupSet.getAreaForSection(sect);
                        this.A.setQuick(rowIndex, rup, nucleationMFDConstraintWt * (sectArea / rupArea) / sectMFDConstraint.getRate(i));
                        ++numNonZeroElements;
                    }
                    this.d[rowIndex] = nucleationMFDConstraintWt;
                    ++rowIndex;
                }
            }
        }
        if (this.config.getMFDSmoothnessConstraintWt() > 0.0 || this.config.getMFDSmoothnessConstraintWtForPaleoParents() > 0.0) {
            void var32_179;
            double MFDSmoothingConstraintWt = this.config.getMFDSmoothnessConstraintWt();
            double MFDSmoothingConstraintWtForPaleoParents = this.config.getMFDSmoothnessConstraintWtForPaleoParents();
            numNonZeroElements = 0;
            HashMap hashMap = Maps.newHashMap();
            for (FaultSection faultSection : rupSet.getFaultSectionDataList()) {
                Integer n = faultSection.getParentSectionId();
                List parentSects = (List)hashMap.get(n);
                if (parentSects == null) {
                    parentSects = Lists.newArrayList();
                    hashMap.put(n, parentSects);
                }
                parentSects.add(faultSection);
            }
            ArrayList<Integer> paleoParents = new ArrayList<Integer>();
            if (this.config.getPaleoRateConstraintWt() > 0.0) {
                void var31_155;
                boolean bl = false;
                while (var31_155 < this.paleoRateConstraints.size()) {
                    int n = rupSet.getFaultSectionDataList().get(this.paleoRateConstraints.get((int)var31_155).sectionIndex).getParentSectionId();
                    paleoParents.add(n);
                    ++var31_155;
                }
            }
            if (this.config.getPaleoSlipConstraintWt() > 0.0) {
                void var31_157;
                boolean bl = false;
                while (var31_157 < this.aveSlipConstraints.size()) {
                    int n = rupSet.getFaultSectionDataList().get(this.aveSlipConstraints.get((int)var31_157).sectionIndex).getParentSectionId();
                    paleoParents.add(n);
                    ++var31_157;
                }
            }
            ArrayList arrayList = Lists.newArrayList();
            boolean bl = false;
            while (var32_179 < rupSet.getNumSections()) {
                arrayList.add(new HashSet<Integer>(rupSet.getRupturesForSection((int)var32_179)));
                ++var32_179;
            }
            for (List sectsForParent : hashMap.values()) {
                boolean parentSectIsPaleo = false;
                int parentID = rupSet.getFaultSectionDataList().get(((FaultSection)sectsForParent.get(0)).getSectionId()).getParentSectionId();
                if (paleoParents.contains(parentID)) {
                    parentSectIsPaleo = true;
                }
                double constraintWeight = MFDSmoothingConstraintWt;
                if (parentSectIsPaleo) {
                    constraintWeight = MFDSmoothingConstraintWtForPaleoParents;
                }
                if (constraintWeight == 0.0) continue;
                for (int j = 1; j < sectsForParent.size() - 2; ++j) {
                    int sect1 = ((FaultSection)sectsForParent.get(j - 1)).getSectionId();
                    HashSet sect1Hash = (HashSet)arrayList.get(sect1);
                    int sect2 = ((FaultSection)sectsForParent.get(j)).getSectionId();
                    HashSet sect2Hash = (HashSet)arrayList.get(sect2);
                    int sect3 = ((FaultSection)sectsForParent.get(j + 1)).getSectionId();
                    HashSet sect3Hash = (HashSet)arrayList.get(sect3);
                    ArrayList sect1Rups = Lists.newArrayList();
                    ArrayList sect2Rups = Lists.newArrayList();
                    ArrayList sect3Rups = Lists.newArrayList();
                    for (Integer sect1Rup : sect1Hash) {
                        if (sect2Hash.contains(sect1Rup)) continue;
                        sect1Rups.add(sect1Rup);
                    }
                    for (Integer sect2Rup : sect2Hash) {
                        if (sect1Hash.contains(sect2Rup)) continue;
                        sect2Rups.add(sect2Rup);
                    }
                    for (Integer sect2Rup : sect2Hash) {
                        if (sect3Hash.contains(sect2Rup)) continue;
                        sect2Rups.add(sect2Rup);
                    }
                    for (Integer sect3Rup : sect3Hash) {
                        if (sect2Hash.contains(sect3Rup)) continue;
                        sect3Rups.add(sect3Rup);
                    }
                    U3SectionMFD_constraint sectMFDConstraint = MFDConstraints.get(sect2);
                    if (sectMFDConstraint == null) continue;
                    int numMagBins = sectMFDConstraint.getNumMags();
                    for (int magBin = 0; magBin < numMagBins; ++magBin) {
                        ArrayList<Integer> sect1RupsForMagBin = new ArrayList<Integer>();
                        for (int i = 0; i < sect1Rups.size(); ++i) {
                            double mag = rupSet.getMagForRup((Integer)sect1Rups.get(i));
                            if (!sectMFDConstraint.isMagInBin(mag, magBin)) continue;
                            sect1RupsForMagBin.add((Integer)sect1Rups.get(i));
                        }
                        ArrayList<Integer> sect2RupsForMagBin = new ArrayList<Integer>();
                        for (int i = 0; i < sect2Rups.size(); ++i) {
                            double mag = rupSet.getMagForRup((Integer)sect2Rups.get(i));
                            if (!sectMFDConstraint.isMagInBin(mag, magBin)) continue;
                            sect2RupsForMagBin.add((Integer)sect2Rups.get(i));
                        }
                        ArrayList<Integer> sect3RupsForMagBin = new ArrayList<Integer>();
                        for (int i = 0; i < sect3Rups.size(); ++i) {
                            double mag = rupSet.getMagForRup((Integer)sect3Rups.get(i));
                            if (!sectMFDConstraint.isMagInBin(mag, magBin)) continue;
                            sect3RupsForMagBin.add((Integer)sect3Rups.get(i));
                        }
                        Iterator iterator = sect1RupsForMagBin.iterator();
                        while (iterator.hasNext()) {
                            int rup = (Integer)iterator.next();
                            this.A.setQuick(rowIndex, rup, constraintWeight);
                            ++numNonZeroElements;
                        }
                        iterator = sect2RupsForMagBin.iterator();
                        while (iterator.hasNext()) {
                            int rup = (Integer)iterator.next();
                            this.A.setQuick(rowIndex, rup, -constraintWeight);
                            ++numNonZeroElements;
                        }
                        iterator = sect3RupsForMagBin.iterator();
                        while (iterator.hasNext()) {
                            int rup = (Integer)iterator.next();
                            this.A.setQuick(rowIndex, rup, constraintWeight);
                            ++numNonZeroElements;
                        }
                        this.d[rowIndex] = 0.0;
                        ++rowIndex;
                    }
                }
            }
        }
        if (this.config.getMomentConstraintWt() > 0.0) {
            void var29_129;
            double momentConstraintWt = this.config.getMomentConstraintWt();
            double totalMomentTarget = rupSet.getTotalReducedMomentRate();
            numNonZeroElements = 0;
            boolean bl = false;
            while (var29_129 < numRuptures) {
                this.A.setQuick(rowIndex, (int)var29_129, momentConstraintWt * MagUtils.magToMoment(rupMeanMag[var29_129]));
                ++numNonZeroElements;
                ++var29_129;
            }
            this.d[rowIndex] = momentConstraintWt * totalMomentTarget;
            ++rowIndex;
            System.out.println("Number of nonzero elements in A matrix = " + numNonZeroElements);
        }
        if (this.config.getParkfieldConstraintWt() > 0.0) {
            double ParkfieldConstraintWt = this.config.getParkfieldConstraintWt();
            double ParkfieldMeanRate = 0.04;
            List<Integer> list = UCERF3InversionInputGenerator.findParkfieldRups(rupSet);
            numNonZeroElements = 0;
            for (int r = 0; r < list.size(); ++r) {
                int n = list.get(r);
                this.A.setQuick(rowIndex, n, ParkfieldConstraintWt);
                ++numNonZeroElements;
            }
            this.d[rowIndex] = ParkfieldConstraintWt * ParkfieldMeanRate;
            ++rowIndex;
            System.out.println("Number of nonzero elements in A matrix = " + numNonZeroElements + "\n");
        }
        System.out.println("Row ranges:");
        for (ConstraintRange range : this.constraintRowRanges) {
            System.out.println("\t" + String.valueOf(range));
        }
        if (this.config.getEventRateSmoothnessWt() > 0.0) {
            double eventRateSmoothnessWt = this.config.getEventRateSmoothnessWt();
            numNonZeroElements = 0;
            ArrayList<Integer> parentIDs = new ArrayList<Integer>();
            for (FaultSection faultSection : rupSet.getFaultSectionDataList()) {
                int parentID = faultSection.getParentSectionId();
                if (parentIDs.contains(parentID)) continue;
                parentIDs.add(parentID);
            }
            Iterator<FaultSection> iterator = parentIDs.iterator();
            while (iterator.hasNext()) {
                void var31_162;
                int n = (Integer)((Object)iterator.next());
                ArrayList<Integer> sectsForParent = new ArrayList<Integer>();
                for (FaultSection faultSection : rupSet.getFaultSectionDataList()) {
                    int sectParentID = faultSection.getParentSectionId();
                    if (sectParentID != n) continue;
                    sectsForParent.add(faultSection.getSectionId());
                }
                boolean bl = false;
                while (var31_162 < sectsForParent.size() - 1) {
                    double probPaleoVisible;
                    int rup;
                    int n3 = (Integer)sectsForParent.get((int)var31_162);
                    int sect2 = (Integer)sectsForParent.get((int)(var31_162 + true));
                    ArrayList sect1Rups = Lists.newArrayList(rupSet.getRupturesForSection(n3));
                    ArrayList sect2Rups = Lists.newArrayList(rupSet.getRupturesForSection(sect2));
                    Iterator iterator2 = sect1Rups.iterator();
                    while (iterator2.hasNext()) {
                        rup = (Integer)iterator2.next();
                        probPaleoVisible = this.paleoProbabilityModel.getProbPaleoVisible(rupSet, rup, n3);
                        this.A.setQuick(rowIndex, rup, probPaleoVisible * eventRateSmoothnessWt);
                        ++numNonZeroElements;
                    }
                    iterator2 = sect2Rups.iterator();
                    while (iterator2.hasNext()) {
                        rup = (Integer)iterator2.next();
                        probPaleoVisible = this.paleoProbabilityModel.getProbPaleoVisible(rupSet, rup, sect2);
                        this.A.setQuick(rowIndex, rup, -probPaleoVisible * eventRateSmoothnessWt);
                        ++numNonZeroElements;
                    }
                    this.d[rowIndex] = 0.0;
                    ++rowIndex;
                    ++var31_162;
                }
            }
            System.out.println("Number of nonzero elements in A matrix = " + numNonZeroElements + "\n");
        }
        if (numRows != rowIndex) {
            System.out.println("Current rowIndex = " + rowIndex + "; numRows of A = " + numRows);
            throw new IllegalStateException("Number of constraints does not match # of rows of A");
        }
        if (this.waterLevelRates != null) {
            this.A.forEachNonZero(new IntIntDoubleFunction(){

                public synchronized double apply(int row, int col, double val) {
                    double[] dArray = UCERF3InversionInputGenerator.this.d;
                    int n = row;
                    dArray[n] = dArray[n] - val * UCERF3InversionInputGenerator.this.waterLevelRates[col];
                    return val;
                }
            });
            if (this.d_ineq != null) {
                this.A_ineq.forEachNonZero(new IntIntDoubleFunction(){

                    public synchronized double apply(int row, int col, double val) {
                        double[] dArray = UCERF3InversionInputGenerator.this.d_ineq;
                        int n = row;
                        dArray[n] = dArray[n] - val * UCERF3InversionInputGenerator.this.waterLevelRates[col];
                        return val;
                    }
                });
            }
            this.initialSolution = Arrays.copyOf(this.initialSolution, numRuptures);
            for (int i = 0; i < numRuptures; ++i) {
                double adjustedVal = this.initialSolution[i] - this.waterLevelRates[i];
                if (adjustedVal < 0.0) {
                    adjustedVal = 0.0;
                }
                this.initialSolution[i] = adjustedVal;
            }
        }
    }

    public static double getDistanceAlongRupture(List<FaultSection> sectsInRup, int targetSectIndex) {
        return UCERF3InversionInputGenerator.getDistanceAlongRupture(sectsInRup, targetSectIndex, null);
    }

    public static double getDistanceAlongRupture(List<? extends FaultSection> sectsInRup, int targetSectIndex, Map<Integer, Double> traceLengthCache) {
        double distanceAlongRup = 0.0;
        double totalLength = 0.0;
        double lengthToRup = 0.0;
        boolean reachConstraintLoc = false;
        for (int i = 0; i < sectsInRup.size(); ++i) {
            FaultSection sect = sectsInRup.get(i);
            int sectIndex = sect.getSectionId();
            Double sectLength = null;
            if (traceLengthCache != null) {
                sectLength = traceLengthCache.get(sectIndex);
                if (sectLength == null) {
                    sectLength = sect.getFaultTrace().getTraceLength();
                    traceLengthCache.put(sectIndex, sectLength);
                }
            } else {
                sectLength = sect.getFaultTrace().getTraceLength();
            }
            totalLength += sectLength.doubleValue();
            if (sectIndex == targetSectIndex) {
                reachConstraintLoc = true;
                lengthToRup += sectLength / 2.0;
            }
            if (reachConstraintLoc) continue;
            lengthToRup += sectLength.doubleValue();
        }
        if (!reachConstraintLoc) {
            throw new IllegalStateException("Paleo site subsection was not included in rupture subsections");
        }
        distanceAlongRup = lengthToRup / totalLength;
        if (distanceAlongRup > 0.5) {
            distanceAlongRup = 1.0 - distanceAlongRup;
        }
        return distanceAlongRup;
    }

    public UCERF3InversionConfiguration getConfig() {
        return this.config;
    }

    public List<? extends UncertainDataConstraint.SectMappedUncertainDataConstraint> getPaleoRateConstraints() {
        return this.paleoRateConstraints;
    }

    public double[] getImprobabilityConstraint() {
        return this.improbabilityConstraint;
    }

    public PaleoProbabilityModel getPaleoProbabilityModel() {
        return this.paleoProbabilityModel;
    }

    public static List<Integer> findParkfieldRups(FaultSystemRupSet rupSet) {
        int parkfieldParentSectID = 32;
        List<Integer> potentialRups = rupSet.getRupturesForParentSection(parkfieldParentSectID);
        ArrayList<Integer> parkfieldRups = new ArrayList<Integer>();
        if (potentialRups == null) {
            System.out.println("Warning: parkfield not found...removed?");
            return parkfieldRups;
        }
        block0: for (int i = 0; i < potentialRups.size(); ++i) {
            List<Integer> sects = rupSet.getSectionsIndicesForRup(potentialRups.get(i));
            if (sects.size() < 6 || sects.size() > 8) continue;
            for (int s = 0; s < sects.size(); ++s) {
                int parent = rupSet.getFaultSectionData(sects.get(s)).getParentSectionId();
                if (parent != parkfieldParentSectID) continue block0;
            }
            parkfieldRups.add(potentialRups.get(i));
        }
        return parkfieldRups;
    }

    private static void validateNewVsOld() throws IOException {
        U3LogicTreeBranch branch = U3LogicTreeBranch.DEFAULT;
        InversionFaultSystemRupSet rupSet = InversionFaultSystemRupSetFactory.forBranch(branch);
        UCERF3InversionConfiguration config = UCERF3InversionConfiguration.forModel(branch.getValue(InversionModels.class), rupSet, rupSet.getFaultModel(), rupSet.getInversionTargetMFDs());
        config.setRupRateSmoothingConstraintWt(1.0);
        config.setMagnitudeEqualityConstraintWt(1.0);
        config.setSmoothnessWt(10000.0);
        config.setMomentConstraintWt(1.0);
        config.setRupRateConstraintWt(1.0);
        config.setEventRateSmoothnessWt(1.0);
        config.setParticipationSmoothnessConstraintWt(1.0);
        ArrayList<U3PaleoRateConstraint> paleoRateConstraints = CommandLineInversionRunner.getPaleoConstraints(rupSet.getFaultModel(), rupSet);
        Object improbabilityConstraint = null;
        PaleoProbabilityModel paleoProbabilityModel = UCERF3InversionInputGenerator.loadDefaultPaleoProbabilityModel();
        List<U3AveSlipConstraint> aveSlipConstraints = U3AveSlipConstraint.load(rupSet.getFaultSectionDataList());
        System.out.println("BUILDING ORIGINAL");
        UCERF3InversionInputGenerator origGen = UCERF3InversionInputGenerator.getTestConfig(rupSet, rupSet.getFaultModel(), rupSet.getInversionTargetMFDs());
        origGen.generateInputsOld(null);
        System.out.println("BUILDING NEW");
        UCERF3InversionInputGenerator newGen = UCERF3InversionInputGenerator.getTestConfig(rupSet, rupSet.getFaultModel(), rupSet.getInversionTargetMFDs());
        newGen.generateInputs(true);
        UCERF3InversionInputGenerator.validate(origGen, newGen);
    }

    private static void testConfigureNewFileFormat() throws Exception {
        File tempDir = Files.createTempDir();
        U3LogicTreeBranch origBranch = U3LogicTreeBranch.DEFAULT;
        InversionFaultSystemRupSet origRupSet = InversionFaultSystemRupSetFactory.forBranch(origBranch);
        InversionTargetMFDs origTargetMFDs = origRupSet.getModule(InversionTargetMFDs.class);
        ModSectMinMags origMinMags = origRupSet.requireModule(ModSectMinMags.class);
        UCERF3InversionInputGenerator origGen = UCERF3InversionInputGenerator.getTestConfig(origRupSet, origBranch.getValue(FaultModels.class), origTargetMFDs);
        File tempFile = new File(tempDir, "ivfrs_new.zip");
        origRupSet.getArchive().write(tempFile);
        FaultSystemRupSet rupSet = FaultSystemRupSet.load(tempFile);
        System.out.println("Copying original zone polygons and traces so that opensha issue #25 doesn't affect comparisons");
        for (int s = 0; s < rupSet.getNumSections(); ++s) {
            FaultSection origSect = origRupSet.getFaultSectionData(s);
            FaultSection newSect = rupSet.getFaultSectionData(s);
            newSect.setZonePolygon(origSect.getZonePolygon());
            for (int i = 0; i < newSect.getFaultTrace().size(); ++i) {
                Location origLoc = (Location)origSect.getFaultTrace().get(i);
                Location newLoc = (Location)newSect.getFaultTrace().get(i);
                boolean equals = newLoc.equals(origLoc);
                equals = equals && origLoc.getLatRad() == newLoc.getLatRad();
                boolean bl = equals = equals && origLoc.getLonRad() == newLoc.getLonRad();
                if (equals) continue;
                System.err.println("Trace location differs for " + origSect.getName() + ", location " + i);
                System.err.println("\tORIG DEGs\t" + origLoc.getLatitude() + "\t" + origLoc.getLongitude() + "\t" + origLoc.getDepth());
                System.err.println("\tNEW DEGs\t" + newLoc.getLatitude() + "\t" + newLoc.getLongitude() + "\t" + newLoc.getDepth());
                System.err.println("\tORIG RADs\t" + origLoc.getLatRad() + "\t" + origLoc.getLonRad());
                System.err.println("\tNEW RADs\t" + newLoc.getLatRad() + "\t" + newLoc.getLonRad());
                newSect.getFaultTrace().set(i, origLoc);
            }
        }
        U3LogicTreeBranch newBranch = rupSet.requireModule(U3LogicTreeBranch.class);
        Preconditions.checkState((boolean)newBranch.equals(origBranch));
        InversionTargetMFDs newTargetMFDs = rupSet.requireModule(InversionTargetMFDs.class);
        System.out.println("Validating modified min mags");
        UCERF3InversionInputGenerator.validateMinMags(origMinMags, rupSet.requireModule(ModSectMinMags.class));
        UCERF3InversionInputGenerator modGen = UCERF3InversionInputGenerator.getTestConfig(rupSet, newBranch.getValue(FaultModels.class), newTargetMFDs);
        System.out.println("Validating target MFD constraints");
        List<? extends IncrementalMagFreqDist> origConstrs = origTargetMFDs.getMFD_Constraints();
        List<? extends IncrementalMagFreqDist> newConstrs = newTargetMFDs.getMFD_Constraints();
        Preconditions.checkState((origConstrs.size() == newConstrs.size() ? 1 : 0) != 0, (Object)"MFD constraint size mismatch");
        for (int i = 0; i < origConstrs.size(); ++i) {
            IncrementalMagFreqDist origConstr = origConstrs.get(i);
            IncrementalMagFreqDist newConstr = newConstrs.get(i);
            Preconditions.checkState((boolean)origConstr.getRegion().equals(newConstr.getRegion()), (Object)"Region mismatch");
            UCERF3InversionInputGenerator.validateMFD(origConstr, newConstr);
        }
        System.out.println("Generating mod inputs");
        modGen.generateInputs();
        System.out.println("Generating orig inputs");
        origGen.generateInputs();
        UCERF3InversionInputGenerator.validate(origGen, modGen);
        FileUtils.deleteRecursive(tempDir);
    }

    private static void testBuildNewFormat() throws Exception {
        U3LogicTreeBranch origBranch = U3LogicTreeBranch.DEFAULT;
        InversionFaultSystemRupSet origRupSet = InversionFaultSystemRupSetFactory.forBranch(origBranch);
        InversionTargetMFDs origTargetMFDs = origRupSet.getModule(U3InversionTargetMFDs.class);
        ModSectMinMags origMinMags = origRupSet.requireModule(ModSectMinMags.class);
        UCERF3InversionInputGenerator origGen = UCERF3InversionInputGenerator.getTestConfig(origRupSet, origBranch.getValue(FaultModels.class), origTargetMFDs);
        FaultSystemRupSet.Builder builder = FaultSystemRupSet.builder(origRupSet.getFaultSectionDataList(), origRupSet.getSectionIndicesForAllRups());
        FaultSystemRupSet rupSet = new U3InversionConfigFactory().updateRuptureSetForBranch(builder.build(), origBranch);
        U3LogicTreeBranch newBranch = rupSet.requireModule(U3LogicTreeBranch.class);
        Preconditions.checkState((boolean)newBranch.equals(origBranch));
        InversionTargetMFDs newTargetMFDs = rupSet.requireModule(U3InversionTargetMFDs.class);
        System.out.println("Validating modified min mags");
        UCERF3InversionInputGenerator.validateMinMags(origMinMags, rupSet.requireModule(ModSectMinMags.class));
        UCERF3InversionInputGenerator modGen = UCERF3InversionInputGenerator.getTestConfig(rupSet, newBranch.getValue(FaultModels.class), newTargetMFDs);
        System.out.println("Validating target MFD constraints");
        List<? extends IncrementalMagFreqDist> origConstrs = origTargetMFDs.getMFD_Constraints();
        List<? extends IncrementalMagFreqDist> newConstrs = newTargetMFDs.getMFD_Constraints();
        Preconditions.checkState((origConstrs.size() == newConstrs.size() ? 1 : 0) != 0, (Object)"MFD constraint size mismatch");
        for (int i = 0; i < origConstrs.size(); ++i) {
            IncrementalMagFreqDist origConstr = origConstrs.get(i);
            IncrementalMagFreqDist newConstr = newConstrs.get(i);
            Preconditions.checkState((boolean)origConstr.getRegion().equals(newConstr.getRegion()), (Object)"Region mismatch");
            UCERF3InversionInputGenerator.validateMFD(origConstr, newConstr);
        }
        System.out.println("Generating mod inputs");
        modGen.generateInputs();
        System.out.println("Generating orig inputs");
        origGen.generateInputs();
        UCERF3InversionInputGenerator.validate(origGen, modGen);
    }

    public static void main(String[] args) throws Exception {
        UCERF3InversionInputGenerator.testBuildNewFormat();
    }

    private static UCERF3InversionInputGenerator getTestConfig(FaultSystemRupSet rupSet, FaultModels fm, InversionTargetMFDs targetMFDs) throws IOException {
        U3LogicTreeBranch branch = U3LogicTreeBranch.DEFAULT;
        UCERF3InversionConfiguration config = UCERF3InversionConfiguration.forModel(branch.getValue(InversionModels.class), rupSet, fm, targetMFDs);
        config.setRupRateSmoothingConstraintWt(1.0);
        config.setMagnitudeEqualityConstraintWt(1.0);
        config.setSmoothnessWt(10000.0);
        config.setMomentConstraintWt(1.0);
        config.setRupRateConstraintWt(1.0);
        config.setEventRateSmoothnessWt(1.0);
        config.setParticipationSmoothnessConstraintWt(1.0);
        config.setSmoothnessWt(0.0);
        ArrayList<U3PaleoRateConstraint> paleoRateConstraints = CommandLineInversionRunner.getPaleoConstraints(fm, rupSet);
        double[] improbabilityConstraint = null;
        PaleoProbabilityModel paleoProbabilityModel = UCERF3InversionInputGenerator.loadDefaultPaleoProbabilityModel();
        List<U3AveSlipConstraint> aveSlipConstraints = U3AveSlipConstraint.load(rupSet.getFaultSectionDataList());
        return new UCERF3InversionInputGenerator(rupSet, config, paleoRateConstraints, aveSlipConstraints, improbabilityConstraint, paleoProbabilityModel);
    }

    private static void validate(UCERF3InversionInputGenerator origGen, UCERF3InversionInputGenerator modGen) {
        DoubleMatrix2D A_orig = origGen.A;
        DoubleMatrix2D A_ineq_orig = origGen.A_ineq;
        double[] d_orig = origGen.d;
        double[] d_ineq_orig = origGen.d_ineq;
        List origRanges = origGen.constraintRowRanges;
        double[] initial_orig = origGen.initialSolution;
        DoubleMatrix2D A_new = modGen.A;
        DoubleMatrix2D A_ineq_new = modGen.A_ineq;
        double[] d_new = modGen.d;
        double[] d_ineq_new = modGen.d_ineq;
        List newRanges = modGen.constraintRowRanges;
        double[] initial_new = modGen.initialSolution;
        System.out.println("A orig size: " + A_orig.rows() + " x " + A_orig.columns());
        System.out.println("A new size: " + A_new.rows() + " x " + A_new.columns());
        if (A_ineq_orig != null || A_ineq_new != null) {
            System.out.println("A_ineq orig size: " + A_ineq_orig.rows() + " x " + A_ineq_orig.columns());
            System.out.println("A_ineq new size: " + A_ineq_new.rows() + " x " + A_ineq_new.columns());
        }
        for (boolean ineq : new boolean[]{false, true}) {
            List<ConstraintRange> ranges1 = UCERF3InversionInputGenerator.getMatches(origRanges, ineq);
            List<ConstraintRange> ranges2 = UCERF3InversionInputGenerator.getMatches(newRanges, ineq);
            Preconditions.checkState((ranges1.size() == ranges2.size() ? 1 : 0) != 0, (String)"Range sizes inconsistent: %s != %s", (int)ranges1.size(), (int)ranges2.size());
            for (int i = 0; i < ranges1.size(); ++i) {
                ConstraintRange r1 = ranges1.get(i);
                ConstraintRange r2 = ranges2.get(i);
                Preconditions.checkState((r1.startRow == r2.startRow ? 1 : 0) != 0, (String)"Start row mismatch:\n\tORIG: %s\n\tNEW: %s", (Object)r1, (Object)r2);
                Preconditions.checkState((r1.endRow == r2.endRow ? 1 : 0) != 0, (String)"End row mismatch:\n\tORIG: %s\n\tNEW: %s", (Object)r1, (Object)r2);
            }
        }
        System.out.println("Validating A");
        UCERF3InversionInputGenerator.validateA(A_orig, A_new, origRanges, false);
        if (A_ineq_orig != null || A_ineq_new != null) {
            System.out.println("Validating A_ineq");
            UCERF3InversionInputGenerator.validateA(A_ineq_orig, A_ineq_new, origRanges, true);
        }
        System.out.println("Validating D");
        UCERF3InversionInputGenerator.validateD(d_orig, d_new, origRanges, false);
        if (d_ineq_orig != null || d_ineq_new != null) {
            System.out.println("Validating D_ineq");
            UCERF3InversionInputGenerator.validateD(d_ineq_orig, d_ineq_new, origRanges, true);
        }
        System.out.println("Validating initial");
        UCERF3InversionInputGenerator.validateRates(initial_orig, initial_new);
        System.out.println("Validating waterlevel");
        UCERF3InversionInputGenerator.validateRates(origGen.getWaterLevelRates(), modGen.getWaterLevelRates());
    }

    private static List<ConstraintRange> getMatches(List<ConstraintRange> ranges, boolean ineq) {
        ArrayList<ConstraintRange> ret = new ArrayList<ConstraintRange>();
        for (ConstraintRange range : ranges) {
            if (ineq != range.inequality) continue;
            ret.add(range);
        }
        return ret;
    }

    private static void validateA(DoubleMatrix2D A_orig, DoubleMatrix2D A_new, List<ConstraintRange> constraintRanges, boolean ineq) {
        Preconditions.checkState((A_orig != A_new ? 1 : 0) != 0, (Object)"orig and new are same instance!");
        ValidateFunc validateFunc = new ValidateFunc(A_new, constraintRanges, ineq);
        A_orig.forEachNonZero((IntIntDoubleFunction)validateFunc);
        long origCount = validateFunc.count;
        ValidateFunc countFunc = new ValidateFunc(null, null, ineq);
        A_new.forEachNonZero((IntIntDoubleFunction)countFunc);
        long newCount = countFunc.count;
        Preconditions.checkState((origCount == newCount ? 1 : 0) != 0, (String)"Nonzero count mismatch: %s != %s", (long)origCount, (long)newCount);
        System.out.println("Validated " + origCount + " non-zero values");
    }

    private static void validateD(double[] d_orig, double[] d_new, List<ConstraintRange> constraintRanges, boolean ineq) {
        Preconditions.checkState((d_orig != d_new ? 1 : 0) != 0, (Object)"orig and new are same instance!");
        Preconditions.checkState((d_orig.length == d_new.length ? 1 : 0) != 0, (String)"d length mismatch: %s != %s", (int)d_orig.length, (int)d_new.length);
        for (int i = 0; i < d_orig.length; ++i) {
            ConstraintRange matchRange = null;
            if (d_orig[i] != d_new[i]) {
                for (ConstraintRange range : constraintRanges) {
                    if (!range.contains(i, ineq)) continue;
                    matchRange = range;
                }
            }
            UCERF3InversionInputGenerator.validate(d_orig[i], d_new[i], "d", i, "\nConstraint: " + String.valueOf(matchRange));
        }
        System.out.println("Validated " + d_orig.length + " data values");
    }

    private static void validateRates(double[] origRates, double[] newRates) {
        if (origRates == null) {
            Preconditions.checkState((newRates == null ? 1 : 0) != 0, (Object)"orig is null but new isn't");
            System.out.println("Both are null, skipping");
            return;
        }
        Preconditions.checkNotNull((Object)newRates, (Object)"orig is non-null but new is null");
        Preconditions.checkState((origRates != newRates ? 1 : 0) != 0, (Object)"orig and new are same instance!");
        Preconditions.checkState((origRates.length == newRates.length ? 1 : 0) != 0, (String)"rates length mismatch: %s != %s", (int)origRates.length, (int)newRates.length);
        for (int i = 0; i < newRates.length; ++i) {
            UCERF3InversionInputGenerator.validate(origRates[i], newRates[i], "rate", i);
        }
        System.out.println("Validated " + origRates.length + " rate values");
    }

    private static void validateMinMags(ModSectMinMags origMinMags, ModSectMinMags newMinMags) {
        double[] newVals;
        double[] origVals = origMinMags.getMinMagForSections();
        Preconditions.checkState((origVals != (newVals = newMinMags.getMinMagForSections()) ? 1 : 0) != 0, (Object)"orig and new are same instance!");
        Preconditions.checkState((origVals.length == newVals.length ? 1 : 0) != 0, (String)"rates length mismatch: %s != %s", (int)origVals.length, (int)newVals.length);
        for (int i = 0; i < origVals.length; ++i) {
            UCERF3InversionInputGenerator.validate(origVals[i], newVals[i], "min mag", i);
        }
        System.out.println("Validated " + origVals.length + " rate values");
    }

    private static void validateMFD(IncrementalMagFreqDist origMFD, IncrementalMagFreqDist newMFD) {
        Preconditions.checkState((origMFD != newMFD ? 1 : 0) != 0, (Object)"orig and new are same instance!");
        Preconditions.checkState((origMFD.size() == newMFD.size() ? 1 : 0) != 0, (String)"rates length mismatch: %s != %s", (int)origMFD.size(), (int)newMFD.size());
        for (int i = 0; i < newMFD.size(); ++i) {
            Point2D origPt = origMFD.get(i);
            Point2D newPt = newMFD.get(i);
            UCERF3InversionInputGenerator.validate(origPt.getX(), newPt.getX(), "x", i);
            UCERF3InversionInputGenerator.validate(origPt.getY(), newPt.getY(), "y", i, " at x=" + (float)origPt.getX());
        }
    }

    private static void validate(double val1, double val2, String type, int index) {
        UCERF3InversionInputGenerator.validate(val1, val2, type, index, "");
    }

    private static void validate(double val1, double val2, String type, int index, String extra) {
        Preconditions.checkState((val1 == val2 || !test_double_percision && (float)val1 == (float)val2 ? 1 : 0) != 0, (String)(type + " mismatch at %s: %s != %s" + extra), (Object)index, (Object)val1, (Object)val2);
    }

    private static class ValidateFunc
    implements IntIntDoubleFunction {
        private DoubleMatrix2D compare;
        private List<ConstraintRange> constraintRanges;
        private boolean ineq;
        private long count = 0L;

        public ValidateFunc(DoubleMatrix2D compare, List<ConstraintRange> constraintRanges, boolean ineq) {
            this.compare = compare;
            this.constraintRanges = constraintRanges;
            this.ineq = ineq;
        }

        public double apply(int row, int col, double val) {
            if (this.compare != null) {
                double oVal = this.compare.get(row, col);
                ConstraintRange matchRange = null;
                if (val != oVal) {
                    for (ConstraintRange range : this.constraintRanges) {
                        if (!range.contains(row, this.ineq)) continue;
                        matchRange = range;
                    }
                }
                Preconditions.checkState((val == oVal || !test_double_percision && (float)val == (float)oVal ? 1 : 0) != 0, (String)"Value mismatch at row=%s, col=%s: %s != %s\nConstraint: %s", (Object[])new Object[]{row, col, val, oVal, matchRange});
            }
            ++this.count;
            return val;
        }
    }
}

