/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.inversion.laughTest;

import java.util.List;
import java.util.Map;
import org.opensha.commons.util.IDPairing;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.PlausibilityResult;
import org.opensha.sha.faultSurface.FaultSection;
import scratch.UCERF3.inversion.laughTest.AbstractPlausibilityFilter;

public class CumulativeJumpDistFilter
extends AbstractPlausibilityFilter {
    private Map<IDPairing, Double> distances;
    private double maxCmlJumpDist;

    public CumulativeJumpDistFilter(Map<IDPairing, Double> distances, double maxCmlJumpDist) {
        this.distances = distances;
        this.maxCmlJumpDist = maxCmlJumpDist;
    }

    @Override
    public PlausibilityResult applyLastSection(List<? extends FaultSection> rupture, List<IDPairing> pairings, List<Integer> junctionIndexes) {
        double dist = 0.0;
        for (int junctionIndex : junctionIndexes) {
            IDPairing pair = pairings.get(junctionIndex + 1);
            dist += this.distances.get(pair).doubleValue();
        }
        if (dist <= this.maxCmlJumpDist) {
            return PlausibilityResult.PASS;
        }
        return PlausibilityResult.FAIL_HARD_STOP;
    }

    @Override
    public boolean isApplyJunctionsOnly() {
        return true;
    }

    @Override
    public String getName() {
        return "Cumulative Jump Dist Filter";
    }

    @Override
    public String getShortName() {
        return "CumJumpDist";
    }
}

