/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.inversion.laughTest;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.dom4j.Attribute;
import org.dom4j.Element;
import org.opensha.commons.util.IDPairing;
import org.opensha.sha.faultSurface.FaultSection;
import scratch.UCERF3.inversion.coulomb.CoulombRates;
import scratch.UCERF3.inversion.coulomb.CoulombRatesTester;
import scratch.UCERF3.inversion.laughTest.AbstractPlausibilityFilter;
import scratch.UCERF3.inversion.laughTest.AzimuthChangeFilter;
import scratch.UCERF3.inversion.laughTest.BuggyCoulombFilter;
import scratch.UCERF3.inversion.laughTest.CoulombFilter;
import scratch.UCERF3.inversion.laughTest.CumulativeAzimuthChangeFilter;
import scratch.UCERF3.inversion.laughTest.CumulativeJumpDistFilter;
import scratch.UCERF3.inversion.laughTest.CumulativeRakeChangeFilter;
import scratch.UCERF3.inversion.laughTest.MinSectsPerParentFilter;
import scratch.UCERF3.inversion.laughTest.OldPlausibilityConfiguration;

public class UCERF3PlausibilityConfig
implements OldPlausibilityConfiguration {
    public static final String XML_METADATA_NAME = "LaughTestFilter";
    private double maxJumpDist;
    private double maxAzimuthChange;
    private double maxTotAzimuthChange;
    private double maxCmlJumpDist;
    private double maxCmlRakeChange;
    private double maxCmlAzimuthChange;
    private int minNumSectInRup;
    private CoulombRates coulombRates;
    private CoulombRatesTester coulombTester;
    private boolean applyGarlockPintoMtnFix;
    private HashSet<Integer> parentSectsToIgnore;
    private boolean allowSingleSectDuringJumps;
    private List<AbstractPlausibilityFilter> laughTests;
    private boolean ucerf3p2Filter = false;

    public static UCERF3PlausibilityConfig getUCERF3p2Filter() {
        System.err.println("*** WARNING ***");
        System.err.println("UCERF3.2 and before laugh test bugs have been enabled for backwards compatibility. This should be disabled before future production runs!");
        System.err.println("*** WARNING ***");
        double maxAzimuthChange = 60.0;
        double maxJumpDist = 5.0;
        double maxCumJumpDist = Double.POSITIVE_INFINITY;
        double maxTotAzimuthChange = 60.0;
        int minNumSectInRup = 2;
        double maxCmlRakeChange = 180.0;
        double maxCmlAzimuthChange = 560.0;
        boolean allowSingleSectDuringJumps = false;
        double minAverageProb = 0.1;
        double minIndividualProb = 0.1;
        double minimumStressExclusionCeiling = 1.5;
        boolean applyBranchesOnly = true;
        boolean allowAnyWay = false;
        CoulombRatesTester coulombTester = new CoulombRatesTester(CoulombRatesTester.TestType.COULOMB_STRESS, minAverageProb, minIndividualProb, minimumStressExclusionCeiling, applyBranchesOnly, allowAnyWay);
        coulombTester.setBuggyMinStress(true);
        boolean applyGarlockPintoMtnFix = true;
        UCERF3PlausibilityConfig filter = new UCERF3PlausibilityConfig(maxJumpDist, maxAzimuthChange, maxTotAzimuthChange, maxCumJumpDist, maxCmlRakeChange, maxCmlAzimuthChange, minNumSectInRup, allowSingleSectDuringJumps, coulombTester, applyGarlockPintoMtnFix);
        filter.ucerf3p2Filter = true;
        return filter;
    }

    public static UCERF3PlausibilityConfig getDefault() {
        double maxAzimuthChange = 60.0;
        double maxJumpDist = 5.0;
        double maxCumJumpDist = Double.POSITIVE_INFINITY;
        double maxTotAzimuthChange = 60.0;
        int minNumSectInRup = 2;
        double maxCmlRakeChange = 180.0;
        double maxCmlAzimuthChange = 560.0;
        boolean allowSingleSectDuringJumps = true;
        double minAverageProb = 0.04;
        double minIndividualProb = 0.04;
        double minimumStressExclusionCeiling = 1.25;
        boolean applyBranchesOnly = true;
        boolean allowAnyWay = true;
        CoulombRatesTester coulombTester = new CoulombRatesTester(CoulombRatesTester.TestType.COULOMB_STRESS, minAverageProb, minIndividualProb, minimumStressExclusionCeiling, applyBranchesOnly, allowAnyWay);
        boolean applyGarlockPintoMtnFix = true;
        return new UCERF3PlausibilityConfig(maxJumpDist, maxAzimuthChange, maxTotAzimuthChange, maxCumJumpDist, maxCmlRakeChange, maxCmlAzimuthChange, minNumSectInRup, allowSingleSectDuringJumps, coulombTester, applyGarlockPintoMtnFix);
    }

    public UCERF3PlausibilityConfig(double maxJumpDist, double maxAzimuthChange, double maxTotAzimuthChange, double maxCumJumpDist, double maxCmlRakeChange, double maxCmlAzimuthChange, int minNumSectInRup, boolean allowSingleSectDuringJumps, CoulombRatesTester coulombTester, boolean applyGarlockPintoMtnFix) {
        this.maxJumpDist = maxJumpDist;
        this.maxAzimuthChange = maxAzimuthChange;
        this.maxTotAzimuthChange = maxTotAzimuthChange;
        this.maxCmlJumpDist = maxCumJumpDist;
        this.maxCmlRakeChange = maxCmlRakeChange;
        this.maxCmlAzimuthChange = maxCmlAzimuthChange;
        this.minNumSectInRup = minNumSectInRup;
        this.allowSingleSectDuringJumps = allowSingleSectDuringJumps;
        this.coulombTester = coulombTester;
        this.applyGarlockPintoMtnFix = applyGarlockPintoMtnFix;
    }

    public void setCoulombRates(CoulombRates coulombRates) {
        this.coulombRates = coulombRates;
    }

    public void clearLaughTests() {
        this.laughTests = null;
    }

    @Override
    public synchronized List<AbstractPlausibilityFilter> buildPlausibilityFilters(Map<IDPairing, Double> azimuths, Map<IDPairing, Double> distances, List<List<Integer>> sectionConnectionsListList, List<? extends FaultSection> subSectData) {
        ArrayList tests2 = Lists.newArrayList();
        if (this.minNumSectInRup > 0) {
            tests2.add(new MinSectsPerParentFilter.ContinualFilter(this.minNumSectInRup));
            tests2.add(new MinSectsPerParentFilter.CleanupFilter(this.minNumSectInRup, this.allowSingleSectDuringJumps, sectionConnectionsListList, subSectData));
        }
        if (!UCERF3PlausibilityConfig.isNaNInfinite(this.maxAzimuthChange) || !UCERF3PlausibilityConfig.isNaNInfinite(this.maxTotAzimuthChange)) {
            tests2.add(new AzimuthChangeFilter(this.maxAzimuthChange, this.maxTotAzimuthChange, this.applyGarlockPintoMtnFix, azimuths));
        }
        if (!UCERF3PlausibilityConfig.isNaNInfinite(this.maxCmlJumpDist)) {
            tests2.add(new CumulativeJumpDistFilter(distances, this.maxCmlJumpDist));
        }
        if (!UCERF3PlausibilityConfig.isNaNInfinite(this.maxCmlRakeChange)) {
            HashMap<Integer, Double> rakesMap = new HashMap<Integer, Double>();
            for (FaultSection faultSection : subSectData) {
                rakesMap.put(faultSection.getSectionId(), faultSection.getAveRake());
            }
            tests2.add(new CumulativeRakeChangeFilter(rakesMap, this.maxCmlRakeChange));
        }
        if (!UCERF3PlausibilityConfig.isNaNInfinite(this.maxCmlAzimuthChange)) {
            tests2.add(new CumulativeAzimuthChangeFilter(azimuths, this.maxCmlAzimuthChange));
        }
        if (this.coulombTester != null) {
            Preconditions.checkNotNull((Object)this.coulombRates, (Object)"Coulomb filter enabled but Coulomb rates not set");
            if (this.ucerf3p2Filter) {
                tests2.add(new BuggyCoulombFilter(this.coulombRates, this.coulombTester, subSectData, sectionConnectionsListList));
            } else {
                tests2.add(new CoulombFilter(this.coulombRates, this.coulombTester));
            }
        }
        this.laughTests = tests2;
        if (this.ucerf3p2Filter) {
            this.getLaughTest(AzimuthChangeFilter.class).setUCERF3p2LL_List();
            this.getLaughTest(AzimuthChangeFilter.class).setTotAzChangeAtJunctionsOnly(true);
            if (!UCERF3PlausibilityConfig.isNaNInfinite(this.maxCmlAzimuthChange)) {
                this.getLaughTest(CumulativeAzimuthChangeFilter.class).setBuggyAzChange(true);
            }
        }
        return tests2;
    }

    @Override
    public List<AbstractPlausibilityFilter> getPlausibilityFilters() {
        return this.laughTests;
    }

    public <E extends AbstractPlausibilityFilter> E getLaughTest(Class<E> clazz) {
        if (this.laughTests == null) {
            return null;
        }
        for (AbstractPlausibilityFilter test : this.laughTests) {
            if (!clazz.isInstance(test)) continue;
            return (E)test;
        }
        return null;
    }

    private static boolean isNaNInfinite(double val) {
        if (Double.isNaN(val)) {
            return true;
        }
        if (Double.isInfinite(val)) {
            return true;
        }
        return val == Double.MAX_VALUE;
    }

    @Override
    public double getMaxJumpDist() {
        return this.maxJumpDist;
    }

    public void setMaxJumpDist(double maxJumpDist) {
        this.maxJumpDist = maxJumpDist;
    }

    public double getMaxAzimuthChange() {
        return this.maxAzimuthChange;
    }

    public void setMaxAzimuthChange(double maxAzimuthChange) {
        this.maxAzimuthChange = maxAzimuthChange;
    }

    public double getMaxTotAzimuthChange() {
        return this.maxTotAzimuthChange;
    }

    public void setMaxTotAzimuthChange(double maxTotAzimuthChange) {
        this.maxTotAzimuthChange = maxTotAzimuthChange;
    }

    public double getMaxCmlJumpDist() {
        return this.maxCmlJumpDist;
    }

    public void setMaxCmlmJumpDist(double maxCumJumpDist) {
        this.maxCmlJumpDist = maxCumJumpDist;
    }

    public double getMaxCmlRakeChange() {
        return this.maxCmlRakeChange;
    }

    public void setMaxCmlRakeChange(double maxCmlRakeChange) {
        this.maxCmlRakeChange = maxCmlRakeChange;
    }

    public double getMaxCmlAzimuthChange() {
        return this.maxCmlAzimuthChange;
    }

    public void setMaxCmlAzimuthChange(double maxCmlAzimuthChange) {
        this.maxCmlAzimuthChange = maxCmlAzimuthChange;
    }

    public int getMinNumSectInRup() {
        return this.minNumSectInRup;
    }

    public void setMinNumSectInRup(int minNumSectInRup) {
        this.minNumSectInRup = minNumSectInRup;
    }

    public boolean isAllowSingleSectDuringJumps() {
        return this.allowSingleSectDuringJumps;
    }

    public void setAllowSingleSectDuringJumps(boolean allowSingleSectDuringJumps) {
        this.allowSingleSectDuringJumps = allowSingleSectDuringJumps;
    }

    public CoulombRatesTester getCoulombFilter() {
        return this.coulombTester;
    }

    public void setCoulombFilter(CoulombRatesTester coulombFilter) {
        this.coulombTester = coulombFilter;
    }

    @Override
    public HashSet<Integer> getParentSectsToIgnore() {
        return this.parentSectsToIgnore;
    }

    public void setParentSectsToIgnore(HashSet<Integer> parentSectsToIgnore) {
        this.parentSectsToIgnore = parentSectsToIgnore;
    }

    public String toString() {
        return "LaughTestFilter [maxJumpDist=" + this.maxJumpDist + ", maxAzimuthChange=" + this.maxAzimuthChange + ", maxTotAzimuthChange=" + this.maxTotAzimuthChange + ", maxCumJumpDist=" + this.maxCmlJumpDist + ", maxCmlRakeChange=" + this.maxCmlRakeChange + ", maxCmlAzimuthChange=" + this.maxCmlAzimuthChange + ", minNumSectInRup=" + this.minNumSectInRup + ", coulombFilter=" + String.valueOf(this.coulombTester) + "]";
    }

    @Override
    public Element toXMLMetadata(Element root) {
        Element el = root.addElement(XML_METADATA_NAME);
        el.addAttribute("maxJumpDist", "" + this.maxJumpDist);
        el.addAttribute("maxAzimuthChange", "" + this.maxAzimuthChange);
        el.addAttribute("maxTotAzimuthChange", "" + this.maxTotAzimuthChange);
        el.addAttribute("maxCmlJumpDist", "" + this.maxCmlJumpDist);
        el.addAttribute("maxCmlRakeChange", "" + this.maxCmlRakeChange);
        el.addAttribute("maxCmlAzimuthChange", "" + this.maxCmlAzimuthChange);
        el.addAttribute("minNumSectInRup", "" + this.minNumSectInRup);
        el.addAttribute("allowSingleSectDuringJumps", "" + this.allowSingleSectDuringJumps);
        el.addAttribute("applyGarlockPintoMtnFix", "" + this.applyGarlockPintoMtnFix);
        if (this.ucerf3p2Filter) {
            el.addAttribute("ucerf3p2Filter", "" + this.ucerf3p2Filter);
        }
        if (this.coulombTester != null) {
            this.coulombTester.toXMLMetadata(el);
        }
        if (this.parentSectsToIgnore != null && !this.parentSectsToIgnore.isEmpty()) {
            Element ignoresEl = el.addElement("IgnoredParents");
            for (Integer parentSect : this.parentSectsToIgnore) {
                Element ignoreEl = ignoresEl.addElement("Parent");
                ignoreEl.addAttribute("id", "" + parentSect);
            }
        }
        return root;
    }

    public static UCERF3PlausibilityConfig fromXMLMetadata(Element laughEl) {
        double maxJumpDist = Double.parseDouble(laughEl.attributeValue("maxJumpDist"));
        double maxAzimuthChange = Double.parseDouble(laughEl.attributeValue("maxAzimuthChange"));
        double maxTotAzimuthChange = Double.parseDouble(laughEl.attributeValue("maxTotAzimuthChange"));
        double maxCmlJumpDist = Double.parseDouble(laughEl.attributeValue("maxCmlJumpDist"));
        double maxCmlRakeChange = Double.parseDouble(laughEl.attributeValue("maxCmlRakeChange"));
        double maxCmlAzimuthChange = Double.parseDouble(laughEl.attributeValue("maxCmlAzimuthChange"));
        int minNumSectInRup = Integer.parseInt(laughEl.attributeValue("minNumSectInRup"));
        boolean allowSingleSectDuringJumps = Boolean.parseBoolean(laughEl.attributeValue("allowSingleSectDuringJumps"));
        Attribute fixAtt = laughEl.attribute("applyGarlockPintoMtnFix");
        boolean applyGarlockPintoMtnFix = fixAtt == null ? true : Boolean.parseBoolean(fixAtt.getValue());
        CoulombRatesTester coulombFilter = null;
        Element coulombEl = laughEl.element("CoulombRatesTester");
        if (coulombEl != null) {
            coulombFilter = CoulombRatesTester.fromXMLMetadata(coulombEl);
        }
        UCERF3PlausibilityConfig filter = new UCERF3PlausibilityConfig(maxJumpDist, maxAzimuthChange, maxTotAzimuthChange, maxCmlJumpDist, maxCmlRakeChange, maxCmlAzimuthChange, minNumSectInRup, allowSingleSectDuringJumps, coulombFilter, applyGarlockPintoMtnFix);
        Element ignoresEl = laughEl.element("IgnoredParents");
        if (ignoresEl != null) {
            HashSet<Integer> ignores = new HashSet<Integer>();
            Iterator ignoresIt = laughEl.elementIterator();
            while (ignoresIt.hasNext()) {
                ignores.add(Integer.parseInt(((Element)ignoresIt.next()).attributeValue("id")));
            }
            filter.setParentSectsToIgnore(ignores);
        }
        return filter;
    }
}

