/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.logicTree;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Element;
import org.opensha.commons.logicTree.LogicTreeBranch;
import org.opensha.commons.logicTree.LogicTreeLevel;
import org.opensha.commons.metadata.XMLSaveable;
import org.opensha.commons.util.ClassUtils;
import scratch.UCERF3.enumTreeBranches.DeformationModels;
import scratch.UCERF3.enumTreeBranches.FaultModels;
import scratch.UCERF3.enumTreeBranches.InversionModels;
import scratch.UCERF3.enumTreeBranches.MaxMagOffFault;
import scratch.UCERF3.enumTreeBranches.MomentRateFixes;
import scratch.UCERF3.enumTreeBranches.ScalingRelationships;
import scratch.UCERF3.enumTreeBranches.SlipAlongRuptureModels;
import scratch.UCERF3.enumTreeBranches.SpatialSeisPDF;
import scratch.UCERF3.enumTreeBranches.TotalMag5Rate;
import scratch.UCERF3.logicTree.U3LogicTreeBranchNode;
import scratch.UCERF3.logicTree.VariableLogicTreeBranch;

public class U3LogicTreeBranch
extends LogicTreeBranch<U3LogicTreeBranchNode<?>>
implements XMLSaveable {
    public static final String XML_METADATA_NAME = "LogicTreeBranch";
    public static final U3LogicTreeBranch DEFAULT = U3LogicTreeBranch.fromValues(FaultModels.FM3_1, DeformationModels.ZENGBB, ScalingRelationships.SHAW_2009_MOD, SlipAlongRuptureModels.TAPERED, InversionModels.CHAR_CONSTRAINED, TotalMag5Rate.RATE_7p9, MaxMagOffFault.MAG_7p6, MomentRateFixes.NONE, SpatialSeisPDF.UCERF3);
    public static final U3LogicTreeBranch UCERF2 = U3LogicTreeBranch.fromValues(FaultModels.FM2_1, DeformationModels.UCERF2_ALL, ScalingRelationships.AVE_UCERF2, SlipAlongRuptureModels.UNIFORM, InversionModels.CHAR_CONSTRAINED, TotalMag5Rate.RATE_6p5, MaxMagOffFault.MAG_7p6, MomentRateFixes.NONE, SpatialSeisPDF.UCERF2);
    private static List<Class<? extends U3LogicTreeBranchNode<?>>> logicTreeClasses;
    private static List<LogicTreeLevel<? extends U3LogicTreeBranchNode<?>>> levels;
    private static Table<Class<? extends U3LogicTreeBranchNode<?>>, InversionModels, Double> classWeightTotals;

    public static U3LogicTreeBranch getMEAN_UCERF3(FaultModels fm) {
        return U3LogicTreeBranch.getMEAN_UCERF3(fm, DeformationModels.MEAN_UCERF3);
    }

    public static U3LogicTreeBranch getMEAN_UCERF3(FaultModels fm, DeformationModels dm) {
        return U3LogicTreeBranch.fromValues(fm, dm, ScalingRelationships.MEAN_UCERF3, SlipAlongRuptureModels.MEAN_UCERF3, InversionModels.CHAR_CONSTRAINED, TotalMag5Rate.RATE_7p9, MaxMagOffFault.MAG_7p6, MomentRateFixes.NONE, SpatialSeisPDF.UCERF3);
    }

    public static synchronized List<Class<? extends U3LogicTreeBranchNode<?>>> getLogicTreeNodeClasses() {
        if (logicTreeClasses == null) {
            logicTreeClasses = Lists.newArrayList();
            logicTreeClasses.add(FaultModels.class);
            logicTreeClasses.add(DeformationModels.class);
            logicTreeClasses.add(ScalingRelationships.class);
            logicTreeClasses.add(SlipAlongRuptureModels.class);
            logicTreeClasses.add(InversionModels.class);
            logicTreeClasses.add(TotalMag5Rate.class);
            logicTreeClasses.add(MaxMagOffFault.class);
            logicTreeClasses.add(MomentRateFixes.class);
            logicTreeClasses.add(SpatialSeisPDF.class);
            logicTreeClasses = Collections.unmodifiableList(logicTreeClasses);
        }
        return logicTreeClasses;
    }

    public static synchronized List<LogicTreeLevel<? extends U3LogicTreeBranchNode<?>>> getLogicTreeLevels() {
        if (levels == null) {
            levels = new ArrayList();
            for (Class<U3LogicTreeBranchNode<?>> clazz : U3LogicTreeBranch.getLogicTreeNodeClasses()) {
                U3LogicTreeBranchNode<?> value0 = clazz.getEnumConstants()[0];
                LogicTreeLevel.EnumBackedLevel level = LogicTreeLevel.forEnumUnchecked(value0, value0.getBranchLevelName(), value0.getShortBranchLevelName());
                levels.add(level);
            }
        }
        return levels;
    }

    protected U3LogicTreeBranch(U3LogicTreeBranch branch) {
        super(branch);
    }

    protected U3LogicTreeBranch(List<U3LogicTreeBranchNode<?>> branch) {
        super(U3LogicTreeBranch.getLogicTreeLevels(), branch);
    }

    protected U3LogicTreeBranch(List<LogicTreeLevel<? extends U3LogicTreeBranchNode<?>>> levels, List<U3LogicTreeBranchNode<?>> branch) {
        super(levels, branch);
    }

    protected U3LogicTreeBranch() {
    }

    public int getNumAwayFrom(U3LogicTreeBranch branch) {
        return super.getNumAwayFrom(branch);
    }

    public static <E extends U3LogicTreeBranchNode<?>> Class<E> getEnumEnclosingClass(Class<E> clazz) {
        if (!clazz.isEnum()) {
            clazz = clazz.getEnclosingClass();
        }
        return clazz;
    }

    @Override
    public String buildFileName() {
        Object str = null;
        for (int i = 0; i < this.size(); ++i) {
            U3LogicTreeBranchNode value = (U3LogicTreeBranchNode)this.getValue(i);
            if (value == null) {
                throw new IllegalStateException("Must be fully specified to build file name! (missing=" + ClassUtils.getClassNameWithoutPackage(U3LogicTreeBranch.getLogicTreeNodeClasses().get(i)) + ")");
            }
            str = str == null ? "" : (String)str + "_";
            str = (String)str + value.encodeChoiceString();
        }
        return str;
    }

    public static U3LogicTreeBranch fromValues(List<U3LogicTreeBranchNode<?>> vals) {
        U3LogicTreeBranchNode[] valsArray = new U3LogicTreeBranchNode[vals.size()];
        for (int i = 0; i < vals.size(); ++i) {
            valsArray[i] = vals.get(i);
        }
        return U3LogicTreeBranch.fromValues(valsArray);
    }

    public static U3LogicTreeBranch fromValues(U3LogicTreeBranchNode<?> ... vals) {
        return U3LogicTreeBranch.fromValues(true, vals);
    }

    public static U3LogicTreeBranch fromValues(boolean setNullToDefault, U3LogicTreeBranchNode<?> ... vals) {
        List<Class<U3LogicTreeBranchNode<?>>> classes = U3LogicTreeBranch.getLogicTreeNodeClasses();
        ArrayList values = Lists.newArrayList();
        for (int i = 0; i < classes.size(); ++i) {
            values.add(null);
        }
        for (U3LogicTreeBranchNode<?> val : vals) {
            if (val == null) continue;
            Class<?> valClass = U3LogicTreeBranch.getEnumEnclosingClass(val.getClass());
            int ind = -1;
            for (int i = 0; i < classes.size(); ++i) {
                Class<U3LogicTreeBranchNode<?>> clazz = classes.get(i);
                if (!clazz.equals(valClass)) continue;
                ind = i;
                break;
            }
            Preconditions.checkArgument((ind >= 0 ? 1 : 0) != 0, (Object)("Value of class '" + String.valueOf(valClass) + "' not a valid logic tree branch class"));
            values.set(ind, val);
        }
        U3LogicTreeBranch branch = new U3LogicTreeBranch(values);
        if (setNullToDefault) {
            if (branch.getValue(FaultModels.class) == null && branch.getValue(DeformationModels.class) != null) {
                int fmIndex = U3LogicTreeBranch.getLogicTreeNodeClasses().indexOf(FaultModels.class);
                DeformationModels dm = branch.getValue(DeformationModels.class);
                FaultModels defaultFM = DEFAULT.getValue(FaultModels.class);
                if (dm.getApplicableFaultModels().contains(defaultFM)) {
                    branch.setValue(fmIndex, defaultFM);
                } else {
                    branch.setValue(fmIndex, (U3LogicTreeBranchNode)dm.getApplicableFaultModels().get(0));
                }
            }
            for (int i = 0; i < classes.size(); ++i) {
                if (branch.getValue(i) != null) continue;
                branch.setValue(i, (U3LogicTreeBranchNode)DEFAULT.getValue(i));
            }
        }
        return branch;
    }

    public static U3LogicTreeBranch fromStringValues(List<String> strings) {
        return U3LogicTreeBranch.fromFileName(Joiner.on((String)"_").join(strings));
    }

    public static U3LogicTreeBranch fromFileName(String fileName) {
        List<Class<U3LogicTreeBranchNode<?>>> classes = U3LogicTreeBranch.getLogicTreeNodeClasses();
        ArrayList branch = Lists.newArrayList();
        for (Class<U3LogicTreeBranchNode<?>> clazz : classes) {
            U3LogicTreeBranchNode<?>[] options;
            U3LogicTreeBranchNode<?> value = null;
            for (U3LogicTreeBranchNode<?> option : options = clazz.getEnumConstants()) {
                if (!U3LogicTreeBranch.doesStringContainOption(option, fileName)) continue;
                value = option;
                break;
            }
            branch.add(value);
        }
        return new U3LogicTreeBranch(branch);
    }

    private static boolean doesStringContainOption(U3LogicTreeBranchNode<?> option, String str) {
        String encoded = option.encodeChoiceString();
        return str.startsWith(encoded + "_") || str.contains("_" + encoded + "_") || str.contains("_" + encoded + ".") || str.endsWith("_" + encoded);
    }

    public static <E extends Enum<E>> E parseValue(Class<? extends U3LogicTreeBranchNode<E>> clazz, String str) {
        U3LogicTreeBranchNode<E>[] options;
        for (U3LogicTreeBranchNode<E> option : options = clazz.getEnumConstants()) {
            if (!U3LogicTreeBranch.doesStringContainOption(option, str)) continue;
            return (E)((Enum)((Object)option));
        }
        return null;
    }

    public String getTabSepValStringHeader() {
        return "FltMod\tDefMod\tScRel\tSlipAlongMod\tInvModels\tM5Rate\tMmaxOff\tMoRateFix\tSpatSeisPDF";
    }

    public String getTabSepValString() {
        Object str = "";
        boolean first = true;
        for (U3LogicTreeBranchNode val : this) {
            if (!first) {
                str = (String)str + "\t";
            } else {
                first = false;
            }
            if (val == null) {
                str = (String)str + "(null)";
                continue;
            }
            str = (String)str + val.getShortName();
        }
        return str;
    }

    public static void main(String[] args) throws IOException {
        String str = DEFAULT.buildFileName();
        System.out.println("PARSING: " + str);
        U3LogicTreeBranch br = U3LogicTreeBranch.fromFileName(str);
        FaultModels fm = (FaultModels)U3LogicTreeBranch.parseValue(FaultModels.class, str);
        System.out.println("FM? " + String.valueOf(fm));
        System.out.println("Num away? " + br.getNumAwayFrom(br));
        U3LogicTreeBranch br2 = U3LogicTreeBranch.fromFileName(str);
        System.out.println(br2);
        System.out.println("Num away? " + br.getNumAwayFrom(br2));
        br2.setValue(FaultModels.FM3_2);
        System.out.println(br2);
        System.out.println("Num away? " + br.getNumAwayFrom(br2));
        String json = br.getJSON();
        System.out.println(json);
    }

    @Override
    public Object clone() {
        ArrayList newBranches = Lists.newArrayList();
        for (int i = 0; i < this.size(); ++i) {
            newBranches.add((U3LogicTreeBranchNode)this.getValue(i));
        }
        return new U3LogicTreeBranch(newBranches);
    }

    public U3LogicTreeBranch copy() {
        return new U3LogicTreeBranch(this);
    }

    public double getAprioriBranchWt() {
        double wt = 1.0;
        InversionModels im = this.getValue(InversionModels.class);
        for (U3LogicTreeBranchNode node : this) {
            wt *= U3LogicTreeBranch.getNormalizedWt(node, im);
        }
        return wt;
    }

    private static synchronized double getClassWeightTotal(Class<? extends U3LogicTreeBranchNode> clazz, InversionModels im) {
        Double tot;
        if (classWeightTotals == null) {
            classWeightTotals = HashBasedTable.create();
        }
        if ((tot = (Double)classWeightTotals.get(clazz, (Object)im)) == null) {
            tot = 0.0;
            for (U3LogicTreeBranchNode val : clazz.getEnumConstants()) {
                tot = tot + val.getRelativeWeight(im);
            }
            classWeightTotals.put(clazz, (Object)im, (Object)tot);
        }
        return tot;
    }

    public static double getNormalizedWt(U3LogicTreeBranchNode<? extends Enum<?>> node, InversionModels im) {
        if (node == null) {
            return 0.0;
        }
        Class<?> clazz = U3LogicTreeBranch.getEnumEnclosingClass(node.getClass());
        return node.getRelativeWeight(im) / U3LogicTreeBranch.getClassWeightTotal(clazz, im);
    }

    @Override
    public Element toXMLMetadata(Element root) {
        Element el = root.addElement(XML_METADATA_NAME);
        Element nodesEl = el.addElement("Nodes");
        for (Class<? extends U3LogicTreeBranchNode<?>> clazz : U3LogicTreeBranch.getLogicTreeNodeClasses()) {
            U3LogicTreeBranchNode val = (U3LogicTreeBranchNode)this.getValueUnchecked(clazz);
            if (val == null) continue;
            String className = ClassUtils.getClassNameWithoutPackage(clazz);
            Element nodeEl = nodesEl.addElement("Node");
            nodeEl.addAttribute("className", className);
            nodeEl.addAttribute("enumName", val.name());
            nodeEl.addAttribute("longName", val.getName());
            nodeEl.addAttribute("shortName", val.getShortName());
        }
        if (this instanceof VariableLogicTreeBranch) {
            VariableLogicTreeBranch variable = (VariableLogicTreeBranch)this;
            Element element = el.addElement("Variations");
            for (int i = 0; i < variable.getVariations().size(); ++i) {
                String variation = variable.getVariations().get(i);
                Element varEl = element.addElement("Variation");
                varEl.addAttribute("index", "" + i);
                varEl.addAttribute("variation", variation);
            }
        }
        return root;
    }

    public static U3LogicTreeBranch fromXMLMetadata(Element branchEl) {
        Element nodesEl = branchEl.element("Nodes");
        HashMap nodeValMap = Maps.newHashMap();
        HashMap nodeShortNameMap = Maps.newHashMap();
        Iterator nodesIt = nodesEl.elementIterator();
        while (nodesIt.hasNext()) {
            Element nodeEl = (Element)nodesIt.next();
            String className = nodeEl.attributeValue("className");
            String enumName = nodeEl.attributeValue("enumName");
            String shortName = nodeEl.attributeValue("shortName");
            nodeValMap.put(className, enumName);
            nodeShortNameMap.put(className, shortName);
        }
        List<Class<U3LogicTreeBranchNode<?>>> classes = U3LogicTreeBranch.getLogicTreeNodeClasses();
        ArrayList branchList = Lists.newArrayList();
        for (Class<U3LogicTreeBranchNode<?>> clazz : classes) {
            U3LogicTreeBranchNode<?>[] options;
            String className = ClassUtils.getClassNameWithoutPackage(clazz);
            String enumName = (String)nodeValMap.get(className);
            String shortName = (String)nodeShortNameMap.get(className);
            if (enumName == null) {
                System.err.println("Warning: Couldn't load " + className + " from logic tree branch XML, no value set");
                branchList.add(null);
                continue;
            }
            U3LogicTreeBranchNode<?> value = null;
            for (U3LogicTreeBranchNode<?> option : options = clazz.getEnumConstants()) {
                if (!option.name().equals(enumName) && !option.getShortName().equals(shortName)) continue;
                value = option;
                break;
            }
            if (value == null) {
                System.err.println("Warning: Couldn't load " + className + " from logic tree branch XML, enum value unknown/changed: " + enumName + " (" + shortName + ")");
            }
            branchList.add(value);
        }
        U3LogicTreeBranch branch = new U3LogicTreeBranch(branchList);
        Element varsEl = branchEl.element("Variations");
        if (varsEl != null) {
            String variation;
            Iterator varsIt = varsEl.elementIterator();
            HashMap varIndexMap = Maps.newHashMap();
            while (varsIt.hasNext()) {
                Element varEl = (Element)varsIt.next();
                Integer index = Integer.parseInt(varEl.attributeValue("index"));
                variation = varEl.attributeValue("variation");
                varIndexMap.put(index, variation);
            }
            if (!varIndexMap.isEmpty()) {
                ArrayList variations = Lists.newArrayList();
                for (int i = 0; i < varIndexMap.size(); ++i) {
                    variation = (String)varIndexMap.get(i);
                    Preconditions.checkNotNull((Object)variation, (Object)("No variation for index: " + i));
                    variations.add(variation);
                }
                branch = new VariableLogicTreeBranch(branch, variations);
            }
        }
        return branch;
    }
}

