/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.utils.FindEquivUCERF2_Ruptures;

import java.io.File;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.opensha.sha.earthquake.ERF;
import org.opensha.sha.earthquake.ProbEqkRupture;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.UCERF2;
import org.opensha.sha.faultSurface.FaultSection;
import scratch.UCERF3.enumTreeBranches.FaultModels;
import scratch.UCERF3.utils.ModUCERF2.ModMeanUCERF2;
import scratch.UCERF3.utils.ModUCERF2.ModMeanUCERF2_FM2pt1;
import scratch.UCERF3.utils.ModUCERF2.ModMeanUCERF2_FM2pt2;

public abstract class FindEquivUCERF2_Ruptures {
    protected static final boolean D = false;
    protected ERF modifiedUCERF2;
    protected int NUM_SECTIONS;
    protected int NUM_INVERSION_RUPTURES;
    protected UCERF2_FaultModel ucerf2_fm;
    protected List<? extends FaultSection> faultSectionData;
    protected FaultSystemRupSet faultSysRupSet;
    Hashtable<String, ArrayList<String>> subsectsForSect;
    protected static final String SUB_DIR_NAME = "FindEquivUCERF2_Ruptures";
    protected File scratchDir;

    public FindEquivUCERF2_Ruptures(FaultSystemRupSet faultSysRupSet, File scratchDir, UCERF2_FaultModel ucerf2_fm) {
        this.scratchDir = scratchDir = new File(scratchDir, SUB_DIR_NAME);
        if (!scratchDir.exists()) {
            scratchDir.mkdir();
        }
        this.faultSysRupSet = faultSysRupSet;
        this.ucerf2_fm = ucerf2_fm;
        this.faultSectionData = faultSysRupSet.getFaultSectionDataList();
        this.NUM_SECTIONS = this.faultSectionData.size();
        this.NUM_INVERSION_RUPTURES = faultSysRupSet.getNumRuptures();
        this.modifiedUCERF2 = FindEquivUCERF2_Ruptures.buildERF(ucerf2_fm);
    }

    protected static UCERF2_FaultModel getUCERF2_FM(FaultModels fm) {
        if (fm == null || fm == FaultModels.FM2_1) {
            return UCERF2_FaultModel.FM2_1;
        }
        if (fm == FaultModels.FM3_1) {
            return UCERF2_FaultModel.FM2_1;
        }
        return UCERF2_FaultModel.FM2_2;
    }

    protected boolean isFirstOrLastSubsectInSect(int sectIndex) {
        if (this.subsectsForSect == null) {
            this.subsectsForSect = new Hashtable();
            for (FaultSection faultSection : this.faultSectionData) {
                if (this.subsectsForSect.containsKey(faultSection.getParentSectionName())) {
                    this.subsectsForSect.get(faultSection.getParentSectionName()).add(faultSection.getSectionName());
                    continue;
                }
                ArrayList<String> list = new ArrayList<String>();
                list.add(faultSection.getSectionName());
                this.subsectsForSect.put(faultSection.getParentSectionName(), list);
            }
        }
        FaultSection sectData = this.faultSectionData.get(sectIndex);
        ArrayList<String> arrayList = this.subsectsForSect.get(sectData.getParentSectionName());
        String firstName = arrayList.get(0);
        String lastName = arrayList.get(arrayList.size() - 1);
        boolean result = false;
        if (firstName.equals(sectData.getSectionName())) {
            result = true;
        } else if (lastName.equals(sectData.getSectionName())) {
            result = true;
        }
        return result;
    }

    public static ERF buildERF(FaultModels fm) {
        return FindEquivUCERF2_Ruptures.buildERF(FindEquivUCERF2_Ruptures.getUCERF2_FM(fm));
    }

    public static ERF buildERF(UCERF2_FaultModel fm) {
        ModMeanUCERF2 modifiedUCERF2 = fm == UCERF2_FaultModel.FM2_2 ? new ModMeanUCERF2_FM2pt2() : new ModMeanUCERF2_FM2pt1();
        modifiedUCERF2.setParameter(UCERF2.BACK_SEIS_NAME, UCERF2.BACK_SEIS_EXCLUDE);
        modifiedUCERF2.setParameter("Probability Model", "Poisson");
        modifiedUCERF2.getTimeSpan().setDuration(30.0);
        modifiedUCERF2.setParameter("Floater Type", "Only along strike ( rupture full DDW)");
        modifiedUCERF2.updateForecast();
        if (modifiedUCERF2.getNumSources() != fm.numSources) {
            throw new RuntimeException("Error - wrong number of sources (should be " + fm.numSources + " rather than " + modifiedUCERF2.getNumSources() + "); some UCERF2 adj params not set correctly?");
        }
        int numUCERF2_Ruptures = 0;
        for (int s = 0; s < fm.sourcesToUse; ++s) {
            numUCERF2_Ruptures += modifiedUCERF2.getSource(s).getNumRuptures();
        }
        if (numUCERF2_Ruptures != fm.numRuptures) {
            throw new RuntimeException("problem with NUM_RUPTURES; something changed?  old=" + fm.numRuptures + "\tnew=" + numUCERF2_Ruptures);
        }
        return modifiedUCERF2;
    }

    public abstract ArrayList<double[]> getMagsAndRatesForRuptures();

    public abstract double[] getMagsAndRatesForRupture(int var1);

    public final int getNumUCERF2_Ruptures() {
        return this.ucerf2_fm.numRuptures;
    }

    public abstract ProbEqkRupture getRthUCERF2_Rupture(int var1);

    public abstract int getEquivFaultSystemRupIndexForUCERF2_Rupture(int var1);

    public final FaultSystemRupSet getFaultSysRupSet() {
        return this.faultSysRupSet;
    }

    public ERF getUCERF2_ERF() {
        return this.modifiedUCERF2;
    }

    public static enum UCERF2_FaultModel {
        FM2_1(11706, 394, 274),
        FM2_2(11886, 397, 277);

        protected int numRuptures;
        protected int numSources;
        protected int sourcesToUse;

        private UCERF2_FaultModel(int numRuptures, int numSources, int sourcesToUse) {
            this.numRuptures = numRuptures;
            this.numSources = numSources;
            this.sourcesToUse = sourcesToUse;
        }
    }
}

