/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.utils;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import org.opensha.commons.geo.Location;

public class GeologicSlipRate {
    private boolean isMax;
    private boolean isMin;
    private boolean isRange;
    private double discrete;
    private double min;
    private double max;
    private Location loc;
    private String valString;
    private int sectID = -1;

    public GeologicSlipRate(Location loc, double min, double max) {
        this.loc = loc;
        this.isMax = false;
        this.isMin = false;
        this.isRange = true;
        this.discrete = Double.NaN;
        this.min = min;
        this.max = max;
    }

    public GeologicSlipRate(Location loc, boolean isMin, boolean isMax, double value) {
        this.loc = loc;
        Preconditions.checkArgument((!isMin || !isMax ? 1 : 0) != 0, (Object)"isMin and isMax can't both be true!");
        this.isMin = isMin;
        this.isMax = isMax;
        this.isRange = false;
        this.discrete = value;
        this.min = Double.NaN;
        this.max = Double.NaN;
    }

    public double getValue() {
        if (this.isRange) {
            return (this.max + this.min) / 2.0;
        }
        return this.discrete;
    }

    public boolean isMax() {
        return this.isMax;
    }

    public boolean isMin() {
        return this.isMin;
    }

    public boolean isRange() {
        return this.isRange;
    }

    public String getValString() {
        return this.valString;
    }

    public void setValString(String description) {
        this.valString = description;
    }

    public Location getLocation() {
        return this.loc;
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public void setSectID(int sectID) {
        this.sectID = sectID;
    }

    public int getSectID() {
        return this.sectID;
    }

    public static String numbersSpacesOnly(String str, boolean allowMinus) {
        if (str == null) {
            return null;
        }
        StringBuffer strBuff = new StringBuffer();
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (!Character.isDigit(c) && c != ' ' && c != '.' && (!allowMinus || c != '-')) continue;
            strBuff.append(c);
        }
        return strBuff.toString();
    }

    private static String[] removeEmpty(String[] vals) {
        ArrayList<String> newVals = new ArrayList<String>();
        for (String val : vals) {
            if (val.length() <= 0) continue;
            newVals.add(val);
        }
        String[] ret = new String[newVals.size()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = (String)newVals.get(i);
        }
        return ret;
    }

    public static GeologicSlipRate fromString(Location loc, String str) {
        GeologicSlipRate rate;
        if ((str = str.trim()).contains("-")) {
            String numSpaces = GeologicSlipRate.numbersSpacesOnly(str, false);
            String[] vals = GeologicSlipRate.removeEmpty(numSpaces.split(" "));
            if (vals.length != 2) {
                Object valStr = null;
                for (String val : vals) {
                    valStr = valStr == null ? "" : (String)valStr + ",";
                    valStr = (String)valStr + val;
                }
                throw new IllegalStateException("could not parse range: " + str + " (vals: " + valStr + ")");
            }
            double min = Double.parseDouble(vals[0]);
            double max = Double.parseDouble(vals[1]);
            rate = new GeologicSlipRate(loc, min, max);
        } else if (str.contains("\u00b1")) {
            String numSpaces = GeologicSlipRate.numbersSpacesOnly(str, false);
            double val = Double.parseDouble(GeologicSlipRate.removeEmpty(numSpaces.split(" "))[0]);
            rate = new GeologicSlipRate(loc, false, false, val);
        } else {
            boolean isMin = false;
            boolean isMax = false;
            if (str.contains("<") || str.contains("\u2264")) {
                isMax = true;
            } else if (str.contains(">") || str.contains("\u2265")) {
                isMin = true;
            }
            String numSpaces = GeologicSlipRate.numbersSpacesOnly(str, false);
            double val = Double.parseDouble(GeologicSlipRate.removeEmpty(numSpaces.split(" "))[0]);
            rate = new GeologicSlipRate(loc, isMin, isMax, val);
        }
        rate.setValString(str);
        return rate;
    }

    public String toString() {
        String ret = "Slip Rate: " + this.getValue();
        if (this.getValString() != null) {
            ret = ret + " (" + this.getValString() + ")";
        }
        return ret;
    }
}

