/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.utils;

import java.io.IOException;
import org.opensha.commons.data.region.CaliforniaRegions;
import org.opensha.commons.data.xyz.GriddedGeoDataSet;
import org.opensha.commons.geo.Location;
import scratch.UCERF3.analysis.GMT_CA_Maps;
import scratch.UCERF3.griddedSeismicity.GridReader;

public class SmoothSeismicitySpatialPDF_Fetcher {
    public static final String SUBDIR = "SeismicityGrids";
    public static final String FILENAME_UCERF2 = "SmoothSeis_UCERF2.txt";
    public static final String FILENAME_UCERF3 = "SmoothSeis_KF_5-5-2012.txt";
    public static final String FILENAME_UCERF3pt3 = "SmoothSeis_KF_4-9-2013.txt";
    public static final String FILENAME_UCERF3pt3_SHALLOW = "SmoothSeis_KF_4-9-2013_Shallow.txt";
    public static final String FILENAME_UCERF3pt3_DEEP = "SmoothSeis_KF_4-9-2013_Deep.txt";
    public static final String FILENAME_MP_UNSMOOTHED = "UnsmoothSeis_MP_3-5-2018.txt";
    static final CaliforniaRegions.RELM_TESTING_GRIDDED griddedRegion = new CaliforniaRegions.RELM_TESTING_GRIDDED();

    public static double[] getUCERF2() {
        return new GridReader(FILENAME_UCERF2).getValues();
    }

    public static double[] getUCERF3() {
        return new GridReader(FILENAME_UCERF3pt3_SHALLOW).getValues();
    }

    public static double[] getUnsmoothed() {
        return new GridReader(FILENAME_MP_UNSMOOTHED).getValues();
    }

    public static GriddedGeoDataSet getUCERF2pdfAsGeoData() {
        return SmoothSeismicitySpatialPDF_Fetcher.readPDF_Data(FILENAME_UCERF2);
    }

    public static GriddedGeoDataSet getUCERF3pdfAsGeoData() {
        return SmoothSeismicitySpatialPDF_Fetcher.readPDF_Data(FILENAME_UCERF3pt3_SHALLOW);
    }

    private static GriddedGeoDataSet readPDF_Data(String filename) {
        GriddedGeoDataSet pdfData = new GriddedGeoDataSet(griddedRegion, true);
        GridReader reader = new GridReader(filename);
        for (Location loc : griddedRegion) {
            pdfData.set(loc, (double)reader.getValue(loc));
        }
        return pdfData;
    }

    private static double getSumOfData(GriddedGeoDataSet data) {
        double sum = 0.0;
        for (int i = 0; i < data.size(); ++i) {
            sum += data.get(i);
        }
        return sum;
    }

    private static void plotMapsForReport() {
        try {
            GriddedGeoDataSet u2pdf = SmoothSeismicitySpatialPDF_Fetcher.readPDF_Data(FILENAME_UCERF2);
            GriddedGeoDataSet u3pdf = SmoothSeismicitySpatialPDF_Fetcher.readPDF_Data(FILENAME_UCERF3pt3_SHALLOW);
            GriddedGeoDataSet avePDF = new GriddedGeoDataSet(griddedRegion, true);
            for (int i = 0; i < u2pdf.size(); ++i) {
                avePDF.set(i, 0.5 * (u2pdf.get(i) + u3pdf.get(i)));
            }
            GMT_CA_Maps.plotSpatialPDF_Map(u2pdf.copy(), "UCERF2_SmoothSeisPDF", "test meta data", "UCERF2_SmoothSeisPDF_Map");
            GMT_CA_Maps.plotSpatialPDF_Map(u3pdf, "UCERF3_SmoothSeisPDF", "test meta data", "UCERF3_SmoothSeisPFD_Map");
            GMT_CA_Maps.plotRatioOfRateMaps(avePDF, u2pdf, "aveUCERF3vsUCERF2_SmoothSeisPDF_Ratio", "test meta data", "aveUCERF3vsUCERF2_SmoothSeisPDF_Ratio");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void plotMaps() {
        try {
            GriddedGeoDataSet u2pdf = SmoothSeismicitySpatialPDF_Fetcher.readPDF_Data(FILENAME_UCERF2);
            GriddedGeoDataSet u3pdf = SmoothSeismicitySpatialPDF_Fetcher.readPDF_Data(FILENAME_UCERF3);
            GriddedGeoDataSet u33pdf = SmoothSeismicitySpatialPDF_Fetcher.readPDF_Data(FILENAME_UCERF3pt3);
            GriddedGeoDataSet u33pdfShallow = SmoothSeismicitySpatialPDF_Fetcher.readPDF_Data(FILENAME_UCERF3pt3_SHALLOW);
            GriddedGeoDataSet u33pdfDeep = SmoothSeismicitySpatialPDF_Fetcher.readPDF_Data(FILENAME_UCERF3pt3_DEEP);
            GMT_CA_Maps.plotSpatialPDF_Map(u3pdf.copy(), "UCERF32_SmoothSeisPDF", "test meta data", "UCERF32_SmoothSeisPFD_Map");
            GMT_CA_Maps.plotSpatialPDF_Map(u33pdf.copy(), "UCERF33_SmoothSeisPDF", "test meta data", "UCERF33_SmoothSeisPFD_Map");
            GMT_CA_Maps.plotSpatialPDF_Map(u33pdfShallow.copy(), "UCERF33shallow_SmoothSeisPDF", "test meta data", "UCERF33shallow_SmoothSeisPFD_Map");
            GMT_CA_Maps.plotSpatialPDF_Map(u33pdfDeep.copy(), "UCERF33deep_SmoothSeisPDF", "test meta data", "UCERF33deep_SmoothSeisPFD_Map");
            GMT_CA_Maps.plotRatioOfRateMaps(u33pdf, u3pdf, "UCERF33_UCERF32_SeisPDF_Ratio", "test meta data", "UCERF33_UCERF32_SeisPDF_Ratio");
            GMT_CA_Maps.plotRatioOfRateMaps(u33pdfShallow, u33pdf, "UCERF33shallow_UCERF33_SeisPDF_Ratio", "test meta data", "UCERF33shallow_UCERF33_SeisPDF_Ratio");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        SmoothSeismicitySpatialPDF_Fetcher.plotMapsForReport();
    }
}

