/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.utils;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.opensha.commons.util.ExceptionUtils;
import org.opensha.sha.faultSurface.FaultSection;
import scratch.UCERF3.enumTreeBranches.DeformationModels;
import scratch.UCERF3.enumTreeBranches.FaultModels;
import scratch.UCERF3.utils.DeformationModelFetcher;
import scratch.UCERF3.utils.UCERF3_DataUtils;

public class UCERF2_A_FaultMapper {
    private static final String DIR = "FaultModels";
    private static final String A_FAULT_FILE_NAME = "a_faults.txt";
    private static HashSet<Integer> typeAFaults;

    public static boolean wasUCERF2_TypeAFault(int sectionID) {
        return UCERF2_A_FaultMapper.getTypeAFaults().contains(sectionID);
    }

    private static synchronized HashSet<Integer> getTypeAFaults() {
        if (typeAFaults == null) {
            try {
                typeAFaults = new HashSet();
                BufferedReader br = new BufferedReader(UCERF3_DataUtils.getReader(DIR, A_FAULT_FILE_NAME));
                String line = br.readLine();
                while (line != null) {
                    if (!(line = line.trim()).startsWith("#") && !line.isEmpty()) {
                        Integer id = Integer.parseInt(line.split("\t")[0]);
                        typeAFaults.add(id);
                    }
                    line = br.readLine();
                }
            }
            catch (IOException e) {
                typeAFaults = null;
                ExceptionUtils.throwAsRuntimeException(e);
            }
        }
        return typeAFaults;
    }

    private static void writeDataFile(File outputFile, File segFile, File fm3_1_nameChangeFile, File fm3_2_nameChangeFile) throws IOException {
        Map<String, String> fm3_1_changes = UCERF2_A_FaultMapper.loadNameChanges(fm3_1_nameChangeFile);
        Map<String, String> fm3_2_changes = UCERF2_A_FaultMapper.loadNameChanges(fm3_2_nameChangeFile);
        HashMap aFaults = Maps.newHashMap();
        List segLines = FileUtils.readLines((File)segFile);
        for (FaultModels fm : FaultModels.values()) {
            Map<Integer, FaultSection> sects = fm.getFaultSectionIDMap();
            HashMap sectsByName = Maps.newHashMap();
            for (FaultSection sect : sects.values()) {
                sectsByName.put(sect.getSectionName().trim(), sect.getSectionId());
            }
            for (String line : segLines) {
                if ((line = line.trim()).isEmpty() || line.startsWith("#") || line.startsWith("-")) continue;
                String[] names = (line = line.substring(line.indexOf(":") + 1)).contains(";") ? line.split(";") : new String[]{line};
                for (String name : names) {
                    Integer sectID;
                    name = name.trim();
                    if (fm == FaultModels.FM3_1 && fm3_1_changes.containsKey(name)) {
                        name = fm3_1_changes.get(name);
                    }
                    if (fm == FaultModels.FM3_2 && fm3_2_changes.containsKey(name)) {
                        name = fm3_2_changes.get(name);
                    }
                    if ((sectID = (Integer)sectsByName.get(name)) == null) {
                        System.out.println("WARNING: sect not found with name: " + name + ", FM: " + String.valueOf(fm));
                        int min = Integer.MAX_VALUE;
                        String closest = null;
                        for (String matchName : sectsByName.keySet()) {
                            int dist = StringUtils.getLevenshteinDistance((CharSequence)name, (CharSequence)matchName);
                            if (dist >= min) continue;
                            min = dist;
                            closest = matchName;
                        }
                        System.out.println("Possible match: " + closest);
                        continue;
                    }
                    if (aFaults.containsKey(sectID)) continue;
                    aFaults.put(sectID, name);
                }
            }
        }
        FileWriter fw = new FileWriter(outputFile);
        fw.write("#ID\tName\n");
        ArrayList sectIDs = Lists.newArrayList(aFaults.keySet());
        Collections.sort(sectIDs);
        for (Integer sectID : sectIDs) {
            String name = (String)aFaults.get(sectID);
            fw.write(sectID + "\t" + name + "\n");
        }
        fw.close();
    }

    private static Map<String, String> loadNameChanges(File file) throws IOException {
        HashMap changes = Maps.newHashMap();
        for (String line : FileUtils.readLines((File)file)) {
            String[] names = line.trim().split("\t");
            changes.put(names[0].trim(), names[1].trim());
        }
        return changes;
    }

    public static void main(String[] args) throws IOException {
        File dir = new File("/tmp");
        DeformationModelFetcher fetcher = new DeformationModelFetcher(FaultModels.FM2_1, DeformationModels.UCERF2_ALL, null, 0.0);
        for (FaultSection faultSection : fetcher.getParentSectionList()) {
            System.out.println(faultSection.getSectionId() + "\t" + faultSection.getSectionName() + "\t" + UCERF2_A_FaultMapper.wasUCERF2_TypeAFault(faultSection.getSectionId()));
        }
    }
}

