/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.utils.UCERF2_Section_MFDs;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.jfree.chart.plot.DatasetRenderingOrder;
import org.opensha.commons.calc.FractileCurveCalculator;
import org.opensha.commons.data.function.AbstractXY_DataSet;
import org.opensha.commons.data.function.EvenlyDiscretizedFunc;
import org.opensha.commons.data.function.XY_DataSet;
import org.opensha.commons.data.function.XY_DataSetList;
import org.opensha.commons.geo.Location;
import org.opensha.commons.gui.plot.HeadlessGraphPanel;
import org.opensha.commons.gui.plot.PlotCurveCharacterstics;
import org.opensha.commons.gui.plot.PlotLineType;
import org.opensha.commons.gui.plot.PlotSymbol;
import org.opensha.commons.util.ExceptionUtils;
import org.opensha.refFaultParamDb.vo.FaultSectionPrefData;
import org.opensha.sha.earthquake.ERF;
import org.opensha.sha.earthquake.ProbEqkRupture;
import org.opensha.sha.earthquake.ProbEqkSource;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemSolution;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.A_Faults.A_FaultSegmentedSourceGenerator;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.FaultSegmentData;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.MeanUCERF2.MeanUCERF2;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.UCERF2;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.UCERF2_TimeIndependentEpistemicList;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.UnsegmentedSource;
import org.opensha.sha.faultSurface.FaultSection;
import org.opensha.sha.faultSurface.FaultTrace;
import org.opensha.sha.magdist.IncrementalMagFreqDist;
import org.opensha.sha.magdist.SummedMagFreqDist;
import scratch.UCERF3.enumTreeBranches.FaultModels;
import scratch.UCERF3.inversion.CommandLineInversionRunner;
import scratch.UCERF3.inversion.UCERF2_ComparisonSolutionFetcher;
import scratch.UCERF3.utils.UCERF3_DataUtils;

public class UCERF2_Section_MFDsCalc {
    private static boolean D = false;
    public static int ELSINORE_COMBINED_STEPOVER_FAULT_SECTION_ID = 402;
    public static int GLEN_IVY_STEPOVER_FAULT_SECTION_ID = 297;
    public static int TEMECULA_STEPOVER_FAULT_SECTION_ID = 298;
    public static int SJ_COMBINED_STEPOVER_FAULT_SECTION_ID = 401;
    public static int SJ_VALLEY_STEPOVER_FAULT_SECTION_ID = 290;
    public static int SJ_ANZA_STEPOVER_FAULT_SECTION_ID = 291;
    static final String DATA_SUB_DIR = "UCERF2_Section_MFDs";
    static final String PART_SUB_DIR = "ParticipationFiles";
    static final String NUCL_SUB_DIR = "NucleationFiles";
    static final String SECT_LIST_FILE_NAME = "UCERF2_sectionIDs_AndNames.txt";
    static final String MFD_PLOTS_DIR = "dev/scratch/UCERF3/data/scratch/UCERF2_SectionMFD_Plots";
    HashMap<String, Integer> sectionIDfromNameMap;
    HashMap<Integer, String> sectionNamefromID_Map;
    HashMap<Integer, XY_DataSetList> mfdList_ForSectID_Map;
    HashMap<Integer, ArrayList<Integer>> mfdBranches_ForSectID_Map;
    HashMap<Integer, ArrayList<Double>> mfdWts_ForSectID_Map;
    HashMap<Integer, Double> totWtForSectID_Map;
    HashMap<String, SummedMagFreqDist> meanUCERF2_MFD_ForSectID_Map;
    boolean isParticipation;
    public static final double MIN_MAG = 5.05;
    public static final int NUM_MAG = 40;
    public static final double DELTA_MAG = 0.1;
    File precomputedDataDir;
    private static HashMap<Integer, String> sectionNamesCache;
    private static HashMap<Integer, Integer> UCERF3toUCERF2ParentSectionIDMap;

    private UCERF2_Section_MFDsCalc(boolean isParticipation) {
        File sectListFile;
        this.isParticipation = isParticipation;
        this.precomputedDataDir = UCERF3_DataUtils.DEFAULT_SCRATCH_DATA_DIR.getParentFile();
        System.out.println("UCERF2_Source_MFDsCalc is creating data; this will take some time...");
        File dataDir = new File(this.precomputedDataDir, DATA_SUB_DIR);
        if (!dataDir.exists()) {
            dataDir.mkdirs();
        }
        if (!(sectListFile = new File(dataDir, SECT_LIST_FILE_NAME)).exists()) {
            UCERF2_Section_MFDsCalc.writeListOfAllFaultSections(sectListFile);
        }
        this.readListOfAllFaultSections();
        this.makeMFD_Lists();
        this.writeMinMaxMeanMFDsToFiles(dataDir);
    }

    public static ArrayList<IncrementalMagFreqDist> getMeanMinAndMaxMFD(int parID, boolean isParticipation, boolean cumDist) {
        HashMap<Integer, String> sectionNamesMap = UCERF2_Section_MFDsCalc.getSectionNamesMap();
        if (!sectionNamesMap.containsKey(parID)) {
            HashMap<Integer, Integer> idMapping = UCERF2_Section_MFDsCalc.getUCERF3toUCERF2ParentSectionIDMap();
            if (idMapping.containsKey(parID)) {
                parID = idMapping.get(parID);
            } else {
                return null;
            }
        }
        String subDirName = isParticipation ? PART_SUB_DIR : NUCL_SUB_DIR;
        String distType = cumDist ? "cum" : "incr";
        String fileName = distType + parID + ".txt";
        ArrayList<IncrementalMagFreqDist> mfdList = null;
        try {
            String line;
            BufferedReader br = new BufferedReader(UCERF3_DataUtils.getReader(DATA_SUB_DIR, subDirName, fileName));
            ArrayList<String> lineList = new ArrayList<String>();
            while ((line = br.readLine()) != null) {
                lineList.add(line);
            }
            String[] strArray = StringUtils.split((String)((String)lineList.get(0)), (String)"\t");
            String name = strArray[0];
            strArray = StringUtils.split((String)((String)lineList.get(2)), (String)"\t");
            double minMag = Double.valueOf(strArray[0]);
            strArray = StringUtils.split((String)((String)lineList.get(lineList.size() - 1)), (String)"\t");
            double maxmag = Double.valueOf(strArray[0]);
            int numMag = lineList.size() - 2;
            IncrementalMagFreqDist meanMFD = new IncrementalMagFreqDist(minMag, maxmag, numMag);
            IncrementalMagFreqDist minMFD = new IncrementalMagFreqDist(minMag, maxmag, numMag);
            IncrementalMagFreqDist maxMFD = new IncrementalMagFreqDist(minMag, maxmag, numMag);
            for (int l = 2; l < lineList.size(); ++l) {
                strArray = StringUtils.split((String)((String)lineList.get(l)), (String)"\t");
                meanMFD.set(l - 2, (double)Double.valueOf(strArray[1]));
                minMFD.set(l - 2, (double)Double.valueOf(strArray[2]));
                maxMFD.set(l - 2, (double)Double.valueOf(strArray[3]));
            }
            meanMFD.setName(name + " mean " + distType + " MFD");
            meanMFD.setInfo("section ID = " + parID);
            minMFD.setName(name + " min " + distType + " MFD");
            minMFD.setInfo("section ID = " + parID);
            maxMFD.setName(name + " max " + distType + " MFD");
            maxMFD.setInfo("section ID = " + parID);
            mfdList = new ArrayList<IncrementalMagFreqDist>();
            mfdList.add(meanMFD);
            mfdList.add(minMFD);
            mfdList.add(maxMFD);
        }
        catch (Exception e) {
            ExceptionUtils.throwAsRuntimeException(e);
        }
        return mfdList;
    }

    private void writeMinMaxMeanMFDsToFiles(File dataDir) {
        File directory;
        if (this.isParticipation) {
            directory = new File(dataDir, PART_SUB_DIR);
            if (!directory.exists()) {
                directory.mkdirs();
            }
        } else {
            directory = new File(dataDir, NUCL_SUB_DIR);
            if (!directory.exists()) {
                directory.mkdirs();
            }
        }
        for (int parID : this.mfdList_ForSectID_Map.keySet()) {
            XY_DataSetList mfdList = this.mfdList_ForSectID_Map.get(parID);
            double weight = this.totWtForSectID_Map.get(parID);
            if (mfdList != null) {
                FractileCurveCalculator frCurveCalc = new FractileCurveCalculator(mfdList, (List<Double>)this.mfdWts_ForSectID_Map.get(parID));
                AbstractXY_DataSet meanCurve = frCurveCalc.getMeanCurve();
                AbstractXY_DataSet minCurve = frCurveCalc.getMinimumCurve();
                AbstractXY_DataSet maxCurve = frCurveCalc.getMaximumCurve();
                File fileName = new File(directory, "incr" + parID + ".txt");
                try {
                    FileWriter fw = new FileWriter(fileName);
                    fw.write(this.sectionNamefromID_Map.get(parID) + "\n");
                    fw.write("mag\tmean\tmin\tmax\n");
                    for (int i = 0; i < meanCurve.size(); ++i) {
                        fw.write(meanCurve.getX(i) + "\t" + meanCurve.getY(i) / weight + "\t" + minCurve.getY(i) / weight + "\t" + maxCurve.getY(i) / weight + "\n");
                    }
                    fw.close();
                }
                catch (IOException e) {
                    System.out.println("IO exception = " + String.valueOf(e));
                }
                FractileCurveCalculator frCurveCalcCum = new FractileCurveCalculator(this.getCumMFD_ListForSect(parID), (List<Double>)this.mfdWts_ForSectID_Map.get(parID));
                AbstractXY_DataSet meanCurveCum = frCurveCalcCum.getMeanCurve();
                AbstractXY_DataSet minCurveCum = frCurveCalcCum.getMinimumCurve();
                AbstractXY_DataSet maxCurveCum = frCurveCalcCum.getMaximumCurve();
                File fileNameCum = new File(directory, "cum" + parID + ".txt");
                try {
                    FileWriter fwCum = new FileWriter(fileNameCum);
                    fwCum.write(this.sectionNamefromID_Map.get(parID) + "\n");
                    fwCum.write("mag\tmean\tmin\tmax\n");
                    for (int i = 0; i < meanCurve.size(); ++i) {
                        fwCum.write(meanCurveCum.getX(i) + "\t" + meanCurveCum.getY(i) / weight + "\t" + minCurveCum.getY(i) / weight + "\t" + maxCurveCum.getY(i) / weight + "\n");
                    }
                    fwCum.close();
                }
                catch (IOException e) {
                    System.out.println("IO exception = " + String.valueOf(e));
                }
                continue;
            }
            System.out.println("Null MFD List for: id = " + parID + ";  name = " + this.sectionNamefromID_Map.get(parID));
        }
    }

    private XY_DataSetList getCumMFD_ListForSect(int parID) {
        XY_DataSetList mfdList = this.mfdList_ForSectID_Map.get(parID);
        XY_DataSetList cumMFD_List = new XY_DataSetList();
        for (XY_DataSet mfd : mfdList) {
            cumMFD_List.add(((SummedMagFreqDist)mfd).getCumRateDistWithOffset());
        }
        return cumMFD_List;
    }

    public void writeSectionWeights() {
        for (int parIndex : this.sectionNamefromID_Map.keySet()) {
            double wt = this.totWtForSectID_Map.get(parIndex);
            System.out.println((float)wt + "\t" + this.sectionNamefromID_Map.get(parIndex) + "\t" + parIndex);
        }
    }

    public void saveAllTestMFD_Plots(boolean plotCumDist) {
        if (this.meanUCERF2_MFD_ForSectID_Map == null) {
            this.makeMeanUCERF2_MFD_List();
        }
        FaultSystemSolution fltSysSol = UCERF2_ComparisonSolutionFetcher.getUCERF2Solution(FaultModels.FM2_1);
        ArrayList<Integer> u2_parIds = new ArrayList<Integer>();
        for (FaultSection faultSection : fltSysSol.getRupSet().getFaultSectionDataList()) {
            int parID = faultSection.getParentSectionId();
            if (u2_parIds.contains(parID)) continue;
            if (this.sectionNamefromID_Map.keySet().contains(parID)) {
                u2_parIds.add(parID);
                continue;
            }
            if (!D) continue;
            System.out.println("Not including " + faultSection.getParentSectionName());
        }
        for (Integer n : u2_parIds) {
            EvenlyDiscretizedFunc mappedMFD;
            if (D) {
                System.out.println("Working on " + this.sectionNamefromID_Map.get(n));
            }
            if (this.isParticipation) {
                mappedMFD = plotCumDist ? fltSysSol.calcParticipationMFD_forParentSect(n, 5.05, 8.95, 40).getCumRateDistWithOffset() : fltSysSol.calcParticipationMFD_forParentSect(n, 5.05, 8.95, 40);
                mappedMFD.setName("UCERF2 Mapped Participation MFD for " + this.sectionNamefromID_Map.get(n));
            } else {
                mappedMFD = plotCumDist ? fltSysSol.calcNucleationMFD_forParentSect(n, 5.05, 8.95, 40).getCumRateDistWithOffset() : fltSysSol.calcNucleationMFD_forParentSect(n, 5.05, 8.95, 40);
                mappedMFD.setName("UCERF2 Mapped Nucleation MFD for " + this.sectionNamefromID_Map.get(n));
            }
            double totWeight = this.totWtForSectID_Map.get(n);
            mappedMFD.scale(totWeight);
            ArrayList<XY_DataSet> funcs = new ArrayList<XY_DataSet>();
            funcs.add(mappedMFD);
            ArrayList<PlotCurveCharacterstics> chars = new ArrayList<PlotCurveCharacterstics>();
            chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, PlotSymbol.CROSS, 3.0f, Color.RED));
            XY_DataSetList mfdList = this.mfdList_ForSectID_Map.get(n);
            if (mfdList != null) {
                FractileCurveCalculator frCurveCalc = plotCumDist ? new FractileCurveCalculator(this.getCumMFD_ListForSect(n), (List<Double>)this.mfdWts_ForSectID_Map.get(n)) : new FractileCurveCalculator(mfdList, (List<Double>)this.mfdWts_ForSectID_Map.get(n));
                funcs.add(frCurveCalc.getMeanCurve());
                funcs.add(frCurveCalc.getMinimumCurve());
                funcs.add(frCurveCalc.getMaximumCurve());
            } else {
                System.out.println("Null MFD List for: id = " + n + ";  name = " + this.sectionNamefromID_Map.get(n));
            }
            chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.BLUE));
            chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 1.0f, Color.BLUE));
            chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 1.0f, Color.BLUE));
            if (plotCumDist) {
                funcs.add(this.meanUCERF2_MFD_ForSectID_Map.get(this.sectionNamefromID_Map.get(n)).getCumRateDistWithOffset());
            } else {
                funcs.add(this.meanUCERF2_MFD_ForSectID_Map.get(this.sectionNamefromID_Map.get(n)));
            }
            chars.add(new PlotCurveCharacterstics(PlotSymbol.CIRCLE, 5.0f, Color.BLUE));
            ArrayList<IncrementalMagFreqDist> mfds = UCERF2_Section_MFDsCalc.getMeanMinAndMaxMFD(n, this.isParticipation, plotCumDist);
            if (totWeight < 0.99999) {
                for (IncrementalMagFreqDist mfd : mfds) {
                    mfd.scale(totWeight);
                }
            }
            funcs.addAll(mfds);
            chars.add(new PlotCurveCharacterstics(PlotSymbol.CROSS, 3.0f, Color.BLUE));
            chars.add(new PlotCurveCharacterstics(PlotSymbol.CROSS, 3.0f, Color.BLUE));
            chars.add(new PlotCurveCharacterstics(PlotSymbol.CROSS, 3.0f, Color.BLUE));
            HeadlessGraphPanel gp = new HeadlessGraphPanel();
            CommandLineInversionRunner.setFontSizes(gp);
            gp.setYLog(true);
            gp.setRenderingOrder(DatasetRenderingOrder.FORWARD);
            gp.setUserBounds(5.0, 9.0, 1.0E-7, 1.0);
            float totWt = this.totWtForSectID_Map.get(n).floatValue();
            String title = this.isParticipation ? this.sectionNamefromID_Map.get(n) + " Participation Cum MFDs (totWt=" + totWt + ")" : this.sectionNamefromID_Map.get(n) + " Nucleation Cum MFDs (totWt=" + totWt + ")";
            gp.drawGraphPanel("Magnitude", "Rate (per year)", funcs, chars, title);
            String fileName = this.sectionNamefromID_Map.get(n).replace("\\s+", "");
            String subDir = plotCumDist ? (this.isParticipation ? "/CumulativeParticipation" : "/CumulativeNucleation") : (this.isParticipation ? "/IncrementalParticipation" : "/IncrementalNucleation");
            File filePath = new File(MFD_PLOTS_DIR + subDir);
            if (!filePath.exists()) {
                filePath.mkdirs();
            }
            File file = new File(MFD_PLOTS_DIR + subDir, fileName);
            gp.getChartPanel().setSize(1000, 800);
            try {
                gp.saveAsPDF(file.getAbsolutePath() + ".pdf");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void makeMFD_Lists() {
        this.mfdList_ForSectID_Map = new HashMap();
        this.mfdBranches_ForSectID_Map = new HashMap();
        this.mfdWts_ForSectID_Map = new HashMap();
        this.totWtForSectID_Map = new HashMap();
        UCERF2_TimeIndependentEpistemicList ucerf2EpistemicList = UCERF2_Section_MFDsCalc.getUCERF2_TimeIndependentEpistemicList();
        int numERFs = ucerf2EpistemicList.getNumERFs();
        if (D) {
            System.out.println("Num Branches=" + numERFs);
        }
        for (int branch = 0; branch < numERFs; ++branch) {
            if (D) {
                System.out.println(branch);
            }
            ERF erf = ucerf2EpistemicList.getERF(branch);
            double duration = erf.getTimeSpan().getDuration();
            HashMap<String, SummedMagFreqDist> mfd_ForSectName_Map = new HashMap<String, SummedMagFreqDist>();
            HashMap<CallSite, ArrayList> sectionsForTypeA_RupsMap = new HashMap<CallSite, ArrayList>();
            ArrayList objList = ((UCERF2)erf).get_A_FaultSourceGenerators();
            for (Object obj : objList) {
                if (!(obj instanceof A_FaultSegmentedSourceGenerator)) continue;
                A_FaultSegmentedSourceGenerator srcGen = (A_FaultSegmentedSourceGenerator)obj;
                ArrayList dataList = srcGen.getFaultSegmentData().getPrefFaultSectionDataList();
                for (int r = 0; r < srcGen.getNumRupSources(); ++r) {
                    String srcName = srcGen.getFaultSegmentData().getFaultName() + ";" + srcGen.getLongRupName(r);
                    sectionsForTypeA_RupsMap.put((CallSite)((Object)srcName), dataList);
                }
            }
            for (int s = 0; s < erf.getNumSources(); ++s) {
                ProbEqkSource src = erf.getSource(s);
                if (src instanceof UnsegmentedSource) {
                    ArrayList dataList = ((UnsegmentedSource)src).getFaultSegmentData().getPrefFaultSectionDataList();
                    if (dataList.size() == 1) {
                        SummedMagFreqDist mfd;
                        String name = src.getName();
                        if (!name.equals(((FaultSectionPrefData)dataList.get(0)).getSectionName())) {
                            throw new RuntimeException("Problem");
                        }
                        if (mfd_ForSectName_Map.keySet().contains(name)) {
                            mfd = mfd_ForSectName_Map.get(name);
                        } else {
                            mfd = this.getNewSummedMagFreqDist();
                            mfd_ForSectName_Map.put(name, mfd);
                            mfd.setName(name);
                            mfd.setInfo("Section ID = " + String.valueOf(this.sectionIDfromNameMap.get(name)));
                        }
                        for (ProbEqkRupture rup : src) {
                            mfd.addResampledMagRate(rup.getMag(), rup.getMeanAnnualRate(duration), true);
                        }
                        continue;
                    }
                    this.processSource(src, dataList, mfd_ForSectName_Map, duration);
                    continue;
                }
                String name = src.getName();
                if (!sectionsForTypeA_RupsMap.keySet().contains(name)) continue;
                this.processSource(src, (ArrayList)sectionsForTypeA_RupsMap.get(name), mfd_ForSectName_Map, duration);
            }
            double branchWt = ucerf2EpistemicList.getERF_RelativeWeight(branch);
            for (String name : mfd_ForSectName_Map.keySet()) {
                int id = this.sectionIDfromNameMap.get(name);
                if (!this.mfdList_ForSectID_Map.keySet().contains(id)) {
                    this.mfdList_ForSectID_Map.put(id, new XY_DataSetList());
                    this.mfdBranches_ForSectID_Map.put(id, new ArrayList());
                    this.mfdWts_ForSectID_Map.put(id, new ArrayList());
                }
                this.mfdList_ForSectID_Map.get(id).add((XY_DataSet)mfd_ForSectName_Map.get(name));
                this.mfdBranches_ForSectID_Map.get(id).add(branch);
                this.mfdWts_ForSectID_Map.get(id).add(branchWt);
            }
        }
        for (Integer id : this.mfdWts_ForSectID_Map.keySet()) {
            double totWt = 0.0;
            for (Double wt : this.mfdWts_ForSectID_Map.get(id)) {
                totWt += wt.doubleValue();
            }
            this.totWtForSectID_Map.put(id, totWt);
        }
        SummedMagFreqDist zeroMFD = this.getNewSummedMagFreqDist();
        for (Integer id : this.mfdWts_ForSectID_Map.keySet()) {
            double totWt = this.totWtForSectID_Map.get(id);
            if (!(totWt < 0.99999999)) continue;
            this.mfdList_ForSectID_Map.get(id).add(zeroMFD);
            this.mfdWts_ForSectID_Map.get(id).add(1.0 - totWt);
        }
    }

    private void processSource(ProbEqkSource src, ArrayList<FaultSectionPrefData> dataList, HashMap<String, SummedMagFreqDist> mfd_ForSectName_Map, double duration) {
        ArrayList<SummedMagFreqDist> mfdList = new ArrayList<SummedMagFreqDist>();
        for (FaultSectionPrefData data : dataList) {
            SummedMagFreqDist mfd;
            String name = data.getSectionName();
            if (mfd_ForSectName_Map.keySet().contains(name)) {
                mfd = mfd_ForSectName_Map.get(name);
            } else {
                mfd = this.getNewSummedMagFreqDist();
                mfd.setName(name);
                mfd.setInfo("Section ID = " + String.valueOf(this.sectionIDfromNameMap.get(name)));
                if (name.equals(this.sectionNamefromID_Map.get(ELSINORE_COMBINED_STEPOVER_FAULT_SECTION_ID)) || name.equals(this.sectionNamefromID_Map.get(GLEN_IVY_STEPOVER_FAULT_SECTION_ID)) || name.equals(this.sectionNamefromID_Map.get(TEMECULA_STEPOVER_FAULT_SECTION_ID))) {
                    mfd.setName(this.sectionNamefromID_Map.get(ELSINORE_COMBINED_STEPOVER_FAULT_SECTION_ID));
                    mfd_ForSectName_Map.put(this.sectionNamefromID_Map.get(ELSINORE_COMBINED_STEPOVER_FAULT_SECTION_ID), mfd);
                    mfd_ForSectName_Map.put(this.sectionNamefromID_Map.get(GLEN_IVY_STEPOVER_FAULT_SECTION_ID), mfd);
                    mfd_ForSectName_Map.put(this.sectionNamefromID_Map.get(TEMECULA_STEPOVER_FAULT_SECTION_ID), mfd);
                } else if (name.equals(this.sectionNamefromID_Map.get(SJ_COMBINED_STEPOVER_FAULT_SECTION_ID)) || name.equals(this.sectionNamefromID_Map.get(SJ_ANZA_STEPOVER_FAULT_SECTION_ID)) || name.equals(this.sectionNamefromID_Map.get(SJ_VALLEY_STEPOVER_FAULT_SECTION_ID))) {
                    mfd.setName(this.sectionNamefromID_Map.get(SJ_COMBINED_STEPOVER_FAULT_SECTION_ID));
                    mfd_ForSectName_Map.put(this.sectionNamefromID_Map.get(SJ_COMBINED_STEPOVER_FAULT_SECTION_ID), mfd);
                    mfd_ForSectName_Map.put(this.sectionNamefromID_Map.get(SJ_ANZA_STEPOVER_FAULT_SECTION_ID), mfd);
                    mfd_ForSectName_Map.put(this.sectionNamefromID_Map.get(SJ_VALLEY_STEPOVER_FAULT_SECTION_ID), mfd);
                } else {
                    mfd_ForSectName_Map.put(name, mfd);
                }
            }
            mfdList.add(mfd);
        }
        if (mfdList.size() != dataList.size()) {
            throw new RuntimeException("Problem");
        }
        for (ProbEqkRupture rup : src) {
            double[] fracOnEachSect = this.isParticipation ? this.getSectionParticipationsForRup(rup, dataList) : this.getFractionOfRupOnEachSection(rup, dataList);
            double mag = rup.getMag();
            boolean stepoverDone = false;
            for (int i = 0; i < mfdList.size(); ++i) {
                if (!(fracOnEachSect[i] > 0.0)) continue;
                String name = dataList.get(i).getSectionName();
                if (name.equals(this.sectionNamefromID_Map.get(GLEN_IVY_STEPOVER_FAULT_SECTION_ID)) || name.equals(this.sectionNamefromID_Map.get(TEMECULA_STEPOVER_FAULT_SECTION_ID))) {
                    if (stepoverDone) continue;
                    ((SummedMagFreqDist)mfdList.get(i)).addResampledMagRate(mag, fracOnEachSect[i] * rup.getMeanAnnualRate(duration), true);
                    stepoverDone = true;
                    continue;
                }
                if (name.equals(this.sectionNamefromID_Map.get(SJ_ANZA_STEPOVER_FAULT_SECTION_ID)) || name.equals(this.sectionNamefromID_Map.get(SJ_VALLEY_STEPOVER_FAULT_SECTION_ID))) {
                    if (stepoverDone) continue;
                    ((SummedMagFreqDist)mfdList.get(i)).addResampledMagRate(mag, fracOnEachSect[i] * rup.getMeanAnnualRate(duration), true);
                    stepoverDone = true;
                    continue;
                }
                ((SummedMagFreqDist)mfdList.get(i)).addResampledMagRate(mag, fracOnEachSect[i] * rup.getMeanAnnualRate(duration), true);
            }
        }
    }

    private double[] getFractionOfRupOnEachSection(ProbEqkRupture rup, ArrayList<FaultSectionPrefData> dataList) {
        int i;
        double[] fracOnEachSect = new double[dataList.size()];
        double[] ddwForSect = new double[dataList.size()];
        for (int i2 = 0; i2 < dataList.size(); ++i2) {
            ddwForSect[i2] = dataList.get(i2).getReducedDownDipWidth();
        }
        FaultTrace rupTrace = rup.getRuptureSurface().getEvenlyDiscritizedUpperEdge();
        for (int l = 1; l < rupTrace.size() - 1; ++l) {
            Location loc = (Location)rupTrace.get(l);
            double minDist = Double.MAX_VALUE;
            int minLocSectIndex = -1;
            for (int s = 0; s < dataList.size(); ++s) {
                double dist = dataList.get(s).getFaultTrace().minDistToLine(loc);
                if (!(dist < minDist)) continue;
                minDist = dist;
                minLocSectIndex = s;
            }
            int n = minLocSectIndex;
            fracOnEachSect[n] = fracOnEachSect[n] + ddwForSect[minLocSectIndex];
        }
        double total = 0.0;
        for (i = 0; i < dataList.size(); ++i) {
            total += fracOnEachSect[i];
        }
        for (i = 0; i < dataList.size(); ++i) {
            fracOnEachSect[i] = fracOnEachSect[i] / total;
        }
        return fracOnEachSect;
    }

    private double[] getSectionParticipationsForRup(ProbEqkRupture rup, ArrayList<FaultSectionPrefData> dataList) {
        double[] partOfSect = new double[dataList.size()];
        FaultTrace rupTrace = rup.getRuptureSurface().getEvenlyDiscritizedUpperEdge();
        for (int l = 1; l < rupTrace.size() - 1; ++l) {
            Location loc = (Location)rupTrace.get(l);
            double minDist = Double.MAX_VALUE;
            int minLocSectIndex = -1;
            for (int s = 0; s < dataList.size(); ++s) {
                double dist = dataList.get(s).getFaultTrace().minDistToLine(loc);
                if (!(dist < minDist)) continue;
                minDist = dist;
                minLocSectIndex = s;
            }
            partOfSect[minLocSectIndex] = 1.0;
        }
        return partOfSect;
    }

    private SummedMagFreqDist getNewSummedMagFreqDist() {
        return new SummedMagFreqDist(5.05, 40, 0.1);
    }

    private static void writeListOfAllFaultSections(File sectListFile) {
        UCERF2_TimeIndependentEpistemicList ucerf2EpistemicList = UCERF2_Section_MFDsCalc.getUCERF2_TimeIndependentEpistemicList();
        int numERFs = ucerf2EpistemicList.getNumERFs();
        if (D) {
            System.out.println("Num Branches=" + numERFs);
        }
        ArrayList<String> sectionNames = new ArrayList<String>();
        ArrayList<Integer> sectionIDs = new ArrayList<Integer>();
        ArrayList typeA_RupNamesList = new ArrayList();
        for (int i = 0; i < numERFs; ++i) {
            if (D) {
                System.out.println(i);
            }
            ERF erf = ucerf2EpistemicList.getERF(i);
            ArrayList objList = ((UCERF2)erf).get_A_FaultSourceGenerators();
            for (Object obj : objList) {
                if (!(obj instanceof A_FaultSegmentedSourceGenerator)) continue;
                A_FaultSegmentedSourceGenerator srcGen = (A_FaultSegmentedSourceGenerator)obj;
                FaultSegmentData segData = ((A_FaultSegmentedSourceGenerator)obj).getFaultSegmentData();
                ArrayList dataList = segData.getPrefFaultSectionDataList();
                for (FaultSectionPrefData data : dataList) {
                    int id = data.getSectionId();
                    if (sectionIDs.contains(id)) continue;
                    String name = data.getSectionName();
                    if (sectionNames.contains(name)) {
                        throw new RuntimeException("Error - duplicate name but not id");
                    }
                    sectionIDs.add(id);
                    sectionNames.add(name);
                }
            }
            for (int s = 0; s < erf.getNumSources(); ++s) {
                ProbEqkSource src = erf.getSource(s);
                if (!(src instanceof UnsegmentedSource)) continue;
                FaultSegmentData segData = ((UnsegmentedSource)src).getFaultSegmentData();
                ArrayList dataList = segData.getPrefFaultSectionDataList();
                for (FaultSectionPrefData data : dataList) {
                    int id = data.getSectionId();
                    if (sectionIDs.contains(id)) continue;
                    String name = data.getSectionName();
                    if (sectionNames.contains(name)) {
                        throw new RuntimeException("Error - duplicate name but not id");
                    }
                    sectionIDs.add(id);
                    sectionNames.add(name);
                }
            }
        }
        try {
            FileWriter fw = new FileWriter(sectListFile);
            for (int i = 0; i < sectionNames.size(); ++i) {
                if (D) {
                    System.out.println(String.valueOf(sectionIDs.get(i)) + "\t" + (String)sectionNames.get(i));
                }
                fw.write(String.valueOf(sectionIDs.get(i)) + "\t" + (String)sectionNames.get(i) + "\n");
            }
            fw.close();
        }
        catch (IOException e) {
            System.out.println("IO exception = " + String.valueOf(e));
        }
    }

    private void readListOfAllFaultSections() {
        this.sectionIDfromNameMap = new HashMap();
        this.sectionNamefromID_Map = UCERF2_Section_MFDsCalc.getSectionNamesMap();
        for (Integer id : this.sectionNamefromID_Map.keySet()) {
            this.sectionIDfromNameMap.put(this.sectionNamefromID_Map.get(id), id);
        }
        for (String name : this.sectionIDfromNameMap.keySet()) {
            Integer id = this.sectionIDfromNameMap.get(name);
            if (D) {
                System.out.println(id + "\t" + name);
            }
            if (name.equals(this.sectionNamefromID_Map.get(id))) continue;
            throw new RuntimeException("Problem");
        }
    }

    private static synchronized HashMap<Integer, String> getSectionNamesMap() {
        if (sectionNamesCache == null) {
            sectionNamesCache = Maps.newHashMap();
            try {
                String line;
                BufferedReader reader = new BufferedReader(UCERF3_DataUtils.getReader(DATA_SUB_DIR, SECT_LIST_FILE_NAME));
                int l = -1;
                while ((line = reader.readLine()) != null) {
                    ++l;
                    String[] st = StringUtils.split((String)line, (String)"\t");
                    Integer id = Integer.valueOf(st[0]);
                    String name = st[1];
                    sectionNamesCache.put(id, name);
                }
            }
            catch (Exception e) {
                ExceptionUtils.throwAsRuntimeException(e);
            }
        }
        return sectionNamesCache;
    }

    public static synchronized HashMap<Integer, Integer> getUCERF3toUCERF2ParentSectionIDMap() {
        if (UCERF3toUCERF2ParentSectionIDMap == null) {
            UCERF3toUCERF2ParentSectionIDMap = Maps.newHashMap();
            HashMap<Integer, String> ucerf2SectIDsToNamesMap = UCERF2_Section_MFDsCalc.getSectionNamesMap();
            HashMap ucerf2SectNamesToIDsMap = Maps.newHashMap();
            for (Integer n : ucerf2SectIDsToNamesMap.keySet()) {
                ucerf2SectNamesToIDsMap.put(ucerf2SectIDsToNamesMap.get(n), n);
            }
            HashMap ucerf3SectNamesToIDsMap = Maps.newHashMap();
            for (FaultSection sect : FaultModels.FM3_1.getFaultSections()) {
                ucerf3SectNamesToIDsMap.put(sect.getName(), sect.getSectionId());
            }
            for (FaultSection sect : FaultModels.FM3_2.getFaultSections()) {
                if (ucerf3SectNamesToIDsMap.containsKey(sect.getSectionName())) continue;
                ucerf3SectNamesToIDsMap.put(sect.getName(), sect.getSectionId());
            }
            try {
                HashMap<String, String> hashMap = UCERF2_Section_MFDsCalc.loadUCERF3toUCER2NameMappingFile(FaultModels.FM3_1);
                hashMap.putAll(UCERF2_Section_MFDsCalc.loadUCERF3toUCER2NameMappingFile(FaultModels.FM3_2));
                for (String ucerf3Name : hashMap.keySet()) {
                    String ucerf2Name = hashMap.get(ucerf3Name);
                    Integer ucerf2ID = (Integer)ucerf2SectNamesToIDsMap.get(ucerf2Name);
                    Preconditions.checkNotNull((Object)ucerf2ID, (Object)("UCERF3 to UCERF2 mapping has incorrect name (UCERF2 name incorrect): '" + ucerf3Name + "' => '" + ucerf2Name + "'"));
                    Integer ucerf3ID = (Integer)ucerf3SectNamesToIDsMap.get(ucerf3Name);
                    Preconditions.checkNotNull((Object)ucerf2ID, (Object)("UCERF3 to UCERF2 mapping has incorrect name (UCERF3 name incorrect): '" + ucerf3Name + "' => '" + ucerf2Name + "'"));
                    UCERF3toUCERF2ParentSectionIDMap.put(ucerf3ID, ucerf2ID);
                }
            }
            catch (IOException iOException) {
                ExceptionUtils.throwAsRuntimeException(iOException);
            }
        }
        return UCERF3toUCERF2ParentSectionIDMap;
    }

    public static HashMap<String, String> loadUCERF3toUCER2NameMappingFile(FaultModels fm) throws IOException {
        String line;
        String fName;
        String subDir = "FindEquivUCERF2_Ruptures";
        switch (fm) {
            case FM3_1: {
                fName = "FM2to3_1_sectionNameChanges.txt";
                break;
            }
            case FM3_2: {
                fName = "FM2to3_1_sectionNameChanges.txt";
                break;
            }
            default: {
                throw new IllegalArgumentException("No mapping for " + String.valueOf(fm) + " to UCERF2 parent sections");
            }
        }
        BufferedReader br = new BufferedReader(UCERF3_DataUtils.getReader(subDir, fName));
        HashMap mapping = Maps.newHashMap();
        while ((line = br.readLine()) != null) {
            if ((line = line.trim()).contains("REMOVED") || line.contains("COMBINED") || line.contains("MULTIPLE")) continue;
            String[] split = line.split("\t");
            Preconditions.checkState((split.length == 2 ? 1 : 0) != 0, (Object)("incorrectly formatted line (should have exaclty 2 items separated by a tab): " + line));
            String ucerf2Name = split[0];
            String ucerf3Name = split[1];
            mapping.put(ucerf3Name, ucerf2Name);
        }
        return mapping;
    }

    private static UCERF2_TimeIndependentEpistemicList getUCERF2_TimeIndependentEpistemicList() {
        UCERF2_TimeIndependentEpistemicList ucerf2EpistemicList = new UCERF2_TimeIndependentEpistemicList();
        ucerf2EpistemicList.getAdjustableParameterList().getParameter(UCERF2.BACK_SEIS_NAME).setValue(UCERF2.BACK_SEIS_EXCLUDE);
        return ucerf2EpistemicList;
    }

    private void makeMeanUCERF2_MFD_List() {
        ArrayList dataList;
        UCERF2_TimeIndependentEpistemicList ucerf2EpistemicList = UCERF2_Section_MFDsCalc.getUCERF2_TimeIndependentEpistemicList();
        ERF erf = ucerf2EpistemicList.getERF(0);
        double duration = erf.getTimeSpan().getDuration();
        HashMap<CallSite, ArrayList> sectionsForTypeA_RupsMap = new HashMap<CallSite, ArrayList>();
        ArrayList objList = ((UCERF2)erf).get_A_FaultSourceGenerators();
        for (Object obj : objList) {
            if (!(obj instanceof A_FaultSegmentedSourceGenerator)) continue;
            A_FaultSegmentedSourceGenerator srcGen = (A_FaultSegmentedSourceGenerator)obj;
            dataList = srcGen.getFaultSegmentData().getPrefFaultSectionDataList();
            for (int r = 0; r < srcGen.getNumRupSources(); ++r) {
                String srcName = srcGen.getFaultSegmentData().getFaultName() + ";" + srcGen.getLongRupName(r);
                sectionsForTypeA_RupsMap.put((CallSite)((Object)srcName), dataList);
            }
        }
        this.meanUCERF2_MFD_ForSectID_Map = new HashMap();
        MeanUCERF2 meanUCERF2 = new MeanUCERF2();
        meanUCERF2.setParameter("Probability Model", "Poisson");
        meanUCERF2.setParameter(UCERF2.BACK_SEIS_NAME, UCERF2.BACK_SEIS_EXCLUDE);
        meanUCERF2.updateForecast();
        duration = meanUCERF2.getTimeSpan().getDuration();
        if (D) {
            System.out.println(meanUCERF2.getAdjustableParameterList().toString());
        }
        if (sectionsForTypeA_RupsMap == null) {
            throw new RuntimeException("Error: sectionsForTypeA_RupsMap is null; need to run makeMFD_Lists()");
        }
        for (int s = 0; s < meanUCERF2.getNumSources(); ++s) {
            ProbEqkSource src = meanUCERF2.getSource(s);
            if (src instanceof UnsegmentedSource) {
                dataList = ((UnsegmentedSource)src).getFaultSegmentData().getPrefFaultSectionDataList();
                if (dataList.size() == 1) {
                    SummedMagFreqDist mfd;
                    String name = src.getName();
                    if (!name.equals(((FaultSectionPrefData)dataList.get(0)).getSectionName())) {
                        throw new RuntimeException("Problem");
                    }
                    if (this.meanUCERF2_MFD_ForSectID_Map.keySet().contains(name)) {
                        mfd = this.meanUCERF2_MFD_ForSectID_Map.get(name);
                    } else {
                        mfd = this.getNewSummedMagFreqDist();
                        this.meanUCERF2_MFD_ForSectID_Map.put(name, mfd);
                        mfd.setName(name);
                        mfd.setInfo("Section ID = " + String.valueOf(this.sectionIDfromNameMap.get(name)));
                    }
                    for (ProbEqkRupture rup : src) {
                        mfd.addResampledMagRate(rup.getMag(), rup.getMeanAnnualRate(duration), true);
                    }
                    continue;
                }
                this.processSource(src, dataList, this.meanUCERF2_MFD_ForSectID_Map, duration);
                continue;
            }
            String name = src.getName();
            if (sectionsForTypeA_RupsMap.keySet().contains(name)) {
                this.processSource(src, (ArrayList)sectionsForTypeA_RupsMap.get(name), this.meanUCERF2_MFD_ForSectID_Map, duration);
                continue;
            }
            if (!D) continue;
            System.out.println("Ignored source: " + name);
        }
    }

    public static void main(String[] args) {
        UCERF2_Section_MFDsCalc test = new UCERF2_Section_MFDsCalc(false);
        test.saveAllTestMFD_Plots(false);
        test.saveAllTestMFD_Plots(true);
        System.out.println("DONE");
    }
}

