/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.utils;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;

public class UCERF3_DataUtils {
    private static final String s = File.separator;
    public static File DEFAULT_SCRATCH_DATA_DIR = new File("src" + s + "main" + s + "resources" + s + "scratchData" + s + "ucerf3");
    public static String DATA_URL_PREFIX = "/data/erf/ucerf3";

    public static URL locateResource(String ... pathElements) {
        String relativePath = UCERF3_DataUtils.getRelativePath(pathElements);
        URL url = UCERF3_DataUtils.class.getResource(relativePath);
        Preconditions.checkNotNull((Object)url, (Object)("Resource '" + pathElements[pathElements.length - 1] + "' could not be located: " + relativePath));
        return url;
    }

    private static String getRelativePath(String ... pathElements) {
        Object relativePath = DATA_URL_PREFIX;
        for (String pathElement : pathElements) {
            if (pathElement == null) continue;
            relativePath = (String)relativePath + "/" + pathElement;
        }
        return relativePath;
    }

    public static InputStream locateResourceAsStream(String fileName) {
        return UCERF3_DataUtils.locateResourceAsStream(null, fileName);
    }

    public static InputStream locateResourceAsStream(String ... pathElements) {
        String relativePath = UCERF3_DataUtils.getRelativePath(pathElements);
        InputStream stream = UCERF3_DataUtils.class.getResourceAsStream(relativePath);
        Preconditions.checkNotNull((Object)stream, (Object)("Resource '" + pathElements[pathElements.length - 1] + "' could not be located: " + relativePath));
        return stream;
    }

    public static Reader getReader(InputStream is) throws IOException {
        return new InputStreamReader(is);
    }

    public static Reader getReader(URL url) throws IOException {
        URLConnection uc = url.openConnection();
        return new InputStreamReader((InputStream)uc.getContent());
    }

    public static Reader getReader(String ... pathElements) throws IOException {
        InputStream stream = UCERF3_DataUtils.locateResourceAsStream(pathElements);
        return UCERF3_DataUtils.getReader(stream);
    }
}

