/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.utils;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.opensha.commons.data.function.EvenlyDiscretizedFunc;
import org.opensha.commons.gui.plot.GraphWindow;
import org.opensha.commons.gui.plot.PlotCurveCharacterstics;
import org.opensha.commons.gui.plot.PlotLineType;
import org.opensha.commons.util.ExceptionUtils;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.UCERF2;
import org.opensha.sha.magdist.IncrementalMagFreqDist;
import scratch.UCERF3.utils.GardnerKnopoffAftershockFilter;
import scratch.UCERF3.utils.UCERF3_DataUtils;

public class UCERF3_Observed_MFD_Fetcher {
    static final boolean D = true;
    private static final String SUB_DIR_NAME = "mfdData";
    static final double MIN_MAG = 4.75;
    static final double DELTA_MAG = 0.5;
    IncrementalMagFreqDist directCountsFull;
    IncrementalMagFreqDist directCountsLA;
    IncrementalMagFreqDist directCountsNoCal;
    IncrementalMagFreqDist directCountsSF;
    IncrementalMagFreqDist directCountsSoCal;
    IncrementalMagFreqDist directCountsFull_Lower95;
    IncrementalMagFreqDist directCountsLA_Lower95;
    IncrementalMagFreqDist directCountsNoCal_Lower95;
    IncrementalMagFreqDist directCountsSF_Lower95;
    IncrementalMagFreqDist directCountsSoCal_Lower95;
    IncrementalMagFreqDist directCountsFull_Upper95;
    IncrementalMagFreqDist directCountsLA_Upper95;
    IncrementalMagFreqDist directCountsNoCal_Upper95;
    IncrementalMagFreqDist directCountsSF_Upper95;
    IncrementalMagFreqDist directCountsSoCal_Upper95;

    public UCERF3_Observed_MFD_Fetcher() {
        this.readAllData();
    }

    private void readAllData() {
        ArrayList<IncrementalMagFreqDist> mfds = UCERF3_Observed_MFD_Fetcher.readMFD_DataFromFile("DirectCountWholeState.txt");
        this.directCountsFull = mfds.get(0);
        this.directCountsFull_Lower95 = mfds.get(1);
        this.directCountsFull_Upper95 = mfds.get(2);
        mfds = UCERF3_Observed_MFD_Fetcher.readMFD_DataFromFile("DirectCountLA.txt");
        this.directCountsLA = mfds.get(0);
        this.directCountsLA_Lower95 = mfds.get(1);
        this.directCountsLA_Upper95 = mfds.get(2);
        mfds = UCERF3_Observed_MFD_Fetcher.readMFD_DataFromFile("DirectCountNoCal.txt");
        this.directCountsNoCal = mfds.get(0);
        this.directCountsNoCal_Lower95 = mfds.get(1);
        this.directCountsNoCal_Upper95 = mfds.get(2);
        mfds = UCERF3_Observed_MFD_Fetcher.readMFD_DataFromFile("DirectCountSF.txt");
        this.directCountsSF = mfds.get(0);
        this.directCountsSF_Lower95 = mfds.get(1);
        this.directCountsSF_Upper95 = mfds.get(2);
        mfds = UCERF3_Observed_MFD_Fetcher.readMFD_DataFromFile("DirectCountSoCal.txt");
        this.directCountsSoCal = mfds.get(0);
        this.directCountsSoCal_Lower95 = mfds.get(1);
        this.directCountsSoCal_Upper95 = mfds.get(2);
    }

    private static ArrayList<IncrementalMagFreqDist> readMFD_DataFromFile(String fileName) {
        ArrayList<String> lineList = new ArrayList<String>();
        try {
            String line;
            BufferedReader reader = new BufferedReader(UCERF3_DataUtils.getReader(SUB_DIR_NAME, fileName));
            while ((line = reader.readLine()) != null) {
                lineList.add(line);
            }
        }
        catch (Exception e) {
            ExceptionUtils.throwAsRuntimeException(e);
        }
        int numMag = lineList.size();
        IncrementalMagFreqDist mfdMean = new IncrementalMagFreqDist(4.75, numMag, 0.5);
        IncrementalMagFreqDist mfdLower95Conf = new IncrementalMagFreqDist(4.75, numMag, 0.5);
        IncrementalMagFreqDist mfdUpper95Conf = new IncrementalMagFreqDist(4.75, numMag, 0.5);
        int l = 0;
        for (String line : lineList) {
            System.out.println(line);
            String[] st = StringUtils.split((String)line, (String)" ");
            double magTest = 4.75 + (double)l * 0.5;
            double mag = (Double.valueOf(st[0]) + Double.valueOf(st[1])) / 2.0;
            if (mag >= magTest + 0.001 || mag <= magTest - 0.001) {
                throw new RuntimeException("mags are unequal: " + mag + "\t" + magTest);
            }
            mfdMean.set(mag, (double)Double.valueOf(st[2]));
            if (st.length > 3) {
                mfdLower95Conf.set(mag, (double)Double.valueOf(st[3]));
                mfdUpper95Conf.set(mag, (double)Double.valueOf(st[4]));
            }
            ++l;
        }
        mfdMean.setName("Mean MFD from " + fileName);
        mfdLower95Conf.setName("Lower 95th Conf MFD from " + fileName);
        mfdUpper95Conf.setName("Upper 95th Conf MFD from " + fileName);
        mfdMean.setInfo(" ");
        mfdLower95Conf.setInfo(" ");
        mfdUpper95Conf.setInfo(" ");
        ArrayList<IncrementalMagFreqDist> mfds = new ArrayList<IncrementalMagFreqDist>();
        mfds.add(mfdMean);
        mfds.add(mfdLower95Conf);
        mfds.add(mfdUpper95Conf);
        return mfds;
    }

    public void plotMFDs() {
        ArrayList<PlotCurveCharacterstics> plotChars = new ArrayList<PlotCurveCharacterstics>();
        plotChars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.GREEN));
        plotChars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.BLUE));
        plotChars.add(new PlotCurveCharacterstics(PlotLineType.DASHED, 2.0f, Color.BLUE));
        plotChars.add(new PlotCurveCharacterstics(PlotLineType.DASHED, 2.0f, Color.BLUE));
        ArrayList<IncrementalMagFreqDist> funcs2 = new ArrayList<IncrementalMagFreqDist>();
        funcs2.add(this.directCountsNoCal);
        funcs2.add(this.directCountsNoCal_Lower95);
        funcs2.add(this.directCountsNoCal_Upper95);
        GraphWindow graph2 = new GraphWindow(funcs2, "No Cal Mag-Freq Dists", plotChars);
        graph2.setX_AxisLabel("Mag");
        graph2.setY_AxisLabel("Rate");
        graph2.setY_AxisRange(0.001, 500.0);
        graph2.setX_AxisRange(3.5, 8.0);
        graph2.setYLog(true);
        ArrayList<IncrementalMagFreqDist> funcs3 = new ArrayList<IncrementalMagFreqDist>();
        funcs3.add(this.directCountsSoCal);
        funcs3.add(this.directCountsSoCal_Lower95);
        funcs3.add(this.directCountsSoCal_Upper95);
        GraphWindow graph3 = new GraphWindow(funcs3, "So Cal Mag-Freq Dists", plotChars);
        graph3.setX_AxisLabel("Mag");
        graph3.setY_AxisLabel("Rate");
        graph3.setY_AxisRange(0.001, 500.0);
        graph3.setX_AxisRange(3.5, 8.0);
        graph3.setYLog(true);
        ArrayList<EvenlyDiscretizedFunc> funcs = new ArrayList<EvenlyDiscretizedFunc>();
        funcs.add(this.directCountsFull);
        funcs.add(this.directCountsFull_Lower95);
        funcs.add(this.directCountsFull_Upper95);
        funcs.addAll(UCERF2.getObsCumMFD(true));
        plotChars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.RED));
        plotChars.add(new PlotCurveCharacterstics(PlotLineType.DASHED, 2.0f, Color.RED));
        plotChars.add(new PlotCurveCharacterstics(PlotLineType.DASHED, 2.0f, Color.RED));
        GraphWindow graph = new GraphWindow(funcs, "All Cal Cum Mag-Freq Dists", plotChars);
        graph.setX_AxisLabel("Mag");
        graph.setY_AxisLabel("Rate");
        graph.setY_AxisRange(0.001, 500.0);
        graph.setX_AxisRange(3.5, 8.0);
        graph.setYLog(true);
        ArrayList<IncrementalMagFreqDist> funcs5 = new ArrayList<IncrementalMagFreqDist>();
        funcs5.add(this.directCountsLA);
        funcs5.add(this.directCountsLA_Lower95);
        funcs5.add(this.directCountsLA_Upper95);
        GraphWindow graph4 = new GraphWindow(funcs5, "LA Box MFD", plotChars);
        graph4.setX_AxisLabel("Mag");
        graph4.setY_AxisLabel("Rate");
        graph4.setY_AxisRange(0.001, 500.0);
        graph4.setX_AxisRange(3.5, 8.0);
        graph4.setYLog(true);
        ArrayList<IncrementalMagFreqDist> funcs6 = new ArrayList<IncrementalMagFreqDist>();
        funcs6.add(this.directCountsSF);
        funcs6.add(this.directCountsSF_Lower95);
        funcs6.add(this.directCountsSF_Upper95);
        GraphWindow graph5 = new GraphWindow(funcs6, "SF Box MFD", plotChars);
        graph5.setX_AxisLabel("Mag");
        graph5.setY_AxisLabel("Rate");
        graph5.setY_AxisRange(0.001, 500.0);
        graph5.setX_AxisRange(3.5, 8.0);
        graph5.setYLog(true);
    }

    public void plotCumMFDs() {
        ArrayList<PlotCurveCharacterstics> plotChars = new ArrayList<PlotCurveCharacterstics>();
        plotChars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.GREEN));
        plotChars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.BLUE));
        plotChars.add(new PlotCurveCharacterstics(PlotLineType.DASHED, 2.0f, Color.BLUE));
        plotChars.add(new PlotCurveCharacterstics(PlotLineType.DASHED, 2.0f, Color.BLUE));
        plotChars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.BLACK));
        ArrayList<EvenlyDiscretizedFunc> funcs2 = new ArrayList<EvenlyDiscretizedFunc>();
        funcs2.add(this.directCountsNoCal.getCumRateDistWithOffset());
        funcs2.add(this.directCountsNoCal_Lower95.getCumRateDistWithOffset());
        funcs2.add(this.directCountsNoCal_Upper95.getCumRateDistWithOffset());
        GraphWindow graph2 = new GraphWindow(funcs2, "No Cal Mag-Freq Dists", plotChars);
        graph2.setX_AxisLabel("Mag");
        graph2.setY_AxisLabel("Rate");
        graph2.setY_AxisRange(0.001, 500.0);
        graph2.setX_AxisRange(3.5, 8.0);
        graph2.setYLog(true);
        ArrayList<EvenlyDiscretizedFunc> funcs3 = new ArrayList<EvenlyDiscretizedFunc>();
        funcs3.add(this.directCountsSoCal.getCumRateDistWithOffset());
        funcs3.add(this.directCountsSoCal_Lower95.getCumRateDistWithOffset());
        funcs3.add(this.directCountsSoCal_Upper95.getCumRateDistWithOffset());
        GraphWindow graph3 = new GraphWindow(funcs3, "So Cal Mag-Freq Dists", plotChars);
        graph3.setX_AxisLabel("Mag");
        graph3.setY_AxisLabel("Rate");
        graph3.setY_AxisRange(0.001, 500.0);
        graph3.setX_AxisRange(3.5, 8.0);
        graph3.setYLog(true);
        ArrayList<EvenlyDiscretizedFunc> funcs = new ArrayList<EvenlyDiscretizedFunc>();
        funcs.add(this.directCountsFull.getCumRateDistWithOffset());
        funcs.add(this.directCountsFull_Lower95.getCumRateDistWithOffset());
        funcs.add(this.directCountsFull_Upper95.getCumRateDistWithOffset());
        funcs.addAll(UCERF2.getObsCumMFD(true));
        plotChars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.RED));
        plotChars.add(new PlotCurveCharacterstics(PlotLineType.DASHED, 2.0f, Color.RED));
        plotChars.add(new PlotCurveCharacterstics(PlotLineType.DASHED, 2.0f, Color.RED));
        GraphWindow graph = new GraphWindow(funcs, "All Cal Cum Mag-Freq Dists", plotChars);
        graph.setX_AxisLabel("Mag");
        graph.setY_AxisLabel("Rate");
        graph.setY_AxisRange(0.001, 500.0);
        graph.setX_AxisRange(3.5, 8.0);
        graph.setYLog(true);
        ArrayList<EvenlyDiscretizedFunc> funcs5 = new ArrayList<EvenlyDiscretizedFunc>();
        funcs5.add(this.directCountsLA.getCumRateDistWithOffset());
        funcs5.add(this.directCountsLA_Lower95.getCumRateDistWithOffset());
        funcs5.add(this.directCountsLA_Upper95.getCumRateDistWithOffset());
        GraphWindow graph4 = new GraphWindow(funcs5, "LA Box Cum MFD", plotChars);
        graph4.setX_AxisLabel("Mag");
        graph4.setY_AxisLabel("Rate");
        graph4.setY_AxisRange(0.001, 500.0);
        graph4.setX_AxisRange(3.5, 8.0);
        graph4.setYLog(true);
        ArrayList<EvenlyDiscretizedFunc> funcs6 = new ArrayList<EvenlyDiscretizedFunc>();
        funcs6.add(this.directCountsSF.getCumRateDistWithOffset());
        funcs6.add(this.directCountsSF_Lower95.getCumRateDistWithOffset());
        funcs6.add(this.directCountsSF_Upper95.getCumRateDistWithOffset());
        GraphWindow graph5 = new GraphWindow(funcs6, "SF Box Cum MFD", plotChars);
        graph5.setX_AxisLabel("Mag");
        graph5.setY_AxisLabel("Rate");
        graph5.setY_AxisRange(0.001, 500.0);
        graph5.setX_AxisRange(3.5, 8.0);
        graph5.setYLog(true);
    }

    public void plotDeclusteredSFandLS_BoxMFDs() {
        ArrayList<PlotCurveCharacterstics> plotChars = new ArrayList<PlotCurveCharacterstics>();
        plotChars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.BLACK));
        plotChars.add(new PlotCurveCharacterstics(PlotLineType.DASHED, 2.0f, Color.BLUE));
        plotChars.add(new PlotCurveCharacterstics(PlotLineType.DASHED, 2.0f, Color.BLUE));
        for (int i = 0; i < this.directCountsLA.size(); ++i) {
            double fract = GardnerKnopoffAftershockFilter.scaleForMagnitude(this.directCountsLA.getX(i));
            this.directCountsLA.set(i, fract * this.directCountsLA.getY(i));
            this.directCountsLA_Lower95.set(i, fract * this.directCountsLA_Lower95.getY(i));
            this.directCountsLA_Upper95.set(i, fract * this.directCountsLA_Upper95.getY(i));
            this.directCountsSF.set(i, fract * this.directCountsSF.getY(i));
            this.directCountsSF_Lower95.set(i, fract * this.directCountsSF_Lower95.getY(i));
            this.directCountsSF_Upper95.set(i, fract * this.directCountsSF_Upper95.getY(i));
        }
        ArrayList<EvenlyDiscretizedFunc> funcs5 = new ArrayList<EvenlyDiscretizedFunc>();
        funcs5.add(this.directCountsLA.getCumRateDistWithOffset());
        funcs5.add(this.directCountsLA_Lower95.getCumRateDistWithOffset());
        funcs5.add(this.directCountsLA_Upper95.getCumRateDistWithOffset());
        GraphWindow graph4 = new GraphWindow(funcs5, "LA Box Cum MFD", plotChars);
        graph4.setX_AxisLabel("Magnitude");
        graph4.setY_AxisLabel("Rate (per year)");
        graph4.setPlotLabelFontSize(18);
        graph4.setAxisLabelFontSize(18);
        graph4.setTickLabelFontSize(16);
        graph4.setX_AxisRange(5.0, 9.0);
        graph4.setY_AxisRange(1.0E-4, 1.0);
        graph4.setYLog(true);
        try {
            graph4.saveAsPDF("FelzerLA_BoxDeclustered.pdf");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ArrayList<EvenlyDiscretizedFunc> funcs6 = new ArrayList<EvenlyDiscretizedFunc>();
        funcs6.add(this.directCountsSF.getCumRateDistWithOffset());
        funcs6.add(this.directCountsSF_Lower95.getCumRateDistWithOffset());
        funcs6.add(this.directCountsSF_Upper95.getCumRateDistWithOffset());
        GraphWindow graph5 = new GraphWindow(funcs6, "SF Box Cum MFD", plotChars);
        graph5.setX_AxisLabel("Magnitude");
        graph5.setY_AxisLabel("Rate (per year)");
        graph5.setPlotLabelFontSize(18);
        graph5.setAxisLabelFontSize(18);
        graph5.setTickLabelFontSize(16);
        graph5.setX_AxisRange(5.0, 9.0);
        graph5.setY_AxisRange(1.0E-4, 1.0);
        graph5.setYLog(true);
        try {
            graph5.saveAsPDF("FelzerSF_BoxDeclustered.pdf");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.readAllData();
    }

    public static void main(String[] args) {
        UCERF3_Observed_MFD_Fetcher test = new UCERF3_Observed_MFD_Fetcher();
        test.plotDeclusteredSFandLS_BoxMFDs();
    }

    public static enum Area {
        ALL_CA,
        NO_CA,
        SO_CA,
        LA_BOX,
        SF_BOX;

    }
}

