/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.utils.paleoRateConstraints;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.primitives.Doubles;
import java.awt.Color;
import java.awt.Font;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.math3.stat.StatUtils;
import org.dom4j.DocumentException;
import org.jfree.chart.annotations.XYTextAnnotation;
import org.jfree.chart.ui.TextAnchor;
import org.opensha.commons.data.CSVFile;
import org.opensha.commons.data.function.AbstractDiscretizedFunc;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.commons.data.function.EvenlyDiscretizedFunc;
import org.opensha.commons.data.uncertainty.Uncertainty;
import org.opensha.commons.data.uncertainty.UncertaintyBoundType;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationUtils;
import org.opensha.commons.gui.plot.GraphWindow;
import org.opensha.commons.gui.plot.HeadlessGraphPanel;
import org.opensha.commons.gui.plot.PlotCurveCharacterstics;
import org.opensha.commons.gui.plot.PlotLineType;
import org.opensha.commons.gui.plot.PlotMultiDataLayer;
import org.opensha.commons.gui.plot.PlotSpec;
import org.opensha.commons.gui.plot.PlotSymbol;
import org.opensha.commons.util.ExceptionUtils;
import org.opensha.commons.util.FaultUtils;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemSolution;
import org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.impl.PaleoProbabilityModel;
import org.opensha.sha.faultSurface.FaultSection;
import org.opensha.sha.faultSurface.FaultTrace;
import scratch.UCERF3.U3FaultSystemSolutionFetcher;
import scratch.UCERF3.U3SlipEnabledRupSet;
import scratch.UCERF3.U3SlipEnabledSolution;
import scratch.UCERF3.inversion.CommandLineInversionRunner;
import scratch.UCERF3.inversion.InversionFaultSystemRupSet;
import scratch.UCERF3.inversion.InversionFaultSystemSolution;
import scratch.UCERF3.utils.U3FaultSystemIO;
import scratch.UCERF3.utils.UCERF3_DataUtils;
import scratch.UCERF3.utils.aveSlip.U3AveSlipConstraint;
import scratch.UCERF3.utils.paleoRateConstraints.U3PaleoRateConstraint;
import scratch.UCERF3.utils.paleoRateConstraints.UCERF3_PaleoProbabilityModel;
import scratch.UCERF3.utils.paleoRateConstraints.UCERF3_PaleoRateConstraintFetcher;

public class PaleoFitPlotter {
    private static final PlotSymbol CONFIDENCE_BOUND_SYMBOL = PlotSymbol.DASH;
    private static final PlotSymbol DATA_SYMBOL = PlotSymbol.CIRCLE;
    private static final float CONFIDENCE_BOUND_WIDTH = 1.0f;
    private static boolean smooth_x_vals = false;

    public static PlotSpec getSegRateComparisonSpec(List<U3PaleoRateConstraint> paleoRateConstraint, List<U3AveSlipConstraint> aveSlipConstraints, FaultSystemSolution sol) {
        Preconditions.checkState((paleoRateConstraint.size() > 0 ? 1 : 0) != 0, (Object)"Must have at least one rate constraint");
        Preconditions.checkNotNull((Object)sol, (Object)"Solution cannot me null!");
        FaultSystemRupSet rupSet = sol.getRupSet();
        boolean plotAveSlipBars = true;
        List<? extends FaultSection> datas = rupSet.getFaultSectionDataList();
        ArrayList<AbstractDiscretizedFunc> funcs = new ArrayList<AbstractDiscretizedFunc>();
        HashMap funcParentsMap = Maps.newHashMap();
        ArrayList<PlotCurveCharacterstics> plotChars = new ArrayList<PlotCurveCharacterstics>();
        Color paleoProbColor = Color.RED;
        ArbitrarilyDiscretizedFunc paleoRateMean = new ArbitrarilyDiscretizedFunc();
        paleoRateMean.setName("Paleo Rate Constraint: Mean");
        funcs.add(paleoRateMean);
        plotChars.add(new PlotCurveCharacterstics(DATA_SYMBOL, 5.0f, paleoProbColor));
        ArbitrarilyDiscretizedFunc paleoRateUpper = new ArbitrarilyDiscretizedFunc();
        paleoRateUpper.setName("Paleo Rate Constraint: Upper 95% Confidence");
        funcs.add(paleoRateUpper);
        plotChars.add(new PlotCurveCharacterstics(CONFIDENCE_BOUND_SYMBOL, 5.0f, paleoProbColor));
        ArbitrarilyDiscretizedFunc paleoRateLower = new ArbitrarilyDiscretizedFunc();
        paleoRateLower.setName("Paleo Rate Constraint: Lower 95% Confidence");
        funcs.add(paleoRateLower);
        plotChars.add(new PlotCurveCharacterstics(CONFIDENCE_BOUND_SYMBOL, 5.0f, paleoProbColor));
        ArbitrarilyDiscretizedFunc aveSlipRateMean = null;
        ArbitrarilyDiscretizedFunc aveSlipRateUpper = null;
        ArbitrarilyDiscretizedFunc aveSlipRateLower = null;
        paleoRateConstraint = Lists.newArrayList((Iterable)paleoRateConstraint);
        Color aveSlipColor = new Color(10, 100, 55);
        if (aveSlipConstraints != null) {
            aveSlipRateMean = new ArbitrarilyDiscretizedFunc();
            aveSlipRateMean.setName("Ave Slip Rate Constraint: Mean");
            funcs.add(aveSlipRateMean);
            plotChars.add(new PlotCurveCharacterstics(DATA_SYMBOL, 5.0f, aveSlipColor));
            if (plotAveSlipBars) {
                aveSlipRateUpper = new ArbitrarilyDiscretizedFunc();
                aveSlipRateUpper.setName("Ave Slip Rate Constraint: Upper 95% Confidence");
                funcs.add(aveSlipRateUpper);
                plotChars.add(new PlotCurveCharacterstics(CONFIDENCE_BOUND_SYMBOL, 5.0f, aveSlipColor));
                aveSlipRateLower = new ArbitrarilyDiscretizedFunc();
                aveSlipRateLower.setName("Ave Slip Rate Constraint: Lower 95% Confidence");
                funcs.add(aveSlipRateLower);
                plotChars.add(new PlotCurveCharacterstics(CONFIDENCE_BOUND_SYMBOL, 5.0f, aveSlipColor));
            }
            for (U3AveSlipConstraint aveSlip : aveSlipConstraints) {
                paleoRateConstraint.add(new AveSlipFakePaleoConstraint(aveSlip, aveSlip.getSubSectionIndex(), rupSet.getSlipRateForSection(aveSlip.getSubSectionIndex())));
            }
        }
        int xGap = 5;
        UCERF3_PaleoProbabilityModel paleoProbModel = null;
        try {
            paleoProbModel = UCERF3_PaleoProbabilityModel.load();
        }
        catch (IOException e) {
            ExceptionUtils.throwAsRuntimeException(e);
        }
        int x = 5;
        HashMap<Integer, Integer> xIndForParentMap = new HashMap<Integer, Integer>();
        double runningMisfitTotal = 0.0;
        Color origColor = Color.BLACK;
        for (int p = 0; p < paleoRateConstraint.size(); ++p) {
            double paleoRateX;
            int n;
            U3PaleoRateConstraint constr = (U3PaleoRateConstraint)paleoRateConstraint.get(p);
            int sectID = constr.getSectionIndex();
            int parentID = -1;
            String name = null;
            for (FaultSection faultSection : datas) {
                if (faultSection.getSectionId() != sectID) continue;
                if (faultSection.getParentSectionId() < 0) {
                    throw new IllegalStateException("parent ID isn't populated for solution!");
                }
                parentID = faultSection.getParentSectionId();
                name = faultSection.getParentSectionName();
                break;
            }
            if (parentID < 0) {
                System.err.println("No match for rate constraint for section " + sectID);
                continue;
            }
            int minSect = Integer.MAX_VALUE;
            int n2 = -1;
            for (FaultSection faultSection : datas) {
                if (faultSection.getParentSectionId() != parentID) continue;
                int mySectID = faultSection.getSectionId();
                if (mySectID < minSect) {
                    minSect = mySectID;
                }
                if (mySectID <= n) continue;
                n = mySectID;
            }
            Preconditions.checkState((n >= minSect ? 1 : 0) != 0);
            void numSects = n - minSect;
            int n3 = sectID - minSect;
            if (xIndForParentMap.containsKey(parentID)) {
                paleoRateX = (Integer)xIndForParentMap.get(parentID) + n3;
            } else {
                paleoRateX = x + n3;
                EvenlyDiscretizedFunc paleoRtFunc = new EvenlyDiscretizedFunc((double)x, (int)numSects, 1.0);
                EvenlyDiscretizedFunc aveSlipRtFunc = new EvenlyDiscretizedFunc((double)x, (int)numSects, 1.0);
                EvenlyDiscretizedFunc origRtFunc = new EvenlyDiscretizedFunc((double)x, (int)numSects, 1.0);
                paleoRtFunc.setName("(x=" + x + ") Solution paleo rates for: " + name);
                aveSlipRtFunc.setName("(x=" + x + ") Solution ave slip prob visible rates for: " + name);
                origRtFunc.setName("(x=" + x + ") Solution original rates for: " + name);
                InversionFaultSystemSolution invSol = null;
                if (sol instanceof InversionFaultSystemSolution) {
                    invSol = (InversionFaultSystemSolution)sol;
                }
                for (int j = 0; j < numSects; ++j) {
                    int mySectID = minSect + j;
                    paleoRtFunc.set(j, PaleoFitPlotter.getPaleoRateForSect(sol, mySectID, paleoProbModel));
                    origRtFunc.set(j, PaleoFitPlotter.getPaleoRateForSect(sol, mySectID, null));
                    if (invSol == null) continue;
                    aveSlipRtFunc.set(j, PaleoFitPlotter.getAveSlipProbRateForSect(invSol, mySectID));
                }
                funcs.add(origRtFunc);
                plotChars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 1.0f, origColor));
                if (invSol != null) {
                    funcs.add(aveSlipRtFunc);
                    plotChars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, aveSlipColor));
                }
                funcs.add(paleoRtFunc);
                plotChars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, paleoProbColor));
                funcParentsMap.put(parentID, paleoRtFunc);
                xIndForParentMap.put(parentID, x);
                x += numSects;
                x += 5;
            }
            if (constr instanceof AveSlipFakePaleoConstraint) {
                aveSlipRateMean.set(paleoRateX, constr.getMeanRate());
                if (!plotAveSlipBars) continue;
                aveSlipRateUpper.set(paleoRateX, constr.getUpper95ConfOfRate());
                aveSlipRateLower.set(paleoRateX, constr.getLower95ConfOfRate());
                continue;
            }
            DiscretizedFunc func = (DiscretizedFunc)funcParentsMap.get(parentID);
            double rate = PaleoFitPlotter.getPaleoRateForSect(sol, sectID, paleoProbModel);
            double misfit = Math.pow((constr.getMeanRate() - rate) / constr.getStdDevOfMeanRate(), 2.0);
            Object info = func.getInfo();
            info = info == null || ((String)info).isEmpty() ? "" : (String)info + "\n";
            info = (String)info + "\tSect " + sectID + ". Mean: " + constr.getMeanRate() + "\tStd Dev: " + constr.getStdDevOfMeanRate() + "\tSolution: " + rate + "\tMisfit: " + misfit;
            runningMisfitTotal += misfit;
            func.setInfo((String)info);
            paleoRateMean.set(paleoRateX, constr.getMeanRate());
            paleoRateUpper.set(paleoRateX, constr.getUpper95ConfOfRate());
            paleoRateLower.set(paleoRateX, constr.getLower95ConfOfRate());
        }
        DiscretizedFunc func = (DiscretizedFunc)funcs.get(funcs.size() - 1);
        Object info = func.getInfo();
        info = (String)info + "\n\n\tTOTAL MISFIT: " + runningMisfitTotal;
        func.setInfo((String)info);
        return new PlotSpec(funcs, plotChars, "Paleosiesmic Constraint Fit", "", "Event Rate Per Year");
    }

    public static void showSegRateComparison(List<U3PaleoRateConstraint> paleoRateConstraint, List<U3AveSlipConstraint> aveSlipConstraints, InversionFaultSystemSolution sol) {
        PlotSpec spec = PaleoFitPlotter.getSegRateComparisonSpec(paleoRateConstraint, aveSlipConstraints, sol);
        GraphWindow w = new GraphWindow(spec.getPlotElems(), spec.getTitle(), spec.getChars(), true);
        w.setX_AxisLabel(spec.getXAxisLabel());
        w.setY_AxisLabel(spec.getYAxisLabel());
    }

    public static HeadlessGraphPanel getHeadlessSegRateComparison(List<U3PaleoRateConstraint> paleoRateConstraint, List<U3AveSlipConstraint> aveSlipConstraints, InversionFaultSystemSolution sol, boolean yLog) {
        PlotSpec spec = PaleoFitPlotter.getSegRateComparisonSpec(paleoRateConstraint, aveSlipConstraints, sol);
        HeadlessGraphPanel gp = new HeadlessGraphPanel();
        CommandLineInversionRunner.setFontSizes(gp);
        gp.setYLog(yLog);
        gp.drawGraphPanel(spec);
        return gp;
    }

    public static double getPaleoRateForSect(FaultSystemSolution sol, int sectIndex, PaleoProbabilityModel paleoProbModel) {
        FaultSystemRupSet rupSet = sol.getRupSet();
        double rate = 0.0;
        for (int rupID : rupSet.getRupturesForSection(sectIndex)) {
            double rupRate = sol.getRateForRup(rupID);
            if (paleoProbModel != null) {
                rupRate *= paleoProbModel.getProbPaleoVisible(rupSet, rupID, sectIndex);
            }
            rate += rupRate;
        }
        return rate;
    }

    static double getAveSlipProbRateForSect(U3SlipEnabledSolution sol, int sectIndex) {
        U3SlipEnabledRupSet rupSet = sol.getRupSet();
        double rate = 0.0;
        for (int rupID : rupSet.getRupturesForSection(sectIndex)) {
            int sectIndexInRup = rupSet.getSectionsIndicesForRup(rupID).indexOf(sectIndex);
            double slipOnSect = rupSet.getSlipOnSectionsForRup(rupID)[sectIndexInRup];
            double rupRate = sol.getRateForRup(rupID) * U3AveSlipConstraint.getProbabilityOfObservedSlip(slipOnSect);
            rate += rupRate;
        }
        return rate;
    }

    public static Map<String, PlotSpec[]> getFaultSpecificPaleoPlotSpec(List<U3PaleoRateConstraint> paleoRateConstraint, List<U3AveSlipConstraint> aveSlipConstraints, Map<String, List<Integer>> namedFaultsMap, U3SlipEnabledSolution sol) {
        U3SlipEnabledRupSet rupSet = sol.getRupSet();
        paleoRateConstraint = Lists.newArrayList(paleoRateConstraint);
        if (aveSlipConstraints != null) {
            for (U3AveSlipConstraint aveSlip : aveSlipConstraints) {
                paleoRateConstraint.add(new AveSlipFakePaleoConstraint(aveSlip, aveSlip.getSubSectionIndex(), rupSet.getSlipRateForSection(aveSlip.getSubSectionIndex())));
            }
        }
        UCERF3_PaleoProbabilityModel paleoProbModel = null;
        try {
            paleoProbModel = UCERF3_PaleoProbabilityModel.load();
        }
        catch (IOException e) {
            ExceptionUtils.throwAsRuntimeException(e);
        }
        Map<String, List<U3PaleoRateConstraint>> namedFaultConstraintsMap = PaleoFitPlotter.getNamedFaultConstraintsMap(paleoRateConstraint, rupSet.getFaultSectionDataList(), namedFaultsMap);
        Map<Integer, List<FaultSection>> allParentsMap = PaleoFitPlotter.getAllParentsMap(rupSet.getFaultSectionDataList());
        ArrayList datas = Lists.newArrayList();
        datas.add(DataForPaleoFaultPlots.build(sol, namedFaultsMap, namedFaultConstraintsMap, allParentsMap, paleoProbModel, 1.0));
        return PaleoFitPlotter.getFaultSpecificPaleoPlotSpecs(namedFaultsMap, namedFaultConstraintsMap, datas, allParentsMap);
    }

    public static Map<String, List<U3PaleoRateConstraint>> getNamedFaultConstraintsMap(List<U3PaleoRateConstraint> paleoRateConstraint, List<? extends FaultSection> fsd, Map<String, List<Integer>> namedFaultsMap) {
        HashMap namedFaultConstraintsMap = Maps.newHashMap();
        for (U3PaleoRateConstraint constr : paleoRateConstraint) {
            FaultSection sect = fsd.get(constr.getSectionIndex());
            Integer parentID = sect.getParentSectionId();
            String name = null;
            for (String faultName : namedFaultsMap.keySet()) {
                List<Integer> parentIDs = namedFaultsMap.get(faultName);
                if (!parentIDs.contains(parentID)) continue;
                name = faultName;
                break;
            }
            if (name == null) {
                System.err.println("WARNING: no named fault map for paleo constraint on parent section " + sect.getParentSectionName() + " (pale name=" + constr.getPaleoSiteName() + ")");
                continue;
            }
            List constraintsForFault = (List)namedFaultConstraintsMap.get(name);
            if (constraintsForFault == null) {
                constraintsForFault = Lists.newArrayList();
                namedFaultConstraintsMap.put(name, constraintsForFault);
            }
            constraintsForFault.add(constr);
        }
        return namedFaultConstraintsMap;
    }

    public static Map<Integer, List<FaultSection>> getAllParentsMap(List<? extends FaultSection> fsd) {
        HashMap allParentsMap = Maps.newHashMap();
        for (FaultSection faultSection : fsd) {
            List parentSects = (List)allParentsMap.get(faultSection.getParentSectionId());
            if (parentSects == null) {
                parentSects = Lists.newArrayList();
                allParentsMap.put(faultSection.getParentSectionId(), parentSects);
            }
            parentSects.add(faultSection);
        }
        return allParentsMap;
    }

    private static List<PlotCurveCharacterstics> getCharsForFuncs(List<DiscretizedFunc> funcs, Color color, float mainThickness) {
        ArrayList chars = Lists.newArrayList();
        if (funcs.size() == 1) {
            chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, mainThickness, color));
        } else {
            chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 1.0f, color));
            chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 1.0f, color));
            chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, mainThickness, color));
        }
        return chars;
    }

    private static List<DiscretizedFunc> getFuncsForScalar(List<DataForPaleoFaultPlots> datas, int arrayIndex, int parentID, double[][] xvals, String name) {
        ArrayList funcs = Lists.newArrayList();
        if (datas.size() == 1) {
            ArbitrarilyDiscretizedFunc func = new ArbitrarilyDiscretizedFunc();
            func.setName(name);
            double[] array = datas.get((int)0).allArraysList.get(arrayIndex).get(parentID);
            for (int i = 0; i < array.length; ++i) {
                for (double x : xvals[i]) {
                    func.set(x, array[i]);
                }
            }
            funcs.add(func);
        } else {
            int s;
            double[][] arrayVals = new double[xvals.length][datas.size()];
            double totWeight = 0.0;
            double[] weights = new double[datas.size()];
            for (int d = 0; d < datas.size(); ++d) {
                DataForPaleoFaultPlots data = datas.get(d);
                double[] array = data.allArraysList.get(arrayIndex).get(parentID);
                for (s = 0; s < xvals.length; ++s) {
                    arrayVals[s][d] = array[s];
                }
                weights[d] = data.weight;
                totWeight += data.weight;
            }
            for (int i = 0; i < weights.length; ++i) {
                weights[i] = weights[i] / totWeight;
            }
            Preconditions.checkState((totWeight > 0.0 ? 1 : 0) != 0);
            ArbitrarilyDiscretizedFunc minFunc = new ArbitrarilyDiscretizedFunc();
            minFunc.setName(name + " (minimum)");
            ArbitrarilyDiscretizedFunc maxFunc = new ArbitrarilyDiscretizedFunc();
            maxFunc.setName(name + " (maximum)");
            ArbitrarilyDiscretizedFunc meanFunc = new ArbitrarilyDiscretizedFunc();
            meanFunc.setName(name + " (weighted mean)");
            for (s = 0; s < xvals.length; ++s) {
                double[] myXvals = xvals[s];
                double[] array = arrayVals[s];
                double mean = U3FaultSystemSolutionFetcher.calcScaledAverage(array, weights);
                if (Double.isInfinite(mean)) {
                    System.out.println("INFINITE! array=[" + Joiner.on((String)",").join((Iterable)Doubles.asList((double[])array)) + "], weights=[" + Joiner.on((String)",").join((Iterable)Doubles.asList((double[])weights)));
                }
                double min = StatUtils.min((double[])array);
                double max = StatUtils.max((double[])array);
                if (!smooth_x_vals) {
                    boolean xIncreasing = myXvals[myXvals.length - 1] > myXvals[0];
                    for (int i = 0; i < myXvals.length; ++i) {
                        double x = myXvals[i];
                        if (minFunc.getXIndex(x) >= 0) {
                            boolean end;
                            boolean bl = end = i == myXvals.length - 1;
                            x = xIncreasing ? (!end ? (x += 1.0E-4) : (x -= 1.0E-4)) : (!end ? (x -= 1.0E-4) : (x += 1.0E-4));
                        }
                        minFunc.set(x, min);
                        maxFunc.set(x, max);
                        meanFunc.set(x, mean);
                    }
                    continue;
                }
                double x = 0.5 * (myXvals[0] + myXvals[myXvals.length - 1]);
                if (s == 0) {
                    minFunc.set(myXvals[0], min);
                    maxFunc.set(myXvals[0], max);
                    meanFunc.set(myXvals[0], mean);
                }
                minFunc.set(x, min);
                maxFunc.set(x, max);
                meanFunc.set(x, mean);
                if (s != xvals.length - 1) continue;
                minFunc.set(myXvals[myXvals.length - 1], min);
                maxFunc.set(myXvals[myXvals.length - 1], max);
                meanFunc.set(myXvals[myXvals.length - 1], mean);
            }
            funcs.add(minFunc);
            funcs.add(maxFunc);
            funcs.add(meanFunc);
        }
        return funcs;
    }

    public static Map<String, PlotSpec[]> getFaultSpecificPaleoPlotSpecs(Map<String, List<Integer>> namedFaultsMap, Map<String, List<U3PaleoRateConstraint>> namedFaultConstraintsMap, List<DataForPaleoFaultPlots> datas, Map<Integer, List<FaultSection>> allParentsMap) {
        Color origColor = Color.BLACK;
        Color aveSlipColor = new Color(10, 100, 55);
        Color paleoProbColor = Color.RED;
        HashMap specs = Maps.newHashMap();
        for (String name : namedFaultConstraintsMap.keySet()) {
            List<U3PaleoRateConstraint> constraints = namedFaultConstraintsMap.get(name);
            List<Integer> namedFaults = namedFaultsMap.get(name);
            ArrayList rateFuncs = Lists.newArrayList();
            ArrayList rateChars = Lists.newArrayList();
            ArrayList slipFuncs = Lists.newArrayList();
            ArrayList slipChars = Lists.newArrayList();
            ArrayList aveSlipFuncs = Lists.newArrayList();
            ArrayList aveSlipChars = Lists.newArrayList();
            ArrayList allSepLocs = Lists.newArrayList();
            ArbitrarilyDiscretizedFunc paleoRateMean = new ArbitrarilyDiscretizedFunc();
            paleoRateMean.setName("Paleo Rate Constraint: Mean");
            ArbitrarilyDiscretizedFunc paleoRateUpper = new ArbitrarilyDiscretizedFunc();
            paleoRateUpper.setName("Paleo Rate Constraint: Upper 95% Confidence");
            ArbitrarilyDiscretizedFunc paleoRateLower = new ArbitrarilyDiscretizedFunc();
            paleoRateLower.setName("Paleo Rate Constraint: Lower 95% Confidence");
            ArrayList paleoErrorBarFuncs = Lists.newArrayList();
            ArbitrarilyDiscretizedFunc aveSlipRateMean = new ArbitrarilyDiscretizedFunc();
            aveSlipRateMean.setName("Ave Slip Rate Constraint: Mean");
            ArbitrarilyDiscretizedFunc aveSlipDataMean = new ArbitrarilyDiscretizedFunc();
            aveSlipDataMean.setName("Ave Slip Per Event Data: Mean");
            ArbitrarilyDiscretizedFunc aveSlipDataUpper = new ArbitrarilyDiscretizedFunc();
            aveSlipDataUpper.setName("Ave Slip Per Event Data: Upper 95% Confidence");
            ArbitrarilyDiscretizedFunc aveSlipDataLower = new ArbitrarilyDiscretizedFunc();
            aveSlipDataLower.setName("Ave Slip Per Event Data: Lower 95% Confidence");
            double minLat = Double.POSITIVE_INFINITY;
            double maxLat = Double.NEGATIVE_INFINITY;
            double minLon = Double.POSITIVE_INFINITY;
            double maxLon = Double.NEGATIVE_INFINITY;
            double maxSlip = 0.0;
            HashMap sectionsForFault = Maps.newHashMap();
            for (Integer parentID : namedFaults) {
                List<FaultSection> sectionsForParent = allParentsMap.get(parentID);
                if (sectionsForParent == null) continue;
                for (FaultSection sect : sectionsForParent) {
                    for (Location loc : sect.getFaultTrace()) {
                        double lat = loc.getLatitude();
                        double lon = loc.getLongitude();
                        if (lat < minLat) {
                            minLat = lat;
                        }
                        if (lat > maxLat) {
                            maxLat = lat;
                        }
                        if (lon < minLon) {
                            minLon = lon;
                        }
                        if (!(lon > maxLon)) continue;
                        maxLon = lon;
                    }
                }
                for (DataForPaleoFaultPlots data : datas) {
                    double origSlip = StatUtils.max((double[])data.origSlipsMap.get(parentID));
                    double solSlip = StatUtils.max((double[])data.solSlipsMap.get(parentID));
                    if (origSlip > maxSlip) {
                        maxSlip = origSlip;
                    }
                    if (!(solSlip > maxSlip)) continue;
                    maxSlip = solSlip;
                }
                sectionsForFault.put(parentID, sectionsForParent);
            }
            double deltaLat = maxLat - minLat;
            double deltaLon = maxLon - minLon;
            boolean latitudeX = deltaLat > 0.5 * deltaLon;
            PlotCurveCharacterstics sepChar = new PlotCurveCharacterstics(PlotLineType.DASHED, 1.0f, Color.GRAY);
            ArrayList parentNames = Lists.newArrayList();
            for (Integer parentID : namedFaults) {
                List sectionsForParent = (List)sectionsForFault.get(parentID);
                if (sectionsForParent == null) continue;
                String parentName = ((FaultSection)sectionsForParent.get(0)).getParentSectionName();
                parentNames.add(parentName);
            }
            String[] parentNamesArray = parentNames.toArray(new String[0]);
            String commonPrefix = StringUtils.getCommonPrefix((String[])parentNamesArray);
            ArrayList annotations = Lists.newArrayList();
            Font font = new Font("Serif", 0, 14);
            double angle = -1.5707963267948966;
            TextAnchor rotAnchor = TextAnchor.CENTER_RIGHT;
            TextAnchor textAnchor = TextAnchor.CENTER_RIGHT;
            int actualCount = 0;
            for (int i = 0; i < namedFaults.size(); ++i) {
                boolean skip;
                Integer parentID = namedFaults.get(i);
                List sectionsForParent = (List)sectionsForFault.get(parentID);
                if (sectionsForParent == null) continue;
                String parentName = ((FaultSection)sectionsForParent.get(0)).getParentSectionName();
                ++actualCount;
                FaultTrace firstTrace = ((FaultSection)sectionsForParent.get(0)).getFaultTrace();
                FaultTrace lastTrace = ((FaultSection)sectionsForParent.get(sectionsForParent.size() - 1)).getFaultTrace();
                Location startLoc = firstTrace.first();
                Location endLoc = lastTrace.last();
                allSepLocs.add(startLoc);
                allSepLocs.add(endLoc);
                String annotationName = parentName;
                if (!commonPrefix.isEmpty()) {
                    annotationName = annotationName.substring(commonPrefix.length());
                }
                annotationName = annotationName.replaceAll("San Andreas", "");
                annotationName = annotationName.replaceAll("Elsinore", "");
                annotationName = annotationName.replaceAll("\\(", "").replaceAll("\\)", "");
                annotationName = annotationName.replaceAll("2011 CFM", "");
                annotationName = annotationName.replaceAll(" rev", "");
                annotationName = annotationName.trim();
                double midPt = latitudeX ? 0.5 * (startLoc.getLatitude() + endLoc.getLatitude()) : 0.5 * (startLoc.getLongitude() + endLoc.getLongitude());
                if (!annotationName.isEmpty()) {
                    XYTextAnnotation a = new XYTextAnnotation((String)annotationName + " ", midPt, 0.0);
                    a.setFont(font);
                    a.setRotationAnchor(rotAnchor);
                    a.setTextAnchor(textAnchor);
                    a.setRotationAngle(angle);
                    annotations.add(a);
                }
                double[][] xvals = new double[sectionsForParent.size()][];
                for (int s = 0; s < xvals.length; ++s) {
                    FaultTrace trace = ((FaultSection)sectionsForParent.get(s)).getFaultTrace();
                    xvals[s] = new double[trace.size()];
                    for (int t = 0; t < trace.size(); ++t) {
                        Location loc = (Location)trace.get(t);
                        xvals[s][t] = latitudeX ? loc.getLatitude() : loc.getLongitude();
                    }
                }
                List<DiscretizedFunc> origSlipFuncs = PaleoFitPlotter.getFuncsForScalar(datas, 0, parentID, xvals, "Original nonreduced slip rates for: " + (String)parentName);
                List<DiscretizedFunc> targetSlipFuncs = PaleoFitPlotter.getFuncsForScalar(datas, 1, parentID, xvals, "Target slip rates for: " + (String)parentName);
                List<DiscretizedFunc> solSlipFuncs = PaleoFitPlotter.getFuncsForScalar(datas, 2, parentID, xvals, "Solution slip rates for: " + (String)parentName);
                List<DiscretizedFunc> paleoRtFuncs = PaleoFitPlotter.getFuncsForScalar(datas, 3, parentID, xvals, "Solution paleo rates for: " + (String)parentName);
                List<DiscretizedFunc> origRtFuncs = PaleoFitPlotter.getFuncsForScalar(datas, 4, parentID, xvals, "Solution original rates for: " + (String)parentName);
                List<DiscretizedFunc> aveSlipRtFuncs = PaleoFitPlotter.getFuncsForScalar(datas, 5, parentID, xvals, "Solution ave slip prob visible rates for: " + (String)parentName);
                List<DiscretizedFunc> myAveSlipsFuncs = PaleoFitPlotter.getFuncsForScalar(datas, 6, parentID, xvals, "Solution average slip per event for: " + (String)parentName);
                List<DiscretizedFunc> myAvePaleoSlipsFuncs = PaleoFitPlotter.getFuncsForScalar(datas, 7, parentID, xvals, "Solution average paleo observable slip per event for: " + (String)parentName);
                boolean bl = skip = origRtFuncs.get(origRtFuncs.size() - 1).getMaxY() <= 0.0;
                if (skip) continue;
                rateFuncs.addAll(paleoRtFuncs);
                rateChars.addAll(PaleoFitPlotter.getCharsForFuncs(paleoRtFuncs, paleoProbColor, 2.0f));
                rateFuncs.addAll(origRtFuncs);
                rateChars.addAll(PaleoFitPlotter.getCharsForFuncs(origRtFuncs, origColor, 1.0f));
                rateFuncs.addAll(aveSlipRtFuncs);
                rateChars.addAll(PaleoFitPlotter.getCharsForFuncs(aveSlipRtFuncs, aveSlipColor, 2.0f));
                if (datas.size() == 1) {
                    slipFuncs.addAll(origSlipFuncs);
                    slipChars.addAll(PaleoFitPlotter.getCharsForFuncs(origSlipFuncs, Color.CYAN, 1.0f));
                }
                slipFuncs.addAll(targetSlipFuncs);
                slipChars.addAll(PaleoFitPlotter.getCharsForFuncs(targetSlipFuncs, Color.BLUE, 2.0f));
                slipFuncs.addAll(solSlipFuncs);
                slipChars.addAll(PaleoFitPlotter.getCharsForFuncs(solSlipFuncs, Color.MAGENTA, 2.0f));
                aveSlipFuncs.addAll(myAveSlipsFuncs);
                aveSlipChars.addAll(PaleoFitPlotter.getCharsForFuncs(myAveSlipsFuncs, Color.BLUE, 2.0f));
                aveSlipFuncs.addAll(myAvePaleoSlipsFuncs);
                aveSlipChars.addAll(PaleoFitPlotter.getCharsForFuncs(myAvePaleoSlipsFuncs, Color.MAGENTA, 2.0f));
            }
            if (actualCount == 0) continue;
            for (U3PaleoRateConstraint constr : constraints) {
                Preconditions.checkNotNull((Object)constr, (Object)"Paleo Constraint NULL!");
                Preconditions.checkNotNull((Object)constr.getPaleoSiteLoction(), (Object)"Paleo Constraint Location NULL!");
                FaultSection mappedSect = null;
                block10: for (Integer parentID : namedFaults) {
                    for (FaultSection sect : allParentsMap.get(parentID)) {
                        if (sect.getSectionId() != constr.getSectionIndex()) continue;
                        mappedSect = sect;
                        continue block10;
                    }
                }
                Preconditions.checkNotNull(mappedSect, (Object)("Couldn't find mapped sub section: " + constr.getSectionIndex()));
                FaultTrace mappedTrace = mappedSect.getFaultTrace();
                mappedTrace = FaultUtils.resampleTrace(mappedTrace, 20);
                Location origPaleoLocation = constr.getPaleoSiteLoction();
                Location paleoLocation = null;
                double paleoLocDist = Double.POSITIVE_INFINITY;
                for (Location traceLoc : mappedTrace) {
                    double dist = LocationUtils.horzDistanceFast(origPaleoLocation, traceLoc);
                    if (!(dist < paleoLocDist)) continue;
                    paleoLocDist = dist;
                    paleoLocation = traceLoc;
                }
                double paleoRateX = latitudeX ? paleoLocation.getLatitude() : paleoLocation.getLongitude();
                if (constr instanceof AveSlipFakePaleoConstraint) {
                    aveSlipRateMean.set(paleoRateX, constr.getMeanRate());
                    aveSlipDataMean.set(paleoRateX, ((AveSlipFakePaleoConstraint)constr).origAveSlip);
                    aveSlipDataUpper.set(paleoRateX, ((AveSlipFakePaleoConstraint)constr).origAveSlipUpper);
                    aveSlipDataLower.set(paleoRateX, ((AveSlipFakePaleoConstraint)constr).origAveSlipLower);
                    continue;
                }
                paleoRateMean.set(paleoRateX, constr.getMeanRate());
                paleoRateUpper.set(paleoRateX, constr.getUpper95ConfOfRate());
                paleoRateLower.set(paleoRateX, constr.getLower95ConfOfRate());
                ArbitrarilyDiscretizedFunc errorBarFunc = new ArbitrarilyDiscretizedFunc();
                errorBarFunc.setName("Paleo Rate Constraint: Error Bar");
                errorBarFunc.set(paleoRateX - 5.0E-5, constr.getUpper95ConfOfRate());
                errorBarFunc.set(paleoRateX + 5.0E-5, constr.getLower95ConfOfRate());
                paleoErrorBarFuncs.add(errorBarFunc);
            }
            if (aveSlipRateMean.size() > 0) {
                rateFuncs.add(aveSlipRateMean);
                rateChars.add(new PlotCurveCharacterstics(DATA_SYMBOL, 5.0f, aveSlipColor));
            }
            if (paleoRateMean.size() > 0) {
                rateFuncs.add(paleoRateMean);
                rateChars.add(new PlotCurveCharacterstics(DATA_SYMBOL, 5.0f, paleoProbColor));
                rateFuncs.add(paleoRateUpper);
                rateChars.add(new PlotCurveCharacterstics(CONFIDENCE_BOUND_SYMBOL, 5.0f, paleoProbColor));
                rateFuncs.add(paleoRateLower);
                rateChars.add(new PlotCurveCharacterstics(CONFIDENCE_BOUND_SYMBOL, 5.0f, paleoProbColor));
                for (ArbitrarilyDiscretizedFunc errorBarFunc : paleoErrorBarFuncs) {
                    rateFuncs.add(errorBarFunc);
                    rateChars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 1.0f, paleoProbColor));
                }
            }
            if (aveSlipDataMean.size() > 0) {
                aveSlipFuncs.add(aveSlipDataMean);
                aveSlipChars.add(new PlotCurveCharacterstics(DATA_SYMBOL, 5.0f, aveSlipColor));
                aveSlipFuncs.add(aveSlipDataUpper);
                aveSlipChars.add(new PlotCurveCharacterstics(CONFIDENCE_BOUND_SYMBOL, 5.0f, aveSlipColor));
                aveSlipFuncs.add(aveSlipDataLower);
                aveSlipChars.add(new PlotCurveCharacterstics(CONFIDENCE_BOUND_SYMBOL, 5.0f, aveSlipColor));
            }
            System.out.println(name + "\tDeltaLat: " + deltaLat + "\tDeltaLon: " + deltaLon + "\tLatitudeX ? " + latitudeX);
            String paleoTitle = "Paleo Rates/Constraints for " + name;
            String slipTitle = "Slip Rates for " + name;
            String aveSlipTitle = "Average Slip In Events for " + name;
            String xAxisLabel = latitudeX ? "Latitude (degrees)" : "Longitude (degrees)";
            String paleoYAxisLabel = "Event Rate Per Year";
            String slipYAxisLabel = "Slip Rate (mm/yr)";
            String aveSlipYAxisLabel = "Ave Slip In Events (m)";
            ArrayList paleoOnlyFuncs = Lists.newArrayList();
            ArrayList paleoOnlyChars = Lists.newArrayList();
            paleoOnlyFuncs.addAll(rateFuncs);
            paleoOnlyChars.addAll(rateChars);
            ArrayList slipOnlyFuncs = Lists.newArrayList();
            ArrayList slipOnlyChars = Lists.newArrayList();
            slipOnlyFuncs.addAll(slipFuncs);
            slipOnlyChars.addAll(slipChars);
            PlotMultiDataLayer paleoSeps = new PlotMultiDataLayer();
            paleoSeps.setInfo("(separators)");
            PlotMultiDataLayer slipSeps = new PlotMultiDataLayer();
            slipSeps.setInfo("(separators)");
            PlotMultiDataLayer aveSeps = new PlotMultiDataLayer();
            aveSeps.setInfo("(separators)");
            for (Location sepLoc : allSepLocs) {
                double x = latitudeX ? sepLoc.getLatitude() : sepLoc.getLongitude();
                paleoSeps.addVerticalLine(x, 1.0E-10, 10.0);
                slipSeps.addVerticalLine(x, 1.0E-10, 5000.0);
                aveSeps.addVerticalLine(x, 0.0, 50.0);
            }
            paleoOnlyFuncs.add(paleoSeps);
            slipOnlyChars.add(sepChar);
            slipOnlyFuncs.add(slipSeps);
            paleoOnlyChars.add(sepChar);
            aveSlipFuncs.add(aveSeps);
            aveSlipChars.add(sepChar);
            PlotSpec paleoOnlySpec = new PlotSpec(paleoOnlyFuncs, paleoOnlyChars, paleoTitle, xAxisLabel, paleoYAxisLabel);
            paleoOnlySpec.setPlotAnnotations(annotations);
            PlotSpec slipOnlySpec = new PlotSpec(slipOnlyFuncs, slipOnlyChars, slipTitle, xAxisLabel, slipYAxisLabel);
            slipOnlySpec.setPlotAnnotations(annotations);
            PlotSpec aveSlipSpec = new PlotSpec(aveSlipFuncs, aveSlipChars, aveSlipTitle, xAxisLabel, aveSlipYAxisLabel);
            aveSlipSpec.setPlotAnnotations(annotations);
            PlotSpec[] specArray = new PlotSpec[]{paleoOnlySpec, slipOnlySpec, aveSlipSpec};
            specs.put(name, specArray);
        }
        return specs;
    }

    public static void writeTables(File dir, InversionFaultSystemSolution sol, List<U3AveSlipConstraint> aveSlipConstraints, List<U3PaleoRateConstraint> paleoRateConstraints, FaultSystemSolution ucerf2Sol, List<U3AveSlipConstraint> ucerf2AveSlipConstraints, List<U3PaleoRateConstraint> ucerf2PaleoRateConstraints, PaleoProbabilityModel paleoProbModel) throws IOException {
        CSVFile<String> aveSlipTable = PaleoFitPlotter.buildAveSlipTable(sol, aveSlipConstraints, ucerf2Sol, ucerf2AveSlipConstraints);
        CSVFile<String> paleoTable = PaleoFitPlotter.buildPaleoRateTable(sol, paleoRateConstraints, ucerf2Sol, ucerf2PaleoRateConstraints, paleoProbModel);
        File aveSlipFile = new File(dir, "ave_slip_rates.csv");
        File paleoFile = new File(dir, "paleo_rates.csv");
        aveSlipTable.writeToFile(aveSlipFile);
        paleoTable.writeToFile(paleoFile);
    }

    public static CSVFile<String> buildAveSlipTable(InversionFaultSystemSolution sol, List<U3AveSlipConstraint> constraints, FaultSystemSolution ucerf2Sol, List<U3AveSlipConstraint> ucerf2AveSlipConstraints) {
        InversionFaultSystemRupSet rupSet = sol.getRupSet();
        CSVFile<String> csv = new CSVFile<String>(true);
        ArrayList header = Lists.newArrayList((Object[])new String[]{rupSet.getFaultModel().getShortName() + " Mapping", "Latitude", "Longitude", "Weighted Mean Slip", "UCERF2 Reduced Slip Rate", "UCERF2 Proxy Event Rate", "UCERF3 Reduced Slip Rate", "UCERF3 Proxy Event Rate", "UCERF3 Paleo Visible Rate"});
        csv.addLine(header);
        for (int i = 0; i < constraints.size(); ++i) {
            U3AveSlipConstraint constr = constraints.get(i);
            U3AveSlipConstraint ucerf2Constraint = null;
            for (U3AveSlipConstraint u2Constr : ucerf2AveSlipConstraints) {
                if (!u2Constr.getSiteLocation().equals(constr.getSiteLocation())) continue;
                ucerf2Constraint = u2Constr;
                break;
            }
            int subsectionIndex = constr.getSubSectionIndex();
            double slip = rupSet.getSlipRateForSection(subsectionIndex);
            double proxyRate = slip / constr.getWeightedMean();
            double obsRate = 0.0;
            for (int rupID : rupSet.getRupturesForSection(constr.getSubSectionIndex())) {
                int sectIndexInRup = rupSet.getSectionsIndicesForRup(rupID).indexOf(subsectionIndex);
                double slipOnSect = rupSet.getSlipOnSectionsForRup(rupID)[sectIndexInRup];
                double probVisible = U3AveSlipConstraint.getProbabilityOfObservedSlip(slipOnSect);
                obsRate += sol.getRateForRup(rupID) * probVisible;
            }
            ArrayList line = Lists.newArrayList();
            line.add(constr.getSubSectionName());
            line.add("" + constr.getSiteLocation().getLatitude());
            line.add("" + constr.getSiteLocation().getLongitude());
            line.add("" + constr.getWeightedMean());
            if (ucerf2Constraint == null) {
                line.add("");
                line.add("");
            } else {
                double ucerf2SlipRate = ucerf2Sol.getRupSet().getSlipRateForSection(ucerf2Constraint.getSubSectionIndex());
                line.add("" + ucerf2SlipRate);
                double ucerf2ProxyRate = ucerf2SlipRate / constr.getWeightedMean();
                line.add("" + ucerf2ProxyRate);
            }
            line.add("" + slip);
            line.add("" + proxyRate);
            line.add("" + obsRate);
            csv.addLine(line);
        }
        return csv;
    }

    public static CSVFile<String> buildPaleoRateTable(InversionFaultSystemSolution sol, List<U3PaleoRateConstraint> constraints, FaultSystemSolution ucerf2Sol, List<U3PaleoRateConstraint> ucerf2PaleoConstraints, PaleoProbabilityModel paleoProbModel) {
        InversionFaultSystemRupSet rupSet = sol.getRupSet();
        CSVFile<String> csv = new CSVFile<String>(true);
        ArrayList header = Lists.newArrayList((Object[])new String[]{rupSet.getFaultModel().getShortName() + " Mapping", "Latitude", "Longitude", "Paleo Observed Rate", "Paleo Observed Lower Bound", "Paleo Observed Upper Bound", "UCERF2 Proxy Event Rate", "UCERF3 Paleo Visible Rate"});
        csv.addLine(header);
        for (int i = 0; i < constraints.size(); ++i) {
            U3PaleoRateConstraint constr = constraints.get(i);
            U3PaleoRateConstraint ucerf2Constraint = null;
            for (U3PaleoRateConstraint u2Constr : ucerf2PaleoConstraints) {
                if (!u2Constr.getPaleoSiteLoction().equals(constr.getPaleoSiteLoction())) continue;
                ucerf2Constraint = u2Constr;
                break;
            }
            ArrayList line = Lists.newArrayList();
            line.add(constr.getFaultSectionName());
            line.add("" + constr.getPaleoSiteLoction().getLatitude());
            line.add("" + constr.getPaleoSiteLoction().getLongitude());
            line.add("" + constr.getMeanRate());
            line.add("" + constr.getLower95ConfOfRate());
            line.add("" + constr.getUpper95ConfOfRate());
            if (ucerf2Constraint == null) {
                line.add("");
            } else {
                line.add("" + PaleoFitPlotter.getPaleoRateForSect(ucerf2Sol, ucerf2Constraint.getSectionIndex(), paleoProbModel));
            }
            double obsRate = 0.0;
            for (int rupID : rupSet.getRupturesForSection(constr.getSectionIndex())) {
                obsRate += sol.getRateForRup(rupID) * paleoProbModel.getProbPaleoVisible(rupSet, rupID, constr.getSectionIndex());
            }
            line.add("" + obsRate);
            csv.addLine(line);
        }
        return csv;
    }

    public static void main(String[] args) throws IOException, DocumentException {
        File invDir = new File(UCERF3_DataUtils.DEFAULT_SCRATCH_DATA_DIR, "InversionSolutions");
        File solFile = new File(invDir, "FM3_1_ZENG_EllB_DsrUni_CharConst_M5Rate8.7_MMaxOff7.6_NoFix_SpatSeisU3_VarPaleo10_VarMFDSmooth1000_VarSectNuclMFDWt0.01_sol.zip");
        InversionFaultSystemSolution sol = U3FaultSystemIO.loadInvSol(solFile);
        ArrayList<U3PaleoRateConstraint> paleoRateConstraint = UCERF3_PaleoRateConstraintFetcher.getConstraints(sol.getRupSet().getFaultSectionDataList());
        List<U3AveSlipConstraint> aveSlipConstraints = U3AveSlipConstraint.load(sol.getRupSet().getFaultSectionDataList());
        File plotDir = new File("/tmp/paleo_fault_plots");
        if (!plotDir.exists()) {
            plotDir.mkdir();
        }
        Map<String, List<Integer>> namedFaultsMap = sol.getRupSet().getFaultModel().getNamedFaultsMapAlt();
        CommandLineInversionRunner.writePaleoFaultPlots(paleoRateConstraint, aveSlipConstraints, namedFaultsMap, sol, plotDir);
    }

    public static class AveSlipFakePaleoConstraint
    extends U3PaleoRateConstraint {
        private boolean isMultiple;
        private double origAveSlip;
        private double origAveSlipUpper;
        private double origAveSlipLower;

        public AveSlipFakePaleoConstraint(U3AveSlipConstraint aveSlip, int sectIndex, double slipRate) {
            super(aveSlip.name, sectIndex, aveSlip.sectionName, aveSlip.dataLocation, slipRate / aveSlip.getWeightedMean(), new Uncertainty(UncertaintyBoundType.TWO_SIGMA.estimateStdDev(slipRate / aveSlip.estimateUncertaintyBounds((UncertaintyBoundType)UncertaintyBoundType.TWO_SIGMA).upperBound, slipRate / aveSlip.estimateUncertaintyBounds((UncertaintyBoundType)UncertaintyBoundType.TWO_SIGMA).lowerBound)));
            this.isMultiple = false;
            this.origAveSlip = aveSlip.getWeightedMean();
            this.origAveSlipLower = aveSlip.getLowerUncertaintyBound();
            this.origAveSlipUpper = aveSlip.getUpperUncertaintyBound();
        }

        public AveSlipFakePaleoConstraint(U3AveSlipConstraint aveSlip, int sectIndex, double[] slipRates, double[] weights) {
            super(aveSlip.name, sectIndex, aveSlip.sectionName, aveSlip.dataLocation, U3FaultSystemSolutionFetcher.calcScaledAverage(slipRates, weights) / aveSlip.getWeightedMean(), new Uncertainty(UncertaintyBoundType.TWO_SIGMA.estimateStdDev(StatUtils.min((double[])slipRates) / aveSlip.estimateUncertaintyBounds((UncertaintyBoundType)UncertaintyBoundType.TWO_SIGMA).upperBound, StatUtils.max((double[])slipRates) / aveSlip.estimateUncertaintyBounds((UncertaintyBoundType)UncertaintyBoundType.TWO_SIGMA).lowerBound)));
            this.isMultiple = true;
            this.origAveSlip = aveSlip.getWeightedMean();
            this.origAveSlipLower = aveSlip.getLowerUncertaintyBound();
            this.origAveSlipUpper = aveSlip.getUpperUncertaintyBound();
        }
    }

    public static class DataForPaleoFaultPlots
    implements Serializable {
        private Map<Integer, double[]> origSlipsMap = Maps.newHashMap();
        private Map<Integer, double[]> targetSlipsMap = Maps.newHashMap();
        private Map<Integer, double[]> solSlipsMap = Maps.newHashMap();
        private Map<Integer, double[]> paleoRatesMap = Maps.newHashMap();
        private Map<Integer, double[]> origRatesMap = Maps.newHashMap();
        private Map<Integer, double[]> aveSlipRatesMap = Maps.newHashMap();
        private Map<Integer, double[]> aveSlipsMap = Maps.newHashMap();
        private Map<Integer, double[]> avePaleoSlipsMap = Maps.newHashMap();
        private List<Map<Integer, double[]>> allArraysList = Lists.newArrayList();
        private double weight;

        private DataForPaleoFaultPlots(double weight) {
            this.allArraysList.add(this.origSlipsMap);
            this.allArraysList.add(this.targetSlipsMap);
            this.allArraysList.add(this.solSlipsMap);
            this.allArraysList.add(this.paleoRatesMap);
            this.allArraysList.add(this.origRatesMap);
            this.allArraysList.add(this.aveSlipRatesMap);
            this.allArraysList.add(this.aveSlipsMap);
            this.allArraysList.add(this.avePaleoSlipsMap);
            this.weight = weight;
        }

        public static DataForPaleoFaultPlots build(U3SlipEnabledSolution sol, Map<String, List<Integer>> namedFaultsMap, Map<String, List<U3PaleoRateConstraint>> namedFaultConstraintsMap, Map<Integer, List<FaultSection>> allParentsMap, PaleoProbabilityModel paleoProbModel, double weight) {
            return DataForPaleoFaultPlots.build(sol, namedFaultsMap, namedFaultConstraintsMap, allParentsMap, paleoProbModel, weight, null, null);
        }

        public static DataForPaleoFaultPlots build(U3SlipEnabledSolution sol, Map<String, List<Integer>> namedFaultsMap, Map<String, List<U3PaleoRateConstraint>> namedFaultConstraintsMap, Map<Integer, List<FaultSection>> allParentsMap, PaleoProbabilityModel paleoProbModel, double weight, double[] aveSlipsData, double[] aveSlipsPaleoObsData) {
            DataForPaleoFaultPlots data = new DataForPaleoFaultPlots(weight);
            Stopwatch watch = Stopwatch.createUnstarted();
            Stopwatch paleoWatch = Stopwatch.createUnstarted();
            Stopwatch slipsWatch = Stopwatch.createUnstarted();
            Stopwatch aveSlipsWatch = Stopwatch.createUnstarted();
            watch.start();
            for (String name : namedFaultConstraintsMap.keySet()) {
                List<Integer> parentIDs = namedFaultsMap.get(name);
                for (Integer parentID : parentIDs) {
                    List<FaultSection> sects = allParentsMap.get(parentID);
                    int numSects = sects.size();
                    double[] origSlips = new double[numSects];
                    double[] targetSlips = new double[numSects];
                    double[] solSlips = new double[numSects];
                    double[] paleoRates = new double[numSects];
                    double[] origRates = new double[numSects];
                    double[] aveSlipRates = new double[numSects];
                    double[] aveSlips = new double[numSects];
                    double[] avePaleoSlips = new double[numSects];
                    for (int s = 0; s < numSects; ++s) {
                        FaultSection sect = sects.get(s);
                        int mySectID = sect.getSectionId();
                        paleoWatch.start();
                        paleoRates[s] = PaleoFitPlotter.getPaleoRateForSect(sol, mySectID, paleoProbModel);
                        origRates[s] = PaleoFitPlotter.getPaleoRateForSect(sol, mySectID, null);
                        aveSlipRates[s] = PaleoFitPlotter.getAveSlipProbRateForSect(sol, mySectID);
                        paleoWatch.stop();
                        slipsWatch.start();
                        origSlips[s] = sect.getOrigAveSlipRate();
                        targetSlips[s] = sol.getRupSet().getSlipRateForSection(sect.getSectionId()) * 1000.0;
                        solSlips[s] = sol.calcSlipRateForSect(sect.getSectionId()) * 1000.0;
                        slipsWatch.stop();
                        aveSlipsWatch.start();
                        if (aveSlipsData == null) {
                            aveSlips[s] = sol.calcSlipPFD_ForSect(sect.getSectionId()).getMean();
                            avePaleoSlips[s] = sol.calcPaleoObsSlipPFD_ForSect(sect.getSectionId()).getMean();
                        } else {
                            aveSlips[s] = aveSlipsData[sect.getSectionId()];
                            avePaleoSlips[s] = aveSlipsPaleoObsData[sect.getSectionId()];
                        }
                        aveSlipsWatch.stop();
                    }
                    data.origSlipsMap.put(parentID, origSlips);
                    data.targetSlipsMap.put(parentID, targetSlips);
                    data.solSlipsMap.put(parentID, solSlips);
                    data.paleoRatesMap.put(parentID, paleoRates);
                    data.origRatesMap.put(parentID, origRates);
                    data.aveSlipRatesMap.put(parentID, aveSlipRates);
                    data.aveSlipsMap.put(parentID, aveSlips);
                    data.avePaleoSlipsMap.put(parentID, avePaleoSlips);
                }
            }
            watch.stop();
            System.out.println("Calc Times:\ttotal=" + watch.elapsed(TimeUnit.SECONDS) + "\tpaleo=" + paleoWatch.elapsed(TimeUnit.SECONDS) + "\tslip=" + slipsWatch.elapsed(TimeUnit.SECONDS) + "\taveSlip=" + aveSlipsWatch.elapsed(TimeUnit.SECONDS));
            return data;
        }
    }
}

