/*
 * Decompiled with CFR 0.152.
 */
package scratch.kevin.simulators.erf;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.opensha.commons.data.function.HistogramFunction;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationUtils;
import org.opensha.commons.geo.Region;
import org.opensha.commons.util.DataUtils;
import org.opensha.commons.util.FaultUtils;
import org.opensha.commons.util.IDPairing;
import org.opensha.refFaultParamDb.vo.FaultSectionPrefData;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemSolution;
import org.opensha.sha.faultSurface.FaultSection;
import org.opensha.sha.simulators.EventRecord;
import org.opensha.sha.simulators.SimulatorElement;
import org.opensha.sha.simulators.SimulatorEvent;
import org.opensha.sha.simulators.iden.ElementMagRangeDescription;
import org.opensha.sha.simulators.iden.EventsInWindowsMatcher;
import org.opensha.sha.simulators.iden.RuptureIdentifier;
import org.opensha.sha.simulators.parsers.EQSIMv06FileReader;
import org.opensha.sha.simulators.utils.General_EQSIM_Tools;
import org.opensha.sha.simulators.utils.SimulatorUtils;
import scratch.kevin.simulators.erf.SubSectionBiulder;

public class SimulatorFaultSystemSolution
extends FaultSystemSolution {
    private List<? extends SimulatorEvent> events;
    private SubSectionBiulder subSectBuilder;
    private static final Joiner j = Joiner.on((String)"_");

    public static SimulatorFaultSystemSolution build(List<SimulatorElement> elements, List<? extends SimulatorEvent> events, double durationYears) {
        SubSectionBiulder subSectBuilder = new SubSectionBiulder(elements);
        return SimulatorFaultSystemSolution.build(subSectBuilder, events, durationYears);
    }

    public static SimulatorFaultSystemSolution build(SubSectionBiulder subSectBuilder, List<? extends SimulatorEvent> events, double durationYears) {
        FaultSystemRupSet rupSet = SimulatorFaultSystemSolution.buildRupSet(subSectBuilder.getElements(), events, durationYears, subSectBuilder);
        return new SimulatorFaultSystemSolution(rupSet, subSectBuilder, events, durationYears);
    }

    SimulatorFaultSystemSolution(FaultSystemRupSet rupSet, SubSectionBiulder subSectBuilder, List<? extends SimulatorEvent> events, double durationYears) {
        super(rupSet, SimulatorFaultSystemSolution.buildRates(rupSet.getNumRuptures(), durationYears));
        this.events = events;
        this.subSectBuilder = subSectBuilder;
    }

    public List<double[]> getSlipAlongRupVals(boolean max) {
        ArrayList vals = Lists.newArrayList();
        FaultSystemRupSet rupSet = this.getRupSet();
        Map<Integer, Integer> elemToSubMap = this.subSectBuilder.getElemIDToSubSectsMap();
        Preconditions.checkState((this.events.size() == rupSet.getNumRuptures() ? 1 : 0) != 0);
        for (int i = 0; i < this.events.size(); ++i) {
            List<Integer> inds = rupSet.getSectionsIndicesForRup(i);
            ArrayList elemMappedSlips = Lists.newArrayList();
            for (int j = 0; j < inds.size(); ++j) {
                elemMappedSlips.add(new ArrayList());
            }
            SimulatorEvent e = this.events.get(i);
            int[] elemIDs = e.getAllElementIDs();
            double[] elemSlips = e.getAllElementSlips();
            for (int j = 0; j < e.getNumElements(); ++j) {
                int mappedIndex = elemToSubMap.get(elemIDs[j]);
                double slip = elemSlips[j];
                int ind = inds.indexOf(mappedIndex);
                ((List)elemMappedSlips.get(ind)).add(slip);
            }
            double[] slips = new double[inds.size()];
            for (int j = 0; j < slips.length; ++j) {
                Iterator iterator;
                List sectSlips = (List)elemMappedSlips.get(j);
                if (sectSlips.isEmpty()) {
                    slips[j] = 0.0;
                    continue;
                }
                if (max) {
                    iterator = sectSlips.iterator();
                    while (iterator.hasNext()) {
                        double slip = (Double)iterator.next();
                        slips[j] = Math.max(slip, slips[j]);
                    }
                    continue;
                }
                iterator = sectSlips.iterator();
                while (iterator.hasNext()) {
                    double slip = (Double)iterator.next();
                    int n = j;
                    slips[n] = slips[n] + slip;
                }
                int n = j;
                slips[n] = slips[n] / (double)sectSlips.size();
            }
            vals.add(slips);
        }
        return vals;
    }

    static FaultSystemRupSet buildRupSet(List<SimulatorElement> elements, List<SimulatorEvent> events, double durationYears) {
        System.out.print("Building FSD...");
        SubSectionBiulder subSectBuilder = new SubSectionBiulder(elements);
        return SimulatorFaultSystemSolution.buildRupSet(elements, events, durationYears, subSectBuilder);
    }

    static FaultSystemRupSet buildRupSet(List<SimulatorElement> elements, List<? extends SimulatorEvent> events, double durationYears, SubSectionBiulder subSectBuilder) {
        List<FaultSectionPrefData> fsd = subSectBuilder.getSubSectsList();
        Map<Integer, Integer> elemIDsMap = subSectBuilder.getElemIDToSubSectsMap();
        System.out.println("DONE.");
        double[] mags = new double[events.size()];
        double[] rupRakes = new double[events.size()];
        double[] rupAreas = new double[events.size()];
        double[] rupLengths = new double[events.size()];
        ArrayList sectionForRups = Lists.newArrayList();
        Comparator<FaultSection> fsdIndexSorter = new Comparator<FaultSection>(){

            @Override
            public int compare(FaultSection o1, FaultSection o2) {
                return Integer.valueOf(o1.getSectionId()).compareTo(o2.getSectionId());
            }
        };
        HashMap distsCache = Maps.newHashMap();
        System.out.print("Building ruptures...");
        for (int i = 0; i < events.size(); ++i) {
            SimulatorEvent e = events.get(i);
            mags[i] = e.getMagnitude();
            rupAreas[i] = e.getArea();
            rupLengths[i] = e.getLength();
            List<Object> subSectsForFaults = Lists.newArrayList();
            for (EventRecord rec : e) {
                ArrayList subSectsForFault = Lists.newArrayList();
                HashSet<FaultSection> hashSet = new HashSet<FaultSection>();
                for (int elemID : rec.getElementIDs()) {
                    Preconditions.checkState((elemIDsMap.get(elemID) != null ? 1 : 0) != 0, (Object)("No mapping for " + (int)elemID + "...map size: " + elemIDsMap.size()));
                    hashSet.add(fsd.get(elemIDsMap.get(elemID)));
                }
                subSectsForFault.addAll(hashSet);
                Collections.sort(subSectsForFault, fsdIndexSorter);
                subSectsForFaults.add(subSectsForFault);
            }
            if (subSectsForFaults.size() > 1) {
                subSectsForFaults = SimulatorFaultSystemSolution.sortRupture(fsd, (List<List<FaultSection>>)subSectsForFaults, distsCache);
            }
            ArrayList rakes = Lists.newArrayList();
            ArrayList rupSectIndexes = Lists.newArrayList();
            for (List list : subSectsForFaults) {
                Object object = list.iterator();
                while (object.hasNext()) {
                    FaultSection subSect = (FaultSection)object.next();
                    rupSectIndexes.add(subSect.getSectionId());
                    rakes.add(subSect.getAveRake());
                }
            }
            sectionForRups.add(rupSectIndexes);
            double avgRake = FaultUtils.getAngleAverage(rakes);
            if (avgRake > 180.0) {
                avgRake -= 360.0;
            }
            rupRakes[i] = avgRake;
        }
        System.out.println("DONE.");
        String info = "Fault Simulators Solution\n# Elements: " + elements.size() + "\n# Sub Sections: " + fsd.size() + "\n# Events/Rups: " + events.size() + "\nDuration: " + durationYears + "\nIndv. Rup Rate: " + 1.0 / durationYears;
        FaultSystemRupSet rupSet = new FaultSystemRupSet(fsd, sectionForRups, mags, rupRakes, rupAreas, rupLengths);
        rupSet.setInfoString(info);
        return rupSet;
    }

    private static double[] buildRates(int num, double durationYears) {
        double rupRate = 1.0 / durationYears;
        double[] rates = new double[num];
        for (int i = 0; i < num; ++i) {
            rates[i] = rupRate;
        }
        return rates;
    }

    private static double calcDistance(List<? extends FaultSection> fsd, IDPairing pairing, Map<IDPairing, Double> distsCache) {
        Double cachedDist = distsCache.get(pairing);
        if (cachedDist != null) {
            return cachedDist;
        }
        double minDist = Double.POSITIVE_INFINITY;
        for (Location loc1 : fsd.get(pairing.getID1()).getFaultTrace()) {
            for (Location loc2 : fsd.get(pairing.getID2()).getFaultTrace()) {
                double dist = LocationUtils.horzDistance(loc1, loc2);
                if (!(dist < minDist)) continue;
                minDist = dist;
            }
        }
        distsCache.put(pairing, minDist);
        distsCache.put(pairing.getReversed(), minDist);
        return minDist;
    }

    public static List<List<FaultSection>> sortRupture(List<? extends FaultSection> fsd, List<List<FaultSection>> subSectsForFaults, Map<IDPairing, Double> distsCache) {
        return SimulatorFaultSystemSolution.sortRupture(fsd, subSectsForFaults, distsCache, null);
    }

    public static List<List<FaultSection>> sortRupture(List<? extends FaultSection> fsd, List<List<FaultSection>> subSectsForFaults, Map<IDPairing, Double> distsCache, Collection<FaultSection> reversedSections) {
        double isolatedMaxDist = 0.0;
        int isolatedFaultIndex = -1;
        boolean isolatedFaultStart = false;
        HashSet<Integer> parents = new HashSet<Integer>();
        for (int i = 0; i < subSectsForFaults.size(); ++i) {
            List<FaultSection> subSects = subSectsForFaults.get(i);
            int parent = subSects.get(0).getParentSectionId();
            for (int j = 1; j < subSects.size(); ++j) {
                Preconditions.checkState((parent == subSects.get(j).getParentSectionId() ? 1 : 0) != 0);
            }
            Preconditions.checkState((!parents.contains(parent) ? 1 : 0) != 0);
            parents.add(parent);
        }
        for (int j = 0; j < subSectsForFaults.size(); ++j) {
            List<FaultSection> subSects1 = subSectsForFaults.get(j);
            int startID1 = subSects1.get(0).getSectionId();
            int endID1 = subSects1.get(subSects1.size() - 1).getSectionId();
            for (int k = 0; k < subSectsForFaults.size(); ++k) {
                double endEndDist;
                double endStartDist;
                double startEndDist;
                if (j == k) continue;
                List<FaultSection> subSects2 = subSectsForFaults.get(k);
                int startID2 = subSects2.get(0).getSectionId();
                int endID2 = subSects2.get(subSects2.size() - 1).getSectionId();
                double startStartDist = SimulatorFaultSystemSolution.calcDistance(fsd, new IDPairing(startID1, startID2), distsCache);
                if (startStartDist > isolatedMaxDist) {
                    isolatedMaxDist = startStartDist;
                    isolatedFaultIndex = j;
                    isolatedFaultStart = true;
                }
                if ((startEndDist = SimulatorFaultSystemSolution.calcDistance(fsd, new IDPairing(startID1, endID2), distsCache)) > isolatedMaxDist) {
                    isolatedMaxDist = startEndDist;
                    isolatedFaultIndex = j;
                    isolatedFaultStart = true;
                }
                if ((endStartDist = SimulatorFaultSystemSolution.calcDistance(fsd, new IDPairing(endID1, startID2), distsCache)) > isolatedMaxDist) {
                    isolatedMaxDist = endStartDist;
                    isolatedFaultIndex = j;
                    isolatedFaultStart = false;
                }
                if (!((endEndDist = SimulatorFaultSystemSolution.calcDistance(fsd, new IDPairing(endID1, endID2), distsCache)) > isolatedMaxDist)) continue;
                isolatedMaxDist = endEndDist;
                isolatedFaultIndex = j;
                isolatedFaultStart = false;
            }
        }
        if (isolatedFaultIndex < 0) {
            isolatedFaultIndex = 0;
            isolatedFaultStart = true;
        }
        ArrayList sortedFaults = Lists.newArrayList();
        List<FaultSection> curFault = subSectsForFaults.remove(isolatedFaultIndex);
        if (!isolatedFaultStart) {
            Collections.reverse(curFault);
            if (reversedSections != null) {
                reversedSections.addAll(curFault);
            }
        }
        sortedFaults.add(curFault);
        int curEndID = curFault.get(0).getSectionId();
        while (!subSectsForFaults.isEmpty()) {
            double minDist = Double.POSITIVE_INFINITY;
            int closestFaultIndex = -1;
            boolean closestAtStart = false;
            for (int i = 0; i < subSectsForFaults.size(); ++i) {
                List<FaultSection> faultSects = subSectsForFaults.get(i);
                double startDist = SimulatorFaultSystemSolution.calcDistance(fsd, new IDPairing(curEndID, faultSects.get(0).getSectionId()), distsCache);
                double endDist = SimulatorFaultSystemSolution.calcDistance(fsd, new IDPairing(curEndID, faultSects.get(faultSects.size() - 1).getSectionId()), distsCache);
                if (startDist < minDist) {
                    minDist = startDist;
                    closestFaultIndex = i;
                    closestAtStart = true;
                }
                if (!(endDist < minDist)) continue;
                minDist = endDist;
                closestFaultIndex = i;
                closestAtStart = false;
            }
            curFault = subSectsForFaults.remove(closestFaultIndex);
            if (!closestAtStart) {
                Collections.reverse(curFault);
                if (reversedSections != null) {
                    reversedSections.addAll(curFault);
                }
            }
            sortedFaults.add(curFault);
            curEndID = curFault.get(0).getSectionId();
        }
        return sortedFaults;
    }

    public static void main(String[] args) throws IOException {
        File dir = new File("/home/kevin/Simulators");
        File geomFile = new File(dir, "ALLCAL2_1-7-11_Geometry.dat");
        System.out.println("Loading geometry...");
        General_EQSIM_Tools tools = new General_EQSIM_Tools(geomFile);
        File eventFile = new File(dir, "eqs.ALLCAL2_RSQSim_sigma0.5-5_b=0.015.long.barall");
        System.out.println("Loading events...");
        List<SimulatorEvent> events = EQSIMv06FileReader.readEventsFile(eventFile, tools.getElementsList());
        double durationYears = SimulatorUtils.getSimulationDurationYears(events);
        Region region = null;
        ElementMagRangeDescription cholameIden = new ElementMagRangeDescription("SAF Cholame 7+", 966, 7.0, 10.0);
        ElementMagRangeDescription carrizoIden = new ElementMagRangeDescription("SAF Carrizo 7+", 1026, 7.0, 10.0);
        ElementMagRangeDescription mojaveIden = new ElementMagRangeDescription("SAF Mojave 7+", 1246, 7.0, 10.0);
        ElementMagRangeDescription coachellaIden = new ElementMagRangeDescription("SAF Coachella 7+", 1602, 7.0, 10.0);
        ElementMagRangeDescription mojaveCoachellCorupture = new ElementMagRangeDescription("SAF Mojave/Coachella Corupture 7+", 6.0, 10.0, 1246, 1602);
        double quietYears = 156.0;
        double forecastYears = 30.0;
        RuptureIdentifier rupIden = null;
        if (rupIden != null) {
            EventsInWindowsMatcher matcher = new EventsInWindowsMatcher(events, rupIden, quietYears, quietYears + forecastYears, false);
            events = matcher.getEventsInWindows();
            durationYears = matcher.getTotalWindowDurationYears();
            System.out.println("New duration: " + durationYears + " (" + events.size() + " events in " + matcher.getMatchIDs().size() + " matches)");
        }
        if (region != null) {
            HashMap elementsInRegionsCache = Maps.newHashMap();
            for (SimulatorElement simulatorElement : tools.getElementsList()) {
                elementsInRegionsCache.put(simulatorElement.getID(), region.contains(simulatorElement.getCenterLocation()));
            }
            ArrayList eventsInRegion = Lists.newArrayList();
            block1: for (SimulatorEvent e : events) {
                for (int elemID : e.getAllElementIDs()) {
                    if (!((Boolean)elementsInRegionsCache.get(elemID)).booleanValue()) continue;
                    eventsInRegion.add(e);
                    continue block1;
                }
            }
            System.out.println(eventsInRegion.size() + "/" + events.size() + " events in region: " + region.getName());
            events = eventsInRegion;
        }
        SimulatorFaultSystemSolution fss = SimulatorFaultSystemSolution.build(tools.getElementsList(), events, durationYears);
        System.out.println(fss.getInfoString());
        HashMap rupCounts = Maps.newHashMap();
        FaultSystemRupSet faultSystemRupSet = fss.getRupSet();
        for (int r = 0; r < faultSystemRupSet.getNumRuptures(); ++r) {
            String key = SimulatorFaultSystemSolution.uniqueRupHash(faultSystemRupSet.getSectionsIndicesForRup(r));
            Integer count = (Integer)rupCounts.get(key);
            if (count == null) {
                count = 0;
            }
            count = count + 1;
            rupCounts.put(key, count);
        }
        DataUtils.MinMaxAveTracker track = new DataUtils.MinMaxAveTracker();
        HistogramFunction hist = new HistogramFunction(1.0, 10, 1.0);
        int tot = 0;
        for (String key : rupCounts.keySet()) {
            int count = (Integer)rupCounts.get(key);
            tot += count;
            track.addValue(count);
            hist.add(hist.getClosestXIndex(count), 1.0);
        }
        System.out.println(rupCounts.size() + "/" + tot + " unique rupture");
        System.out.println(track);
        System.out.println(hist);
    }

    private static String uniqueRupHash(List<Integer> sects) {
        sects = Lists.newArrayList(sects);
        Collections.sort(sects);
        return j.join((Iterable)sects);
    }
}

