/*
 * Decompiled with CFR 0.152.
 */
package scratch.kevin.simulators.erf;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.math3.stat.StatUtils;
import org.opensha.commons.geo.LocationUtils;
import org.opensha.commons.util.DataUtils;
import org.opensha.refFaultParamDb.vo.FaultSectionPrefData;
import org.opensha.sha.earthquake.FocalMechanism;
import org.opensha.sha.faultSurface.EvenlyGriddedSurface;
import org.opensha.sha.faultSurface.FaultTrace;
import org.opensha.sha.faultSurface.FourPointEvenlyGriddedSurface;
import org.opensha.sha.simulators.RectangularElement;
import org.opensha.sha.simulators.SimulatorElement;
import org.opensha.sha.simulators.utils.General_EQSIM_Tools;

public class SubSectionBiulder {
    private List<SimulatorElement> elements;
    private List<FaultSectionPrefData> subSectsList;
    private Map<Integer, Integer> elemIDToSubSectsMap;
    private static AlongStrikeComparator alongStrikeComparator = new AlongStrikeComparator();
    private static DownDipComparator downDipComparator = new DownDipComparator();

    public SubSectionBiulder(List<SimulatorElement> elements) {
        this.elements = elements;
        HashMap sectsMap = Maps.newHashMap();
        for (SimulatorElement e : elements) {
            List elemsForSect = (List)sectsMap.get(e.getSectionID());
            if (elemsForSect == null) {
                elemsForSect = Lists.newArrayList();
                sectsMap.put(e.getSectionID(), elemsForSect);
            }
            Preconditions.checkState((boolean)(e instanceof RectangularElement), (Object)"Only rectangular supported (for now)");
            elemsForSect.add((RectangularElement)e);
        }
        SubSectionBiulder.checkAssignNAS(sectsMap);
        this.subSectsList = Lists.newArrayList();
        this.elemIDToSubSectsMap = Maps.newHashMap();
        int sectIndex = 0;
        for (Integer sectID : sectsMap.keySet()) {
            List elemsForSect = (List)sectsMap.get(sectID);
            String sectName = ((RectangularElement)elemsForSect.get(0)).getSectionName();
            List<List<RectangularElement>> organized = SubSectionBiulder.organizeElemsIntoColumns(elemsForSect);
            int subSectIndex = 0;
            for (List<RectangularElement> column : organized) {
                String subSectName = sectName + ", Subsection " + subSectIndex++;
                RectangularElement top = column.get(0);
                RectangularElement bottom = column.get(column.size() - 1);
                FocalMechanism mech = top.getFocalMechanism();
                double[] dips = new double[column.size()];
                for (int i = 0; i < column.size(); ++i) {
                    dips[i] = column.get(i).getFocalMechanism().getDip();
                }
                double avgDip = Math.abs(StatUtils.mean((double[])dips));
                double dipDir = LocationUtils.azimuth(top.getCenterLocation(), bottom.getCenterLocation());
                double upperDepth = SubSectionBiulder.getMinDepth(top.getSurface());
                double lowerDepth = SubSectionBiulder.getMaxDepth(bottom.getSurface());
                FaultTrace trace = new FaultTrace(subSectName);
                trace.addAll(top.getSurface().getRowAsTrace(0));
                FaultSectionPrefData fsd = new FaultSectionPrefData();
                fsd.setSectionId(sectIndex);
                fsd.setSectionName(subSectName);
                fsd.setShortName(subSectName);
                fsd.setAveSlipRate(top.getSlipRate());
                fsd.setAveDip(avgDip);
                fsd.setAveRake(mech.getRake());
                fsd.setAveUpperDepth(upperDepth);
                fsd.setAveLowerDepth(lowerDepth);
                fsd.setConnector(false);
                fsd.setAseismicSlipFactor(top.getAseisFactor());
                fsd.setFaultTrace(trace);
                fsd.setDipDirection((float)dipDir);
                fsd.setParentSectionName(sectName);
                fsd.setParentSectionId(sectID);
                this.subSectsList.add(fsd);
                for (SimulatorElement simulatorElement : column) {
                    this.elemIDToSubSectsMap.put(simulatorElement.getID(), sectIndex);
                }
                Preconditions.checkState((++sectIndex == this.subSectsList.size() ? 1 : 0) != 0);
            }
        }
    }

    public List<SimulatorElement> getElements() {
        return this.elements;
    }

    public List<FaultSectionPrefData> getSubSectsList() {
        return this.subSectsList;
    }

    public Map<Integer, Integer> getElemIDToSubSectsMap() {
        return this.elemIDToSubSectsMap;
    }

    private static double getMinDepth(EvenlyGriddedSurface surf) {
        return SubSectionBiulder.getAveDepth(surf, 0);
    }

    private static double getMaxDepth(EvenlyGriddedSurface surf) {
        return SubSectionBiulder.getAveDepth(surf, surf.getNumRows() - 1);
    }

    private static double getAveDepth(EvenlyGriddedSurface surf, int row) {
        double[] vals = new double[surf.getNumCols()];
        for (int i = 0; i < vals.length; ++i) {
            vals[i] = surf.getLocation(row, i).getDepth();
        }
        return StatUtils.mean((double[])vals);
    }

    private static List<List<RectangularElement>> organizeElemsIntoColumns(Collection<RectangularElement> elementsForFault) {
        ArrayList sortedAlongStrike = Lists.newArrayList(elementsForFault);
        Collections.sort(sortedAlongStrike, alongStrikeComparator);
        ArrayList organized = Lists.newArrayList();
        int curAlongStrike = -1;
        List curAlongStrikeList = null;
        for (RectangularElement elem : sortedAlongStrike) {
            Preconditions.checkState((elem.getNumAlongStrike() >= 0 ? 1 : 0) != 0, (Object)("Uh oh, NAS: " + elem.getNumAlongStrike()));
            if (curAlongStrike != elem.getNumAlongStrike()) {
                if (curAlongStrikeList != null) {
                    Collections.sort(curAlongStrikeList, downDipComparator);
                    for (int i = 1; i < curAlongStrikeList.size(); ++i) {
                        Preconditions.checkState((((RectangularElement)curAlongStrikeList.get(i - 1)).getNumDownDip() == ((RectangularElement)curAlongStrikeList.get(i)).getNumDownDip() - 1 ? 1 : 0) != 0);
                    }
                    organized.add(curAlongStrikeList);
                }
                curAlongStrikeList = Lists.newArrayList();
                if (curAlongStrike == -1) {
                    Preconditions.checkState((elem.getNumAlongStrike() == 0 ? 1 : 0) != 0);
                } else {
                    Preconditions.checkState((elem.getNumAlongStrike() == curAlongStrike + 1 ? 1 : 0) != 0);
                }
                curAlongStrike = elem.getNumAlongStrike();
            }
            curAlongStrikeList.add(elem);
        }
        if (!curAlongStrikeList.isEmpty()) {
            organized.add(curAlongStrikeList);
        }
        return organized;
    }

    private static void checkAssignNAS(Map<Integer, List<RectangularElement>> sectsMap) {
        DASComparator dasCompare = new DASComparator();
        for (Integer sectID : sectsMap.keySet()) {
            int i;
            List<RectangularElement> elems = sectsMap.get(sectID);
            if (elems.get(0).getNumAlongStrike() >= 0) continue;
            FourPointEvenlyGriddedSurface surf = elems.get(0).getSurface();
            double elemDeltaDepth = surf.getLocation(1, 0).getDepth() - surf.getLocation(0, 0).getDepth();
            DataUtils.MinMaxAveTracker depthTrack = new DataUtils.MinMaxAveTracker();
            for (SimulatorElement simulatorElement : elems) {
                depthTrack.addValue(simulatorElement.getCenterLocation().getDepth());
            }
            double minDepth = depthTrack.getMin();
            double maxDepth = depthTrack.getMax();
            double deltaDepth = maxDepth - minDepth;
            double numElemsNoRound = deltaDepth / elemDeltaDepth + 1.0;
            int numElemsDD = (int)(numElemsNoRound + 0.5);
            double depthError = numElemsNoRound - Math.floor(numElemsNoRound);
            if (depthError > 0.5) {
                depthError = 1.0 - depthError;
            }
            Preconditions.checkState((depthError < 0.1 ? 1 : 0) != 0, (Object)("DDW error too big, may be unstable: min=" + minDepth + ", max=" + maxDepth + ", delta=" + deltaDepth + ", elemDelta=" + elemDeltaDepth + ", numElems=" + numElemsNoRound));
            ArrayList elemsByDepth = Lists.newArrayList();
            for (i = 0; i < numElemsDD; ++i) {
                elemsByDepth.add(new ArrayList());
            }
            for (SimulatorElement simulatorElement : elems) {
                double depth = simulatorElement.getCenterLocation().getDepth();
                double depthIndexNoRound = (depth - minDepth) / elemDeltaDepth;
                double depthIndexError = depthIndexNoRound - Math.floor(depthIndexNoRound);
                if (depthIndexError > 0.5) {
                    depthIndexError = 1.0 - depthIndexError;
                }
                Preconditions.checkState((depthIndexError < 0.1 ? 1 : 0) != 0, (Object)("DDW depth for elem too big, may be unstable: min=" + minDepth + ", max=" + maxDepth + ", depth=" + deltaDepth + ", elemDelta=" + elemDeltaDepth + ", depthIndexNoRound=" + depthIndexNoRound));
                int depthIndex = (int)(depthIndexNoRound + 0.5);
                ((List)elemsByDepth.get(depthIndex)).add(simulatorElement);
            }
            for (i = 1; i < elemsByDepth.size(); ++i) {
                Preconditions.checkState((((List)elemsByDepth.get(i - 1)).size() == ((List)elemsByDepth.get(i)).size() ? 1 : 0) != 0, (Object)"Error binning by depth");
            }
            for (i = 0; i < elemsByDepth.size(); ++i) {
                List list = (List)elemsByDepth.get(i);
                Collections.sort(list, dasCompare);
                for (int j = 0; j < list.size(); ++j) {
                    SimulatorElement elem = (SimulatorElement)list.get(j);
                    elem.setNumAlongStrike(j);
                    elem.setNumDownDip(i);
                }
            }
        }
    }

    public static void main(String[] args) throws IOException {
        File dir = new File("/home/kevin/Simulators");
        File geomFile = new File(dir, "ALLCAL2_1-7-11_Geometry.dat");
        System.out.println("Loading geometry...");
        General_EQSIM_Tools tools = new General_EQSIM_Tools(geomFile);
        SubSectionBiulder builder = new SubSectionBiulder(tools.getElementsList());
        System.out.println("Elems: " + tools.getElementsList().size());
        System.out.println("Sub Sects: " + builder.getSubSectsList().size());
        System.out.println("Mappings: " + builder.getElemIDToSubSectsMap().size());
    }

    private static class AlongStrikeComparator
    implements Comparator<SimulatorElement> {
        private AlongStrikeComparator() {
        }

        @Override
        public int compare(SimulatorElement o1, SimulatorElement o2) {
            return Integer.valueOf(o1.getNumAlongStrike()).compareTo(o2.getNumAlongStrike());
        }
    }

    private static class DownDipComparator
    implements Comparator<SimulatorElement> {
        private DownDipComparator() {
        }

        @Override
        public int compare(SimulatorElement o1, SimulatorElement o2) {
            return Integer.valueOf(o1.getNumDownDip()).compareTo(o2.getNumDownDip());
        }
    }

    private static class DASComparator
    implements Comparator<SimulatorElement> {
        private DASComparator() {
        }

        @Override
        public int compare(SimulatorElement o1, SimulatorElement o2) {
            return Double.compare(o1.getAveDAS(), o2.getAveDAS());
        }
    }
}

