/*
 * Decompiled with CFR 0.152.
 */
package scratch.kevin.ucerf3;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipException;
import org.dom4j.DocumentException;
import org.opensha.commons.data.function.EvenlyDiscretizedFunc;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.faultSurface.FaultSection;
import scratch.UCERF3.U3FaultSystemRupSet;
import scratch.UCERF3.erf.mean.RuptureCombiner;
import scratch.UCERF3.utils.U3FaultSystemIO;

public class RupSetDownsampler {
    private FaultSystemRupSet rupSet;
    private double deltaMag;
    private Map<String, List<Integer>> parentSectsToRupsMap;
    private HashSet<Integer> rupsToKeep;
    private static Joiner keyJoin = Joiner.on((String)"_");

    public RupSetDownsampler(FaultSystemRupSet rupSet, double deltaMag) {
        this.rupSet = rupSet;
        this.deltaMag = deltaMag;
    }

    private void initParentSectsToRupsMap() {
        this.parentSectsToRupsMap = Maps.newHashMap();
        for (int r = 0; r < this.rupSet.getNumRuptures(); ++r) {
            String key = this.getParentsKey(r);
            ArrayList rups = this.parentSectsToRupsMap.get(key);
            if (rups == null) {
                rups = Lists.newArrayList();
                this.parentSectsToRupsMap.put(key, rups);
            }
            rups.add(r);
        }
    }

    private String getParentsKey(int rupIndex) {
        ArrayList parents = Lists.newArrayList(this.rupSet.getParentSectionsForRup(rupIndex));
        Collections.sort(parents);
        return keyJoin.join((Iterable)parents);
    }

    public void calculate() {
        this.initParentSectsToRupsMap();
        int numMag = (int)(4.0 / this.deltaMag + 0.5);
        EvenlyDiscretizedFunc magFunc = new EvenlyDiscretizedFunc(5.0, numMag, this.deltaMag);
        this.rupsToKeep = new HashSet();
        for (int sectIndex = 0; sectIndex < this.rupSet.getNumSections(); ++sectIndex) {
            if (sectIndex % 100 == 0) {
                System.out.println("Processing section " + sectIndex + "/" + this.rupSet.getNumSections() + ". " + this.rupsToKeep.size() + "/" + this.rupSet.getNumRuptures() + " rups so far.");
            }
            int parentID = this.rupSet.getFaultSectionData(sectIndex).getParentSectionId();
            List<Integer> rups = this.rupSet.getRupturesForSection(sectIndex);
            for (int r : rups) {
                if (this.rupsToKeep.contains(r)) continue;
                ArrayList sects = this.rupSet.getSectionsIndicesForRup(r);
                if (sects.get(sects.size() - 1) == sectIndex) {
                    sects = Lists.newArrayList(sects);
                    Collections.reverse(sects);
                }
                if ((Integer)sects.get(0) != sectIndex) continue;
                int lastParent = this.rupSet.getFaultSectionData((Integer)sects.get(sects.size() - 1)).getParentSectionId();
                if (lastParent == parentID) {
                    this.rupsToKeep.add(r);
                    continue;
                }
                int sectsOnLastParent = this.getNumSectsOnParent(r, lastParent);
                int maxSectsOnLastParent = 0;
                double myMag = this.rupSet.getMagForRup(r);
                int myMagIndex = magFunc.getClosestXIndex(myMag);
                double myMagDelta = Math.abs(myMag - magFunc.getX(myMagIndex));
                double minOtherMagDelta = Double.POSITIVE_INFINITY;
                int maxMagIndex = -1;
                List<Integer> otherRupsSameParents = this.parentSectsToRupsMap.get(this.getParentsKey(r));
                for (int otherRup : otherRupsSameParents) {
                    int count = this.getNumSectsOnParent(otherRup, lastParent);
                    if (count > maxSectsOnLastParent) {
                        maxSectsOnLastParent = count;
                    }
                    if (otherRup == r) continue;
                    double otherMag = this.rupSet.getMagForRup(otherRup);
                    int otherMagIndex = magFunc.getClosestXIndex(otherMag);
                    if (otherMagIndex > maxMagIndex) {
                        maxMagIndex = otherMagIndex;
                    }
                    double otherMagDelta = Math.abs(otherMag - magFunc.getX(myMagIndex));
                    minOtherMagDelta = Math.min(minOtherMagDelta, otherMagDelta);
                }
                if (sectsOnLastParent == maxSectsOnLastParent) {
                    this.rupsToKeep.add(r);
                    continue;
                }
                if (!(myMagDelta <= minOtherMagDelta) || myMagIndex >= maxMagIndex) continue;
                this.rupsToKeep.add(r);
            }
        }
    }

    private int getNumSectsOnParent(int rupIndex, int parentID) {
        int count = 0;
        for (FaultSection sect : this.rupSet.getFaultSectionDataForRupture(rupIndex)) {
            if (sect.getParentSectionId() != parentID) continue;
            ++count;
        }
        return count;
    }

    public synchronized List<Integer> getRuptures() {
        if (this.rupsToKeep == null) {
            this.calculate();
        }
        ArrayList rups = Lists.newArrayList(this.rupsToKeep);
        Collections.sort(rups);
        return rups;
    }

    public FaultSystemRupSet getDownsampled() {
        List<Integer> rups = this.getRuptures();
        return new RuptureCombiner.SubsetRupSet(this.rupSet, rups);
    }

    public static void main(String[] args) throws ZipException, IOException, DocumentException {
        U3FaultSystemRupSet rupSet = U3FaultSystemIO.loadRupSet(new File("/home/kevin/workspace/OpenSHA/dev/scratch/UCERF3/data/scratch/InversionSolutions/2013_05_10-ucerf3p3-production-10runs_COMPOUND_SOL_FM3_1_MEAN_BRANCH_AVG_SOL.zip"));
        RupSetDownsampler sampler = new RupSetDownsampler(rupSet, 0.05);
        sampler.calculate();
        int orig = rupSet.getNumRuptures();
        int sampled = sampler.rupsToKeep.size();
        double percent = 100.0 * (double)sampled / (double)orig;
        System.out.println("Retained " + sampled + "/" + orig + " ruptures (" + (float)percent + " %)");
        FaultSystemRupSet sampledRupSet = sampler.getDownsampled();
    }
}

