/*
 * Decompiled with CFR 0.152.
 */
package scratch.kevin.ucerf3;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfImportedPage;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfTemplate;
import com.itextpdf.text.pdf.PdfWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.opensha.commons.util.FileNameComparator;

public class TestPDFCombine {
    public static void combine(List<File> inputFiles, File outputFile) throws IOException, DocumentException {
        int num = inputFiles.size();
        Preconditions.checkState((num >= 2 ? 1 : 0) != 0);
        int cols = num == 2 ? 2 : (num >= 7 ? 2 : (num >= 5 ? 3 : 2));
        int rows = 1;
        int numOnCurRow = 0;
        for (int numAccountedFor = 0; numAccountedFor < num; ++numAccountedFor) {
            if (numOnCurRow == cols) {
                numOnCurRow = 0;
                ++rows;
            }
            ++numOnCurRow;
        }
        System.out.println(num + ": " + rows + "x" + cols);
        double scale = 1.0 / (double)rows;
        System.out.println("Scale: " + (scale *= 0.95));
        boolean rotate = false;
        if (cols > 2) {
            rotate = true;
            scale *= 0.8;
        }
        if (num == 2) {
            rotate = true;
            scale *= 0.65;
        }
        TestPDFCombine.combine(inputFiles, outputFile, cols, scale, rotate, 0.0, 0.0);
    }

    public static void combine(List<File> inputFiles, File outputFile, int cols, double scale, boolean rotate, double xMarginBuffFract, double yMarginBuffFract) throws IOException, DocumentException {
        TestPDFCombine.combine(inputFiles, outputFile, cols, scale, rotate, xMarginBuffFract, yMarginBuffFract, 1.05, 0.95);
    }

    public static void combine(List<File> inputFiles, File outputFile, int cols, double scale, boolean rotate, double xMarginBuffFract, double yMarginBuffFract, double xPosMult, double yPosMult) throws IOException, DocumentException {
        int num = inputFiles.size();
        Preconditions.checkState((num >= 2 ? 1 : 0) != 0);
        int rows = 1;
        int numOnCurRow = 0;
        for (int numAccountedFor = 0; numAccountedFor < num; ++numAccountedFor) {
            if (numOnCurRow == cols) {
                numOnCurRow = 0;
                ++rows;
            }
            ++numOnCurRow;
        }
        Rectangle size = PageSize.LETTER;
        if (rotate) {
            size = size.rotate();
        }
        Document doc = new Document(size);
        PdfWriter writer = PdfWriter.getInstance((Document)doc, (OutputStream)new FileOutputStream(outputFile));
        doc.open();
        PdfContentByte cb = writer.getDirectContent();
        int row = 0;
        int col = 0;
        doc.newPage();
        double maxX = size.getWidth();
        double maxY = size.getHeight();
        for (File file : inputFiles) {
            if (col == cols) {
                col = 0;
                ++row;
            }
            System.out.println("Reading " + file.getName());
            PdfReader reader = new PdfReader((InputStream)new FileInputStream(file));
            PdfImportedPage page = writer.getImportedPage(reader, 1);
            int myRow = rows - row - 1;
            double x = maxX * (double)col / (double)cols;
            x *= xPosMult;
            if (cols == 1) {
                x = maxX * 0.25;
            }
            double y = maxY * (double)myRow / (double)rows;
            y *= yPosMult;
            System.out.println("doc at x=" + (x += xMarginBuffFract * maxX) + ", y=" + (y += yMarginBuffFract * maxY));
            cb.addTemplate((PdfTemplate)page, (float)scale, 0.0f, 0.0f, (float)scale, (float)x, (float)y);
            ++col;
        }
        doc.close();
        writer.close();
    }

    public static void combine(File pdfDir, File outputDir) throws IOException, DocumentException {
        if (!outputDir.exists()) {
            outputDir.mkdir();
        }
        HashSet<String> prefixes = new HashSet<String>();
        for (File file : pdfDir.listFiles()) {
            String name = file.getName();
            if (!name.endsWith(".pdf") || !name.contains("_") || name.contains("hist") || name.contains("combined")) continue;
            String prefix = name.substring(0, name.indexOf("_"));
            prefixes.add(prefix);
        }
        for (String prefix : prefixes) {
            ArrayList files = Lists.newArrayList();
            for (File file : pdfDir.listFiles()) {
                String name = file.getName();
                if (!name.endsWith(".pdf") || !name.startsWith(prefix) || name.contains("_hist") || name.contains("diff") || name.contains("combined")) continue;
                files.add(file);
            }
            Collections.sort(files, new FileNameComparator());
            System.out.println("Doing " + prefix);
            TestPDFCombine.combine(files, new File(outputDir, prefix + "_combined.pdf"));
        }
    }

    public static void main(String[] args) throws IOException, DocumentException {
        File rootDir = new File("/home/kevin/OpenSHA/UCERF3/TimeDependent_AVE_ALL/m6.7_30yr/BranchSensitivityMaps");
        File outputDir = new File("/tmp/pdf_combine");
        TestPDFCombine.combine(rootDir, outputDir);
    }
}

