/*
 * Decompiled with CFR 0.152.
 */
package scratch.kevin.ucerf3;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.dom4j.DocumentException;
import org.opensha.commons.util.FaultUtils;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.util.UniqueRupture;
import scratch.UCERF3.U3FaultSystemRupSet;
import scratch.UCERF3.U3FaultSystemSolution;
import scratch.UCERF3.utils.U3FaultSystemIO;

class UniqueRupSetWriter {
    UniqueRupSetWriter() {
    }

    public static void main(String[] args) throws IOException, DocumentException {
        File rupSetsDir = new File("/home/kevin/OpenSHA/UCERF4/rup_sets");
        File solFile = new File(rupSetsDir, "rsqsim_4983_stitched_m6.5_skip65000_sectArea0.5.zip");
        File outFile = new File(rupSetsDir, "rsqsim_4983_stitched_m6.5_skip65000_sectArea0.5_unique.zip");
        U3FaultSystemSolution sol = U3FaultSystemIO.loadSol(solFile);
        U3FaultSystemRupSet rupSet = sol.getRupSet();
        ArrayList<UniqueRupture> uniques = new ArrayList<UniqueRupture>();
        HashMap<UniqueRupture, Integer> uniqueIndexes = new HashMap<UniqueRupture, Integer>();
        ArrayList uniqueMappings = new ArrayList();
        for (int r = 0; r < rupSet.getNumRuptures(); ++r) {
            UniqueRupture unique = UniqueRupture.forIDs(rupSet.getSectionsIndicesForRup(r));
            uniques.add(unique);
            Integer uniqueIndex = (Integer)uniqueIndexes.get(unique);
            if (uniqueIndex == null) {
                uniqueIndex = uniqueIndexes.size();
                uniqueIndexes.put(unique, uniqueIndex);
                uniqueMappings.add(new ArrayList());
            }
            ((List)uniqueMappings.get(uniqueIndex)).add(r);
        }
        System.out.println("Found " + uniqueIndexes.size() + " unique ruptures");
        double[] mags = new double[uniqueMappings.size()];
        double[] rakes = new double[uniqueMappings.size()];
        double[] rupAreas = new double[uniqueMappings.size()];
        double[] rupLengths = null;
        double[] rates = new double[uniqueMappings.size()];
        ArrayList<List<Integer>> sectsList = new ArrayList<List<Integer>>();
        for (int r = 0; r < mags.length; ++r) {
            List myIndexes = (List)uniqueMappings.get(r);
            ArrayList<Double> weights = new ArrayList<Double>();
            ArrayList<Double> myMags = new ArrayList<Double>();
            ArrayList<Double> myRakes = new ArrayList<Double>();
            ArrayList<Double> myAreas = new ArrayList<Double>();
            double sumRate = 0.0;
            Preconditions.checkState((myIndexes.size() > 0 ? 1 : 0) != 0);
            Iterator iterator = myIndexes.iterator();
            while (iterator.hasNext()) {
                int index = (Integer)iterator.next();
                double rate = sol.getRateForRup(index);
                weights.add(rate);
                myMags.add(rupSet.getMagForRup(index));
                myRakes.add(rupSet.getAveRakeForRup(index));
                myAreas.add(rupSet.getAreaForRup(index));
                sumRate += rate;
            }
            mags[r] = UniqueRupSetWriter.weightedAvg(myMags, weights);
            rupAreas[r] = UniqueRupSetWriter.weightedAvg(myAreas, weights);
            rakes[r] = FaultUtils.getInRakeRange(FaultUtils.getScaledAngleAverage(weights, myRakes));
            rates[r] = sumRate;
            sectsList.add(rupSet.getSectionsIndicesForRup((Integer)myIndexes.get(0)));
        }
        U3FaultSystemRupSet modRupSet = new U3FaultSystemRupSet(rupSet.getFaultSectionDataList(), rupSet.getSlipRateForAllSections(), null, rupSet.getAreaForAllSections(), sectsList, mags, rakes, rupAreas, rupLengths, rupSet.getInfoString());
        U3FaultSystemSolution modSol = new U3FaultSystemSolution(modRupSet, rates);
        U3FaultSystemIO.writeSol(modSol, outFile);
    }

    private static double weightedAvg(List<Double> values, List<Double> weights) {
        double ret = 0.0;
        double sumWeight = 0.0;
        for (int i = 0; i < values.size(); ++i) {
            ret += values.get(i) * weights.get(i);
            sumWeight += weights.get(i).doubleValue();
        }
        return ret / sumWeight;
    }
}

