/*
 * Decompiled with CFR 0.152.
 */
package scratch.kevin.ucerf3.etas;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.math3.stat.StatUtils;
import org.dom4j.DocumentException;
import org.opensha.commons.data.region.CaliforniaRegions;
import org.opensha.commons.geo.GriddedRegion;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.Region;
import org.opensha.sha.earthquake.AbstractNthRupERF;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemSolution;
import org.opensha.sha.earthquake.faultSysSolution.modules.MFDGridSourceProvider;
import org.opensha.sha.earthquake.faultSysSolution.modules.SubSeismoOnFaultMFDs;
import org.opensha.sha.earthquake.observedEarthquake.ObsEqkRupList;
import org.opensha.sha.earthquake.observedEarthquake.ObsEqkRupture;
import org.opensha.sha.earthquake.param.ProbabilityModelOptions;
import org.opensha.sha.faultSurface.FaultSection;
import org.opensha.sha.magdist.GutenbergRichterMagFreqDist;
import org.opensha.sha.magdist.IncrementalMagFreqDist;
import scratch.UCERF3.U3FaultSystemRupSet;
import scratch.UCERF3.U3FaultSystemSolution;
import scratch.UCERF3.erf.ETAS.ETAS_CubeDiscretizationParams;
import scratch.UCERF3.erf.ETAS.ETAS_EqkRupture;
import scratch.UCERF3.erf.ETAS.ETAS_LongTermMFDs;
import scratch.UCERF3.erf.ETAS.ETAS_Params.ETAS_ParameterList;
import scratch.UCERF3.erf.ETAS.ETAS_Params.U3ETAS_ProbabilityModelOptions;
import scratch.UCERF3.erf.ETAS.ETAS_PrimaryEventSampler;
import scratch.UCERF3.erf.ETAS.ETAS_Simulator;
import scratch.UCERF3.erf.ETAS.ETAS_Utils;
import scratch.UCERF3.erf.ETAS.FaultSystemSolutionERF_ETAS;
import scratch.UCERF3.erf.ETAS.launcher.ETAS_Launcher;
import scratch.UCERF3.griddedSeismicity.FaultPolyMgr;
import scratch.UCERF3.griddedSeismicity.GridSourceFileReader;
import scratch.UCERF3.utils.LastEventData;
import scratch.UCERF3.utils.RELM_RegionUtils;

public class CacheFileGen {
    private static U3FaultSystemSolution buildFakeTestFSS() throws IOException, DocumentException {
        FaultSystemSolution origFSS = FaultSystemSolution.load(new File("/home/kevin/git/ucerf3-etas-launcher/inputs/2013_05_10-ucerf3p3-production-10runs_COMPOUND_SOL_FM3_1_SpatSeisU3_MEAN_BRANCH_AVG_SOL.zip"));
        HashSet<Integer> parentIDs = new HashSet<Integer>();
        parentIDs.add(286);
        parentIDs.add(301);
        ArrayList<Integer> validRupIDs = new ArrayList<Integer>();
        FaultSystemRupSet origRupSet = origFSS.getRupSet();
        SubSeismoOnFaultMFDs origSubSeismo = origFSS.requireModule(SubSeismoOnFaultMFDs.class);
        for (int r = 0; r < origRupSet.getNumRuptures(); ++r) {
            boolean match = true;
            for (FaultSection faultSection : origRupSet.getFaultSectionDataForRupture(r)) {
                if (parentIDs.contains(faultSection.getParentSectionId())) continue;
                match = false;
                break;
            }
            if (!match) continue;
            validRupIDs.add(r);
        }
        System.out.println("We have " + validRupIDs.size() + " ruptures");
        ArrayList<FaultSection> subSects = new ArrayList<FaultSection>();
        HashMap<Integer, Integer> sectID_oldToNew = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> sectID_newToOld = new HashMap<Integer, Integer>();
        for (FaultSection faultSection : origRupSet.getFaultSectionDataList()) {
            if (!parentIDs.contains(faultSection.getParentSectionId())) continue;
            int newID = subSects.size();
            sectID_oldToNew.put(faultSection.getSectionId(), newID);
            sectID_newToOld.put(newID, faultSection.getSectionId());
            faultSection.setSectionId(newID);
            subSects.add(faultSection);
        }
        System.out.println("We have " + subSects.size() + " sections");
        double[] dArray = new double[subSects.size()];
        double[] dArray2 = new double[subSects.size()];
        double[] sectAreas = new double[subSects.size()];
        ArrayList<IncrementalMagFreqDist> subSeismoOnFaultMFDs = new ArrayList<IncrementalMagFreqDist>();
        for (int s = 0; s < subSects.size(); ++s) {
            int sectIndex = (Integer)sectID_newToOld.get(((FaultSection)subSects.get(s)).getSectionId());
            dArray[s] = origRupSet.getSlipRateForSection(sectIndex);
            dArray2[s] = origRupSet.getSlipRateStdDevForSection(sectIndex);
            sectAreas[s] = origRupSet.getAreaForSection(sectIndex);
            subSeismoOnFaultMFDs.add(origSubSeismo.get(sectIndex));
        }
        ArrayList<List<Integer>> sectionForRups = new ArrayList<List<Integer>>();
        int numRups = validRupIDs.size();
        double[] mags = new double[numRups];
        double[] rakes = new double[numRups];
        double[] rupAreas = new double[numRups];
        double[] rupLengths = new double[numRups];
        double[] rates = new double[numRups];
        for (int r = 0; r < numRups; ++r) {
            int rupIndex = (Integer)validRupIDs.get(r);
            mags[r] = origRupSet.getMagForRup(rupIndex);
            rakes[r] = origRupSet.getAveRakeForRup(rupIndex);
            rupAreas[r] = origRupSet.getAreaForRup(rupIndex);
            rupLengths[r] = origRupSet.getLengthForRup(rupIndex);
            ArrayList<Integer> rupSections = new ArrayList<Integer>();
            for (Integer prevID : origRupSet.getSectionsIndicesForRup(rupIndex)) {
                rupSections.add((Integer)sectID_oldToNew.get(prevID));
            }
            sectionForRups.add(rupSections);
            rates[r] = origFSS.getRateForRup(rupIndex);
        }
        U3FaultSystemRupSet rupSet = new U3FaultSystemRupSet(subSects, dArray, dArray2, sectAreas, sectionForRups, mags, rakes, rupAreas, rupLengths, "Fake reduced rup set");
        double mfdScale = 1.0;
        double totSum = StatUtils.sum((double[])rates);
        double scaleRatio = 5.0;
        System.out.println("Original supra rate sum: " + totSum);
        int r = 0;
        while (r < rates.length) {
            int n = r++;
            rates[n] = rates[n] * scaleRatio;
        }
        System.out.println("Scaled by " + scaleRatio + " supra rate sum: " + StatUtils.sum((double[])rates));
        Region regionForGridded = null;
        for (FaultSection sect : subSects) {
            for (Location loc : new Location[]{sect.getFaultTrace().first(), sect.getFaultTrace().last()}) {
                regionForGridded = regionForGridded == null ? new Region(loc, 100.0) : Region.union(regionForGridded, new Region(loc, 100.0));
                Preconditions.checkNotNull((Object)regionForGridded);
            }
        }
        MFDGridSourceProvider origGridProv = origFSS.requireModule(MFDGridSourceProvider.class);
        GriddedRegion region = origGridProv.getGriddedRegion();
        HashMap<Integer, IncrementalMagFreqDist> nodeSubSeisMFDs = new HashMap<Integer, IncrementalMagFreqDist>();
        HashMap<Integer, IncrementalMagFreqDist> nodeUnassociatedMFDs = new HashMap<Integer, IncrementalMagFreqDist>();
        FaultPolyMgr faultPolyMgr = FaultPolyMgr.create(subSects, 12.0);
        for (int index = 0; index < region.getNodeCount(); ++index) {
            IncrementalMagFreqDist offMFD;
            Location loc = region.getLocation(index);
            IncrementalMagFreqDist subSeisMFD = origGridProv.getMFD_SubSeisOnFault(index);
            if (subSeisMFD != null && subSeisMFD.calcSumOfY_Vals() == 0.0) {
                subSeisMFD = null;
            }
            if ((offMFD = origGridProv.getMFD_Unassociated(index)) != null && offMFD.calcSumOfY_Vals() == 0.0) {
                offMFD = null;
            }
            Preconditions.checkState((subSeisMFD != null || offMFD != null ? 1 : 0) != 0);
            GutenbergRichterMagFreqDist zeroMFD = subSeisMFD != null ? new GutenbergRichterMagFreqDist(1.0, 0.1, subSeisMFD.getMinX(), subSeisMFD.getMaxX(), subSeisMFD.size()) : new GutenbergRichterMagFreqDist(1.0, 0.1, offMFD.getMinX(), offMFD.getMaxX(), offMFD.size());
            Preconditions.checkState((zeroMFD.calcSumOfY_Vals() > 0.0 ? 1 : 0) != 0);
            double fract = faultPolyMgr.getNodeFraction(index);
            if (fract < 1.0E-10) {
                subSeisMFD = null;
            }
            if (regionForGridded.contains(loc)) {
                if (subSeisMFD != null) {
                    subSeisMFD.scale(mfdScale);
                    nodeSubSeisMFDs.put(index, subSeisMFD);
                }
                if (offMFD != null) {
                    offMFD.scale(mfdScale);
                    nodeUnassociatedMFDs.put(index, offMFD);
                } else if (subSeisMFD == null || fract < 1.0) {
                    nodeUnassociatedMFDs.put(index, zeroMFD);
                }
            } else {
                nodeUnassociatedMFDs.put(index, zeroMFD);
            }
            Preconditions.checkState((nodeUnassociatedMFDs.get(index) != null || nodeSubSeisMFDs.get(index) != null ? 1 : 0) != 0);
        }
        GridSourceFileReader gridProv = new GridSourceFileReader(region, nodeSubSeisMFDs, nodeUnassociatedMFDs);
        for (int i = 0; i < gridProv.getNumLocations(); ++i) {
            IncrementalMagFreqDist totMFD = gridProv.getMFD(i);
            IncrementalMagFreqDist assocMFD = gridProv.getMFD_SubSeisOnFault(i);
            IncrementalMagFreqDist offMFD = gridProv.getMFD_Unassociated(i);
            Preconditions.checkState((assocMFD != null || offMFD != null ? 1 : 0) != 0);
            double rateAssoc = assocMFD == null ? 0.0 : assocMFD.calcSumOfY_Vals();
            double rateOff = offMFD == null ? 0.0 : offMFD.calcSumOfY_Vals();
            Preconditions.checkState((rateAssoc > 0.0 || rateOff > 0.0 ? 1 : 0) != 0, (String)"rateAssoc=%s, assocNull ? %s, rateOff=%s, offNull ? %s", (Object)rateAssoc, (Object)(assocMFD == null ? 1 : 0), (Object)rateOff, (Object)(offMFD == null ? 1 : 0));
            Preconditions.checkState((totMFD.calcSumOfY_Vals() > 0.0 ? 1 : 0) != 0);
        }
        U3FaultSystemSolution sol = new U3FaultSystemSolution(rupSet, rates);
        sol.setGridSourceProvider(gridProv);
        sol.setSubSeismoOnFaultMFD_List(subSeismoOnFaultMFDs);
        return sol;
    }

    public static void main(String[] args) throws IOException, DocumentException {
        U3FaultSystemSolution fss = CacheFileGen.buildFakeTestFSS();
        fss.write(new File("/home/kevin/git/ucerf3-etas-launcher/inputs/small_test_solution.zip"));
        LastEventData.populateSubSects(fss.getRupSet().getFaultSectionDataList(), LastEventData.load());
        FaultSystemSolutionERF_ETAS erf = ETAS_Launcher.buildERF(fss, false, 1.0, 2014);
        erf.updateForecast();
        File cacheFile = new File("src/main/resources/scratchData/ucerf3/InversionSolutions/cubeInsidePolyCache");
        if (cacheFile.exists()) {
            cacheFile.delete();
        }
        if ((cacheFile = new File("src/main/resources/scratchData/ucerf3/InversionSolutions/griddedSeisCorrectionCache")).exists()) {
            cacheFile.delete();
        }
        if ((cacheFile = new File("src/main/resources/scratchData/ucerf3/InversionSolutions/sectDistForCubeCache")).exists()) {
            cacheFile.delete();
        }
        if ((cacheFile = new File("src/main/resources/scratchData/ucerf3/InversionSolutions/sectInCubeCache")).exists()) {
            cacheFile.delete();
        }
        if (!cacheFile.getParentFile().exists()) {
            cacheFile.getParentFile().mkdir();
        }
        File resultsDir = new File("/tmp");
        CaliforniaRegions.RELM_TESTING_GRIDDED reg = RELM_RegionUtils.getGriddedRegionInstance();
        Long randSeed = null;
        boolean includeIndirectTriggering = true;
        boolean includeSpontEvents = true;
        double gridSeisDiscr = 0.1;
        ObsEqkRupList histQkList = new ObsEqkRupList();
        ETAS_Simulator.D = false;
        ETAS_EqkRupture mainshockRup = null;
        ETAS_ParameterList params = new ETAS_ParameterList();
        params.setApplyGridSeisCorr(true);
        ETAS_Simulator.runETAS_Simulation(resultsDir, (AbstractNthRupERF)erf, (GriddedRegion)reg, mainshockRup, (List<? extends ObsEqkRupture>)histQkList, includeSpontEvents, includeIndirectTriggering, gridSeisDiscr, null, randSeed, null, null, null, params, null, null);
        params.setU3ETAS_ProbModel(U3ETAS_ProbabilityModelOptions.POISSON);
        erf.setParameter("Probability Model", (Object)ProbabilityModelOptions.POISSON);
        erf.updateForecast();
        double[] sourceRates = new double[erf.getNumSources()];
        double duration = erf.getTimeSpan().getDuration();
        for (int s = 0; s < erf.getNumSources(); ++s) {
            sourceRates[s] = erf.getSource(s).computeTotalEquivMeanAnnualRate(duration);
        }
        ETAS_CubeDiscretizationParams cubeParams = new ETAS_CubeDiscretizationParams(reg);
        ETAS_LongTermMFDs longTermMFDs = new ETAS_LongTermMFDs(erf, params.getApplySubSeisForSupraNucl());
        ETAS_PrimaryEventSampler etas_PrimEventSampler = new ETAS_PrimaryEventSampler(cubeParams, erf, longTermMFDs, sourceRates, null, params, new ETAS_Utils(), null, null, null);
        etas_PrimEventSampler.getExpectedAfterShockRateInGridCellsFromSupraRates(10.0, new ETAS_ParameterList(), 2.0, null);
    }
}

