/*
 * Decompiled with CFR 0.152.
 */
package scratch.kevin.ucerf3.etas;

import com.google.common.base.Preconditions;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.jfree.chart.plot.DatasetRenderingOrder;
import org.jfree.data.Range;
import org.opensha.commons.data.function.EvenlyDiscretizedFunc;
import org.opensha.commons.data.function.HistogramFunction;
import org.opensha.commons.gui.plot.HeadlessGraphPanel;
import org.opensha.commons.gui.plot.PlotCurveCharacterstics;
import org.opensha.commons.gui.plot.PlotLineType;
import org.opensha.commons.gui.plot.PlotSpec;
import org.opensha.commons.mapping.gmt.elements.GMT_CPT_Files;
import org.opensha.commons.util.MarkdownUtils;
import org.opensha.commons.util.cpt.CPT;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemSolution;
import org.opensha.sha.faultSurface.FaultSection;
import scratch.UCERF3.erf.ETAS.ETAS_CatalogIO;
import scratch.UCERF3.erf.ETAS.ETAS_EqkRupture;
import scratch.UCERF3.erf.ETAS.ETAS_SimulationMetadata;
import scratch.UCERF3.erf.ETAS.analysis.ETAS_AbstractPlot;
import scratch.UCERF3.erf.ETAS.launcher.ETAS_Config;
import scratch.UCERF3.erf.ETAS.launcher.ETAS_Launcher;

public class ETAS_NumHistDebug
extends ETAS_AbstractPlot {
    private HistogramFunction totalHist;
    private double binMax;
    private Map<Integer, HistogramFunction> maxMagHists = new HashMap<Integer, HistogramFunction>();
    private Map<Integer, HistogramFunction> numSupraHists = new HashMap<Integer, HistogramFunction>();
    private Map<Integer, HistogramFunction> kHists = new HashMap<Integer, HistogramFunction>();
    private Map<Boolean, HistogramFunction> garlockHists = new HashMap<Boolean, HistogramFunction>();
    private HashSet<Integer> garlockRups = null;
    private int maxRuptureCount = 0;

    public static void main(String[] args) throws IOException {
        File simDir = new File("/home/kevin/OpenSHA/UCERF3/etas/simulations/2019_11_05-ComCatM7p1_ci38457511_ShakeMapSurfaces_kCOV1p16");
        File binFile = new File(simDir, "results_complete.bin");
        if (!binFile.exists()) {
            binFile = new File(simDir, "results_m5_preserve_chain.bin");
        }
        System.out.println("Bin file: " + binFile.getAbsolutePath());
        File mainOutputDir = new File("/home/kevin/git/misc-research/etas_bimodal_count_debug");
        File myOutputDir = new File(mainOutputDir, simDir.getName());
        Preconditions.checkState((myOutputDir.exists() || myOutputDir.mkdir() ? 1 : 0) != 0);
        ETAS_Config config = ETAS_Config.readJSON(new File(simDir, "config.json"));
        config.setOutputDir(myOutputDir);
        ETAS_Launcher launcher = new ETAS_Launcher(config, false);
        ETAS_NumHistDebug plot = new ETAS_NumHistDebug(config, launcher, 30000, 10);
        plot.processCatalogsFile(binFile);
        plot.finalize(myOutputDir, null);
        List<String> lines = plot.generateMarkdown(".", "#", "");
        MarkdownUtils.writeReadmeAndHTML(lines, myOutputDir);
    }

    public ETAS_NumHistDebug(ETAS_Config config, ETAS_Launcher launcher, int maxCount, int delta) {
        super(config, launcher);
        this.totalHist = new HistogramFunction(((double)delta - 1.0) * 0.5, (int)((double)maxCount / (double)delta), (double)delta);
        this.binMax = this.totalHist.getMaxX() + 0.5 * this.totalHist.getDelta();
    }

    private <E extends Comparable<E>> void plot(HistogramFunction totalHist, Map<E, HistogramFunction> subHists, String title, String legendNameAdd, File outputDir, String prefix) throws IOException {
        ArrayList<E> keys = new ArrayList<E>(subHists.keySet());
        Collections.sort(keys);
        CPT cpt = GMT_CPT_Files.MAX_SPECTRUM.instance();
        cpt = cpt.rescale(0.0, Double.max(1.0, (double)keys.size() - 1.0));
        HistogramFunction runningHist = new HistogramFunction(totalHist.getMinX(), totalHist.getMaxX(), totalHist.size());
        ArrayList<EvenlyDiscretizedFunc> funcs = new ArrayList<EvenlyDiscretizedFunc>();
        ArrayList<PlotCurveCharacterstics> chars = new ArrayList<PlotCurveCharacterstics>();
        for (int i = 0; i < keys.size(); ++i) {
            Comparable key = (Comparable)keys.get(i);
            HistogramFunction hist = subHists.get(key);
            for (int j = 0; j < hist.size(); ++j) {
                runningHist.add(j, hist.getY(j));
            }
            EvenlyDiscretizedFunc clone = runningHist.deepClone();
            clone.setName(legendNameAdd + String.valueOf(key));
            funcs.add(clone);
            chars.add(new PlotCurveCharacterstics(PlotLineType.HISTOGRAM, 1.0f, cpt.getColor(i)));
        }
        funcs.add(totalHist);
        chars.add(new PlotCurveCharacterstics(PlotLineType.HISTOGRAM, 1.0f, Color.GRAY));
        PlotSpec plot = new PlotSpec(funcs, chars, title, "Event Count", "Num Simulations");
        plot.setLegendVisible(true);
        HeadlessGraphPanel gp = ETAS_NumHistDebug.buildGraphPanel();
        gp.setRenderingOrder(DatasetRenderingOrder.REVERSE);
        gp.drawGraphPanel(plot, false, false, new Range(0.0, totalHist.getMaxX() + 0.5 * totalHist.getDelta()), null);
        gp.getChartPanel().setSize(1000, 800);
        gp.saveAsPNG(new File(outputDir, prefix + ".png").getAbsolutePath());
    }

    @Override
    public int getVersion() {
        return 0;
    }

    @Override
    public boolean isFilterSpontaneous() {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected synchronized void doProcessCatalog(ETAS_CatalogIO.ETAS_Catalog completeCatalog, ETAS_CatalogIO.ETAS_Catalog triggeredOnlyCatalog, FaultSystemSolution fss) {
        void var6_11;
        boolean garlock;
        double maxMag;
        int numRups;
        ETAS_SimulationMetadata meta;
        if (this.garlockRups == null) {
            this.garlockRups = new HashSet();
            FaultSystemRupSet rupSet = fss.getRupSet();
            for (FaultSection faultSection : rupSet.getFaultSectionDataList()) {
                if (!faultSection.getName().startsWith("Garlock")) continue;
                this.garlockRups.addAll(rupSet.getRupturesForSection(faultSection.getSectionId()));
            }
        }
        if ((meta = completeCatalog.getSimulationMetadata()) == null) {
            numRups = completeCatalog.size();
            boolean bl = false;
            maxMag = 0.0;
            garlock = false;
            for (ETAS_EqkRupture rup : completeCatalog) {
                if (rup.getFSSIndex() >= 0) {
                    void var6_9;
                    ++var6_9;
                    garlock = garlock || this.garlockRups.contains(rup.getFSSIndex());
                }
                maxMag = Math.max(maxMag, rup.getMag());
            }
        } else {
            numRups = meta.totalNumRuptures;
            int n = meta.numSupraSeis;
            maxMag = meta.maxMag;
            garlock = false;
            for (int i = 0; i < completeCatalog.size() && !garlock && n > 0; ++i) {
                int fssIndex = ((ETAS_EqkRupture)completeCatalog.get(i)).getFSSIndex();
                garlock = garlock || fssIndex > 0 && this.garlockRups.contains(fssIndex);
            }
        }
        if ((double)numRups > this.binMax) {
            return;
        }
        double maxK = Double.NEGATIVE_INFINITY;
        for (ETAS_EqkRupture rup : completeCatalog) {
            if (rup.getMag() < 5.0) continue;
            maxK = Math.max(maxK, Math.log10(rup.getETAS_k()));
        }
        int xInd = this.totalHist.getClosestXIndex(numRups);
        this.maxRuptureCount = Integer.max(this.maxRuptureCount, numRups);
        this.totalHist.add(xInd, 1.0);
        int maxMagInt = (int)maxMag;
        HistogramFunction maxMagHist = this.maxMagHists.get(maxMagInt);
        if (maxMagHist == null) {
            maxMagHist = new HistogramFunction(this.totalHist.getMinX(), this.totalHist.getMaxX(), this.totalHist.size());
            this.maxMagHists.put(maxMagInt, maxMagHist);
        }
        maxMagHist.add(xInd, 1.0);
        HistogramFunction numSupraHist = this.numSupraHists.get((int)var6_11);
        if (numSupraHist == null) {
            numSupraHist = new HistogramFunction(this.totalHist.getMinX(), this.totalHist.getMaxX(), this.totalHist.size());
            this.numSupraHists.put((int)var6_11, numSupraHist);
        }
        numSupraHist.add(xInd, 1.0);
        HistogramFunction garlockHist = this.garlockHists.get(garlock);
        if (garlockHist == null) {
            garlockHist = new HistogramFunction(this.totalHist.getMinX(), this.totalHist.getMaxX(), this.totalHist.size());
            this.garlockHists.put(garlock, garlockHist);
        }
        garlockHist.add(xInd, 1.0);
        if (Double.isFinite(maxK)) {
            int kInt = (int)maxK;
            HistogramFunction kHist = this.kHists.get(kInt);
            if (kHist == null) {
                kHist = new HistogramFunction(this.totalHist.getMinX(), this.totalHist.getMaxX(), this.totalHist.size());
                this.kHists.put(kInt, kHist);
            }
            kHist.add(xInd, 1.0);
        }
    }

    @Override
    protected List<? extends Runnable> doFinalize(File outputDir, FaultSystemSolution fss, ExecutorService exec) throws IOException {
        System.out.println("Maximum rupture count: " + this.maxRuptureCount);
        this.plot(this.totalHist, this.maxMagHists, "Event Count by Max Mag", "Mmax >= ", outputDir, "num_events_hist_max_mag");
        this.plot(this.totalHist, this.numSupraHists, "Event Count by Num Supra", "Nsupra = ", outputDir, "num_events_hist_num_supra");
        this.plot(this.totalHist, this.garlockHists, "Event Count by Garlock Supraseismogenic", "Garlock ? ", outputDir, "num_events_hist_garlock");
        this.plot(this.totalHist, this.kHists, "Event Count by Max K for M>=5", "Log10(k) > ", outputDir, "num_events_hist_max_k");
        return null;
    }

    @Override
    public List<String> generateMarkdown(String relativePathToOutputDir, String topLevelHeading, String topLink) throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add(topLevelHeading + " Total Number Histogram Disaggregation");
        lines.add(topLink);
        lines.add("");
        lines.add(topLevelHeading + "# By Maximum Magnitude");
        lines.add(topLink);
        lines.add("");
        lines.add("![plot](" + relativePathToOutputDir + "/num_events_hist_max_mag.png)");
        lines.add("");
        lines.add(topLevelHeading + "# By Num Supraseismogenic");
        lines.add(topLink);
        lines.add("");
        lines.add("![plot](" + relativePathToOutputDir + "/num_events_hist_num_supra.png)");
        lines.add("");
        lines.add(topLevelHeading + "# By Garlock Rupture");
        lines.add(topLink);
        lines.add("");
        lines.add("![plot](" + relativePathToOutputDir + "/num_events_hist_garlock.png)");
        lines.add("");
        lines.add(topLevelHeading + "# By Max K values for M>=5");
        lines.add(topLink);
        lines.add("");
        lines.add("![plot](" + relativePathToOutputDir + "/num_events_hist_max_k.png)");
        lines.add("");
        return lines;
    }
}

