/*
 * Decompiled with CFR 0.152.
 */
package scratch.kevin.ucerf3.etas;

import com.google.common.base.Preconditions;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opensha.commons.data.CSVFile;
import org.opensha.commons.geo.GriddedRegion;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationUtils;
import org.opensha.commons.util.DataUtils;
import org.opensha.sha.magdist.IncrementalMagFreqDist;
import scratch.UCERF3.erf.ETAS.ETAS_CatalogIO;
import scratch.UCERF3.erf.ETAS.ETAS_EqkRupture;
import scratch.UCERF3.erf.ETAS.launcher.util.ETAS_CatalogIteration;

public class GuillermoMFDCalc {
    static double mfdMinMag = 2.55;
    static double mfdDelta = 0.1;
    static int mfdNumMag = 66;

    public static void main(String[] args) throws IOException {
        File outputDir;
        String contains;
        String prefix;
        File simsDir = new File("/home/scec-02/kmilner/ucerf3/etas_sim");
        File mainOutputDir = new File("/home/scec-02/kmilner/ucerf3/etas_guillermo");
        File cubesCSVFile = new File(mainOutputDir, "California_0p5.csv");
        double spacing = 0.5;
        if (args.length == 0) {
            prefix = "2020_02_04-Start";
            contains = "1yr_kCOV1p5";
            outputDir = new File(mainOutputDir, "full_td_kCOV1p5");
        } else {
            Preconditions.checkArgument((args.length == 3 ? 1 : 0) != 0, (Object)"USAGE: <prefix> <contains> <outfix>");
            prefix = args[0];
            contains = args[1];
            outputDir = new File(mainOutputDir, args[2]);
        }
        Preconditions.checkState((outputDir.exists() || outputDir.mkdir() ? 1 : 0) != 0);
        int minYear = 1986;
        int maxYear = 2020;
        CSVFile<String> cubesCSV = CSVFile.readFile(cubesCSVFile, true);
        ArrayList<Location> centers = new ArrayList<Location>();
        DataUtils.MinMaxAveTracker latTrack = new DataUtils.MinMaxAveTracker();
        DataUtils.MinMaxAveTracker lonTrack = new DataUtils.MinMaxAveTracker();
        for (int row = 1; row < cubesCSV.getNumRows(); ++row) {
            double lat = cubesCSV.getDouble(row, 8);
            double lon = cubesCSV.getDouble(row, 7);
            double depth = cubesCSV.getDouble(row, 9);
            if (depth > 24.0) continue;
            latTrack.addValue(lat);
            lonTrack.addValue(lon);
            centers.add(new Location(lat, lon));
        }
        double minLat = latTrack.getMin();
        double minLon = lonTrack.getMin();
        Location minLoc = new Location(minLat, minLon);
        double maxLat = latTrack.getMax();
        double maxLon = lonTrack.getMax();
        Location maxLoc = new Location(maxLat, maxLon);
        GriddedRegion gridReg = new GriddedRegion(minLoc, maxLoc, spacing, minLoc);
        System.out.println("Min loc: " + String.valueOf(minLoc));
        System.out.println("Max loc: " + String.valueOf(maxLoc));
        System.out.println("Loaded " + centers.size() + " locations");
        System.out.println("Grid reg has " + gridReg.getNodeCount() + " locations");
        HashMap<Integer, Integer> gridToCubeIDMap = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> cubeIdToGridMap = new HashMap<Integer, Integer>();
        HashMap cubeCSVs = new HashMap();
        DataUtils.MinMaxAveTracker distTrack = new DataUtils.MinMaxAveTracker();
        IncrementalMagFreqDist refMFD = new IncrementalMagFreqDist(mfdMinMag, mfdNumMag, mfdDelta);
        ArrayList<Object> header = new ArrayList<Object>();
        header.add("Year");
        for (Point2D pt : refMFD) {
            header.add("" + (float)pt.getX());
        }
        for (int i = 0; i < centers.size(); ++i) {
            int id = i + 1;
            Location center = (Location)centers.get(i);
            int index = gridReg.indexForLocation(center);
            Preconditions.checkState((index >= 0 ? 1 : 0) != 0);
            File[] gridLoc = gridReg.getLocation(index);
            double dist = LocationUtils.horzDistanceFast(center, (Location)gridLoc);
            distTrack.addValue(dist);
            gridToCubeIDMap.put(index, id);
            cubeIdToGridMap.put(id, index);
        }
        System.out.println("Distance stats: " + String.valueOf(distTrack));
        File[] simDirs = simsDir.listFiles();
        for (int year = minYear; year <= maxYear; ++year) {
            String starts = prefix + year;
            File match = null;
            for (File simDir : simDirs) {
                String name = simDir.getName();
                if (!name.startsWith(starts) || !name.contains(contains)) continue;
                match = simDir;
                break;
            }
            System.out.println("*** " + year + " ***");
            if (match == null) {
                System.out.println("\tno match");
                System.out.println("************");
                continue;
            }
            System.out.println("\t" + match.getName());
            File resultsFile = new File(match, "results_complete.bin");
            if (!resultsFile.exists()) {
                System.out.println("\tno results");
                System.out.println("************");
                continue;
            }
            System.out.println("\thas results, processsing...");
            HashMap<Integer, IncrementalMagFreqDist> mfds = new HashMap<Integer, IncrementalMagFreqDist>();
            MFDCalcCallback call = new MFDCalcCallback(gridReg, mfds);
            ETAS_CatalogIteration.processCatalogs(resultsFile, call);
            int numNonZero = 0;
            for (Integer id : cubeIdToGridMap.keySet()) {
                CSVFile<Object> csv = (CSVFile<Object>)cubeCSVs.get(id);
                Integer gridIndex = (Integer)cubeIdToGridMap.get(id);
                IncrementalMagFreqDist mfd = (IncrementalMagFreqDist)mfds.get(gridIndex);
                if (mfd == null) {
                    if (csv == null) continue;
                    mfd = refMFD;
                } else {
                    mfd.scale(1.0 / (double)call.catalogCount);
                    ++numNonZero;
                }
                if (csv == null) {
                    csv = new CSVFile<Object>(true);
                    csv.addLine((List<Object>)header);
                    int year2 = minYear;
                    while (year2 < year) {
                        ArrayList<CallSite> line = new ArrayList<CallSite>();
                        line.add((CallSite)((Object)("" + year)));
                        for (Point2D pt : refMFD) {
                            line.add((CallSite)((Object)("" + (float)pt.getY())));
                        }
                        csv.addLine((List<Object>)line);
                        ++year;
                    }
                    cubeCSVs.put(id, csv);
                }
                ArrayList<CallSite> line = new ArrayList<CallSite>();
                line.add((CallSite)((Object)("" + year)));
                for (Point2D pt : mfd) {
                    line.add((CallSite)((Object)("" + (float)pt.getY())));
                }
                csv.addLine((List<Object>)line);
            }
            System.out.println("\t" + numNonZero + "/" + cubeIdToGridMap.size() + " have values");
            System.out.println("************");
        }
        System.out.println("Writing CSVs");
        for (Integer id : cubeCSVs.keySet()) {
            CSVFile csv = (CSVFile)cubeCSVs.get(id);
            csv.writeToFile(new File(outputDir, "cube_" + id + ".csv"));
        }
        System.out.println("DONE");
    }

    private static class MFDCalcCallback
    implements ETAS_CatalogIteration.Callback {
        private GriddedRegion gridReg;
        private Map<Integer, IncrementalMagFreqDist> mfdMap;
        private int catalogCount = 0;
        private int skipped = 0;

        public MFDCalcCallback(GriddedRegion gridReg, Map<Integer, IncrementalMagFreqDist> mfdMap) {
            this.gridReg = gridReg;
            this.mfdMap = mfdMap;
        }

        @Override
        public void processCatalog(ETAS_CatalogIO.ETAS_Catalog catalog, int index) {
            ++this.catalogCount;
            for (ETAS_EqkRupture rup : catalog) {
                Location hypo = rup.getHypocenterLocation();
                int gridIndex = this.gridReg.indexForLocation(hypo);
                if (gridIndex < 0) {
                    ++this.skipped;
                    continue;
                }
                IncrementalMagFreqDist mfd = this.mfdMap.get(gridIndex);
                if (mfd == null) {
                    mfd = new IncrementalMagFreqDist(mfdMinMag, mfdNumMag, mfdDelta);
                    this.mfdMap.put(gridIndex, mfd);
                }
                mfd.add(mfd.getClosestXIndex(rup.getMag()), 1.0);
            }
        }
    }
}

