/*
 * Decompiled with CFR 0.152.
 */
package scratch.kevin.ucerf3.etas;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import com.google.common.primitives.Ints;
import edu.usc.kmilner.mpj.taskDispatch.MPJTaskCalculator;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.opensha.commons.geo.GriddedRegion;
import org.opensha.commons.geo.Location;
import org.opensha.commons.util.ClassUtils;
import org.opensha.commons.util.ExceptionUtils;
import org.opensha.commons.util.XMLUtils;
import org.opensha.sha.earthquake.AbstractERF;
import org.opensha.sha.earthquake.AbstractNthRupERF;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemSolution;
import org.opensha.sha.earthquake.param.BackgroundRupType;
import org.opensha.sha.faultSurface.FaultSection;
import scratch.UCERF3.enumTreeBranches.SpatialSeisPDF;
import scratch.UCERF3.enumTreeBranches.TotalMag5Rate;
import scratch.UCERF3.erf.ETAS.ETAS_CatalogIO;
import scratch.UCERF3.erf.ETAS.ETAS_EqkRupture;
import scratch.UCERF3.erf.ETAS.ETAS_Params.ETAS_ParameterList;
import scratch.UCERF3.erf.ETAS.ETAS_Params.U3ETAS_ProbabilityModelOptions;
import scratch.UCERF3.erf.ETAS.ETAS_Params.U3ETAS_ProbabilityModelParam;
import scratch.UCERF3.erf.ETAS.ETAS_Params.U3ETAS_StatewideCatalogCompletenessParam;
import scratch.UCERF3.erf.ETAS.ETAS_Params.U3ETAS_TotalRateScaleFactorParam;
import scratch.UCERF3.erf.ETAS.ETAS_Simulator;
import scratch.UCERF3.erf.ETAS.FaultSystemSolutionERF_ETAS;
import scratch.UCERF3.erf.ETAS.NoFaultsModel.ETAS_Simulator_NoFaults;
import scratch.UCERF3.erf.ETAS.NoFaultsModel.UCERF3_GriddedSeisOnlyERF_ETAS;
import scratch.UCERF3.erf.ETAS.launcher.ETAS_Launcher;
import scratch.UCERF3.utils.LastEventData;
import scratch.UCERF3.utils.MatrixIO;
import scratch.UCERF3.utils.RELM_RegionUtils;
import scratch.UCERF3.utils.U3FaultSystemIO;

public class MPJ_ETAS_Simulator
extends MPJTaskCalculator {
    private int numSims;
    private FaultSystemSolution[] sols;
    private Map<Integer, List<LastEventData>> lastEventData;
    private File inputDir;
    private File outputDir;
    private boolean binaryOutput = false;
    private double duration;
    private Long ot;
    private int fssScenarioRupID;
    private List<float[]> fractionSrcAtPointList;
    private List<int[]> srcAtPointList;
    private int[] isCubeInsideFaultPolygon;
    private double[] gridSeisCorrections;
    private String simulationName;
    private boolean includeSpontEvents = true;
    private boolean includeIndirectTriggering = true;
    private double gridSeisDiscr = 0.1;
    private boolean applySubSeisForSupraNucl = true;
    private double totRateScaleFactor = U3ETAS_TotalRateScaleFactorParam.DEFAULT_VALUE;
    private boolean timeIndep = false;
    private GriddedRegion griddedRegion = RELM_RegionUtils.getGriddedRegionInstance();
    private List<ETAS_EqkRupture> histQkList;
    private ETAS_EqkRupture triggerRup;
    private U3ETAS_ProbabilityModelOptions probModel = U3ETAS_ProbabilityModelParam.DEFAULT;
    private boolean imposeGR = false;
    private static final int START_YEAR_DEFAULT = 2014;
    private boolean metadataOnly = false;
    private boolean griddedOnly = false;
    private Random r;
    public static final String TRIGGER_RUP_EL_NAME = "TriggerRup";
    public static final String HIST_CAT_EL_NAME = "HistCatalog";
    public static final String OTHER_PARAMS_EL_NAME = "MiscParams";

    public MPJ_ETAS_Simulator(CommandLine cmd, File inputDir, File outputDir) throws IOException, DocumentException {
        super(cmd);
        ETAS_EqkRupture mainshockRup;
        this.inputDir = inputDir;
        this.outputDir = outputDir;
        ETAS_Simulator.D = false;
        this.lastEventData = LastEventData.load();
        this.numSims = Integer.parseInt(cmd.getOptionValue("num"));
        this.duration = cmd.hasOption("duration") ? Double.parseDouble(cmd.getOptionValue("duration")) : 1.0;
        this.includeSpontEvents = !cmd.hasOption("no-spontaneous");
        this.timeIndep = cmd.hasOption("indep");
        this.imposeGR = cmd.hasOption("impose-gr");
        if (cmd.hasOption("prob-model")) {
            this.probModel = U3ETAS_ProbabilityModelOptions.valueOf(cmd.getOptionValue("prob-model"));
        }
        if (cmd.hasOption("apply-sub-seis-for-supra-nucl")) {
            this.applySubSeisForSupraNucl = Boolean.parseBoolean(cmd.getOptionValue("apply-sub-seis-for-supra-nucl"));
        }
        if (cmd.hasOption("tot-rate-scale-factor")) {
            this.totRateScaleFactor = Double.parseDouble(cmd.getOptionValue("tot-rate-scale-factor"));
        }
        this.binaryOutput = cmd.hasOption("binary");
        File solFile = new File(cmd.getOptionValue("sol-file"));
        Preconditions.checkArgument((boolean)solFile.exists(), (Object)("Solution file doesn't exist: " + solFile.getAbsolutePath()));
        this.sols = new FaultSystemSolution[this.getNumThreads()];
        for (int i = 0; i < this.sols.length; ++i) {
            this.sols[i] = U3FaultSystemIO.loadSol(solFile);
        }
        if (cmd.hasOption("reset-sections")) {
            String resetArg = cmd.getOptionValue("reset-sections").trim();
            Preconditions.checkArgument((boolean)resetArg.contains(":"), (Object)"Reset sections format: epochMillis:s1,s2,...,sn[;epochMillis1:s1,s2]");
            ArrayList args = Lists.newArrayList();
            while (resetArg.contains(";")) {
                int index = resetArg.indexOf(";");
                String subArg = resetArg.substring(0, index);
                Preconditions.checkState((!subArg.isEmpty() ? 1 : 0) != 0);
                args.add(subArg);
                resetArg = resetArg.substring(index + 1);
            }
            if (!resetArg.isEmpty()) {
                args.add(resetArg);
            }
            HashMap resetMap = Maps.newHashMap();
            for (String arg : args) {
                int index;
                if (this.rank == 0) {
                    this.debug("Processing subsection reset arg: " + arg);
                }
                Preconditions.checkState(((index = arg.indexOf(":")) > 0 ? 1 : 0) != 0);
                String timeStr = arg.substring(0, index);
                long time = Long.parseLong(timeStr);
                String sectStr = arg.substring(index + 1);
                String[] sectSplit = sectStr.split(",");
                int[] sects = new int[sectSplit.length];
                for (int i = 0; i < sectSplit.length; ++i) {
                    int s;
                    String sect = sectSplit[i];
                    sects[i] = s = Integer.parseInt(sect);
                }
                resetMap.put(time, sects);
            }
            for (Long time : resetMap.keySet()) {
                int[] sects = (int[])resetMap.get(time);
                if (this.rank == 0) {
                    this.debug("Resetting " + sects.length + " sects to " + time);
                }
                for (FaultSystemSolution sol : this.sols) {
                    FaultSystemRupSet rupSet = sol.getRupSet();
                    for (int s : sects) {
                        rupSet.getFaultSectionData(s).setDateOfLastEvent(time);
                    }
                }
            }
        }
        this.griddedOnly = cmd.hasOption("gridded-only");
        if (this.griddedOnly) {
            ETAS_Simulator_NoFaults.D = false;
        }
        if (cmd.hasOption("millis")) {
            this.ot = Long.parseLong(cmd.getOptionValue("millis"));
        } else {
            int startYear = 2014;
            if (cmd.hasOption("start-year")) {
                startYear = Integer.parseInt(cmd.getOptionValue("start-year"));
            }
            if (this.rank == 0) {
                this.debug("Start year: " + startYear);
            }
            this.ot = Math.round(((double)startYear - 1970.0) * 3.15576E10);
        }
        this.fssScenarioRupID = -1;
        FaultSystemRupSet rupSet = this.sols[0].getRupSet();
        this.histQkList = Lists.newArrayList();
        if (cmd.hasOption("trigger-catalog")) {
            File catFile = new File(cmd.getOptionValue("trigger-catalog"));
            File surfsFile = cmd.hasOption("rupture-surfaces") ? new File(cmd.getOptionValue("rupture-surfaces")) : null;
            this.histQkList.addAll(ETAS_Launcher.loadHistoricalCatalog(catFile, surfsFile, this.sols[0], this.ot, null, U3ETAS_StatewideCatalogCompletenessParam.DEFAULT_VALUE));
        }
        LastEventData.filterDataAfterTime(this.lastEventData, this.ot);
        Location triggerHypo = null;
        if (cmd.hasOption("trigger-loc")) {
            String locStr = cmd.getOptionValue("trigger-loc");
            String[] locSplit = locStr.split(",");
            Preconditions.checkState((locSplit.length == 3 ? 1 : 0) != 0, (Object)"Location must be in format lat,lon,depth");
            triggerHypo = new Location(Double.parseDouble(locSplit[0]), Double.parseDouble(locSplit[1]), Double.parseDouble(locSplit[2]));
        }
        if (cmd.hasOption("trigger-rupture-id")) {
            mainshockRup = new ETAS_EqkRupture();
            mainshockRup.setOriginTime(this.ot);
            this.fssScenarioRupID = Integer.parseInt(cmd.getOptionValue("trigger-rupture-id"));
            mainshockRup.setAveRake(rupSet.getAveRakeForRup(this.fssScenarioRupID));
            mainshockRup.setMag(rupSet.getMagForRup(this.fssScenarioRupID));
            mainshockRup.setRuptureSurface(rupSet.getSurfaceForRupture(this.fssScenarioRupID, 1.0));
            mainshockRup.setID(0);
            mainshockRup.setFSSIndex(this.fssScenarioRupID);
            if (cmd.hasOption("trigger-mag")) {
                mainshockRup.setMag(Double.parseDouble(cmd.getOptionValue("trigger-mag")));
            }
            if (triggerHypo != null) {
                mainshockRup.setHypocenterLocation(triggerHypo);
            }
            this.simulationName = "FSS simulation. M=" + mainshockRup.getMag() + ", fss ID=" + this.fssScenarioRupID;
            this.triggerRup = mainshockRup;
        } else if (cmd.hasOption("trigger-loc")) {
            mainshockRup = new ETAS_EqkRupture();
            mainshockRup.setOriginTime(this.ot);
            Preconditions.checkArgument((boolean)cmd.hasOption("trigger-mag"), (Object)"trigger magnitude not supplied");
            double mag = Double.parseDouble(cmd.getOptionValue("trigger-mag"));
            if (cmd.hasOption("trigger-rake")) {
                mainshockRup.setAveRake(Double.parseDouble(cmd.getOptionValue("trigger-rake")));
            } else {
                mainshockRup.setAveRake(0.0);
            }
            mainshockRup.setMag(mag);
            mainshockRup.setPointSurface(triggerHypo);
            mainshockRup.setID(0);
            mainshockRup.setHypocenterLocation(triggerHypo);
            this.simulationName = "Pt Source. M=" + mag + ", " + String.valueOf(triggerHypo);
            this.triggerRup = mainshockRup;
        } else {
            Preconditions.checkArgument((!cmd.hasOption("trigger-mag") ? 1 : 0) != 0, (Object)"trigger location not supplied");
            this.simulationName = "Spontaneous events";
        }
        this.metadataOnly = cmd.hasOption("metadata-only");
        if (cmd.hasOption("grid-seis-correction")) {
            File cacheFile = new File(inputDir, "griddedSeisCorrectionCache");
            if (this.rank == 0) {
                this.debug("Loading gridded seismicity correction cache file from " + cacheFile.getAbsolutePath());
            }
            this.gridSeisCorrections = MatrixIO.doubleArrayFromFile(cacheFile);
            for (int i = 0; i < this.sols.length; ++i) {
                ETAS_Simulator.correctGriddedSeismicityRatesInERF(this.sols[i], false, this.gridSeisCorrections);
            }
        }
        this.r = new Random(System.nanoTime() + (long)(this.rank * new Random().nextInt()));
    }

    protected int getNumTasks() {
        return this.numSims;
    }

    public String getMemoryDebug() {
        Runtime rt = Runtime.getRuntime();
        long totalMB = rt.totalMemory() / 1024L / 1024L;
        long freeMB = rt.freeMemory() / 1024L / 1024L;
        long usedMB = totalMB - freeMB;
        return "mem t/u/f: " + totalMB + "/" + usedMB + "/" + freeMB;
    }

    protected void calculateBatch(int[] batch) throws Exception {
        if (this.fractionSrcAtPointList == null) {
            File fractionSrcAtPointListFile = new File(this.inputDir, "sectDistForCubeCache");
            File srcAtPointListFile = new File(this.inputDir, "sectInCubeCache");
            File isCubeInsideFaultPolygonFile = new File(this.inputDir, "cubeInsidePolyCache");
            Preconditions.checkState((boolean)fractionSrcAtPointListFile.exists(), (Object)("cache file not found: " + fractionSrcAtPointListFile.getAbsolutePath()));
            Preconditions.checkState((boolean)srcAtPointListFile.exists(), (Object)("cache file not found: " + srcAtPointListFile.getAbsolutePath()));
            Preconditions.checkState((boolean)isCubeInsideFaultPolygonFile.exists(), (Object)("cache file not found: " + isCubeInsideFaultPolygonFile.getAbsolutePath()));
            this.debug("loading cache from " + fractionSrcAtPointListFile.getAbsolutePath() + " (" + this.getMemoryDebug() + ")");
            this.fractionSrcAtPointList = MatrixIO.floatArraysListFromFile(fractionSrcAtPointListFile);
            this.debug("loading cache from " + srcAtPointListFile.getAbsolutePath() + " (" + this.getMemoryDebug() + ")");
            this.srcAtPointList = MatrixIO.intArraysListFromFile(srcAtPointListFile);
            this.debug("loading cache from " + srcAtPointListFile.getAbsolutePath() + " (" + this.getMemoryDebug() + ")");
            this.isCubeInsideFaultPolygon = MatrixIO.intArrayFromFile(isCubeInsideFaultPolygonFile);
            this.debug("done loading caches (" + this.getMemoryDebug() + ")");
        }
        ArrayDeque<Integer> queue = new ArrayDeque<Integer>(Ints.asList((int[])batch));
        HashMap restartsMap = Maps.newHashMap();
        while (!queue.isEmpty()) {
            this.calcForDeque(queue, restartsMap);
        }
    }

    private void calcForDeque(Deque<Integer> queue, Map<Integer, Integer> restartsMap) throws InterruptedException {
        CalcThread[] threads = new CalcThread[this.getNumThreads()];
        for (int i = 0; i < threads.length; ++i) {
            threads[i] = new CalcThread(this.outputDir, this.sols[i], queue, restartsMap);
        }
        for (CalcThread thread : threads) {
            thread.start();
        }
        for (CalcThread thread : threads) {
            thread.join();
        }
    }

    private File getResultsDir(int index) {
        File outputDir = new File(this.outputDir, "results");
        if (!outputDir.exists()) {
            outputDir.mkdir();
        }
        String runName = "" + index;
        int desiredLen = ("" + (this.getNumTasks() - 1)).length();
        while (runName.length() < desiredLen) {
            runName = "0" + runName;
        }
        runName = "sim_" + runName;
        return new File(outputDir, runName);
    }

    private void consolidateBinary() throws IOException {
        File outputFile = new File(this.outputDir, "results.bin");
        File resultsDir = new File(this.outputDir, "results");
        ETAS_CatalogIO.consolidateResultsDirBinary(resultsDir, outputFile, -10.0);
    }

    private void writeMetadata(File metadataFile, AbstractERF erf, ETAS_ParameterList params) throws IOException {
        Document doc = XMLUtils.createDocumentWithRoot();
        Element root = doc.getRootElement();
        Element otherParamsEl = root.addElement(OTHER_PARAMS_EL_NAME);
        otherParamsEl.addAttribute("includeSpontEvents", "" + this.includeSpontEvents);
        otherParamsEl.addAttribute("includeIndirectTriggering", "" + this.includeIndirectTriggering);
        otherParamsEl.addAttribute("gridSeisDiscr", "" + this.gridSeisDiscr);
        otherParamsEl.addAttribute("numSimulations", "" + this.numSims);
        otherParamsEl.addAttribute("duration", "" + this.duration);
        otherParamsEl.addAttribute("ot", "" + this.ot);
        otherParamsEl.addAttribute("binaryOutput", "" + this.binaryOutput);
        erf.toXMLMetadata(root);
        params.toXMLMetadata(root);
        this.griddedRegion.toXMLMetadata(root);
        if (this.triggerRup != null) {
            Element triggerEl = root.addElement(TRIGGER_RUP_EL_NAME);
            if (this.triggerRup.getHypocenterLocation() == null) {
                this.triggerRup.setHypocenterLocation(this.triggerRup.getRuptureSurface().getFirstLocOnUpperEdge());
            }
            triggerEl.addCDATA(ETAS_CatalogIO.getEventFileLine(this.triggerRup));
        }
        if (this.histQkList != null && !this.histQkList.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (ETAS_EqkRupture rup : this.histQkList) {
                sb.append(ETAS_CatalogIO.getEventFileLine(rup)).append("\n");
            }
            Element catEl = root.addElement(HIST_CAT_EL_NAME);
            catEl.addCDATA(sb.toString());
        }
        this.debug("Writing metadata to " + metadataFile.getAbsolutePath());
        XMLUtils.writeDocumentToFile(metadataFile, doc);
    }

    private static long getPrevRandSeed(File resultsDir) throws IOException {
        File infoFile = new File(resultsDir, "infoString.txt");
        if (!infoFile.exists()) {
            return -1L;
        }
        for (String line : Files.readLines((File)infoFile, (Charset)Charset.defaultCharset())) {
            if (!line.contains("randomSeed=")) continue;
            line = line.trim();
            line = line.substring(line.indexOf("=") + 1);
            return Long.parseLong(line);
        }
        return -1L;
    }

    protected void doFinalAssembly() throws Exception {
    }

    public static Options createOptions() {
        Options ops = MPJTaskCalculator.createOptions();
        Option triggerRupID = new Option("r", "trigger-rupture-id", true, "Trigger FSS rupture ID");
        triggerRupID.setRequired(false);
        ops.addOption(triggerRupID);
        Option triggerLoc = new Option("l", "trigger-loc", true, "Trigger location in format lat,lon,depth");
        triggerLoc.setRequired(false);
        ops.addOption(triggerLoc);
        Option triggerMag = new Option("m", "trigger-mag", true, "Trigger magnitude for point source (used with --trigger-loc)");
        triggerMag.setRequired(false);
        ops.addOption(triggerMag);
        Option triggerRake = new Option("tr", "trigger-rake", true, "Trigger rake for point source (used with --trigger-loc, default=0)");
        triggerRake.setRequired(false);
        ops.addOption(triggerRake);
        Option triggerCat = new Option("tc", "trigger-catalog", true, "Trigger catalog in UCERF3 format (no fault sources)");
        triggerCat.setRequired(false);
        ops.addOption(triggerCat);
        Option rupSurfaces = new Option("rs", "rupture-surfaces", true, "Trigger catalog rupture surfaces");
        triggerCat.setRequired(false);
        ops.addOption(rupSurfaces);
        Option startYear = new Option("y", "start-year", true, "Start year for simulation (Default: 2014)");
        startYear.setRequired(false);
        ops.addOption(startYear);
        Option millis = new Option("millis", "millis", true, "Start time for simulation in epoch milliseconds (Default uses --start-year)");
        millis.setRequired(false);
        ops.addOption(millis);
        Option numSims = new Option("n", "num", true, "Number of simulations");
        numSims.setRequired(true);
        ops.addOption(numSims);
        Option solFile = new Option("s", "sol-file", true, "Solution File");
        solFile.setRequired(true);
        ops.addOption(solFile);
        Option duration = new Option("d", "duration", true, "Simulation duration (years), default=1yr");
        duration.setRequired(false);
        ops.addOption(duration);
        Option noSpont = new Option("ns", "no-spontaneous", false, "Flag to disable spontaneous ruptures");
        noSpont.setRequired(false);
        ops.addOption(noSpont);
        Option indep = new Option("i", "indep", false, "Time independent probabilities. Elastic rebound will still be applied for fault initiating event and any triggered events.");
        indep.setRequired(false);
        ops.addOption(indep);
        Option probModel = new Option("p", "prob-model", true, "U3-ETAS probabilidy model. Options: " + Joiner.on((String)",").join((Iterable)Lists.newArrayList((Object[])U3ETAS_ProbabilityModelOptions.values())) + ". Default: " + U3ETAS_ProbabilityModelParam.DEFAULT.name());
        probModel.setRequired(false);
        ops.addOption(probModel);
        Option imposeGROption = new Option("gr", "impose-gr", false, "Impose G-R.");
        imposeGROption.setRequired(false);
        ops.addOption(imposeGROption);
        Option applyLongTermOption = new Option("subseissupra", "apply-sub-seis-for-supra-nucl", true, "Flag to apply/disable whether to correct gridded seismicity rates soas not to be less than the expected rate of aftershocks from supraseismogenic events. Default: true");
        applyLongTermOption.setRequired(false);
        ops.addOption(applyLongTermOption);
        Option binaryOption = new Option("b", "binary", false, "Enables binary output. Default is ASCII.");
        binaryOption.setRequired(false);
        ops.addOption(binaryOption);
        Option metadataOnly = new Option("md", "metadata-only", false, "Write XML metadata file and exit.");
        metadataOnly.setRequired(false);
        ops.addOption(metadataOnly);
        Option gridSeisCorrectRates = new Option("gscorr", "grid-seis-correction", false, "Apply gridded seismicity correction using file in cache directory");
        gridSeisCorrectRates.setRequired(false);
        ops.addOption(gridSeisCorrectRates);
        Option totRateScaleFactor = new Option("scale", "tot-rate-scale-factor", true, "Total rate scale factor. Default: " + U3ETAS_TotalRateScaleFactorParam.DEFAULT_VALUE);
        totRateScaleFactor.setRequired(false);
        ops.addOption(totRateScaleFactor);
        Option griddedOnly = new Option("grid", "gridded-only", false, "Flag for the gridded seismicity only model");
        griddedOnly.setRequired(false);
        ops.addOption(griddedOnly);
        Option resetSections = new Option("reset", "reset-sections", true, "Reset date of last event of the given sub sections. Format: epochMillis:s1,s2,...,sn[;epochMillis1:s1,s2]");
        resetSections.setRequired(false);
        ops.addOption(resetSections);
        return ops;
    }

    public static void main(String[] args) {
        try {
            args = MPJTaskCalculator.initMPJ((String[])args);
            Options options = MPJ_ETAS_Simulator.createOptions();
            CommandLine cmd = MPJ_ETAS_Simulator.parse((Options)options, (String[])args, MPJ_ETAS_Simulator.class);
            args = cmd.getArgs();
            if (args.length != 2) {
                System.err.println("USAGE: " + ClassUtils.getClassNameWithoutPackage(MPJ_ETAS_Simulator.class) + " [options] <input-dir> <output-dir>");
                MPJ_ETAS_Simulator.abortAndExit((int)2);
            }
            File inputDir = new File(args[0]);
            Preconditions.checkArgument((boolean)inputDir.exists(), (Object)("input directory doesn't exist: " + inputDir.getAbsolutePath()));
            File outputDir = new File(args[1]);
            Preconditions.checkArgument((outputDir.exists() || outputDir.mkdir() ? 1 : 0) != 0, (Object)("output directory doesn't exist: " + outputDir.getAbsolutePath()));
            MPJ_ETAS_Simulator driver = new MPJ_ETAS_Simulator(cmd, inputDir, outputDir);
            driver.run();
            if (driver.rank == 0 && driver.binaryOutput) {
                driver.consolidateBinary();
            }
            MPJ_ETAS_Simulator.finalizeMPJ();
            System.exit(0);
        }
        catch (Throwable t) {
            MPJ_ETAS_Simulator.abortAndExit((Throwable)t);
        }
    }

    private class CalcThread
    extends Thread {
        private File outputDir;
        private FaultSystemSolution sol;
        private Deque<Integer> queue;
        private Map<Integer, Integer> restartsMap;

        private CalcThread(File outputDir, FaultSystemSolution sol, Deque<Integer> queue, Map<Integer, Integer> restartsMap) {
            this.outputDir = outputDir;
            this.sol = sol;
            this.queue = queue;
            this.restartsMap = restartsMap;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            if (MPJ_ETAS_Simulator.this.metadataOnly && MPJ_ETAS_Simulator.this.rank > 0) {
                this.queue.clear();
                return;
            }
            while (!this.queue.isEmpty()) {
                long l;
                AbstractNthRupERF erf;
                Deque<Integer> deque = this.queue;
                // MONITORENTER : deque
                Integer index = this.queue.poll();
                // MONITOREXIT : deque
                if (index == null) {
                    return;
                }
                System.gc();
                File resultsDir = MPJ_ETAS_Simulator.this.getResultsDir(index);
                if (!MPJ_ETAS_Simulator.this.metadataOnly && ETAS_Launcher.isAlreadyDone(resultsDir)) {
                    MPJ_ETAS_Simulator.this.debug(index + " is already done: " + resultsDir.getName());
                    continue;
                }
                MPJ_ETAS_Simulator.this.debug("calculating " + index);
                if (MPJ_ETAS_Simulator.this.timeIndep) {
                    for (FaultSection faultSection : this.sol.getRupSet().getFaultSectionDataList()) {
                        faultSection.setDateOfLastEvent(Long.MIN_VALUE);
                    }
                } else {
                    LastEventData.populateSubSects(this.sol.getRupSet().getFaultSectionDataList(), MPJ_ETAS_Simulator.this.lastEventData);
                }
                MPJ_ETAS_Simulator.this.debug("Instantiationg ERF");
                if (MPJ_ETAS_Simulator.this.griddedOnly) {
                    erf = new UCERF3_GriddedSeisOnlyERF_ETAS();
                    erf.setParameter("Treat Background Seismicity As", (Object)BackgroundRupType.POINT);
                    erf.setParameter("Apply Aftershock Filter", false);
                    erf.setParameter("Maximum Magnitude", 8.3);
                    erf.setParameter("Total Regional Rate", TotalMag5Rate.RATE_7p9);
                    erf.setParameter("Spatial Seis PDF", SpatialSeisPDF.UCERF3);
                    erf.getTimeSpan().setStartTimeInMillis(MPJ_ETAS_Simulator.this.ot);
                    erf.getTimeSpan().setDuration(MPJ_ETAS_Simulator.this.duration);
                    erf.updateForecast();
                } else {
                    erf = ETAS_Launcher.buildERF_millis(this.sol, MPJ_ETAS_Simulator.this.timeIndep, MPJ_ETAS_Simulator.this.duration, MPJ_ETAS_Simulator.this.ot);
                    if (MPJ_ETAS_Simulator.this.fssScenarioRupID >= 0) {
                        ((FaultSystemSolutionERF_ETAS)erf).setFltSystemSourceOccurranceTimeForFSSIndex(MPJ_ETAS_Simulator.this.fssScenarioRupID, MPJ_ETAS_Simulator.this.ot);
                    }
                    erf.updateForecast();
                }
                MPJ_ETAS_Simulator.this.debug("Done instantiating ERF");
                try {
                    l = MPJ_ETAS_Simulator.getPrevRandSeed(resultsDir);
                }
                catch (IOException e) {
                    throw ExceptionUtils.asRuntimeException(e);
                }
                if (l > 0L && this.restartsMap.get(index) == null) {
                    MPJ_ETAS_Simulator.this.debug("Resuming old rand seed of " + l + " for " + resultsDir.getName());
                } else {
                    l = MPJ_ETAS_Simulator.this.r.nextLong();
                }
                ETAS_ParameterList params = new ETAS_ParameterList();
                params.setImposeGR(MPJ_ETAS_Simulator.this.imposeGR);
                params.setU3ETAS_ProbModel(MPJ_ETAS_Simulator.this.probModel);
                params.setApplyGridSeisCorr(MPJ_ETAS_Simulator.this.gridSeisCorrections != null);
                params.setApplySubSeisForSupraNucl(MPJ_ETAS_Simulator.this.applySubSeisForSupraNucl);
                params.setTotalRateScaleFactor(MPJ_ETAS_Simulator.this.totRateScaleFactor);
                if (MPJ_ETAS_Simulator.this.rank == 0) {
                    Class<MPJ_ETAS_Simulator> clazz = MPJ_ETAS_Simulator.class;
                    // MONITORENTER : scratch.kevin.ucerf3.etas.MPJ_ETAS_Simulator.class
                    File metadataFile = new File(this.outputDir, "metadata.xml");
                    if (!metadataFile.exists()) {
                        try {
                            MPJ_ETAS_Simulator.this.writeMetadata(metadataFile, erf, params);
                        }
                        catch (IOException e) {
                            System.err.println("WARNING: Failed to write metadata to " + metadataFile.getAbsolutePath());
                            e.printStackTrace();
                        }
                    }
                    // MONITOREXIT : clazz
                    if (MPJ_ETAS_Simulator.this.metadataOnly) {
                        this.queue.clear();
                        return;
                    }
                }
                try {
                    if (MPJ_ETAS_Simulator.this.griddedOnly) {
                        double gridSeisDiscr = 0.1;
                        ETAS_Simulator_NoFaults.runETAS_Simulation(resultsDir, (AbstractNthRupERF)((UCERF3_GriddedSeisOnlyERF_ETAS)erf), MPJ_ETAS_Simulator.this.griddedRegion, MPJ_ETAS_Simulator.this.triggerRup, MPJ_ETAS_Simulator.this.histQkList, MPJ_ETAS_Simulator.this.includeSpontEvents, MPJ_ETAS_Simulator.this.includeIndirectTriggering, gridSeisDiscr, MPJ_ETAS_Simulator.this.simulationName, (Long)l, params, null);
                    } else {
                        ETAS_Simulator.runETAS_Simulation(resultsDir, (AbstractNthRupERF)((FaultSystemSolutionERF_ETAS)erf), MPJ_ETAS_Simulator.this.griddedRegion, MPJ_ETAS_Simulator.this.triggerRup, MPJ_ETAS_Simulator.this.histQkList, MPJ_ETAS_Simulator.this.includeSpontEvents, MPJ_ETAS_Simulator.this.includeIndirectTriggering, MPJ_ETAS_Simulator.this.gridSeisDiscr, MPJ_ETAS_Simulator.this.simulationName, (Long)l, MPJ_ETAS_Simulator.this.fractionSrcAtPointList, MPJ_ETAS_Simulator.this.srcAtPointList, MPJ_ETAS_Simulator.this.isCubeInsideFaultPolygon, params, null, null);
                    }
                    MPJ_ETAS_Simulator.this.debug("completed " + index);
                    if (!MPJ_ETAS_Simulator.this.binaryOutput) continue;
                    File asciiFile = new File(resultsDir, "simulatedEvents.txt");
                    ETAS_CatalogIO.ETAS_Catalog catalog = ETAS_CatalogIO.loadCatalog(asciiFile);
                    File binaryFile = new File(resultsDir, "simulatedEvents.bin");
                    ETAS_CatalogIO.writeCatalogBinary(binaryFile, (List<ETAS_EqkRupture>)catalog);
                    if (binaryFile.length() > 0L) {
                        asciiFile.delete();
                    } else {
                        binaryFile.delete();
                    }
                    MPJ_ETAS_Simulator.this.debug("completed binary output " + index);
                }
                catch (Throwable t) {
                    MPJ_ETAS_Simulator.this.debug("Calc failed with seed " + l + ". Exception: " + String.valueOf(t));
                    t.printStackTrace();
                    if (t.getCause() != null) {
                        System.out.println("cause exceptoin:");
                        t.getCause().printStackTrace();
                    }
                    System.err.flush();
                    Deque<Integer> deque2 = this.queue;
                    // MONITORENTER : deque2
                    Integer prevFails = this.restartsMap.get(index);
                    if (prevFails == null) {
                        prevFails = 0;
                    }
                    if (prevFails == 2) {
                        MPJ_ETAS_Simulator.this.debug("Index " + index + " failed 3 times, bailing");
                        ExceptionUtils.throwAsRuntimeException(t);
                    }
                    this.restartsMap.put(index, prevFails + 1);
                    MPJ_ETAS_Simulator.this.debug("retrying " + index + " later");
                    this.queue.add(index);
                    // MONITOREXIT : deque2
                }
            }
        }
    }
}

