/*
 * Decompiled with CFR 0.152.
 */
package scratch.kevin.ucerf3.etas;

import com.google.common.base.Preconditions;
import com.google.common.io.Files;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import org.opensha.commons.data.comcat.ComcatAccessor;
import org.opensha.commons.data.comcat.ComcatRegionAdapter;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationList;
import org.opensha.commons.geo.Region;
import org.opensha.sha.earthquake.observedEarthquake.ObsEqkRupList;
import org.opensha.sha.earthquake.observedEarthquake.ObsEqkRupture;
import org.opensha.sha.faultSurface.FaultTrace;
import org.opensha.sha.faultSurface.SimpleFaultData;
import scratch.UCERF3.enumTreeBranches.FaultModels;
import scratch.UCERF3.erf.ETAS.ETAS_Params.U3ETAS_ProbabilityModelOptions;
import scratch.UCERF3.erf.ETAS.analysis.ETAS_AbstractPlot;
import scratch.UCERF3.erf.ETAS.launcher.ETAS_Config;
import scratch.UCERF3.erf.ETAS.launcher.TriggerRupture;

public class SearlessValleyConfigGen {
    public static final DateFormat df = new SimpleDateFormat("yyyy_MM_dd");

    public static void main(String[] args) throws IOException {
        File fssFile;
        File cacheDir;
        FaultTrace trace = new FaultTrace("Searless Valley");
        trace.add(new Location(35.91, -117.742));
        trace.add(new Location(35.618, -117.417));
        SimpleFaultData sfd = new SimpleFaultData(90.0, 12.0, 0.0, trace);
        boolean mpj = true;
        HPC_Sites hpcSite = HPC_Sites.HPC;
        FaultModels fm = FaultModels.FM3_1;
        boolean u2 = false;
        Integer startYear = null;
        Long startTimeMillis = 1562383193000L;
        String nameAdd = "following-M7.1";
        boolean histCatalog = false;
        boolean includeSpontaneous = false;
        int numSimulations = 100000;
        double duration = 10.0;
        Long randomSeed = 123456789L;
        Boolean reuseERFs = true;
        U3ETAS_ProbabilityModelOptions probModel = U3ETAS_ProbabilityModelOptions.FULL_TD;
        Double p = null;
        Double c = null;
        Double log10k = null;
        ArrayList<TriggerRupture> triggerList = new ArrayList<TriggerRupture>();
        ComcatAccessor comcat = new ComcatAccessor();
        long catStartTime = new GregorianCalendar(2019, 6, 1).getTimeInMillis();
        long catEndTime = startTimeMillis;
        double lenDays = (double)(catEndTime - catStartTime) / 1000.0 / 60.0 / 60.0 / 24.0;
        System.out.println("Comcat length: " + lenDays + " days");
        Region comcatRegion = new Region((LocationList)trace, 100.0);
        ObsEqkRupList comcatRups = comcat.fetchEventList(null, catStartTime, catEndTime, -1.0, 100.0, new ComcatRegionAdapter(comcatRegion), false, false, 2.5);
        System.out.println("Got " + comcatRups.size() + " ruptures from Comcat");
        boolean m7Found = false;
        for (ObsEqkRupture rup : comcatRups) {
            Preconditions.checkState((rup.getOriginTime() <= startTimeMillis ? 1 : 0) != 0);
            if (rup.getMag() > 7.0) {
                Preconditions.checkState((!m7Found ? 1 : 0) != 0);
                m7Found = true;
                System.out.println("Found M" + (float)rup.getMag());
                triggerList.add(new TriggerRupture.SimpleFault((Long)rup.getOriginTime(), rup.getHypocenterLocation(), rup.getMag(), sfd));
                continue;
            }
            triggerList.add(new TriggerRupture.Point(rup.getHypocenterLocation(), rup.getOriginTime(), rup.getMag()));
        }
        TriggerRupture[] triggerRups = triggerList.toArray(new TriggerRupture[0]);
        String scenarioName = "Searless Valley Sequence Finite Fault";
        Object customCatalogName = null;
        int nodes = 36;
        int hours = 24;
        String queue = hpcSite == HPC_Sites.HPC ? "scec_hiprio" : null;
        Integer threads = null;
        if (hpcSite == HPC_Sites.HPC && threads != null && threads > 12) {
            throw new IllegalStateException("did you set the threads right?");
        }
        File mainOutputDir = new File("${ETAS_SIM_DIR}");
        File launcherDir = new File("${ETAS_LAUNCHER}");
        File inputsDir = new File(launcherDir, "inputs");
        switch (fm) {
            case FM3_1: {
                if (u2) {
                    cacheDir = new File(inputsDir, "cache_u2_mapped_fm3p1");
                    fssFile = new File(inputsDir, "ucerf2_mapped_fm3p1.zip");
                    break;
                }
                cacheDir = new File(inputsDir, "cache_fm3p1_ba");
                fssFile = new File(inputsDir, "2013_05_10-ucerf3p3-production-10runs_COMPOUND_SOL_FM3_1_SpatSeisU3_MEAN_BRANCH_AVG_SOL.zip");
                break;
            }
            case FM3_2: {
                Preconditions.checkState((!u2 ? 1 : 0) != 0);
                cacheDir = new File(inputsDir, "cache_fm3p2_ba");
                fssFile = new File(inputsDir, "2013_05_10-ucerf3p3-production-10runs_COMPOUND_SOL_FM3_2_SpatSeisU3_MEAN_BRANCH_AVG_SOL.zip");
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        File triggerCatalog = null;
        File triggerCatalogSurfaceMappings = null;
        Preconditions.checkState((customCatalogName == null || !histCatalog ? 1 : 0) != 0, (Object)"Can't have both custom catalog and historical catalog");
        if (histCatalog) {
            triggerCatalog = new File(inputsDir, "u3_historical_catalog.txt");
            triggerCatalogSurfaceMappings = new File(inputsDir, "u3_historical_catalog_finite_fault_mappings.xml");
        }
        String dateStr = df.format(new Date());
        Preconditions.checkNotNull((Object)scenarioName);
        Object scenarioFileName = scenarioName.replaceAll(" ", "-").replaceAll("\\W+", "");
        if (u2) {
            scenarioFileName = fm == FaultModels.FM2_1 ? (String)scenarioFileName + "-u2" : (String)scenarioFileName + "-u2mapped";
        }
        scenarioFileName = includeSpontaneous ? (String)scenarioFileName + "-includeSpont" : (String)scenarioFileName + "-noSpont";
        if (histCatalog) {
            scenarioFileName = (String)scenarioFileName + "-historicalCatalog";
        }
        scenarioFileName = (String)scenarioFileName + "-" + probModel.name().toLowerCase();
        scenarioFileName = (String)scenarioFileName + "-" + ETAS_AbstractPlot.getTimeShortLabel(duration).replaceAll(" ", "");
        if (nameAdd != null && !nameAdd.isEmpty()) {
            scenarioFileName = (String)scenarioFileName + "-" + nameAdd;
        }
        String jobName = dateStr + "-" + (String)scenarioFileName;
        System.out.println("Job dir name: " + jobName);
        File outputDir = new File(mainOutputDir, jobName);
        File localOutputDir = ETAS_Config.resolvePath(outputDir.getPath());
        Preconditions.checkState((localOutputDir.exists() || localOutputDir.mkdir() ? 1 : 0) != 0);
        ETAS_Config config = new ETAS_Config(numSimulations, duration, includeSpontaneous, cacheDir, fssFile, outputDir, triggerCatalog, triggerCatalogSurfaceMappings, triggerRups);
        config.setReuseERFs(reuseERFs);
        config.setSimulationName(scenarioName);
        config.setRandomSeed(randomSeed);
        config.setProbModel(probModel);
        Preconditions.checkState((startYear == null || startTimeMillis == null ? 1 : 0) != 0, (Object)"cannot supply both startYear and startTimeMillis");
        Preconditions.checkState((startYear != null || startTimeMillis != null ? 1 : 0) != 0, (Object)"must supply either startYear and startTimeMillis");
        if (startYear != null) {
            config.setStartYear(startYear);
        } else {
            config.setStartTimeMillis(startTimeMillis);
        }
        if (p != null) {
            config.setETAS_P(p);
        }
        if (c != null) {
            config.setETAS_C(c);
        }
        if (log10k != null) {
            config.setETAS_Log10_K(log10k);
        }
        File configFile = new File(outputDir, "config.json");
        File localConfFile = new File(localOutputDir, "config.json");
        config.writeJSON(localConfFile);
        if (mpj) {
            File templateDir = ETAS_Config.resolvePath(new File(new File(launcherDir, "parallel"), "mpj_examples").getPath());
            File slurmScriptFile = new File(localOutputDir, "etas_sim_mpj.slurm");
            File template = new File(templateDir, hpcSite.fileName);
            SearlessValleyConfigGen.updateSlurmScript(template, slurmScriptFile, nodes, threads, hours, queue, configFile);
        }
    }

    public static void updateSlurmScript(File inputFile, File outputFile, int nodes, Integer threads, int hours, String queue, File configFile) throws IOException {
        ArrayList<Object> lines = new ArrayList<Object>();
        boolean nodeLineFound = true;
        int lastIndexSBATCH = -1;
        for (Object line : Files.readLines((File)inputFile, (Charset)Charset.defaultCharset())) {
            if (((String)(line = ((String)line).trim())).startsWith("#SBATCH -t")) {
                line = "#SBATCH -t " + hours + ":00:00";
            }
            if (((String)line).startsWith("#SBATCH -N")) {
                line = "#SBATCH -N " + nodes;
            }
            if (((String)line).startsWith("#SBATCH -n")) {
                int n = threads == null ? nodes : nodes * threads;
                line = "#SBATCH -n " + n;
            }
            if (((String)line).startsWith("#SBATCH -p")) {
                nodeLineFound = true;
                if (queue != null) {
                    line = "#SBATCH -p " + queue;
                }
            }
            if (((String)line).startsWith("ETAS_CONF_JSON=")) {
                line = "ETAS_CONF_JSON=" + configFile.getPath();
            }
            if (((String)line).startsWith("#SBATCH")) {
                lastIndexSBATCH = lines.size();
            }
            if (threads != null && ((String)line).startsWith("THREADS=")) {
                line = "THREADS=" + threads;
            }
            lines.add(line);
        }
        Preconditions.checkState((lastIndexSBATCH >= 0 ? 1 : 0) != 0);
        if (queue != null && !nodeLineFound) {
            lines.add(lastIndexSBATCH + 1, "#SBATCH -p " + queue);
        }
        FileWriter fw = new FileWriter(outputFile);
        for (String string : lines) {
            fw.write(string + "\n");
        }
        fw.close();
    }

    private static enum HPC_Sites {
        HPC("usc_hpcc_mpj_express.slurm"),
        Stampede2("tacc_stampede2_fastmpj.slurm");

        private String fileName;

        private HPC_Sites(String fileName) {
            this.fileName = fileName;
        }
    }
}

