/*
 * Decompiled with CFR 0.152.
 */
package scratch.kevin.ucerf3.etas.weeklyRuns;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Doubles;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.TimeZone;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.commons.math3.stat.StatUtils;
import org.jfree.chart.annotations.XYAnnotation;
import org.jfree.chart.annotations.XYTextAnnotation;
import org.jfree.chart.plot.DatasetRenderingOrder;
import org.jfree.chart.title.PaintScaleLegend;
import org.jfree.chart.title.Title;
import org.jfree.chart.ui.RectangleEdge;
import org.jfree.chart.ui.TextAnchor;
import org.jfree.data.Range;
import org.opensha.commons.data.CSVFile;
import org.opensha.commons.data.comcat.ComcatAccessor;
import org.opensha.commons.data.comcat.ComcatRegionAdapter;
import org.opensha.commons.data.function.AbstractDiscretizedFunc;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.data.function.DefaultXY_DataSet;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.commons.data.function.EvenlyDiscretizedFunc;
import org.opensha.commons.data.function.HistogramFunction;
import org.opensha.commons.data.function.XY_DataSet;
import org.opensha.commons.data.region.CaliforniaRegions;
import org.opensha.commons.data.xyz.EvenlyDiscrXYZ_DataSet;
import org.opensha.commons.gui.plot.GraphPanel;
import org.opensha.commons.gui.plot.HeadlessGraphPanel;
import org.opensha.commons.gui.plot.PlotCurveCharacterstics;
import org.opensha.commons.gui.plot.PlotLineType;
import org.opensha.commons.gui.plot.PlotPreferences;
import org.opensha.commons.gui.plot.PlotSpec;
import org.opensha.commons.gui.plot.PlotSymbol;
import org.opensha.commons.gui.plot.jfreechart.xyzPlot.XYZPlotSpec;
import org.opensha.commons.mapping.gmt.elements.GMT_CPT_Files;
import org.opensha.commons.util.DataUtils;
import org.opensha.commons.util.ExceptionUtils;
import org.opensha.commons.util.FileNameComparator;
import org.opensha.commons.util.MarkdownUtils;
import org.opensha.commons.util.cpt.CPT;
import org.opensha.commons.util.cpt.CPTVal;
import org.opensha.sha.earthquake.EqkRupture;
import org.opensha.sha.earthquake.observedEarthquake.ObsEqkRupList;
import org.opensha.sha.earthquake.observedEarthquake.ObsEqkRupture;
import org.opensha.sha.earthquake.observedEarthquake.parsers.UCERF3_CatalogParser;
import scratch.UCERF3.erf.ETAS.analysis.ETAS_ComcatComparePlot;
import scratch.UCERF3.erf.ETAS.launcher.ETAS_Config;

public class PostProcessPageGen {
    public static void main(String[] args) throws IOException {
        int d;
        int maxNum = Integer.MAX_VALUE;
        File outputParentDir = new File("/home/kevin/git/ucerf3-etas-results/2020-weekly-runs");
        int[] highlightYears = new int[]{1992, 1999, 2010, 2019};
        File dataDir = new File("/home/kevin/OpenSHA/UCERF3/etas/simulations/2020_05_14-weekly-1986-present-full_td-kCOV1.5");
        File outputDir = new File(outputParentDir, dataDir.getName());
        Preconditions.checkState((outputDir.exists() || outputDir.mkdir() ? 1 : 0) != 0);
        File resourcesDir = new File(outputDir, "resources");
        Preconditions.checkState((resourcesDir.exists() || resourcesDir.mkdir() ? 1 : 0) != 0);
        File u3CatalogFile = ETAS_Config.resolvePath("${ETAS_LAUNCHER}/inputs/u3_historical_catalog.txt");
        ObsEqkRupList u3Catalog = UCERF3_CatalogParser.loadCatalog(u3CatalogFile);
        long comcatStartMillis = ((ObsEqkRupture)u3Catalog.get(u3Catalog.size() - 1)).getOriginTime();
        System.out.println("Fetching ComCat events");
        ComcatAccessor accessor = new ComcatAccessor();
        ComcatRegionAdapter cReg = new ComcatRegionAdapter(new CaliforniaRegions.RELM_TESTING());
        long curTime = System.currentTimeMillis();
        ObsEqkRupList comcatEvents = accessor.fetchEventList(null, comcatStartMillis, curTime, -10.0, 24.0, cReg, false, false, 2.5);
        ObsEqkRupList combEvents = new ObsEqkRupList();
        combEvents.addAll(u3Catalog);
        combEvents.addAll(comcatEvents);
        combEvents.sortByOriginTime();
        double[] minMags = new double[]{2.5, 3.0, 4.0, 5.0, 6.0, 7.0};
        double[] scatterDurations = new double[]{1.0, 7.0, 30.0, 365.0};
        String[] scatterDurationLabels = new String[]{"1 Day", "1 Week", "1 Month", "1 Year"};
        double[] dailyMags = new double[]{2.5, 5.0, 7.0};
        PlotCurveCharacterstics[] dailyDataChars = new PlotCurveCharacterstics[]{new PlotCurveCharacterstics(PlotSymbol.CIRCLE, 2.0f, new Color(0, 0, 0, 180)), new PlotCurveCharacterstics(PlotSymbol.FILLED_CIRCLE, 4.0f, Color.BLUE), new PlotCurveCharacterstics(PlotSymbol.FILLED_CIRCLE, 6.0f, Color.RED)};
        PlotCurveCharacterstics[] dailySimChars = new PlotCurveCharacterstics[]{new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.BLACK), new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.BLUE), new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.RED)};
        HistogramFunction histAxis = HistogramFunction.getEncompassingHistogram(-1.0, 4.0, 0.05);
        EvenlyDiscrXYZ_DataSet globalXYZ = new EvenlyDiscrXYZ_DataSet(histAxis.size(), histAxis.size(), histAxis.getMinX(), histAxis.getMinX(), histAxis.getDelta());
        EvenlyDiscrXYZ_DataSet[][] aggregatedXYZs = new EvenlyDiscrXYZ_DataSet[minMags.length][scatterDurations.length];
        for (int m = 0; m < minMags.length; ++m) {
            for (int d2 = 0; d2 < scatterDurations.length; ++d2) {
                aggregatedXYZs[m][d2] = globalXYZ.copy();
            }
        }
        ArrayList<DiscretizedFunc[]> dailyIncrMedianDiffFuncs = new ArrayList<DiscretizedFunc[]>();
        ArrayList<DiscretizedFunc[]> dailyIncrMeanDiffFuncs = new ArrayList<DiscretizedFunc[]>();
        ArrayList<DiscretizedFunc[]> cumulativeMedianDiffFuncs = new ArrayList<DiscretizedFunc[]>();
        ArrayList<DiscretizedFunc[]> cumulativeMeanDiffFuncs = new ArrayList<DiscretizedFunc[]>();
        ArrayList<Double> years = new ArrayList<Double>();
        long earliestStart = Long.MAX_VALUE;
        long lastStart = Long.MIN_VALUE;
        File[] batchDirs = dataDir.listFiles();
        Arrays.sort(batchDirs, new FileNameComparator());
        ExecutorService exec = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
        ArrayList<Future<CalcCallable>> futures = new ArrayList<Future<CalcCallable>>();
        block14: for (File batchDir : batchDirs) {
            if (!batchDir.isDirectory() || !batchDir.getName().startsWith("batch_")) continue;
            System.out.println("processing " + batchDir.getName());
            for (File weekDir : batchDir.listFiles()) {
                if (futures.size() == maxNum) continue block14;
                File resultsDir = new File(weekDir, "aggregated_results");
                if (!resultsDir.exists()) continue;
                System.out.println("\t" + weekDir.getName());
                File configFile = new File(weekDir, "config.json");
                Preconditions.checkState((boolean)configFile.exists());
                ETAS_Config config = ETAS_Config.readJSON(configFile);
                earliestStart = Long.min(earliestStart, config.getSimulationStartTimeMillis());
                lastStart = Long.max(lastStart, config.getSimulationStartTimeMillis());
                futures.add(exec.submit(new CalcCallable(combEvents, curTime, weekDir, config, minMags, scatterDurations, dailyMags, globalXYZ)));
            }
        }
        System.out.println("Waiting on " + futures.size() + " futures...");
        double minYear = PostProcessPageGen.getYear(earliestStart);
        double maxYear = PostProcessPageGen.getYear(lastStart);
        System.out.println("Year range: " + (float)minYear + " => " + (float)maxYear);
        CPT scatterCPT = GMT_CPT_Files.RAINBOW_UNIFORM.instance().rescale(minYear, maxYear);
        scatterCPT = scatterCPT.asDiscrete(10, true);
        double deltaYears = maxYear - minYear;
        double yearInc = deltaYears > 100.0 ? 25.0 : (deltaYears > 50.0 ? 10.0 : (deltaYears > 30.0 ? 5.0 : (deltaYears > 10.0 ? 2.0 : 1.0)));
        PaintScaleLegend scatterBar = GraphPanel.getLegendForCPT(scatterCPT, "Year", 22, 18, yearInc, RectangleEdge.BOTTOM);
        DefaultXY_DataSet[][][] medianMagDurScatters = new DefaultXY_DataSet[scatterCPT.size()][minMags.length][scatterDurations.length];
        DefaultXY_DataSet[][][] meanMagDurScatters = new DefaultXY_DataSet[scatterCPT.size()][minMags.length][scatterDurations.length];
        for (int i = 0; i < scatterCPT.size(); ++i) {
            for (int m = 0; m < minMags.length; ++m) {
                for (int d3 = 0; d3 < scatterDurations.length; ++d3) {
                    medianMagDurScatters[i][m][d3] = new DefaultXY_DataSet();
                    meanMagDurScatters[i][m][d3] = new DefaultXY_DataSet();
                }
            }
        }
        double[][] percentileMeans = new double[minMags.length][scatterDurations.length];
        HistogramFunction[][] percentileFuncs = new HistogramFunction[minMags.length][scatterDurations.length];
        for (int m = 0; m < minMags.length; ++m) {
            for (int d4 = 0; d4 < scatterDurations.length; ++d4) {
                percentileFuncs[m][d4] = new HistogramFunction(2.0, 25, 4.0);
            }
        }
        int[][] dataBelow95ConfCounts = new int[minMags.length][scatterDurations.length];
        int[][] dataAbove95ConfCounts = new int[minMags.length][scatterDurations.length];
        double[][] dataFractZeros = new double[minMags.length][scatterDurations.length];
        double[][] simFractZeros = new double[minMags.length][scatterDurations.length];
        ArrayList<CalcCallable> calls = new ArrayList<CalcCallable>();
        for (Future future : futures) {
            CalcCallable call;
            try {
                call = (CalcCallable)future.get();
            }
            catch (InterruptedException | ExecutionException e) {
                exec.shutdownNow();
                throw ExceptionUtils.asRuntimeException(e);
            }
            calls.add(call);
            dailyIncrMeanDiffFuncs.add(call.meanIncrFuncs);
            dailyIncrMedianDiffFuncs.add(call.medianIncrFuncs);
            cumulativeMeanDiffFuncs.add(call.meanCumulativeFuncs);
            cumulativeMedianDiffFuncs.add(call.medianCumulativeFuncs);
            double year = PostProcessPageGen.getYear(call.startTimeMillis);
            years.add(year);
            int scatterI = 0;
            for (int j = 0; j < scatterCPT.size(); ++j) {
                CPTVal val = (CPTVal)scatterCPT.get(j);
                if (!((double)((float)year) >= val.start) || !((double)((float)year) <= val.end)) continue;
                scatterI = j;
            }
            for (int m = 0; m < minMags.length; ++m) {
                for (int d5 = 0; d5 < scatterDurations.length; ++d5) {
                    meanMagDurScatters[scatterI][m][d5].set(call.dataCumCounts[m][d5], call.meanCumCounts[m][d5]);
                    medianMagDurScatters[scatterI][m][d5].set(call.dataCumCounts[m][d5], call.medianCumCounts[m][d5]);
                    for (int i = 0; i < globalXYZ.size(); ++i) {
                        aggregatedXYZs[m][d5].set(i, aggregatedXYZs[m][d5].get(i) + call.indvXYZs[m][d5].get(i));
                    }
                    double dataPercentile = call.dataPercentiles[m][d5];
                    percentileFuncs[m][d5].add(percentileFuncs[m][d5].getClosestXIndex(dataPercentile), 1.0);
                    double[] dArray = simFractZeros[m];
                    int n = d5;
                    dArray[n] = dArray[n] + call.fractZeros[m][d5] / (double)futures.size();
                    double[] dArray2 = percentileMeans[m];
                    int n2 = d5;
                    dArray2[n2] = dArray2[n2] + dataPercentile / (double)futures.size();
                    if (call.below2p5s[m][d5]) {
                        int[] nArray = dataBelow95ConfCounts[m];
                        int n3 = d5;
                        nArray[n3] = nArray[n3] + 1;
                    }
                    if (call.above97p5s[m][d5]) {
                        int[] nArray = dataAbove95ConfCounts[m];
                        int n4 = d5;
                        nArray[n4] = nArray[n4] + 1;
                    }
                    if (Math.floor(call.dataCumCounts[m][d5]) != 0.0) continue;
                    double[] dArray3 = dataFractZeros[m];
                    int n5 = d5;
                    dArray3[n5] = dArray3[n5] + 1.0 / (double)futures.size();
                }
            }
            if (years.size() % 50 != 0) continue;
            System.out.println("Done with " + years.size() + "/" + futures.size());
        }
        Collections.sort(calls);
        for (int nx = 1; nx < globalXYZ.getNumX(); ++nx) {
            for (int i = 1; i < globalXYZ.getNumY(); ++i) {
                double logNX = Math.log10(nx);
                double logNXp1 = Math.log10(nx + 1);
                double logNY = Math.log10(i);
                double logNYp1 = Math.log10(i + 1);
                int xIndex = histAxis.getClosestXIndex(logNX);
                int yIndex = histAxis.getClosestXIndex(logNY);
                int nextXIndex = histAxis.getClosestXIndex(logNXp1);
                int nextYIndex = histAxis.getClosestXIndex(logNYp1);
                if (nextXIndex - xIndex <= 1 && nextYIndex - yIndex <= 1) continue;
                for (int m = 0; m < minMags.length; ++m) {
                    for (int d6 = 0; d6 < scatterDurations.length; ++d6) {
                        EvenlyDiscrXYZ_DataSet xyz = aggregatedXYZs[m][d6];
                        double val = xyz.get(xIndex, yIndex);
                        for (int x = xIndex; x == xIndex || x < nextXIndex; ++x) {
                            for (int y = yIndex; y == yIndex || y < nextYIndex; ++y) {
                                xyz.set(x, y, val);
                            }
                        }
                    }
                }
            }
        }
        exec.shutdown();
        System.out.println("Plotting");
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("# Aggregated ETAS Weekly Run Data Comparisons");
        lines.add("");
        int n = lines.size();
        String topLink = "*[(top)](#table-of-contents)*";
        lines.add("");
        lines.add("## Data Percentile Histograms");
        lines.add(topLink);
        lines.add("");
        lines.add("Histogram of the percentile of the actual event count within the simulation distribution, for various magnitudes and durations.");
        lines.add("");
        MarkdownUtils.TableBuilder table = MarkdownUtils.tableBuilder();
        table.initNewLine();
        table.addColumn("Min Mag");
        for (String label : scatterDurationLabels) {
            table.addColumn(label);
        }
        table.finalizeLine();
        for (int m = 0; m < minMags.length; ++m) {
            table.initNewLine();
            table.addColumn("**M&ge;" + (float)minMags[m] + "**");
            for (int d7 = 0; d7 < scatterDurations.length; ++d7) {
                ArrayList<AbstractDiscretizedFunc> funcs = new ArrayList<AbstractDiscretizedFunc>();
                ArrayList<PlotCurveCharacterstics> chars = new ArrayList<PlotCurveCharacterstics>();
                funcs.add(percentileFuncs[m][d7]);
                chars.add(new PlotCurveCharacterstics(PlotLineType.HISTOGRAM, 1.0f, Color.GRAY));
                double y = percentileFuncs[m][d7].calcSumOfY_Vals() / (double)percentileFuncs[m][d7].size();
                ArbitrarilyDiscretizedFunc line = new ArbitrarilyDiscretizedFunc();
                line.set(0.0, y);
                line.set(100.0, y);
                funcs.add(line);
                chars.add(new PlotCurveCharacterstics(PlotLineType.DASHED, 4.0f, Color.BLACK));
                Range xRange = new Range(0.0, 100.0);
                Range yRange = new Range(0.0, Math.min(10.0 * y, 1.1 * percentileFuncs[m][d7].getMaxY()));
                PlotSpec spec = new PlotSpec(funcs, chars, " ", "Percentile", "Count");
                DecimalFormat meanDF = new DecimalFormat("0.00");
                DecimalFormat percentDF = new DecimalFormat("0.00%");
                double annY = yRange.getUpperBound() * 0.975;
                XYTextAnnotation meanAnn = new XYTextAnnotation("Mean %-ile: " + meanDF.format(percentileMeans[m][d7]), 5.0, annY);
                Font annFont = new Font("SansSerif", 1, 20);
                meanAnn.setFont(annFont);
                meanAnn.setTextAnchor(TextAnchor.TOP_LEFT);
                spec.addPlotAnnotation((XYAnnotation)meanAnn);
                annY = yRange.getUpperBound() * 0.925;
                XYTextAnnotation simZeroAnn = new XYTextAnnotation("Simulation % == 0: " + percentDF.format(simFractZeros[m][d7]), 5.0, annY);
                simZeroAnn.setFont(annFont);
                simZeroAnn.setTextAnchor(TextAnchor.TOP_LEFT);
                spec.addPlotAnnotation((XYAnnotation)simZeroAnn);
                annY = yRange.getUpperBound() * 0.875;
                XYTextAnnotation dataZeroAnn = new XYTextAnnotation("Data % == 0: " + percentDF.format(dataFractZeros[m][d7]), 5.0, annY);
                dataZeroAnn.setFont(annFont);
                dataZeroAnn.setTextAnchor(TextAnchor.TOP_LEFT);
                spec.addPlotAnnotation((XYAnnotation)dataZeroAnn);
                spec.setLegendVisible(true);
                HeadlessGraphPanel gp = new HeadlessGraphPanel();
                gp.setTickLabelFontSize(18);
                gp.setAxisLabelFontSize(24);
                gp.setPlotLabelFontSize(24);
                gp.setLegendFontSize(18);
                gp.setBackgroundColor(Color.WHITE);
                gp.drawGraphPanel(spec, false, false, xRange, yRange);
                String prefix = "percentile_" + scatterDurationLabels[d7].replaceAll(" ", "").toLowerCase();
                prefix = prefix + "_m" + (float)minMags[m];
                File file = new File(resourcesDir, prefix);
                gp.getChartPanel().setSize(800, 800);
                gp.saveAsPNG(file.getAbsolutePath() + ".png");
                table.addColumn("![chart](resources/" + prefix + ".png)");
            }
            table.finalizeLine();
        }
        lines.addAll(table.build());
        lines.add("");
        lines.add("## Data 95% Confidence Comparisons");
        lines.add(topLink);
        lines.add("");
        lines.add("This plots the percentage of observations which are outside (black lines), below (blue lines), or above (red lines) the simulations 95% confidence interval.");
        lines.add("");
        table = MarkdownUtils.tableBuilder();
        table.initNewLine();
        table.addColumn("Duration");
        table.addColumn("Plot");
        table.finalizeLine();
        for (d = 0; d < scatterDurations.length; ++d) {
            ArrayList<ArbitrarilyDiscretizedFunc> funcs = new ArrayList<ArbitrarilyDiscretizedFunc>();
            ArrayList<PlotCurveCharacterstics> chars = new ArrayList<PlotCurveCharacterstics>();
            ArbitrarilyDiscretizedFunc aboveFunc = new ArbitrarilyDiscretizedFunc();
            ArbitrarilyDiscretizedFunc belowFunc = new ArbitrarilyDiscretizedFunc();
            ArbitrarilyDiscretizedFunc outsideFunc = new ArbitrarilyDiscretizedFunc();
            for (int m = 0; m < minMags.length; ++m) {
                double x = minMags[m];
                int numAbove = dataAbove95ConfCounts[m][d];
                int numBelow = dataBelow95ConfCounts[m][d];
                int numOutside = numAbove + numBelow;
                aboveFunc.set(x, 100.0 * (double)numAbove / (double)calls.size());
                belowFunc.set(x, 100.0 * (double)numBelow / (double)calls.size());
                outsideFunc.set(x, 100.0 * (double)numOutside / (double)calls.size());
            }
            outsideFunc.setName("Outside 95 % Bounds");
            funcs.add(outsideFunc);
            chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 3.0f, Color.BLACK));
            belowFunc.setName("Below 2.5 %-ile");
            funcs.add(belowFunc);
            chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 3.0f, Color.BLUE));
            aboveFunc.setName("Above 97.5 %-ile");
            funcs.add(aboveFunc);
            chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 3.0f, Color.RED));
            Range xRange = new Range(minMags[0], minMags[minMags.length - 1]);
            Range yRange = new Range(0.0, 20.0);
            PlotSpec spec = new PlotSpec(funcs, chars, " ", "Minimum Magnitude", "Data Percentage");
            spec.setLegendVisible(true);
            HeadlessGraphPanel gp = new HeadlessGraphPanel();
            gp.setTickLabelFontSize(18);
            gp.setAxisLabelFontSize(24);
            gp.setPlotLabelFontSize(24);
            gp.setLegendFontSize(18);
            gp.setBackgroundColor(Color.WHITE);
            gp.setRenderingOrder(DatasetRenderingOrder.REVERSE);
            gp.drawGraphPanel(spec, false, false, xRange, yRange);
            String prefix = "conf_bounds_" + scatterDurationLabels[d].replaceAll(" ", "").toLowerCase();
            File file = new File(resourcesDir, prefix);
            gp.getChartPanel().setSize(1000, 800);
            gp.saveAsPNG(file.getAbsolutePath() + ".png");
            table.initNewLine();
            table.addColumn("**" + scatterDurationLabels[d] + "**");
            table.addColumn("![chart](resources/" + prefix + ".png)");
            table.finalizeLine();
        }
        lines.addAll(table.build());
        lines.add("");
        lines.add("## Data vs Model Count Scatters");
        lines.add(topLink);
        lines.add("");
        lines.add("Scatter plots of the actual event count (x-axis) vs the simulation mean or median value, for different durations and magnitude thresholds.");
        lines.add("");
        for (d = 0; d < scatterDurations.length; ++d) {
            lines.add("### " + scatterDurationLabels[d] + " Scatters");
            lines.add(topLink);
            lines.add("");
            table = MarkdownUtils.tableBuilder();
            table.addLine("Min Mag", "Mean Simulation Values", "Median Simulation Values", "Individual Catalogs");
            for (int m = 0; m < minMags.length; ++m) {
                table.initNewLine();
                table.addColumn("**M&ge;" + (float)minMags[m] + "**");
                Range xRange = null;
                Range yRange = null;
                PlotPreferences plotPrefs = null;
                for (boolean isMedian : new boolean[]{false, true}) {
                    ArrayList<DefaultXY_DataSet> funcs = new ArrayList<DefaultXY_DataSet>();
                    ArrayList<PlotCurveCharacterstics> chars = new ArrayList<PlotCurveCharacterstics>();
                    DefaultXY_DataSet[][][] myXYs = isMedian ? medianMagDurScatters : meanMagDurScatters;
                    double maxVal = 0.0;
                    double minVal = Double.POSITIVE_INFINITY;
                    int totalNum = 0;
                    for (int i = 0; i < myXYs.length; ++i) {
                        if (myXYs[i][m][d].size() == 0) continue;
                        funcs.add(myXYs[i][m][d]);
                        chars.add(new PlotCurveCharacterstics(PlotSymbol.BOLD_CROSS, 3.0f, ((CPTVal)scatterCPT.get((int)i)).minColor));
                        for (Point2D pt : myXYs[i][m][d]) {
                            if (!(pt.getX() > 0.0)) continue;
                            maxVal = Math.max(maxVal, pt.getX());
                            minVal = Math.min(minVal, pt.getX());
                            ++totalNum;
                        }
                    }
                    String prefix = "scatter_" + scatterDurationLabels[d].replaceAll(" ", "").toLowerCase();
                    Object yAxisLabel = scatterDurationLabels[d];
                    prefix = prefix + "_m" + (float)minMags[m];
                    if (isMedian) {
                        prefix = prefix + "_sim_medians";
                        yAxisLabel = (String)yAxisLabel + " Sim Median";
                    } else {
                        prefix = prefix + "_sim_means";
                        yAxisLabel = (String)yAxisLabel + " Sim Mean";
                    }
                    String xAxisLabel = scatterDurationLabels[d] + " Data";
                    if (totalNum == 0) {
                        System.out.println("Skipping: " + prefix);
                        table.addColumn("*(N/A)*");
                        continue;
                    }
                    System.out.println("Plotting: " + prefix);
                    maxVal = Math.max(maxVal, 10.0);
                    maxVal = Math.pow(10.0, Math.ceil(Math.log10(maxVal)));
                    if (!Double.isFinite(minVal)) {
                        minVal = 0.1;
                    }
                    minVal = Math.pow(10.0, Math.floor(Math.log10(minVal)));
                    minVal = Math.max(minVal, 0.1);
                    while (minVal >= maxVal) {
                        maxVal *= 10.0;
                    }
                    DefaultXY_DataSet oneToOne = new DefaultXY_DataSet();
                    oneToOne.set(minVal, minVal);
                    oneToOne.set(maxVal, maxVal);
                    funcs.add(oneToOne);
                    chars.add(new PlotCurveCharacterstics(PlotLineType.DASHED, 2.0f, Color.GRAY));
                    PlotSpec spec = new PlotSpec(funcs, chars, " ", xAxisLabel, (String)yAxisLabel);
                    spec.addSubtitle((Title)scatterBar);
                    spec.setLegendVisible(true);
                    HeadlessGraphPanel gp = new HeadlessGraphPanel();
                    gp.setTickLabelFontSize(18);
                    gp.setAxisLabelFontSize(24);
                    gp.setPlotLabelFontSize(24);
                    gp.setLegendFontSize(18);
                    gp.setBackgroundColor(Color.WHITE);
                    plotPrefs = gp.getPlotPrefs();
                    yRange = xRange = new Range(minVal, maxVal);
                    gp.drawGraphPanel(spec, true, true, xRange, yRange);
                    File file = new File(resourcesDir, prefix);
                    gp.getChartPanel().setSize(800, 800);
                    gp.saveAsPNG(file.getAbsolutePath() + ".png");
                    table.addColumn("![chart](resources/" + prefix + ".png)");
                }
                if (xRange == null) {
                    table.addColumn("*(N/A)*");
                } else {
                    double maxVal = Math.max(10.0, aggregatedXYZs[m][d].getMaxZ());
                    CPT cpt = GMT_CPT_Files.RAINBOW_UNIFORM.instance().rescale(1.0, maxVal);
                    cpt.setBelowMinColor(new Color(255, 255, 255, 0));
                    String xAxisLabel = "Log10 " + scatterDurationLabels[d] + " Data";
                    String yAxisLabel = "Log10 " + scatterDurationLabels[d] + " Simulation";
                    XYZPlotSpec spec = new XYZPlotSpec(aggregatedXYZs[m][d], cpt, " ", xAxisLabel, yAxisLabel, "Count");
                    spec.setCPTPosition(RectangleEdge.BOTTOM);
                    ArrayList<DefaultXY_DataSet> funcs = new ArrayList<DefaultXY_DataSet>();
                    ArrayList<PlotCurveCharacterstics> chars = new ArrayList<PlotCurveCharacterstics>();
                    yRange = xRange = new Range(Math.log10(xRange.getLowerBound()), Math.log10(xRange.getUpperBound()));
                    DefaultXY_DataSet oneToOne = new DefaultXY_DataSet();
                    oneToOne.set(xRange.getLowerBound(), xRange.getLowerBound());
                    oneToOne.set(xRange.getUpperBound(), xRange.getUpperBound());
                    funcs.add(oneToOne);
                    chars.add(new PlotCurveCharacterstics(PlotLineType.DASHED, 2.0f, Color.GRAY));
                    spec.setXYElems(funcs);
                    spec.setXYChars(chars);
                    HeadlessGraphPanel gp = new HeadlessGraphPanel(plotPrefs);
                    gp.drawGraphPanel(spec, false, false, xRange, yRange);
                    gp.getChartPanel().getChart().setBackgroundPaint((Paint)Color.WHITE);
                    gp.getChartPanel().setSize(800, 800);
                    String prefix = "scatter_" + scatterDurationLabels[d].replaceAll(" ", "").toLowerCase();
                    prefix = prefix + "_m" + (float)minMags[m] + "_indv_catalogs";
                    gp.saveAsPNG(new File(resourcesDir, prefix + ".png").getAbsolutePath());
                    table.addColumn("![chart](resources/" + prefix + ".png)");
                }
                table.finalizeLine();
            }
            lines.addAll(table.build());
            lines.add("");
        }
        lines.add("## Daily Comparisons");
        lines.add(topLink);
        lines.add("");
        for (DailyQuantity type : DailyQuantity.values()) {
            Range yRange;
            switch (type.ordinal()) {
                case 0: {
                    lines.add("### Daily Probabilitites");
                    yRange = new Range(9.0E-5, 1.1);
                    break;
                }
                case 1: {
                    lines.add("### Daily Medians and 95% Conf");
                    yRange = new Range(0.1, 1000.0);
                    break;
                }
                case 2: {
                    lines.add("### Daily Means");
                    yRange = new Range(9.0E-5, 1000.0);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            lines.add(topLink);
            lines.add("");
            ArrayList<PlotSpec> specs = new ArrayList<PlotSpec>();
            for (double year = Math.floor(minYear); year < Math.ceil(maxYear); year += 1.0) {
                Object rup22;
                GregorianCalendar yearStartCal = new GregorianCalendar();
                yearStartCal.setTimeZone(TimeZone.getTimeZone("UTC"));
                yearStartCal.clear();
                yearStartCal.set(1, (int)year);
                System.out.println("Working on " + (int)year + ", " + String.valueOf((Object)type));
                long yearStartMillis = yearStartCal.getTimeInMillis();
                long yearEndMillis = yearStartMillis + 31536000000L;
                ArrayList<XY_DataSet> funcs = new ArrayList<XY_DataSet>();
                ArrayList<PlotCurveCharacterstics> chars = new ArrayList<PlotCurveCharacterstics>();
                EvenlyDiscretizedFunc[] dataFuncs = new EvenlyDiscretizedFunc[dailyMags.length];
                boolean first = true;
                for (int m = 0; m < dailyMags.length; ++m) {
                    if (type == DailyQuantity.PROB && dailyMags[m] < 4.0) continue;
                    dataFuncs[m] = new EvenlyDiscretizedFunc(0.5, 365, 1.0);
                    if (first) {
                        if (type == DailyQuantity.PROB) {
                            dataFuncs[m].setName("Data M\u2265" + (float)dailyMags[m]);
                        } else {
                            dataFuncs[m].setName("Data M\u2265" + (float)dailyMags[m]);
                        }
                    } else {
                        dataFuncs[m].setName("M\u2265" + (float)dailyMags[m]);
                    }
                    funcs.add(dataFuncs[m]);
                    chars.add(dailyDataChars[m]);
                    first = false;
                }
                for (Object rup22 : combEvents) {
                    long time = ((ObsEqkRupture)rup22).getOriginTime();
                    if (time < yearStartMillis) continue;
                    if (time >= yearEndMillis) break;
                    double mag = ((EqkRupture)rup22).getMag();
                    double day = (double)(time - yearStartMillis) / 8.64E7;
                    int dayIndex = dataFuncs[dataFuncs.length - 1].getClosestXIndex(day);
                    for (int m = 0; m < dailyMags.length; ++m) {
                        if (!(mag >= dailyMags[m]) || dataFuncs[m] == null) continue;
                        if (type == DailyQuantity.PROB) {
                            dataFuncs[m].set(dayIndex, 1.0);
                            continue;
                        }
                        dataFuncs[m].set(dayIndex, dataFuncs[m].getY(dayIndex) + 1.0);
                    }
                }
                boolean firstCall = true;
                rup22 = calls.iterator();
                block48: while (rup22.hasNext()) {
                    CalcCallable call = (CalcCallable)rup22.next();
                    if (call.dayEndTimes == null || call.startTimeMillis > yearEndMillis) continue;
                    first = true;
                    XY_DataSet[] simFuncs = new XY_DataSet[dailyMags.length];
                    XY_DataSet[] lowerFuncs = new XY_DataSet[dailyMags.length];
                    XY_DataSet[] upperFuncs = new XY_DataSet[dailyMags.length];
                    boolean firstDay = true;
                    for (int d8 = 0; d8 < 7; ++d8) {
                        int m;
                        long dayMillis = call.startTimeMillis + (long)d8 * 86400000L;
                        long diffMillis = dayMillis - yearStartMillis;
                        if (diffMillis < 0L) continue;
                        double startDiffDays = (double)diffMillis / 8.64E7;
                        double endDiffDays = startDiffDays + 1.0;
                        if (startDiffDays > 364.5) continue block48;
                        if (simFuncs[simFuncs.length - 1] == null) {
                            for (m = 0; m < dailyMags.length; ++m) {
                                if (type == DailyQuantity.PROB && dailyMags[m] < 4.0) continue;
                                simFuncs[m] = new DefaultXY_DataSet();
                                if (firstCall) {
                                    if (first) {
                                        simFuncs[m].setName("Sim M\u2265" + (float)dailyMags[m]);
                                    } else {
                                        simFuncs[m].setName("M\u2265" + (float)dailyMags[m]);
                                    }
                                }
                                funcs.add(simFuncs[m]);
                                chars.add(dailySimChars[m]);
                                if (type == DailyQuantity.MEDIAN) {
                                    PlotCurveCharacterstics boundChar = new PlotCurveCharacterstics(dailySimChars[m].getLineType(), 1.0f, dailySimChars[m].getColor());
                                    lowerFuncs[m] = new DefaultXY_DataSet();
                                    funcs.add(lowerFuncs[m]);
                                    chars.add(boundChar);
                                    upperFuncs[m] = new DefaultXY_DataSet();
                                    funcs.add(upperFuncs[m]);
                                    chars.add(boundChar);
                                }
                                first = false;
                            }
                            firstCall = false;
                        }
                        if (firstDay) {
                            DefaultXY_DataSet markerFunc = new DefaultXY_DataSet();
                            markerFunc.set(startDiffDays, yRange.getLowerBound());
                            markerFunc.set(startDiffDays, yRange.getUpperBound());
                            funcs.add(markerFunc);
                            chars.add(new PlotCurveCharacterstics(PlotLineType.DOTTED, 1.0f, Color.DARK_GRAY));
                            firstDay = false;
                        }
                        block51: for (m = 0; m < dailyMags.length; ++m) {
                            if (simFuncs[m] == null) continue;
                            switch (type.ordinal()) {
                                case 0: {
                                    simFuncs[m].set(startDiffDays, call.dailyProbs[m][d8]);
                                    simFuncs[m].set(endDiffDays, call.dailyProbs[m][d8]);
                                    continue block51;
                                }
                                case 1: {
                                    simFuncs[m].set(startDiffDays, call.dailyMedians[m][d8]);
                                    lowerFuncs[m].set(startDiffDays, call.dailyP25s[m][d8]);
                                    upperFuncs[m].set(startDiffDays, call.dailyP975s[m][d8]);
                                    simFuncs[m].set(endDiffDays, call.dailyMedians[m][d8]);
                                    lowerFuncs[m].set(endDiffDays, call.dailyP25s[m][d8]);
                                    upperFuncs[m].set(endDiffDays, call.dailyP975s[m][d8]);
                                    continue block51;
                                }
                                case 2: {
                                    simFuncs[m].set(startDiffDays, call.dailyMeans[m][d8]);
                                    simFuncs[m].set(endDiffDays, call.dailyMeans[m][d8]);
                                    continue block51;
                                }
                            }
                        }
                    }
                }
                int i = funcs.size();
                while (--i >= 0) {
                    if (((XY_DataSet)funcs.get(i)).size() != 0) continue;
                    funcs.remove(i);
                    chars.remove(i);
                }
                PlotSpec spec = new PlotSpec(funcs, chars, "Daily " + String.valueOf((Object)type) + " Comparisons", "Day Of Year", type.toString());
                spec.setLegendVisible(specs.isEmpty());
                XYTextAnnotation ann = new XYTextAnnotation("" + (int)year, 1.0, yRange.getUpperBound());
                ann.setFont(new Font("SansSerif", 1, 20));
                ann.setTextAnchor(TextAnchor.TOP_LEFT);
                spec.addPlotAnnotation((XYAnnotation)ann);
                specs.add(spec);
                if (highlightYears == null) continue;
                int yearInt = (int)year;
                for (int highlightYear : highlightYears) {
                    if (yearInt != highlightYear) continue;
                    System.out.println("Writing out highlight plot for " + yearInt);
                    HeadlessGraphPanel gp = new HeadlessGraphPanel();
                    gp.setTickLabelFontSize(18);
                    gp.setAxisLabelFontSize(24);
                    gp.setPlotLabelFontSize(24);
                    gp.setLegendFontSize(18);
                    gp.setBackgroundColor(Color.WHITE);
                    Range xRange = new Range(0.0, 365.0);
                    boolean wasLegend = spec.isLegendVisible();
                    spec.setLegendVisible(true);
                    gp.drawGraphPanel(spec, false, true, xRange, yRange);
                    spec.setLegendVisible(wasLegend);
                    String prefix = "daily_" + type.name() + "_" + yearInt;
                    File file = new File(resourcesDir, prefix);
                    gp.getChartPanel().setSize(1000, 650);
                    gp.saveAsPNG(file.getAbsolutePath() + ".png");
                }
            }
            HeadlessGraphPanel gp = new HeadlessGraphPanel();
            gp.setTickLabelFontSize(18);
            gp.setAxisLabelFontSize(24);
            gp.setPlotLabelFontSize(24);
            gp.setLegendFontSize(18);
            gp.setBackgroundColor(Color.WHITE);
            Range xRange = new Range(0.0, 365.0);
            ArrayList<Range> xRanges = new ArrayList<Range>();
            ArrayList<Range> yRanges = new ArrayList<Range>();
            xRanges.add(xRange);
            for (int i = 0; i < specs.size(); ++i) {
                yRanges.add(yRange);
            }
            gp.drawGraphPanel(specs, false, true, xRanges, yRanges);
            String prefix = "daily_" + type.name();
            File file = new File(resourcesDir, prefix);
            int height = 150 + 200 * specs.size();
            gp.getChartPanel().setSize(1000, height);
            gp.saveAsPNG(file.getAbsolutePath() + ".png");
            lines.add("![Daily Plot](resources/" + prefix + ".png)");
            lines.add("");
        }
        lines.add("## Data Divergence Over Time");
        lines.add(topLink);
        lines.add("");
        lines.add("These plots show how the actual event count diverges from the simulated mean/median prediction as a function of time from simulation start. Each individual thin line represents a unique week, colored by year; mean and median divergence are overlaid with thick lines.");
        lines.add("");
        CPT cpt = GMT_CPT_Files.RAINBOW_UNIFORM.instance().rescale(minYear, maxYear);
        for (int i = 0; i < cpt.size(); ++i) {
            CPTVal cptVal = (CPTVal)cpt.get(i);
            Color min = cptVal.minColor;
            Color max = cptVal.maxColor;
            cptVal.minColor = new Color(min.getRed(), min.getGreen(), min.getBlue(), 50);
            cptVal.maxColor = new Color(max.getRed(), max.getGreen(), max.getBlue(), 50);
        }
        cpt.setBelowMinColor(cpt.getMinColor());
        cpt.setAboveMaxColor(cpt.getMaxColor());
        PaintScaleLegend cptBar = GraphPanel.getLegendForCPT(cpt, "Year", 22, 18, yearInc, RectangleEdge.BOTTOM);
        for (boolean cumulative : new boolean[]{true, false}) {
            ArrayList<DiscretizedFunc[]> medianFuncs;
            ArrayList<DiscretizedFunc[]> meanFuncs;
            if (cumulative) {
                lines.add("### Cumulative Divergence Plots");
                lines.add(topLink);
                lines.add("");
                lines.add("These plots show cumulative divergence from the start of the simulation.");
                lines.add("");
                meanFuncs = cumulativeMeanDiffFuncs;
                medianFuncs = cumulativeMedianDiffFuncs;
            } else {
                lines.add("### Daily Incremental Divergence Plots");
                lines.add(topLink);
                lines.add("");
                lines.add("These plots show incremental divergence binned by day.");
                lines.add("");
                meanFuncs = dailyIncrMeanDiffFuncs;
                medianFuncs = dailyIncrMedianDiffFuncs;
            }
            table = MarkdownUtils.tableBuilder();
            table.addLine("Min Mag", "Mean Simulation Values", "Median Simulation Values");
            for (int m = 0; m < minMags.length; ++m) {
                table.initNewLine();
                table.addColumn("**M&ge;" + (float)minMags[m] + "**");
                double meanMaxY = Double.NaN;
                for (boolean isMedian : new boolean[]{false, true}) {
                    Object yAxisLabel;
                    ArrayList<DiscretizedFunc> funcs = new ArrayList<DiscretizedFunc>();
                    ArrayList<PlotCurveCharacterstics> chars = new ArrayList<PlotCurveCharacterstics>();
                    ArrayList<DiscretizedFunc[]> myFuncs = isMedian ? medianFuncs : meanFuncs;
                    ArrayList vals = new ArrayList();
                    ArrayList<Double> xVals = new ArrayList<Double>();
                    for (int i = 0; i < myFuncs.size(); ++i) {
                        DiscretizedFunc[] magFuncs = (DiscretizedFunc[])myFuncs.get(i);
                        DiscretizedFunc func = magFuncs[m];
                        double year = (Double)years.get(i);
                        Color color = cpt.getColor((float)year);
                        if (func.size() > 0) {
                            funcs.add(func);
                            chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 1.0f, color));
                        }
                        for (int j = 0; j < func.size(); ++j) {
                            if (j == vals.size()) {
                                vals.add(new ArrayList());
                                xVals.add(func.getX(j));
                            }
                            double val = func.getY(j);
                            Preconditions.checkState((boolean)Double.isFinite(val), (String)"Bad value: %s", (Object)val);
                            ((List)vals.get(j)).add(val);
                        }
                    }
                    ArbitrarilyDiscretizedFunc meanFunc = new ArbitrarilyDiscretizedFunc();
                    ArbitrarilyDiscretizedFunc medianFunc = new ArbitrarilyDiscretizedFunc();
                    double maxY = 0.0;
                    double maxX = (Double)xVals.get(xVals.size() - 1);
                    for (int i = 0; i < vals.size(); ++i) {
                        double[] array = Doubles.toArray((Collection)((Collection)vals.get(i)));
                        if (array.length == 0) continue;
                        double x = (Double)xVals.get(i);
                        Preconditions.checkState((boolean)Double.isFinite(x));
                        meanFunc.set(x, StatUtils.mean((double[])array));
                        medianFunc.set(x, DataUtils.median(array));
                        double[] absArray = new double[array.length];
                        for (int j = 0; j < array.length; ++j) {
                            absArray[j] = Math.abs(array[j]);
                        }
                        maxY = StatUtils.percentile((double[])absArray, (double)95.0);
                    }
                    maxY = Math.max(maxY, 1.0);
                    if (isMedian) {
                        maxY = meanMaxY;
                    } else {
                        meanMaxY = maxY;
                    }
                    funcs.add(meanFunc);
                    meanFunc.setName("Mean Difference");
                    chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 4.0f, Color.BLACK));
                    funcs.add(medianFunc);
                    medianFunc.setName("Median Difference");
                    chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 4.0f, Color.BLUE));
                    Object prefix = "";
                    if (cumulative) {
                        prefix = "cumulative";
                        yAxisLabel = "Cumulative";
                    } else {
                        prefix = "incremental";
                        yAxisLabel = "Daily";
                    }
                    prefix = (String)prefix + "_m" + (float)minMags[m];
                    if (isMedian) {
                        prefix = (String)prefix + "_sim_medians";
                        yAxisLabel = (String)yAxisLabel + " Sim Median - Data";
                    } else {
                        prefix = (String)prefix + "_sim_means";
                        yAxisLabel = (String)yAxisLabel + " Sim Mean - Data";
                    }
                    System.out.println("Plotting: " + (String)prefix);
                    PlotSpec spec = new PlotSpec(funcs, chars, " ", "Days Since Sim Start", (String)yAxisLabel);
                    spec.addSubtitle((Title)cptBar);
                    spec.setLegendVisible(true);
                    HeadlessGraphPanel gp = new HeadlessGraphPanel();
                    gp.setTickLabelFontSize(18);
                    gp.setAxisLabelFontSize(24);
                    gp.setPlotLabelFontSize(24);
                    gp.setLegendFontSize(18);
                    gp.setBackgroundColor(Color.WHITE);
                    Range xRange = new Range(0.0, maxX);
                    Range yRange = new Range(-maxY, maxY);
                    gp.drawGraphPanel(spec, false, false, xRange, yRange);
                    File file = new File(resourcesDir, (String)prefix);
                    gp.getChartPanel().setSize(800, 600);
                    gp.saveAsPNG(file.getAbsolutePath() + ".png");
                    table.addColumn("![chart](resources/" + (String)prefix + ".png)");
                }
                table.finalizeLine();
            }
            lines.addAll(table.build());
            lines.add("");
        }
        ArrayList<String> tocLines = new ArrayList<String>();
        tocLines.add("## Table Of Contents");
        tocLines.add("");
        tocLines.addAll(MarkdownUtils.buildTOC(lines, 2, 3));
        lines.addAll(n, tocLines);
        MarkdownUtils.writeReadmeAndHTML(lines, outputDir);
        System.out.println("DONE");
    }

    private static double getYear(long millis) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTimeZone(TimeZone.getTimeZone("UTC"));
        cal.setTimeInMillis(millis);
        double year = cal.get(1);
        return year += ((double)cal.get(6) - 1.0) / 365.25;
    }

    private static class CalcCallable
    implements Callable<CalcCallable>,
    Comparable<CalcCallable> {
        private long curTime;
        private File simDir;
        private double[] minMags;
        private double[] scatterDurations;
        private double[] dailyMinMags;
        private long startTimeMillis;
        private long endTimeMillis;
        private DiscretizedFunc[] medianCumulativeFuncs;
        private DiscretizedFunc[] medianIncrFuncs;
        private DiscretizedFunc[] meanCumulativeFuncs;
        private DiscretizedFunc[] meanIncrFuncs;
        private double[][] meanCumCounts;
        private double[][] medianCumCounts;
        private double[][] dataCumCounts;
        private double[][] dataPercentiles;
        private boolean[][] below2p5s;
        private boolean[][] above97p5s;
        private double[][] fractZeros;
        private ObsEqkRupList subCatalog;
        private EvenlyDiscrXYZ_DataSet globalXYZ;
        private EvenlyDiscrXYZ_DataSet[][] indvXYZs;
        private long[] dayEndTimes;
        private double[][] dailyProbs;
        private double[][] dailyMedians;
        private double[][] dailyMeans;
        private double[][] dailyP25s;
        private double[][] dailyP975s;

        private CalcCallable(ObsEqkRupList combEvents, long curTime, File simDir, ETAS_Config config, double[] minMags, double[] scatterDurations, double[] dailyMinMags, EvenlyDiscrXYZ_DataSet globalXYZ) {
            this.curTime = curTime;
            this.simDir = simDir;
            this.minMags = minMags;
            this.dailyMinMags = dailyMinMags;
            this.scatterDurations = scatterDurations;
            this.globalXYZ = globalXYZ;
            this.startTimeMillis = config.getSimulationStartTimeMillis();
            this.endTimeMillis = Long.min(curTime, this.startTimeMillis + (long)(config.getDuration() * 3.15576E10));
            this.subCatalog = new ObsEqkRupList();
            for (ObsEqkRupture rup : combEvents) {
                long time = rup.getOriginTime();
                if (time < this.startTimeMillis) continue;
                if (time >= this.endTimeMillis) break;
                if (!(rup.getMag() >= 2.5)) continue;
                this.subCatalog.add(rup);
            }
            System.out.println("\tObserved events: " + this.subCatalog.size());
        }

        @Override
        public CalcCallable call() throws Exception {
            CSVFile<String> csv;
            File csvFile;
            String csvName;
            double minMag;
            int m;
            this.medianCumulativeFuncs = new DiscretizedFunc[this.minMags.length];
            this.medianIncrFuncs = new DiscretizedFunc[this.minMags.length];
            this.meanCumulativeFuncs = new DiscretizedFunc[this.minMags.length];
            this.meanIncrFuncs = new DiscretizedFunc[this.minMags.length];
            this.medianCumCounts = new double[this.minMags.length][this.scatterDurations.length];
            this.meanCumCounts = new double[this.minMags.length][this.scatterDurations.length];
            this.dataCumCounts = new double[this.minMags.length][this.scatterDurations.length];
            this.dataPercentiles = new double[this.minMags.length][this.scatterDurations.length];
            this.below2p5s = new boolean[this.minMags.length][this.scatterDurations.length];
            this.above97p5s = new boolean[this.minMags.length][this.scatterDurations.length];
            this.indvXYZs = new EvenlyDiscrXYZ_DataSet[this.minMags.length][this.scatterDurations.length];
            this.fractZeros = new double[this.minMags.length][this.scatterDurations.length];
            File resultsDir = new File(this.simDir, "aggregated_results");
            for (m = 0; m < this.minMags.length; ++m) {
                int d;
                minMag = this.minMags[m];
                csvName = "m" + (float)minMag + "_cumulative_time_stats.csv";
                csvFile = new File(resultsDir, csvName);
                csv = CSVFile.readFile(csvFile, true);
                for (boolean isMedian : new boolean[]{false, true}) {
                    ArbitrarilyDiscretizedFunc cumulativeSimFunc = new ArbitrarilyDiscretizedFunc();
                    ArbitrarilyDiscretizedFunc dataFunc = new ArbitrarilyDiscretizedFunc();
                    cumulativeSimFunc.set(0.0, 0.0);
                    dataFunc.set(0.0, 0.0);
                    int col = isMedian ? 6 : 2;
                    double maxData = (double)(this.curTime - this.startTimeMillis) / 8.64E7;
                    for (int row = 1; row < csv.getNumRows(); ++row) {
                        double val = csv.getDouble(row, col);
                        long time = csv.getLong(row, 0);
                        double days = (double)(time - this.startTimeMillis) / 8.64E7;
                        cumulativeSimFunc.set(days, val);
                        if (!(days <= maxData)) continue;
                        dataFunc.set(days, 0.0);
                    }
                    double[] magDurVals = isMedian ? this.medianCumCounts[m] : this.meanCumCounts[m];
                    for (int d2 = 0; d2 < this.scatterDurations.length; ++d2) {
                        magDurVals[d2] = cumulativeSimFunc.getInterpolatedY(this.scatterDurations[d2]);
                    }
                    for (ObsEqkRupture rup : this.subCatalog) {
                        if (rup.getMag() < minMag) continue;
                        double rupDays = (double)(rup.getOriginTime() - this.startTimeMillis) / 8.64E7;
                        for (int i = 0; i < dataFunc.size(); ++i) {
                            if (!(rupDays <= dataFunc.getX(i))) continue;
                            dataFunc.set(i, dataFunc.getY(i) + 1.0);
                        }
                    }
                    for (int d3 = 0; isMedian && d3 < this.scatterDurations.length; ++d3) {
                        this.dataCumCounts[m][d3] = this.scatterDurations[d3] > maxData ? Double.NaN : dataFunc.getInterpolatedY(this.scatterDurations[d3]);
                    }
                    for (boolean cumulative : new boolean[]{false, true}) {
                        if (cumulative) {
                            ArbitrarilyDiscretizedFunc diffFunc = new ArbitrarilyDiscretizedFunc(){

                                @Override
                                public String toString() {
                                    return "";
                                }
                            };
                            for (Point2D dataPt : dataFunc) {
                                double simY = cumulativeSimFunc.getY(dataPt.getX());
                                double diff = simY - dataPt.getY();
                                diffFunc.set(dataPt.getX(), diff);
                            }
                            if (isMedian) {
                                this.medianCumulativeFuncs[m] = diffFunc;
                                continue;
                            }
                            this.meanCumulativeFuncs[m] = diffFunc;
                            continue;
                        }
                        int num = Integer.min(365, (int)maxData);
                        EvenlyDiscretizedFunc diffFunc = new EvenlyDiscretizedFunc(0.5, num, 1.0){

                            @Override
                            public String toString() {
                                return "";
                            }
                        };
                        for (int i = 0; i < diffFunc.size(); ++i) {
                            double dataStart;
                            double simStart;
                            double x = diffFunc.getX(i);
                            double start = x - 0.5;
                            double end = x + 0.5;
                            if (i == 0) {
                                simStart = 0.0;
                                dataStart = 0.0;
                            } else {
                                simStart = cumulativeSimFunc.getInterpolatedY(start);
                                dataStart = dataFunc.getInterpolatedY(start);
                            }
                            double simEnd = end > cumulativeSimFunc.getMaxX() ? cumulativeSimFunc.getMaxY() : cumulativeSimFunc.getInterpolatedY(end);
                            double dataEnd = end > dataFunc.getMaxX() ? dataFunc.getMaxY() : dataFunc.getInterpolatedY(end);
                            double simVal = simEnd - simStart;
                            double dataVal = dataEnd - dataStart;
                            double diff = simVal - dataVal;
                            diffFunc.set(i, diff);
                        }
                        if (isMedian) {
                            this.medianIncrFuncs[m] = diffFunc;
                            continue;
                        }
                        this.meanIncrFuncs[m] = diffFunc;
                    }
                }
                csvName = "m" + (float)minMag + "_indv_fixed_duration_counts.csv";
                csvFile = new File(resultsDir, csvName);
                if (!csvFile.exists()) continue;
                csv = CSVFile.readFile(csvFile, true);
                for (d = 0; d < this.scatterDurations.length; ++d) {
                    this.indvXYZs[m][d] = this.globalXYZ.copy();
                }
                for (d = 0; d < this.scatterDurations.length; ++d) {
                    double dataVal = Math.floor(this.dataCumCounts[m][d]);
                    double dataLogVal = Math.log10(dataVal);
                    int xInd = this.globalXYZ.getXIndex(dataLogVal);
                    if (xInd < 0) {
                        xInd = 0;
                    }
                    if (xInd >= this.globalXYZ.getNumX()) {
                        xInd = this.globalXYZ.getNumX() - 1;
                    }
                    double[] allCounts = new double[csv.getNumRows() - 1];
                    int numZero = 0;
                    for (int row = 1; row < csv.getNumRows(); ++row) {
                        double simLogVal;
                        int yInd;
                        int simCount = csv.getInt(row, d + 1);
                        allCounts[row - 1] = simCount;
                        if (simCount == 0) {
                            ++numZero;
                        }
                        if ((yInd = this.globalXYZ.getYIndex(simLogVal = Math.log10(simCount))) < 0) {
                            yInd = 0;
                        }
                        if (yInd >= this.globalXYZ.getNumY()) {
                            yInd = this.globalXYZ.getNumY() - 1;
                        }
                        this.indvXYZs[m][d].set(xInd, yInd, this.indvXYZs[m][d].get(xInd, yInd) + 1.0);
                    }
                    this.fractZeros[m][d] = (double)numZero / (double)allCounts.length;
                    this.dataPercentiles[m][d] = ETAS_ComcatComparePlot.invPercentile(allCounts, dataVal);
                    this.below2p5s[m][d] = dataVal < StatUtils.percentile((double[])allCounts, (double)2.5);
                    this.above97p5s[m][d] = dataVal > StatUtils.percentile((double[])allCounts, (double)97.5);
                }
            }
            for (m = 0; m < this.dailyMinMags.length; ++m) {
                int d;
                minMag = this.dailyMinMags[m];
                csvName = "m" + (float)minMag + "_daily_counts.csv";
                csvFile = new File(resultsDir, csvName);
                if (!csvFile.exists() || (csv = CSVFile.readFile(csvFile, true)).getNumRows() <= 7) continue;
                if (this.dayEndTimes == null) {
                    this.dayEndTimes = new long[csv.getNumRows() - 1];
                    for (d = 0; d < this.dayEndTimes.length; ++d) {
                        this.dayEndTimes[d] = csv.getLong(d + 1, 0);
                    }
                    this.dailyProbs = new double[this.minMags.length][this.dayEndTimes.length];
                    this.dailyMedians = new double[this.minMags.length][this.dayEndTimes.length];
                    this.dailyMeans = new double[this.minMags.length][this.dayEndTimes.length];
                    this.dailyP25s = new double[this.minMags.length][this.dayEndTimes.length];
                    this.dailyP975s = new double[this.minMags.length][this.dayEndTimes.length];
                }
                for (d = 0; d < this.dayEndTimes.length; ++d) {
                    int row = d + 1;
                    this.dailyProbs[m][d] = csv.getDouble(row, 1);
                    this.dailyMeans[m][d] = csv.getDouble(row, 2);
                    this.dailyMedians[m][d] = csv.getDouble(row, 6);
                    this.dailyP25s[m][d] = csv.getDouble(row, 4);
                    this.dailyP975s[m][d] = csv.getDouble(row, 8);
                }
            }
            return this;
        }

        @Override
        public int compareTo(CalcCallable o) {
            return Long.compare(this.startTimeMillis, o.startTimeMillis);
        }
    }

    private static enum DailyQuantity {
        PROB("Probability"),
        MEDIAN("Median"),
        MEAN("Mean");

        String label;

        private DailyQuantity(String label) {
            this.label = label;
        }

        public String toString() {
            return this.label;
        }
    }
}

