/*
 * Decompiled with CFR 0.152.
 */
package scratch.peter.curves;

import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ArrayTable;
import com.google.common.collect.BiMap;
import com.google.common.collect.Collections2;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import com.google.common.io.Files;
import com.google.common.primitives.Doubles;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.math3.stat.descriptive.moment.Mean;
import org.apache.commons.math3.stat.descriptive.moment.StandardDeviation;
import org.opensha.commons.calc.FractileCurveCalculator;
import org.opensha.commons.data.function.AbstractXY_DataSet;
import org.opensha.commons.data.function.ArbDiscrEmpiricalDistFunc;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.commons.data.function.XY_DataSet;
import org.opensha.commons.data.function.XY_DataSetList;
import org.opensha.commons.exceptions.InvalidRangeException;
import org.opensha.commons.geo.Location;
import org.opensha.commons.util.DataUtils;
import org.opensha.commons.util.Interpolate;
import org.opensha.nshmp2.util.Period;
import org.opensha.sha.earthquake.ProbEqkRupture;
import org.opensha.sha.earthquake.ProbEqkSource;
import org.opensha.sha.earthquake.param.IncludeBackgroundOption;
import org.opensha.sha.util.NEHRP_TestCity;
import org.opensha.sra.rtgm.RTGM;
import scratch.UCERF3.U3AverageFaultSystemSolution;
import scratch.UCERF3.U3CompoundFaultSystemSolution;
import scratch.UCERF3.enumTreeBranches.DeformationModels;
import scratch.UCERF3.enumTreeBranches.FaultModels;
import scratch.UCERF3.enumTreeBranches.MaxMagOffFault;
import scratch.UCERF3.enumTreeBranches.ScalingRelationships;
import scratch.UCERF3.enumTreeBranches.SlipAlongRuptureModels;
import scratch.UCERF3.enumTreeBranches.SpatialSeisPDF;
import scratch.UCERF3.enumTreeBranches.TotalMag5Rate;
import scratch.UCERF3.erf.FaultSystemSolutionERF;
import scratch.UCERF3.inversion.InversionFaultSystemSolution;
import scratch.UCERF3.logicTree.U3APrioriBranchWeightProvider;
import scratch.UCERF3.logicTree.U3LogicTreeBranch;
import scratch.UCERF3.logicTree.U3LogicTreeBranchNode;
import scratch.UCERF3.utils.ProbOfExceed;
import scratch.peter.curves.TornadoData;
import scratch.peter.nshmp.CurveContainer;
import scratch.peter.ucerf3.calc.UC3_CalcUtils;

public class CurveUtilsUC33 {
    private static final Splitter SPLIT = Splitter.on((char)',');
    private static final Joiner JOIN = Joiner.on((char)',');
    private static final Joiner TAB_JOIN = Joiner.on((char)'\t');
    private static final Mean MEAN = new Mean();
    private static final StandardDeviation STD = new StandardDeviation();
    private static final String S = File.separator;
    private static final String LF = IOUtils.LINE_SEPARATOR;
    private static final List<String> STAT_FIELDS = Lists.newArrayList((Object[])new String[]{"stat", "2in50", "10in50", "rtgm"});
    private static final List<String> SUMMARY_FIELDS = Lists.newArrayList((Object[])new String[]{"wt", "2in50", "10in50", "rtgm"});
    private static final List<String> CITY_FIELDS = Lists.newArrayList((Object[])new String[]{"city", "2in50", "10in50", "rtgm"});
    private static final String UC3_ROOT = "/Users/pmpowers/Documents/OpenSHA/RTGM/data/UC3/";
    private static final String CURVE_FILE = "curves";
    private static final String PARAM_FILE = "params";
    private static final String ROOT = "tmp/UC33/";
    private static List<? extends U3LogicTreeBranchNode<?>> UC33nodeList = Lists.newArrayList((Object[])new Enum[]{FaultModels.FM3_1, FaultModels.FM3_2, DeformationModels.ABM, DeformationModels.GEOLOGIC, DeformationModels.NEOKINEMA, DeformationModels.ZENGBB, ScalingRelationships.SHAW_2009_MOD, ScalingRelationships.HANKS_BAKUN_08, ScalingRelationships.ELLSWORTH_B, ScalingRelationships.ELLB_SQRT_LENGTH, ScalingRelationships.SHAW_CONST_STRESS_DROP, SlipAlongRuptureModels.UNIFORM, SlipAlongRuptureModels.TAPERED, TotalMag5Rate.RATE_6p5, TotalMag5Rate.RATE_7p9, TotalMag5Rate.RATE_9p6, MaxMagOffFault.MAG_7p3, MaxMagOffFault.MAG_7p6, MaxMagOffFault.MAG_7p9, SpatialSeisPDF.UCERF2, SpatialSeisPDF.UCERF3});
    private static List<? extends Class<? extends U3LogicTreeBranchNode<?>>> UC33classList = Lists.newArrayList((Object[])new Class[]{FaultModels.class, DeformationModels.class, ScalingRelationships.class, SlipAlongRuptureModels.class, TotalMag5Rate.class, MaxMagOffFault.class, SpatialSeisPDF.class});
    private static final String fix10in50path = "/Users/pmpowers/Documents/OpenSHA/RTGM/data";
    private static final String[] fixList = new String[]{"FortranUpdate", "FSS_UC2map", "MeanUCERF2", "MeanUCERF2update", "MeanUCERF2update_FM2P1", "ModMeanUCERF2update_FM2P1", "NSHMP_CA_SHA", "NSHMP_CA_SHA-epi", "NSHMP_SHA", "NSHMP_SHA-epi"};

    public static void main(String[] args) throws IOException {
        Object src = null;
        Object out = null;
        Object locs = null;
        EnumSet<Period> periods = EnumSet.of(Period.GM0P00, Period.GM0P20, Period.GM1P00, Period.GM4P00);
        EnumSet<ProbOfExceed> PEs = EnumSet.of(ProbOfExceed.PE2IN50, ProbOfExceed.PE1IN100);
    }

    private static void renameCurveFiles(File dir) throws IOException {
        Collection files = FileUtils.listFiles((File)dir, (String[])new String[]{"csv"}, (boolean)true);
        for (File file : files) {
            File newFile = new File(file.getParentFile(), StringUtils.substringAfterLast((String)file.getName(), (String)"_"));
            Files.copy((File)file, (File)newFile);
            file.delete();
        }
    }

    private static void updateCurveFiles(File dir) throws IOException {
        Collection files = FileUtils.listFiles((File)dir, (String[])new String[]{"csv"}, (boolean)true);
        for (File file : files) {
            File newFile = new File(file.getParentFile(), "src_" + file.getName());
            Files.copy((File)file, (File)newFile);
            Period period = Period.valueOf(file.getParentFile().getName());
            List linesIn = Files.readLines((File)file, (Charset)Charsets.US_ASCII);
            Iterable firstLine = SPLIT.split((CharSequence)linesIn.get(0));
            ArbitrarilyDiscretizedFunc curveModel = new ArbitrarilyDiscretizedFunc();
            for (String gmStr : Iterables.skip((Iterable)firstLine, (int)1)) {
                double gmVal = Double.parseDouble(gmStr);
                curveModel.set(gmVal, 0.0);
            }
            Collection gmVals = Collections2.transform(period.getFunction().xValues(), (Function)Functions.toStringFunction());
            Iterable cityFields = Iterables.concat(CITY_FIELDS, (Iterable)gmVals);
            String cityHeader = JOIN.join(cityFields) + LF;
            Files.write((CharSequence)cityHeader, (File)file, (Charset)Charsets.US_ASCII);
            for (String line : Iterables.skip((Iterable)linesIn, (int)1)) {
                Iterable lineIter = SPLIT.split((CharSequence)line);
                ArrayList lineList = Lists.newArrayList((Iterable)lineIter);
                DiscretizedFunc curve = curveModel.deepClone();
                int idx = 0;
                for (String val : Iterables.skip((Iterable)lineIter, (int)1)) {
                    double annRate = Double.parseDouble(val);
                    curve.set(idx++, annRate);
                }
                double pe2in50 = CurveUtilsUC33.getPE(curve, ProbOfExceed.PE2IN50);
                lineList.add(1, Double.toString(pe2in50));
                double pe10in50 = CurveUtilsUC33.getPE(curve, ProbOfExceed.PE10IN50);
                lineList.add(2, Double.toString(pe10in50));
                double rtgm = CurveUtilsUC33.getRTGM(curve, period);
                lineList.add(3, Double.toString(rtgm));
                String newLine = JOIN.join((Iterable)lineList) + LF;
                Files.append((CharSequence)newLine, (File)file, (Charset)Charsets.US_ASCII);
            }
        }
    }

    private static void reorganizeUC3branchResults(Iterable<Period> periods, File srcDir, File outDir, String locPath, boolean ignoreWts) throws IOException {
        Map<String, Location> locMap = UC3_CalcUtils.readSiteFile(locPath);
        Set<String> locNames = locMap.keySet();
        HashBiMap indexMap = HashBiMap.create();
        HashMap wtMap = Maps.newHashMap();
        File[] branchDirs = srcDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return !f.getName().startsWith(".");
            }
        });
        U3APrioriBranchWeightProvider wtProvider = new U3APrioriBranchWeightProvider();
        int index = 0;
        for (File file : branchDirs) {
            if (!file.isDirectory()) continue;
            String branchName = file.getName();
            indexMap.put((Object)branchName, (Object)index);
            U3LogicTreeBranch ltb = U3LogicTreeBranch.fromFileName(branchName);
            double wt = ignoreWts ? 1.0 : wtProvider.getWeight(ltb);
            wtMap.put(index, wt);
            ++index;
        }
        if (!ignoreWts) {
            Collection wts = wtMap.values();
            double sum = DataUtils.sum(Doubles.toArray(wts));
            System.out.println("Weight sum: " + sum);
            Iterator iterator = wtMap.keySet().iterator();
            while (iterator.hasNext()) {
                int idx = (Integer)iterator.next();
                double wt = (Double)wtMap.get(idx);
                wtMap.put(idx, wt / sum);
            }
        }
        HashMap curveMap = Maps.newHashMap();
        ArrayTable table = null;
        for (Period period : periods) {
            table = ArrayTable.create((Iterable)indexMap.values(), locNames);
            curveMap.put(period, table);
        }
        for (File branch : branchDirs) {
            if (!branch.isDirectory()) continue;
            String branchName = branch.getName();
            int branchIdx = (Integer)indexMap.get((Object)branchName);
            double branchWt = (Double)wtMap.get(branchIdx);
            for (Period period : periods) {
                table = (Table)curveMap.get((Object)period);
                File periodDir = new File(branch, period.name());
                File curveFile = new File(periodDir, "curves.csv");
                List lines = Files.readLines((File)curveFile, (Charset)Charsets.US_ASCII);
                for (String line : Iterables.skip((Iterable)lines, (int)1)) {
                    String locStr = StringUtils.substringBefore((String)line, (String)",");
                    String curveStr = StringUtils.substringAfter((String)line, (String)",");
                    String curveStrOut = branchIdx + "," + branchWt + "," + curveStr;
                    table.put((Object)branchIdx, (Object)locStr, (Object)curveStrOut);
                }
            }
        }
        for (Period period : periods) {
            table = (Table)curveMap.get((Object)period);
            for (String name : locNames) {
                File curvesOut = new File(outDir, period.name() + S + name + S + "curves.csv");
                Files.createParentDirs((File)curvesOut);
                Collection gmVals = Collections2.transform(period.getFunction().xValues(), (Function)Functions.toStringFunction());
                ArrayList headers = Lists.newArrayList((Object[])new String[]{"ERF#", "wt"});
                Iterable cityFields = Iterables.concat((Iterable)headers, (Iterable)gmVals);
                String cityHeader = JOIN.join(cityFields) + LF;
                Files.write((CharSequence)cityHeader, (File)curvesOut, (Charset)Charsets.US_ASCII);
                File paramsOut = new File(outDir, period.name() + S + name + S + "params.csv");
                Files.createParentDirs((File)paramsOut);
                Files.write((CharSequence)("ERF#,BranchName" + LF), (File)paramsOut, (Charset)Charsets.US_ASCII);
                BiMap indexMapInverse = indexMap.inverse();
                for (int i = 0; i < indexMap.size(); ++i) {
                    String curveLine = (String)table.get((Object)i, (Object)name) + LF;
                    String paramLine = i + "," + (String)indexMapInverse.get(i) + LF;
                    Files.append((CharSequence)curveLine, (File)curvesOut, (Charset)Charsets.US_ASCII);
                    Files.append((CharSequence)paramLine, (File)paramsOut, (Charset)Charsets.US_ASCII);
                }
            }
        }
    }

    private static void consolidateFractileData(String dir, Iterable<Period> periods, String locPath) throws IOException {
        Map<String, Location> locMap = UC3_CalcUtils.readSiteFile(locPath);
        Set<String> locNames = locMap.keySet();
        ArrayList keys = Lists.newArrayList((Object[])new String[]{"min", "frac02", "frac16", "mean", "frac84", "frac98", "max"});
        ArrayList headFields = Lists.newArrayList((Object[])new String[]{"loc"});
        headFields.addAll(keys);
        String header = JOIN.join((Iterable)headFields) + LF;
        for (Period p : periods) {
            File out2in50 = new File(dir, "FracDatFromHazCurves-" + p.getLabel() + "-2in50.csv");
            Files.write((CharSequence)header, (File)out2in50, (Charset)Charsets.US_ASCII);
            File out1in100 = new File(dir, "FracDatFromHazCurves-" + p.getLabel() + "-1in100.csv");
            Files.write((CharSequence)header, (File)out1in100, (Charset)Charsets.US_ASCII);
            for (String name : locNames) {
                HashMap map2in50 = Maps.newHashMap();
                HashMap map1in100 = Maps.newHashMap();
                for (int i = 0; i < 10; ++i) {
                    File statFile = new File(dir + "run" + i + S + p.name() + S + name + S + "stats.csv");
                    List statLines = Files.readLines((File)statFile, (Charset)Charsets.US_ASCII);
                    for (String line : Iterables.skip((Iterable)statLines, (int)1)) {
                        Iterator dat = SPLIT.split((CharSequence)line).iterator();
                        String key = (String)dat.next();
                        List vals2in50 = (List)map2in50.get(key);
                        if (vals2in50 == null) {
                            vals2in50 = Lists.newArrayList();
                            map2in50.put(key, vals2in50);
                        }
                        vals2in50.add(Double.valueOf((String)dat.next()));
                        List vals1in100 = (List)map1in100.get(key);
                        if (vals1in100 == null) {
                            vals1in100 = Lists.newArrayList();
                            map1in100.put(key, vals1in100);
                        }
                        vals1in100.add(Double.valueOf((String)dat.next()));
                    }
                }
                List<Double> vals2in50 = CurveUtilsUC33.mapToVals(map2in50, keys);
                String line2in50 = name + "," + JOIN.join(vals2in50) + LF;
                Files.append((CharSequence)line2in50, (File)out2in50, (Charset)Charsets.US_ASCII);
                List<Double> vals1in100 = CurveUtilsUC33.mapToVals(map1in100, keys);
                String line1in100 = name + "," + JOIN.join(vals1in100) + LF;
                Files.append((CharSequence)line1in100, (File)out1in100, (Charset)Charsets.US_ASCII);
            }
        }
    }

    private static List<Double> mapToVals(Map<String, List<Double>> map, List<String> keys) {
        ArrayList out = Lists.newArrayList();
        for (String key : keys) {
            List<Double> keyValues = map.get(key);
            double[] values = Doubles.toArray(keyValues);
            double mean = MEAN.evaluate(values);
            double std = STD.evaluate(values, mean);
            out.add(std / mean);
        }
        return out;
    }

    private static void runInvRunSummaries(String dir, Iterable<Period> periods, String locPath) throws IOException {
        Map<String, Location> locMap = UC3_CalcUtils.readSiteFile(locPath);
        Set<String> locNames = locMap.keySet();
        for (Period p : periods) {
            for (String name : locNames) {
                File srcDir = new File(dir + S + p.name() + S + name);
                File curveFile = new File(srcDir, "curves.csv");
                List curveLines = Files.readLines((File)curveFile, (Charset)Charsets.US_ASCII);
                File sumFile = new File(srcDir, "summary.csv");
                File statFile = new File(srcDir, "stats.csv");
                File stat2File = new File(srcDir, "stats2.csv");
                Iterable firstLine = SPLIT.split((CharSequence)curveLines.get(0));
                ArbitrarilyDiscretizedFunc curveModel = new ArbitrarilyDiscretizedFunc();
                for (String gmStr : Iterables.skip((Iterable)firstLine, (int)2)) {
                    double gmVal = Double.parseDouble(gmStr);
                    curveModel.set(gmVal, 0.0);
                }
                ArrayList weights = Lists.newArrayList();
                ArrayList pe2in50s = Lists.newArrayList();
                ArrayList pe1in100s = Lists.newArrayList();
                XY_DataSetList curves = new XY_DataSetList();
                for (String line : Iterables.skip((Iterable)curveLines, (int)1)) {
                    Iterable vals = SPLIT.split((CharSequence)line);
                    double weight = Double.parseDouble((String)Iterables.get((Iterable)vals, (int)1));
                    weights.add(weight);
                    DiscretizedFunc curve = curveModel.deepClone();
                    int idx = 0;
                    for (String val : Iterables.skip((Iterable)vals, (int)2)) {
                        double annRate = Double.parseDouble(val);
                        if (annRate < 0.0) {
                            annRate = 0.0;
                        }
                        curve.set(idx++, annRate);
                    }
                    curves.add(curve);
                    double pe2in50 = CurveUtilsUC33.getPE(curve, ProbOfExceed.PE2IN50);
                    pe2in50s.add(pe2in50);
                    double pe1in100 = CurveUtilsUC33.getPE(curve, ProbOfExceed.PE1IN100);
                    pe1in100s.add(pe1in100);
                }
                ArrayList summaryFields = Lists.newArrayList((Object[])new String[]{"wt", "2in50", "1in100"});
                String summaryHeader = JOIN.join((Iterable)summaryFields) + LF;
                Files.write((CharSequence)summaryHeader, (File)sumFile, (Charset)Charsets.US_ASCII);
                for (int i = 0; i < weights.size(); ++i) {
                    ArrayList values = Lists.newArrayList((Object[])new String[]{Double.toString((Double)weights.get(i)), Double.toString((Double)pe2in50s.get(i)), Double.toString((Double)pe1in100s.get(i))});
                    String summaryLine = JOIN.join((Iterable)values) + LF;
                    Files.append((CharSequence)summaryLine, (File)sumFile, (Charset)Charsets.US_ASCII);
                }
                ArbDiscrEmpiricalDistFunc f2in50 = CurveUtilsUC33.fractileFunc(pe2in50s, weights);
                ArbDiscrEmpiricalDistFunc f1in100 = CurveUtilsUC33.fractileFunc(pe1in100s, weights);
                Iterable stat2Fields = Iterables.concat((Iterable[])new Iterable[]{Lists.newArrayList((Object[])new String[]{"stat", "min", "frac02", "frac016", "mean", "frac84", "frac98", "max"})});
                String stat2Header = JOIN.join(stat2Fields) + LF;
                Files.write((CharSequence)stat2Header, (File)stat2File, (Charset)Charsets.US_ASCII);
                ArrayList intercepts = Lists.newArrayList((Object[])new String[]{"2in50", Double.toString(f2in50.getMinX()), Double.toString(f2in50.getDiscreteFractile(0.02)), Double.toString(f2in50.getDiscreteFractile(0.16)), Double.toString(f2in50.getMean()), Double.toString(f2in50.getDiscreteFractile(0.84)), Double.toString(f2in50.getDiscreteFractile(0.98)), Double.toString(f2in50.getMaxX())});
                Files.append((CharSequence)(JOIN.join((Iterable)intercepts) + LF), (File)stat2File, (Charset)Charsets.US_ASCII);
                intercepts = Lists.newArrayList((Object[])new String[]{"1in100", Double.toString(f1in100.getMinX()), Double.toString(f1in100.getDiscreteFractile(0.02)), Double.toString(f1in100.getDiscreteFractile(0.16)), Double.toString(f1in100.getMean()), Double.toString(f1in100.getDiscreteFractile(0.84)), Double.toString(f1in100.getDiscreteFractile(0.98)), Double.toString(f1in100.getMaxX())});
                Files.append((CharSequence)(JOIN.join((Iterable)intercepts) + LF), (File)stat2File, (Charset)Charsets.US_ASCII);
                FractileCurveCalculator fcc = new FractileCurveCalculator(curves, weights);
                AbstractXY_DataSet minCurve = fcc.getMinimumCurve();
                AbstractXY_DataSet maxCurve = fcc.getMaximumCurve();
                AbstractXY_DataSet meanCurve = fcc.getMeanCurve();
                AbstractXY_DataSet frac02 = fcc.getFractile(0.02);
                AbstractXY_DataSet frac16 = fcc.getFractile(0.16);
                AbstractXY_DataSet frac84 = fcc.getFractile(0.84);
                AbstractXY_DataSet frac98 = fcc.getFractile(0.98);
                Iterable statFields = Iterables.concat((Iterable)Lists.newArrayList((Object[])new String[]{"stat", "2in50", "1in100"}), (Iterable)Iterables.skip((Iterable)firstLine, (int)2));
                String statHeader = JOIN.join(statFields) + LF;
                Files.write((CharSequence)statHeader, (File)statFile, (Charset)Charsets.US_ASCII);
                ArbitrarilyDiscretizedFunc f = CurveUtilsUC33.xyDataToFunc(minCurve);
                double min2in50 = CurveUtilsUC33.getPE(f, ProbOfExceed.PE2IN50);
                double min1in100 = CurveUtilsUC33.getPE(f, ProbOfExceed.PE1IN100);
                Iterable<String> minDat = CurveUtilsUC33.createData("min", min2in50, min1in100, minCurve);
                String minLine = JOIN.join(minDat) + LF;
                Files.append((CharSequence)minLine, (File)statFile, (Charset)Charsets.US_ASCII);
                f = CurveUtilsUC33.xyDataToFunc(frac02);
                double frac02_2in50 = CurveUtilsUC33.getPE(f, ProbOfExceed.PE2IN50);
                double frac02_1in100 = CurveUtilsUC33.getPE(f, ProbOfExceed.PE1IN100);
                Iterable<String> frac02dat = CurveUtilsUC33.createData("frac02", frac02_2in50, frac02_1in100, frac02);
                String frac02line = JOIN.join(frac02dat) + LF;
                Files.append((CharSequence)frac02line, (File)statFile, (Charset)Charsets.US_ASCII);
                f = CurveUtilsUC33.xyDataToFunc(frac16);
                double frac16_2in50 = CurveUtilsUC33.getPE(f, ProbOfExceed.PE2IN50);
                double frac16_1in100 = CurveUtilsUC33.getPE(f, ProbOfExceed.PE1IN100);
                Iterable<String> frac16dat = CurveUtilsUC33.createData("frac16", frac16_2in50, frac16_1in100, frac16);
                String frac16line = JOIN.join(frac16dat) + LF;
                Files.append((CharSequence)frac16line, (File)statFile, (Charset)Charsets.US_ASCII);
                f = CurveUtilsUC33.xyDataToFunc(meanCurve);
                double mean2in50 = CurveUtilsUC33.getPE(f, ProbOfExceed.PE2IN50);
                double mean1in100 = CurveUtilsUC33.getPE(f, ProbOfExceed.PE1IN100);
                Iterable<String> meanDat = CurveUtilsUC33.createData("mean", mean2in50, mean1in100, meanCurve);
                String meanLine = JOIN.join(meanDat) + LF;
                Files.append((CharSequence)meanLine, (File)statFile, (Charset)Charsets.US_ASCII);
                f = CurveUtilsUC33.xyDataToFunc(frac84);
                double frac84_2in50 = CurveUtilsUC33.getPE(f, ProbOfExceed.PE2IN50);
                double frac84_1in100 = CurveUtilsUC33.getPE(f, ProbOfExceed.PE1IN100);
                Iterable<String> frac84dat = CurveUtilsUC33.createData("frac84", frac84_2in50, frac84_1in100, frac84);
                String frac84line = JOIN.join(frac84dat) + LF;
                Files.append((CharSequence)frac84line, (File)statFile, (Charset)Charsets.US_ASCII);
                f = CurveUtilsUC33.xyDataToFunc(frac98);
                double frac98_2in50 = CurveUtilsUC33.getPE(f, ProbOfExceed.PE2IN50);
                double frac98_1in100 = CurveUtilsUC33.getPE(f, ProbOfExceed.PE1IN100);
                Iterable<String> frac98dat = CurveUtilsUC33.createData("frac98", frac98_2in50, frac98_1in100, frac98);
                String frac98line = JOIN.join(frac98dat) + LF;
                Files.append((CharSequence)frac98line, (File)statFile, (Charset)Charsets.US_ASCII);
                f = CurveUtilsUC33.xyDataToFunc(maxCurve);
                double max2in50 = CurveUtilsUC33.getPE(f, ProbOfExceed.PE2IN50);
                double max1in100 = CurveUtilsUC33.getPE(f, ProbOfExceed.PE1IN100);
                Iterable<String> maxDat = CurveUtilsUC33.createData("max", max2in50, max1in100, maxCurve);
                String maxLine = JOIN.join(maxDat) + LF;
                Files.append((CharSequence)maxLine, (File)statFile, (Charset)Charsets.US_ASCII);
            }
        }
    }

    private static ArbDiscrEmpiricalDistFunc fractileFunc(List<Double> values, List<Double> weights) {
        ArbDiscrEmpiricalDistFunc empirical = new ArbDiscrEmpiricalDistFunc();
        for (int i = 0; i < values.size(); ++i) {
            empirical.set(values.get(i), (double)weights.get(i));
        }
        return empirical;
    }

    private static void runBranchSummaries2(String dir, Iterable<Period> periods, String locPath, boolean tornado) throws IOException {
        Map<String, Location> locMap = UC3_CalcUtils.readSiteFile(locPath);
        Set<String> locNames = locMap.keySet();
        for (Period p : periods) {
            for (String name : locNames) {
                File srcDir = new File(dir + S + p.name() + S + name);
                File srcFile = new File(srcDir, "curves.csv");
                File branchFile = new File(srcDir, "params.csv");
                File statFile = new File(srcDir, "stats.csv");
                File sumFile = new File(srcDir, "summary.csv");
                File torRTGM_File = null;
                File tor2in50_File = null;
                File tor10in50_File = null;
                if (tornado) {
                    torRTGM_File = new File(srcDir, "tornado_rtgm.csv");
                    tor2in50_File = new File(srcDir, "tornado_2in50.csv");
                    tor10in50_File = new File(srcDir, "tornado_10in50.csv");
                }
                CurveUtilsUC33.summarizeBranches(srcFile, branchFile, statFile, sumFile, torRTGM_File, tor2in50_File, tor10in50_File, p);
            }
        }
    }

    private static void buildNodeFlagTable(File branchFile, File flagFile) throws IOException {
        List branchLines = Files.readLines((File)branchFile, (Charset)Charsets.US_ASCII);
        ArrayList branchList = Lists.newArrayList();
        for (Object line : Iterables.skip((Iterable)branchLines, (int)1)) {
            Iterable vals = SPLIT.split((CharSequence)line);
            String branchName = (String)Iterables.get((Iterable)vals, (int)1);
            branchList.add(branchName);
        }
        ArrayTable nodeTable = ArrayTable.create((Iterable)branchList, UC33nodeList);
        for (String branchID : nodeTable.rowKeySet()) {
            for (Object nodeID : nodeTable.columnKeySet()) {
                nodeTable.put((Object)branchID, nodeID, (Object)false);
            }
        }
        for (String branchID : branchList) {
            U3LogicTreeBranch branch = U3LogicTreeBranch.fromFileName(branchID);
            for (Class clazz : UC33classList) {
                U3LogicTreeBranchNode node = (U3LogicTreeBranchNode)branch.getValueUnchecked(clazz);
                nodeTable.put((Object)branchID, (Object)node, (Object)true);
            }
        }
        String nodeHeader = JOIN.join(Iterables.transform(UC33nodeList, (Function)new Function<U3LogicTreeBranchNode<?>, String>(){

            public String apply(U3LogicTreeBranchNode<?> nodeID) {
                return nodeID.name();
            }
        })) + LF;
        Files.write((CharSequence)nodeHeader, (File)flagFile, (Charset)Charsets.US_ASCII);
        for (String branchID : nodeTable.rowKeyList()) {
            ArrayList flags = Lists.newArrayList();
            Map map = nodeTable.row((Object)branchID);
            for (U3LogicTreeBranchNode nodeID : nodeTable.columnKeyList()) {
                flags.add((Boolean)map.get(nodeID) != false ? 1 : 0);
            }
            String flagLine = JOIN.join((Iterable)flags) + LF;
            Files.append((CharSequence)flagLine, (File)flagFile, (Charset)Charsets.US_ASCII);
        }
    }

    private static void summarizeBranches(File curveFile, File branchFile, File stat, File summary, File torRTGM, File tor2in50, File tor10in50, Period period) throws IOException {
        List curveLines = Files.readLines((File)curveFile, (Charset)Charsets.US_ASCII);
        ArrayList weights = Lists.newArrayList();
        ArrayList rtgms = Lists.newArrayList();
        ArrayList pe2in50s = Lists.newArrayList();
        ArrayList pe10in50s = Lists.newArrayList();
        XY_DataSetList curves = new XY_DataSetList();
        List branchLines = Files.readLines((File)branchFile, (Charset)Charsets.US_ASCII);
        ArrayList branchList = Lists.newArrayList();
        Iterable firstLine = SPLIT.split((CharSequence)curveLines.get(0));
        ArbitrarilyDiscretizedFunc curveModel = new ArbitrarilyDiscretizedFunc();
        for (String gmStr : Iterables.skip((Iterable)firstLine, (int)2)) {
            double gmVal = Double.parseDouble(gmStr);
            curveModel.set(gmVal, 0.0);
        }
        for (String line : Iterables.skip((Iterable)curveLines, (int)1)) {
            Iterable vals = SPLIT.split((CharSequence)line);
            double weight = Double.parseDouble((String)Iterables.get((Iterable)vals, (int)1));
            weights.add(weight);
            DiscretizedFunc curve = curveModel.deepClone();
            int idx = 0;
            for (String val : Iterables.skip((Iterable)vals, (int)2)) {
                double annRate = Double.parseDouble(val);
                if (annRate < 0.0) {
                    annRate = 0.0;
                }
                curve.set(idx++, annRate);
            }
            curves.add(curve);
            double pe2in50 = CurveUtilsUC33.getPE(curve, ProbOfExceed.PE2IN50);
            pe2in50s.add(pe2in50);
            double pe10in50 = CurveUtilsUC33.getPE(curve, ProbOfExceed.PE10IN50);
            pe10in50s.add(pe10in50);
            double rtgm = CurveUtilsUC33.getRTGM(curve, period);
            rtgms.add(rtgm);
        }
        for (String line : Iterables.skip((Iterable)branchLines, (int)1)) {
            Iterable vals = SPLIT.split((CharSequence)line);
            String branchName = (String)Iterables.get((Iterable)vals, (int)1);
            branchList.add(branchName);
        }
        Iterable summaryFields = Iterables.concat((Iterable[])new Iterable[]{SUMMARY_FIELDS});
        String summaryHeader = JOIN.join(summaryFields) + LF;
        Files.write((CharSequence)summaryHeader, (File)summary, (Charset)Charsets.US_ASCII);
        for (int i = 0; i < weights.size(); ++i) {
            Iterable<String> lineData = CurveUtilsUC33.createSummaryData((Double)weights.get(i), (Double)pe2in50s.get(i), (Double)pe10in50s.get(i), (Double)rtgms.get(i));
            String summaryLine = JOIN.join(lineData) + LF;
            Files.append((CharSequence)summaryLine, (File)summary, (Charset)Charsets.US_ASCII);
        }
        if (torRTGM != null) {
            TornadoData tdRTGM = new UC3_TornadoBuilder(branchList, rtgms).build();
            Files.write((CharSequence)tdRTGM.toSortedString(), (File)torRTGM, (Charset)Charsets.US_ASCII);
            TornadoData td2in50 = new UC3_TornadoBuilder(branchList, pe2in50s).build();
            Files.write((CharSequence)td2in50.toSortedString(), (File)tor2in50, (Charset)Charsets.US_ASCII);
            TornadoData td10in50 = new UC3_TornadoBuilder(branchList, pe10in50s).build();
            Files.write((CharSequence)td10in50.toSortedString(), (File)tor10in50, (Charset)Charsets.US_ASCII);
        }
        FractileCurveCalculator fcc = new FractileCurveCalculator(curves, weights);
        AbstractXY_DataSet minCurve = fcc.getMinimumCurve();
        AbstractXY_DataSet maxCurve = fcc.getMaximumCurve();
        AbstractXY_DataSet meanCurve = fcc.getMeanCurve();
        ArbitrarilyDiscretizedFunc f = CurveUtilsUC33.xyDataToFunc(meanCurve);
        double mean2in50 = CurveUtilsUC33.getPE(f, ProbOfExceed.PE2IN50);
        double mean10in50 = CurveUtilsUC33.getPE(f, ProbOfExceed.PE10IN50);
        double meanRTGM = CurveUtilsUC33.getRTGM(f, period);
        f = CurveUtilsUC33.xyDataToFunc(minCurve);
        double min2in50 = CurveUtilsUC33.getPE(f, ProbOfExceed.PE2IN50);
        double min10in50 = CurveUtilsUC33.getPE(f, ProbOfExceed.PE10IN50);
        double minRTGM = CurveUtilsUC33.getRTGM(f, period);
        f = CurveUtilsUC33.xyDataToFunc(maxCurve);
        double max2in50 = CurveUtilsUC33.getPE(f, ProbOfExceed.PE2IN50);
        double max10in50 = CurveUtilsUC33.getPE(f, ProbOfExceed.PE10IN50);
        double maxRTGM = CurveUtilsUC33.getRTGM(f, period);
        Iterable statFields = Iterables.concat(STAT_FIELDS, (Iterable)Iterables.skip((Iterable)firstLine, (int)2));
        String statHeader = JOIN.join(statFields) + LF;
        Files.write((CharSequence)statHeader, (File)stat, (Charset)Charsets.US_ASCII);
        Iterable<String> meanDat = CurveUtilsUC33.createData("mean", mean2in50, mean10in50, meanRTGM, meanCurve);
        String meanLine = JOIN.join(meanDat) + LF;
        Files.append((CharSequence)meanLine, (File)stat, (Charset)Charsets.US_ASCII);
        Iterable<String> minDat = CurveUtilsUC33.createData("min", min2in50, min10in50, minRTGM, minCurve);
        String minLine = JOIN.join(minDat) + LF;
        Files.append((CharSequence)minLine, (File)stat, (Charset)Charsets.US_ASCII);
        Iterable<String> maxDat = CurveUtilsUC33.createData("max", max2in50, max10in50, maxRTGM, maxCurve);
        String maxLine = JOIN.join(maxDat) + LF;
        Files.append((CharSequence)maxLine, (File)stat, (Charset)Charsets.US_ASCII);
    }

    private static void generateConvStatData(Iterable<Period> periods, Iterable<ProbOfExceed> PEs) throws IOException {
        String srcPath = "tmp/UC33/curves/src-reduce/UC33-conv/";
        String outPath = "tmp/UC33/curves/conv/conv200stats.csv";
        List<String> siteList = CurveUtilsUC33.readSiteFile("tmp/UC33/curvejobs/sites/all.txt");
        Mean meanCalc = new Mean();
        StandardDeviation stdCalc = new StandardDeviation();
        HashMap lineMap = Maps.newHashMap();
        lineMap.put("site", Lists.newArrayList((Object[])new String[]{"site"}));
        for (String locID : siteList) {
            lineMap.put(locID, Lists.newArrayList((Object[])new String[]{locID}));
        }
        for (Period p : periods) {
            for (ProbOfExceed pe : PEs) {
                String pHead = p.equals((Object)Period.GM0P00) ? "PGA" : (p.equals((Object)Period.GM0P20) ? "5Hz" : (p.equals((Object)Period.GM1P00) ? "1Hz" : "4sec"));
                String peHead = pe.equals((Object)ProbOfExceed.PE2IN50) ? "2in50" : "1in100";
                String label = pHead + "-" + peHead;
                ((List)lineMap.get("site")).add(label + "-mean");
                ((List)lineMap.get("site")).add(label + "-std");
                for (String locID : siteList) {
                    File srcFile = new File(srcPath + p.name() + S + locID + S + "curves.csv");
                    List<DiscretizedFunc> funcs = CurveUtilsUC33.readCurves(srcFile, p);
                    double[] vals = Doubles.toArray(CurveUtilsUC33.getPEs(funcs, pe));
                    double mean = meanCalc.evaluate(vals);
                    double std = stdCalc.evaluate(vals, mean);
                    ((List)lineMap.get(locID)).add(Double.toString(mean));
                    ((List)lineMap.get(locID)).add(Double.toString(std));
                }
            }
        }
        File outFile = new File(outPath);
        Files.write((CharSequence)(JOIN.join((Iterable)lineMap.get("site")) + LF), (File)outFile, (Charset)Charsets.US_ASCII);
        for (String locID : siteList) {
            Files.append((CharSequence)(JOIN.join((Iterable)lineMap.get(locID)) + LF), (File)outFile, (Charset)Charsets.US_ASCII);
        }
    }

    public static List<String> readSiteFile(String path) throws IOException {
        File f = new File(path);
        List lines = Files.readLines((File)f, (Charset)Charsets.US_ASCII);
        ArrayList locIDs = Lists.newArrayList();
        for (String line : lines) {
            if (line.startsWith("#")) continue;
            Iterator it = SPLIT.split((CharSequence)line).iterator();
            locIDs.add((String)it.next());
        }
        return ImmutableList.copyOf((Collection)locIDs);
    }

    private static List<DiscretizedFunc> readCurves(File f, Period p) throws IOException {
        ArrayList fList = Lists.newArrayList();
        List lines = Files.readLines((File)f, (Charset)Charsets.US_ASCII);
        for (String line : Iterables.skip((Iterable)lines, (int)1)) {
            ArbitrarilyDiscretizedFunc func = p.getFunction();
            ArrayList rates = Lists.newArrayList((Iterable)SPLIT.split((CharSequence)line));
            for (int i = 2; i < rates.size(); ++i) {
                func.set(i - 2, (double)Double.valueOf((String)rates.get(i)));
            }
            fList.add(func);
        }
        return fList;
    }

    private static List<Double> getPEs(List<DiscretizedFunc> funcs, ProbOfExceed pe) {
        ArrayList PEs = Lists.newArrayList();
        for (DiscretizedFunc f : funcs) {
            PEs.add(CurveUtilsUC33.getPE(f, pe));
        }
        return PEs;
    }

    public static double getPE(DiscretizedFunc f, ProbOfExceed pe) {
        try {
            return f.getFirstInterpolatedX_inLogXLogYDomain(pe.annualRate());
        }
        catch (InvalidRangeException ire) {
            double[] Xs = Doubles.toArray((Collection)Lists.reverse(f.xValues()));
            double[] Ys = Doubles.toArray((Collection)Lists.reverse(f.yValues()));
            return Interpolate.findLogLogY(Ys, Xs, pe.annualRate());
        }
    }

    public static double getRTGM(DiscretizedFunc f, Period p) {
        if (p != Period.GM0P20 && p != Period.GM1P00) {
            return 0.0;
        }
        RTGM.Frequency freq = p.equals((Object)Period.GM0P20) ? RTGM.Frequency.SA_0P20 : RTGM.Frequency.SA_1P00;
        RTGM rtgm = RTGM.create(f, freq, 0.8).call();
        return rtgm.get();
    }

    private static Iterable<String> createData(String label, double pe2in50, double pe10in50, double rtgm, XY_DataSet curve) {
        ArrayList intercepts = Lists.newArrayList((Object[])new String[]{label, Double.toString(pe2in50), Double.toString(pe10in50), Double.toString(rtgm)});
        Collection values = Collections2.transform(curve.yValues(), (Function)Functions.toStringFunction());
        return Iterables.concat((Iterable)intercepts, (Iterable)values);
    }

    private static Iterable<String> createData(String label, double pe2in50, double pe1in100, XY_DataSet curve) {
        ArrayList intercepts = Lists.newArrayList((Object[])new String[]{label, Double.toString(pe2in50), Double.toString(pe1in100)});
        Collection values = Collections2.transform(curve.yValues(), (Function)Functions.toStringFunction());
        return Iterables.concat((Iterable)intercepts, (Iterable)values);
    }

    private static Iterable<String> createSummaryData(double wt, double pe2in50, double pe10in50, double rtgm) {
        ArrayList values = Lists.newArrayList((Object[])new String[]{Double.toString(wt), Double.toString(pe2in50), Double.toString(pe10in50), Double.toString(rtgm)});
        return values;
    }

    public static void generateFortranCityData() throws IOException {
        String srcPath = "/Volumes/Scratch/nshmp-sources/FortranUpdate";
        String outPath = "/Volumes/Scratch/rtgm/FortranUpdate2";
        EnumSet<Period> periods = EnumSet.of(Period.GM0P00, Period.GM0P20, Period.GM1P00);
        Map<String, Location> siteMap = UC3_CalcUtils.readSiteFile("tmp/UC3sites/all.txt");
        for (Period p : periods) {
            File src = new File(srcPath + S + p.name() + S + "curves.dat");
            File out = new File(outPath + S + p.name() + S + "FORT_curves.csv");
            try {
                Files.createParentDirs((File)out);
                CurveUtilsUC33.deriveCityData(siteMap, src, out, p);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }

    private static void deriveCityData(Map<String, Location> siteMap, File src, File out, Period period) throws IOException {
        Collection gmVals = Collections2.transform(period.getFunction().xValues(), (Function)Functions.toStringFunction());
        Iterable cityFields = Iterables.concat(CITY_FIELDS, (Iterable)gmVals);
        String cityHeader = JOIN.join(cityFields) + LF;
        Files.write((CharSequence)cityHeader, (File)out, (Charset)Charsets.US_ASCII);
        CurveContainer cc = CurveContainer.create(src);
        for (String siteName : siteMap.keySet()) {
            Location loc = siteMap.get(siteName);
            DiscretizedFunc curve = cc.getCurve(loc);
            double pe2in50 = CurveUtilsUC33.getPE(curve, ProbOfExceed.PE2IN50);
            double pe10in50 = CurveUtilsUC33.getPE(curve, ProbOfExceed.PE10IN50);
            double rtgm = CurveUtilsUC33.getRTGM(curve, period);
            Iterable<String> cityData = CurveUtilsUC33.createData(siteName, pe2in50, pe10in50, rtgm, curve);
            String cityLine = JOIN.join(cityData) + LF;
            Files.append((CharSequence)cityLine, (File)out, (Charset)Charsets.US_ASCII);
        }
    }

    private static int medianIndex(List<Double> values) {
        double[] sortedVals = Doubles.toArray(values);
        Arrays.sort(sortedVals);
        int idx = (sortedVals.length - 1) / 2;
        double median = sortedVals[idx];
        return values.indexOf(median);
    }

    private static void fix10in50s() {
        try {
            EnumSet<Period> periods = EnumSet.of(Period.GM0P00, Period.GM0P20, Period.GM1P00);
            for (String dir : fixList) {
                for (Period p : periods) {
                    String path = fix10in50path + S + dir + S + String.valueOf((Object)p) + S;
                    File curveFile = new File(path + "NSHMP08_WUS_curves.csv");
                    if (!curveFile.exists()) {
                        curveFile = new File(path + "NSHMP08_curves.csv");
                    }
                    if (!curveFile.exists()) {
                        curveFile = new File(path + "FORT_curves.csv");
                    }
                    List linesIn = Files.readLines((File)curveFile, (Charset)Charsets.US_ASCII);
                    Iterable firstLine = SPLIT.split((CharSequence)linesIn.get(0));
                    ArbitrarilyDiscretizedFunc curveModel = new ArbitrarilyDiscretizedFunc();
                    for (String gmStr : Iterables.skip((Iterable)firstLine, (int)4)) {
                        double gmVal = Double.parseDouble(gmStr);
                        curveModel.set(gmVal, 0.0);
                    }
                    Files.write((CharSequence)((String)linesIn.get(0) + LF), (File)curveFile, (Charset)Charsets.US_ASCII);
                    for (String line : Iterables.skip((Iterable)linesIn, (int)1)) {
                        Iterable lineIter = SPLIT.split((CharSequence)line);
                        ArrayList lineList = Lists.newArrayList((Iterable)lineIter);
                        DiscretizedFunc curve = curveModel.deepClone();
                        int idx = 0;
                        for (String val : Iterables.skip((Iterable)lineIter, (int)4)) {
                            double annRate = Double.parseDouble(val);
                            curve.set(idx++, annRate);
                        }
                        double pe10in50 = CurveUtilsUC33.getPE(curve, ProbOfExceed.PE10IN50);
                        lineList.set(2, Double.toString(pe10in50));
                        String fixedLine = JOIN.join((Iterable)lineList) + LF;
                        Files.append((CharSequence)fixedLine, (File)curveFile, (Charset)Charsets.US_ASCII);
                    }
                }
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    private static void listAllBranches() {
        try {
            String path1440 = "/Users/pmpowers/projects/OpenSHA/tmp/invSols/tree/2012_10_29-tree-fm31_x7-fm32_x1_COMPOUND_SOL.zip";
            U3CompoundFaultSystemSolution cfss = UC3_CalcUtils.getCompoundSolution(path1440);
            ArrayList branches = Lists.newArrayList(cfss.getBranches());
            File out = new File("tmp/branchlist1440.txt");
            Files.write((CharSequence)"", (File)out, (Charset)Charsets.US_ASCII);
            int idx = 0;
            for (U3LogicTreeBranch branch : branches) {
                Files.append((CharSequence)(idx++ + " " + branch.buildFileName() + LF), (File)out, (Charset)Charsets.US_ASCII);
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    private static void writeConvTestMags() throws IOException {
        int fssRupIdx = 29749;
        int maxIdx = 1;
        File out = new File("tmp/SRPconvTestRupRates.txt");
        String header = TAB_JOIN.join((Object)"FSSidx", (Object)"fssRate", new Object[]{"fssMag", "erfRate", "erfMag"}) + LF;
        Files.write((CharSequence)header, (File)out, (Charset)Charsets.US_ASCII);
        String convSolPath = "/Users/pmpowers/projects/OpenSHA/tmp/invSols/conv/FM3_1_ZENG_Shaw09Mod_DsrTap_CharConst_M5Rate8.7_MMaxOff7.6_NoFix_SpatSeisU3_mean_sol.zip";
        U3AverageFaultSystemSolution afss = UC3_CalcUtils.getAvgSolution(convSolPath);
        for (int i = 0; i < maxIdx; ++i) {
            InversionFaultSystemSolution fss = afss.getSolution(i);
            double fssRupRate = fss.getRateForRup(fssRupIdx);
            double fssRupMag = fss.getRupSet().getMagForRup(fssRupIdx);
            System.out.println(fssRupRate + "\t" + fssRupMag);
            FaultSystemSolutionERF erf = UC3_CalcUtils.getUC3_ERF(convSolPath, IncludeBackgroundOption.EXCLUDE, false, true, 1.0);
            erf.updateForecast();
            int srcIdx = -1;
            for (int j = 0; j < erf.getNumFaultSystemSources(); ++j) {
                int rupIdx = erf.getFltSysRupIndexForSource(j);
                if (rupIdx != fssRupIdx) continue;
                srcIdx = j;
                break;
            }
            Preconditions.checkArgument((srcIdx != -1 ? 1 : 0) != 0);
            ProbEqkSource src = erf.getSource(srcIdx);
            System.out.println(src.getSourceMetadata());
            ProbEqkRupture rup = src.getRupture(0);
            double erfRupRate = rup.getMeanAnnualRate(1.0);
            double erfRupMag = rup.getMag();
            String outLine = TAB_JOIN.join((Object)i, (Object)fssRupRate, new Object[]{fssRupMag, erfRupRate, erfRupMag}) + LF;
            System.out.println(outLine);
            Files.append((CharSequence)outLine, (File)out, (Charset)Charsets.US_ASCII);
        }
    }

    private static ArbitrarilyDiscretizedFunc xyDataToFunc(XY_DataSet xy) {
        ArbitrarilyDiscretizedFunc f = new ArbitrarilyDiscretizedFunc();
        for (Point2D p : xy) {
            f.set(p);
        }
        return f;
    }

    private static void extractFaultCurves(String totalDir, String bgDir, String fltDir, String locFile) throws IOException {
        EnumSet<Period> periods = EnumSet.of(Period.GM0P00, Period.GM0P20, Period.GM1P00, Period.GM4P00);
        Map<String, Location> locMap = UC3_CalcUtils.readSiteFile(locFile);
        String paramFile = "params.csv";
        String curveFile = "curves.csv";
        for (Period p : periods) {
            for (String locName : locMap.keySet()) {
                File totSrc = new File(totalDir + String.valueOf((Object)p) + S + locName + S + curveFile);
                File bgSrc = new File(bgDir + String.valueOf((Object)p) + S + locName + S + curveFile);
                File fltDest = new File(fltDir + String.valueOf((Object)p) + S + locName + S + curveFile);
                Iterator totCurves = Files.readLines((File)totSrc, (Charset)Charsets.US_ASCII).iterator();
                Iterator bgCurves = Files.readLines((File)bgSrc, (Charset)Charsets.US_ASCII).iterator();
                Files.createParentDirs((File)fltDest);
                Files.write((CharSequence)((String)totCurves.next() + LF), (File)fltDest, (Charset)Charsets.US_ASCII);
                bgCurves.next();
                while (totCurves.hasNext()) {
                    Iterable totDat = SPLIT.split((CharSequence)totCurves.next());
                    Iterable bgDat = SPLIT.split((CharSequence)bgCurves.next());
                    Iterable totValStr = Iterables.skip((Iterable)totDat, (int)2);
                    Iterable bgValStr = Iterables.skip((Iterable)bgDat, (int)2);
                    List<Double> totVals = CurveUtilsUC33.stringToDouble(totValStr);
                    List<Double> bgVals = CurveUtilsUC33.stringToDouble(bgValStr);
                    List<Double> fltVals = DataUtils.subtract(totVals, bgVals);
                    Iterable dat = Iterables.concat((Iterable)Iterables.limit((Iterable)totDat, (int)2), fltVals);
                    String fltStr = JOIN.join(dat);
                    Files.append((CharSequence)(fltStr + LF), (File)fltDest, (Charset)Charsets.US_ASCII);
                }
                File paramSrc = new File(totalDir + String.valueOf((Object)p) + S + locName + S + paramFile);
                File paramDest = new File(fltDir + String.valueOf((Object)p) + S + locName + S + paramFile);
                Files.createParentDirs((File)paramDest);
                Files.copy((File)paramSrc, (File)paramDest);
            }
        }
    }

    private static List<Double> stringToDouble(Iterable<String> strVals) {
        ArrayList vals = Lists.newArrayList();
        for (String s : strVals) {
            vals.add(Double.parseDouble(s));
        }
        return vals;
    }

    private static List<String> doubleToString(Iterable<Double> dblVals) {
        ArrayList strs = Lists.newArrayList();
        for (Double d : dblVals) {
            strs.add(Double.toString(d));
        }
        return strs;
    }

    private static void readBinaries() throws IOException {
        String srcDir = "/Users/pmpowers/projects/NSHMP/tmp/out";
        String srcFile = "CAdeep_2014.pga";
        File curveFile = new File(srcDir, srcFile);
        URL url = curveFile.toURI().toURL();
        CurveContainer cc = CurveContainer.create(url);
        System.out.println(NEHRP_TestCity.SANTA_ROSA.location());
        System.out.println(cc.getCurve(NEHRP_TestCity.SANTA_ROSA.location()));
    }

    static class UC3_TornadoBuilder {
        private List<Double> values;
        private List<String> branchNames;
        private Map<String, Integer> branchIdxMap = Maps.newHashMap();

        UC3_TornadoBuilder(List<String> branchNames, List<Double> values) {
            Preconditions.checkArgument((branchNames.size() == values.size() ? 1 : 0) != 0);
            this.branchNames = branchNames;
            this.values = values;
            int idx = 0;
            for (String name : branchNames) {
                this.branchIdxMap.put(name, idx++);
            }
        }

        public TornadoData build() {
            ArrayList classList = Lists.newArrayList();
            HashMap nodeMap = Maps.newHashMap();
            for (Class<? extends U3LogicTreeBranchNode<?>> clazz : U3LogicTreeBranch.getLogicTreeNodeClasses()) {
                HashSet nodeSet = Sets.newHashSet();
                classList.add(clazz);
                nodeMap.put(clazz, nodeSet);
            }
            for (String string : this.branchNames) {
                U3LogicTreeBranch ltb = U3LogicTreeBranch.fromFileName(string);
                for (U3LogicTreeBranchNode node : ltb) {
                    Class<?> clazz = U3LogicTreeBranch.getEnumEnclosingClass(node.getClass());
                    Set nodeSet = (Set)nodeMap.get(clazz);
                    nodeSet.add(node);
                }
            }
            int medIdx = CurveUtilsUC33.medianIndex(this.values);
            double d = this.values.get(medIdx);
            String medBrName = this.branchNames.get(medIdx);
            U3LogicTreeBranch medLTB = U3LogicTreeBranch.fromFileName(medBrName);
            TornadoData td = new TornadoData(d);
            for (Class clazz : classList) {
                Set nodeSet = (Set)nodeMap.get(clazz);
                for (U3LogicTreeBranchNode node : nodeSet) {
                    U3LogicTreeBranch ltb = (U3LogicTreeBranch)medLTB.clone();
                    ltb.setValue(node);
                    String brName = ltb.buildFileName();
                    int brIdx = this.branchIdxMap.get(brName);
                    double brVal = this.values.get(brIdx);
                    td.add(clazz, (Enum)((Object)node), brVal);
                }
            }
            return td;
        }
    }
}

