/*
 * Decompiled with CFR 0.152.
 */
package scratch.peter.nshmp;

import com.google.common.base.CharMatcher;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import com.google.common.io.LineProcessor;
import com.google.common.io.LittleEndianDataInputStream;
import com.google.common.primitives.Doubles;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.math3.util.Precision;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.commons.geo.GriddedRegion;
import org.opensha.commons.geo.Location;
import org.opensha.commons.util.DataUtils;
import org.opensha.nshmp2.tmp.TestGrid;
import org.opensha.nshmp2.util.Period;
import scratch.peter.nshmp.NSHMP_UtilsDev;

public class CurveContainer
implements Iterable<Location> {
    private GriddedRegion region;
    private List<Double> xs;
    private Map<Integer, List<Double>> ysMap;

    public DiscretizedFunc getCurve(Location loc) {
        int idx = this.region.indexForLocation(loc);
        Preconditions.checkArgument((idx != -1 ? 1 : 0) != 0, (Object)("Location is out of range: " + String.valueOf(loc)));
        List<Double> ys = this.ysMap.get(idx);
        ArbitrarilyDiscretizedFunc f = new ArbitrarilyDiscretizedFunc();
        for (int i = 0; i < this.xs.size(); ++i) {
            f.set(this.xs.get(i), (double)ys.get(i));
        }
        return f;
    }

    public List<Double> getValues(Location loc) {
        int idx = this.region.indexForLocation(loc);
        Preconditions.checkArgument((idx != -1 ? 1 : 0) != 0, (Object)("Location is out of range: " + String.valueOf(loc)));
        return this.ysMap.get(idx);
    }

    public int size() {
        return this.ysMap.size();
    }

    public CurveContainer scale(double scale) {
        for (List<Double> values : this.ysMap.values()) {
            DataUtils.scale(scale, values);
        }
        return this;
    }

    public void add(CurveContainer cc) {
        Preconditions.checkArgument((boolean)this.region.equals(cc.region));
        for (Integer idx : this.ysMap.keySet()) {
            DataUtils.add(this.ysMap.get(idx), cc.ysMap.get(idx));
        }
    }

    public void union(CurveContainer cc) {
        Preconditions.checkArgument((this.xs.size() == cc.xs.size() ? 1 : 0) != 0, (String)"Curve container size: %s != %s", (int)this.xs.size(), (int)cc.xs.size());
        for (Location loc : this) {
            int idxFrom = cc.region.indexForLocation(loc);
            int idxTo = this.region.indexForLocation(loc);
            if (idxFrom == -1) continue;
            List<Double> fromYs = cc.ysMap.get(idxFrom);
            DataUtils.add(this.ysMap.get(idxTo), fromYs);
        }
    }

    public void addNSHMP(CurveContainer cc) {
        for (Location loc : this) {
            DiscretizedFunc f = null;
            try {
                f = cc.getCurve(loc);
            }
            catch (IllegalArgumentException iae) {
                System.out.println("Swallowed");
                continue;
            }
            int idx = this.region.indexForLocation(loc);
            DataUtils.add(this.ysMap.get(idx), f.yValues().subList(0, this.xs.size()));
        }
    }

    public void subtract(CurveContainer cc) {
        Preconditions.checkArgument((boolean)this.region.equals(cc.region));
        for (Integer idx : this.ysMap.keySet()) {
            DataUtils.subtract(this.ysMap.get(idx), cc.ysMap.get(idx));
        }
    }

    @Override
    public Iterator<Location> iterator() {
        return this.region.iterator();
    }

    public static CurveContainer create(File f) {
        CurveFileProcessor_NSHMP cfp = new CurveFileProcessor_NSHMP(NSHMP_UtilsDev.getNSHMP_Region());
        CurveContainer curves = null;
        try {
            curves = (CurveContainer)Files.readLines((File)f, (Charset)Charsets.US_ASCII, (LineProcessor)cfp);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return curves;
    }

    public static CurveContainer create(File f, TestGrid tg, double spacing) {
        CurveFileProcessor_SHA cfp = new CurveFileProcessor_SHA(tg.grid(spacing));
        CurveContainer curves = null;
        try {
            curves = (CurveContainer)Files.readLines((File)f, (Charset)Charsets.US_ASCII, (LineProcessor)cfp);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return curves;
    }

    public static CurveContainer create(GriddedRegion gr, List<Double> xs) {
        CurveContainer cc = new CurveContainer();
        cc.xs = ImmutableList.copyOf(xs);
        cc.ysMap = Maps.newHashMap();
        cc.region = gr;
        for (int i = 0; i < gr.getNodeCount(); ++i) {
            cc.ysMap.put(i, Doubles.asList((double[])new double[xs.size()]));
        }
        return cc;
    }

    public static CurveContainer create(URL url) throws IOException {
        LittleEndianDataInputStream in = new LittleEndianDataInputStream(url.openStream());
        CurveContainer cc = new CurveContainer();
        int n = 128;
        for (int i = 0; i < 6; ++i) {
            byte[] nameDat = new byte[n];
            in.read(nameDat, 0, n);
        }
        float period = in.readFloat();
        int nX = in.readInt();
        Period p = Period.valueForPeriod(period);
        cc.xs = Lists.newArrayList();
        for (int i = 0; i < 20; ++i) {
            double val = Precision.round((double)in.readFloat(), (int)3);
            if (i >= nX) continue;
            cc.xs.add(val);
        }
        ArrayList extras = Lists.newArrayList();
        for (int i = 0; i < 10; ++i) {
            double val = Precision.round((double)in.readFloat(), (int)2);
            extras.add(val);
        }
        double minLon = (Double)extras.get(1);
        double maxLon = (Double)extras.get(2);
        double spacing = (Double)extras.get(3);
        double minLat = (Double)extras.get(4);
        double maxLat = (Double)extras.get(5);
        Location nwLoc = new Location(maxLat, minLon);
        Location seLoc = new Location(minLat, maxLon);
        cc.region = new GriddedRegion(nwLoc, seLoc, spacing, GriddedRegion.ANCHOR_0_0);
        int nRows = (int)Math.rint((maxLat - minLat) / spacing) + 1;
        int nCols = (int)Math.rint((maxLon - minLon) / spacing) + 1;
        cc.ysMap = Maps.newHashMapWithExpectedSize((int)cc.region.getNodeCount());
        for (int i = 0; i < cc.region.getNodeCount(); ++i) {
            ArrayList vals = Lists.newArrayList();
            for (int j = 0; j < nX; ++j) {
                vals.add(Double.valueOf(in.readFloat()));
            }
            int regionIdx = CurveContainer.calcIndex(i, nRows, nCols);
            cc.ysMap.put(regionIdx, vals);
        }
        in.close();
        return cc;
    }

    private static int calcIndex(int idx, int nRows, int nCols) {
        return (nRows - idx / nCols - 1) * nCols + idx % nCols;
    }

    public static void main(String[] args) throws IOException {
        String srcDir = "/Users/pmpowers/projects/NSHMP/tmp/out";
        String srcFile = "sub.2014.pga";
        File curveFile = new File(srcDir, srcFile);
        URL url = curveFile.toURI().toURL();
        CurveContainer.create(url);
    }

    static class CurveFileProcessor_NSHMP
    implements LineProcessor<CurveContainer> {
        private Splitter split = Splitter.on((CharMatcher)CharMatcher.whitespace()).omitEmptyStrings();
        private int xCount = 0;
        private int headCount = 0;
        private int headLines = 3;
        private CurveContainer cc = new CurveContainer();

        CurveFileProcessor_NSHMP(GriddedRegion region) {
            this.cc.region = region;
            this.cc.xs = Lists.newArrayList();
            this.cc.ysMap = Maps.newHashMapWithExpectedSize((int)region.getNodeCount());
        }

        public CurveContainer getResult() {
            return this.cc;
        }

        public boolean processLine(String line) throws IOException {
            if (this.headCount < this.headLines) {
                ++this.headCount;
                return true;
            }
            if (line.length() < 20) {
                this.cc.xs.add(Double.parseDouble(line));
                ++this.xCount;
                return true;
            }
            this.addCurve(line);
            return true;
        }

        private void addCurve(String line) {
            Iterator it = this.split.split((CharSequence)line).iterator();
            Location loc = new Location(NSHMP_UtilsDev.toNum((String)it.next()), NSHMP_UtilsDev.toNum((String)it.next()));
            int idx = this.cc.region.indexForLocation(loc);
            double[] vals = new double[this.xCount];
            for (int i = 0; i < this.xCount; ++i) {
                vals[i] = NSHMP_UtilsDev.toNum((String)it.next());
            }
            this.cc.ysMap.put(idx, Doubles.asList((double[])vals));
        }
    }

    public static class CurveFileProcessor_SHA
    implements LineProcessor<CurveContainer> {
        private Splitter split = Splitter.on((char)',').omitEmptyStrings();
        private boolean firstLine = true;
        private CurveContainer cc = new CurveContainer();

        public CurveFileProcessor_SHA(GriddedRegion region) {
            this.cc.region = region;
            this.cc.xs = Lists.newArrayList();
            this.cc.ysMap = Maps.newHashMapWithExpectedSize((int)region.getNodeCount());
        }

        public CurveContainer getResult() {
            return this.cc;
        }

        public boolean processLine(String line) throws IOException {
            if (this.firstLine) {
                Iterable vals = Iterables.skip((Iterable)this.split.split((CharSequence)line), (int)2);
                for (String val : vals) {
                    this.cc.xs.add(Double.parseDouble(val));
                }
                this.firstLine = false;
                return true;
            }
            this.addCurve(line);
            return true;
        }

        private void addCurve(String line) {
            Iterable it = this.split.split((CharSequence)line);
            Location loc = new Location(NSHMP_UtilsDev.toNum((String)Iterables.get((Iterable)it, (int)0)), NSHMP_UtilsDev.toNum((String)Iterables.get((Iterable)it, (int)1)));
            int idx = this.cc.region.indexForLocation(loc);
            Iterable sVals = Iterables.skip((Iterable)it, (int)2);
            ArrayList vals = Lists.newArrayList();
            for (String sVal : sVals) {
                vals.add(NSHMP_UtilsDev.toNum(sVal));
            }
            this.cc.ysMap.put(idx, vals);
        }
    }
}

