/*
 * Decompiled with CFR 0.152.
 */
package scratch.peter.ucerf3;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.primitives.Doubles;
import com.google.common.primitives.Ints;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opensha.commons.data.TimeSpan;
import org.opensha.commons.eq.MagUtils;
import org.opensha.commons.util.FaultUtils;
import org.opensha.sha.earthquake.AbstractERF;
import org.opensha.sha.earthquake.ProbEqkSource;
import org.opensha.sha.earthquake.rupForecastImpl.FaultRuptureSource;
import org.opensha.sha.faultSurface.CompoundSurface;
import org.opensha.sha.faultSurface.FaultSection;
import org.opensha.sha.faultSurface.RuptureSurface;
import scratch.UCERF3.enumTreeBranches.DeformationModels;
import scratch.UCERF3.enumTreeBranches.FaultModels;
import scratch.UCERF3.enumTreeBranches.ScalingRelationships;
import scratch.UCERF3.utils.DeformationModelFetcher;
import scratch.UCERF3.utils.UCERF3_DataUtils;

public class NSHMP13_DeterminisiticERF
extends AbstractERF {
    private static final String NAME = "NSHMP 2013 Deterministic ERF";
    private static final double SPACING = 1.0;
    private static final Set<FaultModels> FMs = EnumSet.of(FaultModels.FM3_1, FaultModels.FM3_2);
    private static final Set<DeformationModels> DMs = EnumSet.of(DeformationModels.GEOLOGIC, DeformationModels.ZENGBB, DeformationModels.NEOKINEMA);
    private static final Set<ScalingRelationships> MSs = EnumSet.of(ScalingRelationships.SHAW_2009_MOD, ScalingRelationships.HANKS_BAKUN_08, ScalingRelationships.ELLSWORTH_B);
    private static Map<DeformationModels, Map<Integer, List<FaultSection>>> faultSectionMaps;
    private static Map<Integer, String> faultNameMap;
    private static Map<Integer, RuptureSurface> surfaceMap;
    private static Map<DeformationModels, Map<Integer, Double>> rakeMap;
    private static Map<Integer, Double> slipMap;
    private static Map<Integer, Double> areaMap;
    private static Map<ScalingRelationships, Map<Integer, Double>> magMap;
    private List<ProbEqkSource> sources;
    private boolean aleatory = false;
    private static final int[] SLOW_AND_HOLOCENE;

    private NSHMP13_DeterminisiticERF(boolean aleatory) {
        this.aleatory = aleatory;
        this.timeSpan = new TimeSpan("None", "Years");
        this.timeSpan.setDuration(1.0);
    }

    public static NSHMP13_DeterminisiticERF create(boolean aleatory) {
        return new NSHMP13_DeterminisiticERF(aleatory);
    }

    @Override
    public int getNumSources() {
        return this.sources.size();
    }

    @Override
    public ProbEqkSource getSource(int idx) {
        return this.sources.get(idx);
    }

    @Override
    public void updateForecast() {
        this.sources = Lists.newArrayList();
        for (Integer id : faultNameMap.keySet()) {
            String name = faultNameMap.get(id);
            if (id < 1000 && slipMap.get(id) <= 0.100001 && !NSHMP13_DeterminisiticERF.isHolocene(id)) continue;
            double mag = 0.0;
            ScalingRelationships msForMag = null;
            for (ScalingRelationships ms : magMap.keySet()) {
                double msMag = magMap.get(ms).get(id);
                if (!(msMag > mag)) continue;
                mag = msMag;
                msForMag = ms;
            }
            double rake = rakeMap.get(DeformationModels.GEOLOGIC).get(id);
            FaultRuptureSource source = new FaultRuptureSource(this.aleatory ? mag + 0.24 : mag, surfaceMap.get(id), rake, 1.0E-4, true);
            source.setName(name + " " + msForMag.getShortName() + " " + DeformationModels.GEOLOGIC.getShortName());
            this.sources.add(source);
        }
    }

    private static boolean isHolocene(int id) {
        for (int listId : SLOW_AND_HOLOCENE) {
            if (listId != id) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getName() {
        return NAME;
    }

    private static void initFaultSectionAndSlipMaps() {
        faultSectionMaps = Maps.newEnumMap(DeformationModels.class);
        slipMap = Maps.newTreeMap();
        areaMap = Maps.newHashMap();
        for (DeformationModels dm : DMs) {
            HashMap sectMap = Maps.newHashMap();
            for (FaultModels fm : FMs) {
                HashMap fmSectMap = Maps.newHashMap();
                DeformationModelFetcher defFetch = new DeformationModelFetcher(fm, dm, UCERF3_DataUtils.DEFAULT_SCRATCH_DATA_DIR, 0.1);
                for (FaultSection faultSection : defFetch.getSubSectionList()) {
                    int n = faultSection.getParentSectionId();
                    List sects = (List)fmSectMap.get(n);
                    if (sects == null) {
                        sects = Lists.newArrayList();
                        fmSectMap.put(n, sects);
                    }
                    sects.add(faultSection);
                }
                sectMap.putAll(fmSectMap);
                if (dm != DeformationModels.GEOLOGIC) continue;
                List<? extends FaultSection> fspds = defFetch.getParentSectionList();
                for (FaultSection faultSection : fspds) {
                    slipMap.put(faultSection.getSectionId(), faultSection.getOrigAveSlipRate());
                    areaMap.put(faultSection.getSectionId(), faultSection.getReducedDownDipWidth() * faultSection.getFaultTrace().getTraceLength());
                }
            }
            faultSectionMaps.put(dm, sectMap);
        }
    }

    private static void initNamesMap() {
        faultNameMap = Maps.newTreeMap();
        for (List<FaultSection> sections : faultSectionMaps.get(DeformationModels.GEOLOGIC).values()) {
            FaultSection sect0 = sections.get(0);
            faultNameMap.put(sect0.getParentSectionId(), sect0.getParentSectionName());
        }
    }

    private static void removeFaults() {
        int[] removals;
        for (int idx : removals = new int[]{296, 402, 299, 289, 401, 293, 236, 721, 719}) {
            faultNameMap.remove(idx);
            for (DeformationModels dm : DMs) {
                faultSectionMaps.get(dm).remove(idx);
            }
        }
    }

    private static void initSurfaceMap() {
        surfaceMap = Maps.newHashMap();
        for (Integer id : faultSectionMaps.get(DeformationModels.GEOLOGIC).keySet()) {
            List<FaultSection> sects = faultSectionMaps.get(DeformationModels.GEOLOGIC).get(id);
            ArrayList surfs = Lists.newArrayList();
            for (FaultSection sect : sects) {
                surfs.add(sect.getFaultSurface(1.0, false, true));
            }
            surfaceMap.put(id, surfs.size() == 1 ? (RuptureSurface)surfs.get(0) : new CompoundSurface(surfs));
        }
    }

    private static void initRakesAndMags() {
        rakeMap = Maps.newEnumMap(DeformationModels.class);
        magMap = Maps.newEnumMap(ScalingRelationships.class);
        for (ScalingRelationships ms : MSs) {
            HashMap idMagMap = Maps.newHashMap();
            magMap.put(ms, idMagMap);
        }
        for (DeformationModels dm : DMs) {
            HashMap idRakeMap = Maps.newHashMap();
            rakeMap.put(dm, idRakeMap);
            for (Integer id : faultSectionMaps.get(dm).keySet()) {
                ArrayList areas = Lists.newArrayList();
                ArrayList rakes = Lists.newArrayList();
                double totalLength = 0.0;
                double totalOriginalArea = 0.0;
                double totalReducedArea = 0.0;
                List<FaultSection> sects = faultSectionMaps.get(dm).get(id);
                for (FaultSection sect : sects) {
                    double length = sect.getTraceLength() * 1000.0;
                    totalLength += length;
                    double reducedArea = length * sect.getReducedDownDipWidth() * 1000.0;
                    areas.add(reducedArea);
                    totalReducedArea += reducedArea;
                    double originalArea = length * sect.getOrigDownDipWidth() * 1000.0;
                    totalOriginalArea += originalArea;
                    rakes.add(sect.getAveRake());
                }
                double originalWidth = totalOriginalArea / totalLength;
                double rake = FaultUtils.getInRakeRange(FaultUtils.getScaledAngleAverage(areas, rakes));
                idRakeMap.put(id, rake);
                if (dm != DeformationModels.GEOLOGIC) continue;
                for (ScalingRelationships ms : MSs) {
                    Map<Integer, Double> idMagMap = magMap.get(ms);
                    double mag = ms.getMag(totalReducedArea, totalLength, totalReducedArea / totalLength, originalWidth, rake);
                    idMagMap.put(id, mag);
                }
            }
        }
    }

    private static void initBigRups() {
        int id = 10000;
        int count = 1;
        Map<Integer, String> bigRupDat = NSHMP13_DeterminisiticERF.toLinkedMap(new int[]{103, 102, -299, -402, -296, 237}, new String[]{"CM", "J", "T", "s", "GI", "W"});
        List<List<Integer>> perms = NSHMP13_DeterminisiticERF.permutations(bigRupDat.keySet());
        NSHMP13_DeterminisiticERF.filterStepover(perms, -402);
        NSHMP13_DeterminisiticERF.addBigRups("Elsinore", id * count++, bigRupDat, perms);
        bigRupDat = NSHMP13_DeterminisiticERF.toLinkedMap(new int[]{49, 341, 48}, new String[]{"GW", "GC", "GE"});
        perms = NSHMP13_DeterminisiticERF.permutations(bigRupDat.keySet());
        NSHMP13_DeterminisiticERF.addBigRups("Garlock", id * count++, bigRupDat, perms);
        bigRupDat = NSHMP13_DeterminisiticERF.toLinkedMap(new int[]{119, 289, 401, 293, 101, 99, 28}, new String[]{"SBV", "SJV", "s", "A", "CC", "B", "SM"});
        perms = NSHMP13_DeterminisiticERF.permutations(bigRupDat.keySet());
        NSHMP13_DeterminisiticERF.filterStepover(perms, 401);
        NSHMP13_DeterminisiticERF.addBigRups("San Jacinto", id * count, bigRupDat, perms);
        bigRupDat = NSHMP13_DeterminisiticERF.toLinkedMap(new int[]{119, 289, 401, 293, 292}, new String[]{"SBV", "SJV", "s", "A", "C"});
        List<List<Integer>> permsAlt = NSHMP13_DeterminisiticERF.permutations(bigRupDat.keySet());
        NSHMP13_DeterminisiticERF.filterStepover(permsAlt, 401);
        NSHMP13_DeterminisiticERF.cleanPerms(permsAlt, perms);
        NSHMP13_DeterminisiticERF.addBigRups("San Jacinto", id * count++ + perms.size(), bigRupDat, permsAlt);
        bigRupDat = NSHMP13_DeterminisiticERF.toLinkedMap(new int[]{-32, -285, 300, 287, 286, 301, 282, 283, -284, 295}, new String[]{"PK", "CH", "CC", "BB", "NM", "SM", "NSB", "SSB", "BG", "CO"});
        perms = NSHMP13_DeterminisiticERF.permutations(bigRupDat.keySet());
        NSHMP13_DeterminisiticERF.addBigRups("S. San Andreas", id * count++, bigRupDat, perms);
        bigRupDat = NSHMP13_DeterminisiticERF.toLinkedMap(new int[]{-653, -654, -655, 657}, new String[]{"SAO", "SAN", "SAP", "SAS"});
        perms = NSHMP13_DeterminisiticERF.permutations(bigRupDat.keySet());
        NSHMP13_DeterminisiticERF.addBigRups("N. San Andreas", id * count++, bigRupDat, perms);
        bigRupDat = NSHMP13_DeterminisiticERF.toLinkedMap(new int[]{-651, -639, -638, -637}, new String[]{"RC", "HN", "HS", "HE"});
        perms = NSHMP13_DeterminisiticERF.permutations(bigRupDat.keySet());
        NSHMP13_DeterminisiticERF.addBigRups("Hayward", id * count++, bigRupDat, perms);
        bigRupDat = NSHMP13_DeterminisiticERF.toLinkedMap(new int[]{601, -602, -603, 621}, new String[]{"CN", "CC", "CS", "CE"});
        perms = NSHMP13_DeterminisiticERF.permutations(bigRupDat.keySet());
        NSHMP13_DeterminisiticERF.addBigRups("Calaveras", id * count++, bigRupDat, perms);
    }

    private static void addBigRups(String name, int id, Map<Integer, String> sectIDs, List<List<Integer>> permutations) {
        for (List<Integer> permutation : permutations) {
            String rupName = NSHMP13_DeterminisiticERF.buildBigRupName(name, sectIDs, permutation);
            faultNameMap.put(id, rupName);
            for (DeformationModels dm : DMs) {
                Map<Integer, List<FaultSection>> dmFaultData = faultSectionMaps.get(dm);
                ArrayList sects = Lists.newArrayList();
                for (Integer sectID : permutation) {
                    sects.addAll(sectID < 0 ? Lists.reverse(dmFaultData.get(Math.abs(sectID))) : (Collection)dmFaultData.get(Math.abs(sectID)));
                }
                dmFaultData.put(id, sects);
            }
            ++id;
        }
    }

    private static String buildBigRupName(String name, Map<Integer, String> sectIDs, List<Integer> permutation) {
        StringBuilder nameOut = new StringBuilder(name).append(": ");
        ArrayList sectNames = Lists.newArrayList();
        for (Integer sect : permutation) {
            sectNames.add(sectIDs.get(sect));
        }
        Joiner.on((char)'+').appendTo(nameOut, (Iterable)sectNames);
        return nameOut.toString();
    }

    private static Map<Integer, String> toLinkedMap(int[] keys, String[] values) {
        Preconditions.checkArgument((keys.length == values.length ? 1 : 0) != 0);
        LinkedHashMap map = Maps.newLinkedHashMap();
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return map;
    }

    private static List<List<Integer>> permutations(Iterable<Integer> vals) {
        ArrayList permutations = Lists.newArrayList();
        ArrayList valList = Lists.newArrayList(vals);
        for (int i = 2; i <= valList.size(); ++i) {
            for (int j = 0; j < valList.size() - i + 1; ++j) {
                permutations.add(valList.subList(j, j + i));
            }
        }
        return permutations;
    }

    private static void cleanPerms(List<List<Integer>> p1, List<List<Integer>> p2) {
        Iterator<List<Integer>> it = p1.iterator();
        block0: while (it.hasNext()) {
            int[] p1array = Ints.toArray((Collection)it.next());
            for (List<Integer> pCheck : p2) {
                int[] pCheckArray = Ints.toArray(pCheck);
                if (!Arrays.equals(p1array, pCheckArray)) continue;
                it.remove();
                continue block0;
            }
        }
    }

    private static void filterStepover(List<List<Integer>> permutations, int idx) {
        List<Integer> totalList = permutations.get(permutations.size() - 1);
        int stepPos = totalList.indexOf(idx);
        Preconditions.checkArgument((stepPos > 0 && stepPos < totalList.size() - 1 ? 1 : 0) != 0);
        int idxBefore = totalList.get(stepPos - 1);
        int idxAfter = totalList.get(stepPos + 1);
        Iterator<List<Integer>> permIt = permutations.iterator();
        while (permIt.hasNext()) {
            List<Integer> permutation = permIt.next();
            int last = permutation.size() - 1;
            if (permutation.get(0) != idxAfter && permutation.get(last) != idxBefore) continue;
            permIt.remove();
        }
    }

    private static void printPermutations(List<List<Integer>> lists) {
        for (List<Integer> s : lists) {
            System.out.println(s);
        }
    }

    private static void printNames(Iterable<Integer> IDs) {
        for (Integer id : IDs) {
            System.out.println(Strings.padEnd((String)Integer.toString(Math.abs(id)), (int)4, (char)' ') + faultNameMap.get(Math.abs(id)));
        }
    }

    private static void printSectionTraces(int id) {
        List<FaultSection> sects = faultSectionMaps.get(DeformationModels.GEOLOGIC).get(id);
        System.out.println(faultNameMap.get(Math.abs(id)));
        for (FaultSection sect : sects) {
            System.out.println(sect.getFaultTrace());
        }
    }

    private static void printRakeMagSummary() {
        System.out.println("[rakes by DM] [mags by MS] ID Name");
        for (Integer id : faultNameMap.keySet()) {
            ArrayList rakes = Lists.newArrayList();
            for (DeformationModels dm : rakeMap.keySet()) {
                rakes.add(Strings.padStart((String)String.format("%.2f", rakeMap.get(dm).get(id)), (int)7, (char)' '));
            }
            ArrayList mags = Lists.newArrayList();
            for (ScalingRelationships ms : magMap.keySet()) {
                mags.add(String.format("%.2f", magMap.get(ms).get(id)));
            }
            System.out.println(String.valueOf(rakes) + " " + String.valueOf(mags) + Strings.padStart((String)Integer.toString(id), (int)6, (char)' ') + " " + faultNameMap.get(id));
        }
    }

    private static void printSlipSummary() {
        ImmutableSortedMap nameIdMap = ImmutableSortedMap.copyOf((Map)HashBiMap.create(faultNameMap).inverse());
        System.out.println("ID, Mag, Slip, Recurrence, Name");
        for (Map.Entry entry : nameIdMap.entrySet()) {
            int id = (Integer)entry.getValue();
            StringBuffer sb = new StringBuffer();
            sb.append(Strings.padStart((String)Integer.toString(id), (int)5, (char)' '));
            sb.append(", ");
            ArrayList mags = Lists.newArrayList();
            for (ScalingRelationships ms : magMap.keySet()) {
                mags.add(magMap.get(ms).get(id));
            }
            double mag = Doubles.max((double[])Doubles.toArray((Collection)mags));
            sb.append(String.format("%.2f", mag));
            sb.append(", ");
            double slip = id > 1000 ? Double.NaN : slipMap.get(id);
            double area = id > 1000 ? Double.NaN : areaMap.get(id);
            double mu = 3.0E10;
            double moRate = area * mu * slip * 1000.0;
            double recurrence = MagUtils.magToMoment(mag) / moRate;
            sb.append(slip);
            sb.append(", ");
            sb.append(Strings.padStart((String)String.format("%d", (int)recurrence), (int)10, (char)' '));
            sb.append(", ");
            sb.append((String)entry.getKey());
            System.out.println(sb.toString());
        }
    }

    public static void main(String[] args) {
        NSHMP13_DeterminisiticERF erf = NSHMP13_DeterminisiticERF.create(true);
        erf.updateForecast();
        for (ProbEqkSource src : erf) {
            System.out.println(src.getNumRuptures() + " " + String.format("%.1f", src.getRupture(0).getAveRake()) + " " + String.format("%.2f", src.getRupture(0).getMag()) + " " + src.getName());
        }
        System.out.println(erf.getNumSources());
    }

    static {
        SLOW_AND_HOLOCENE = new int[]{561, 168, 207, 164, 161, 31, 209, 882, 65, 83, 82, 689, 53, 715};
        NSHMP13_DeterminisiticERF.initFaultSectionAndSlipMaps();
        NSHMP13_DeterminisiticERF.initNamesMap();
        NSHMP13_DeterminisiticERF.initBigRups();
        NSHMP13_DeterminisiticERF.removeFaults();
        NSHMP13_DeterminisiticERF.initSurfaceMap();
        NSHMP13_DeterminisiticERF.initRakesAndMags();
    }
}

