/*
 * Decompiled with CFR 0.152.
 */
package scratch.peter.ucerf3.calc;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import com.google.common.io.Resources;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.DocumentException;
import org.opensha.commons.geo.Location;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemSolution;
import org.opensha.sha.earthquake.param.IncludeBackgroundOption;
import scratch.UCERF3.U3AverageFaultSystemSolution;
import scratch.UCERF3.U3CompoundFaultSystemSolution;
import scratch.UCERF3.erf.FaultSystemSolutionERF;
import scratch.UCERF3.inversion.InversionFaultSystemSolution;
import scratch.UCERF3.logicTree.U3LogicTreeBranch;
import scratch.UCERF3.logicTree.VariableLogicTreeBranch;
import scratch.UCERF3.utils.U3FaultSystemIO;
import scratch.peter.nshmp.NSHMP_UCERF3_ERF;

public class UC3_CalcUtils {
    private static final Splitter SPLIT = Splitter.on((char)',');

    public static FaultSystemSolutionERF getUC3_ERF(String solPath, IncludeBackgroundOption bgOpt, boolean aleatoryMagArea, boolean filterAftShk, double duration) {
        InversionFaultSystemSolution fss = UC3_CalcUtils.getInvSolution(solPath);
        FaultSystemSolutionERF erf = new FaultSystemSolutionERF(fss);
        erf.setName(UC3_CalcUtils.nameFromPath(solPath));
        UC3_CalcUtils.initUC3(erf, bgOpt, aleatoryMagArea, filterAftShk, duration);
        return erf;
    }

    public static FaultSystemSolutionERF getNSHMP_UC3_ERF(String solPath, IncludeBackgroundOption bgOpt, boolean aleatoryMagArea, boolean filterAftShk, double duration) {
        FaultSystemSolution fss = UC3_CalcUtils.getSolution(solPath);
        NSHMP_UCERF3_ERF erf = new NSHMP_UCERF3_ERF(fss);
        erf.setName(UC3_CalcUtils.nameFromPath(solPath));
        UC3_CalcUtils.initUC3(erf, bgOpt, aleatoryMagArea, filterAftShk, duration);
        return erf;
    }

    public static FaultSystemSolutionERF getUC3_ERF(String solPath, int idx, IncludeBackgroundOption bgOpt, boolean aleatoryMagArea, boolean filterAftShk, double duration) {
        U3AverageFaultSystemSolution afss = UC3_CalcUtils.getAvgSolution(solPath);
        U3AverageFaultSystemSolution fss = idx == -1 ? afss : afss.getSolution(idx);
        String erfName = UC3_CalcUtils.nameFromPath(solPath) + "_" + idx;
        FaultSystemSolutionERF erf = new FaultSystemSolutionERF(fss);
        erf.setName(erfName);
        UC3_CalcUtils.initUC3(erf, bgOpt, aleatoryMagArea, filterAftShk, duration);
        return erf;
    }

    public static FaultSystemSolutionERF getUC3_ERF_Compound(String solPath, int idx, IncludeBackgroundOption bgOpt, boolean aleatoryMagArea, boolean filterAftShk, double duration) {
        Preconditions.checkArgument((idx != -1 ? 1 : 0) != 0, (Object)"Index cannot be -1 for compound sol.");
        U3CompoundFaultSystemSolution cfss = UC3_CalcUtils.getCompoundSolution(solPath);
        ArrayList branches = Lists.newArrayList(cfss.getBranches());
        U3LogicTreeBranch branch = (U3LogicTreeBranch)branches.get(idx);
        InversionFaultSystemSolution ifss = cfss.getSolution(branch);
        String erfName = branch.buildFileName();
        FaultSystemSolutionERF erf = new FaultSystemSolutionERF(ifss);
        erf.setName(erfName);
        UC3_CalcUtils.initUC3(erf, bgOpt, aleatoryMagArea, filterAftShk, duration);
        return erf;
    }

    public static FaultSystemSolutionERF getUC3_ERF(String solPath, String branchID, IncludeBackgroundOption bgOpt, boolean aleatoryMagArea, boolean filterAftShk, double duration) {
        U3CompoundFaultSystemSolution cfss = UC3_CalcUtils.getCompoundSolution(solPath);
        InversionFaultSystemSolution fss = null;
        U3LogicTreeBranch branch = null;
        try {
            branch = U3LogicTreeBranch.fromFileName(branchID);
            fss = cfss.getSolution(branch);
        }
        catch (Exception e) {
            branch = VariableLogicTreeBranch.fromFileName(branchID);
            fss = cfss.getSolution(branch);
        }
        FaultSystemSolutionERF erf = new FaultSystemSolutionERF(fss);
        erf.setName(branchID);
        UC3_CalcUtils.initUC3(erf, bgOpt, aleatoryMagArea, filterAftShk, duration);
        return erf;
    }

    private static String nameFromPath(String solPath) {
        int ssIdx1 = StringUtils.lastIndexOf((CharSequence)solPath, (CharSequence)"/") + 1;
        int ssIdx2 = StringUtils.lastIndexOf((CharSequence)solPath, (CharSequence)".");
        return solPath.substring(ssIdx1, ssIdx2);
    }

    public static void initUC3(FaultSystemSolutionERF erf, IncludeBackgroundOption bg, boolean aleatoryMagArea, boolean filterAftershocks, double duration) {
        erf.getParameter("Background Seismicity").setValue(bg);
        erf.getParameter("Aleatory Mag-Area StdDev").setValue(aleatoryMagArea ? 0.12 : 0.0);
        erf.getParameter("Apply Aftershock Filter").setValue(filterAftershocks);
        erf.getTimeSpan().setDuration(duration);
    }

    public static FaultSystemSolution getSolution(String path) {
        try {
            File file = new File(path);
            return U3FaultSystemIO.loadSol(file);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static InversionFaultSystemSolution getInvSolution(String path) {
        try {
            File file = new File(path);
            return U3FaultSystemIO.loadInvSol(file);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static U3AverageFaultSystemSolution getAvgSolution(String path) {
        try {
            File file = new File(path);
            return U3FaultSystemIO.loadAvgInvSol(file);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static U3CompoundFaultSystemSolution getCompoundSolution(String path) {
        try {
            File file = new File(path);
            return U3CompoundFaultSystemSolution.fromZipFile(file);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Map<String, Location> readSiteFile(String path) throws IOException {
        File f = new File(path);
        return UC3_CalcUtils.readSiteFile(Files.readLines((File)f, (Charset)Charsets.US_ASCII));
    }

    public static Map<String, Location> readSiteFile(URL url) throws IOException {
        return UC3_CalcUtils.readSiteFile(Resources.readLines((URL)url, (Charset)Charsets.US_ASCII));
    }

    private static Map<String, Location> readSiteFile(List<String> lines) throws IOException {
        HashMap siteMap = Maps.newHashMap();
        for (String line : lines) {
            if (line.startsWith("#")) continue;
            Iterator it = SPLIT.split((CharSequence)line).iterator();
            String name = (String)it.next();
            double lat = Double.parseDouble((String)it.next());
            double lon = Double.parseDouble((String)it.next());
            siteMap.put(name, new Location(lat, lon));
        }
        return ImmutableMap.copyOf((Map)siteMap);
    }

    public static List<String> readBranchFile(String path) throws IOException {
        File f = new File(path);
        return Files.readLines((File)f, (Charset)Charsets.US_ASCII);
    }

    public static void main(String[] args) throws IOException, DocumentException {
        String solPath = "tmp/UC33/src/mean/mean_ucerf3_sol.zip";
        FaultSystemSolutionERF erf = UC3_CalcUtils.getNSHMP_UC3_ERF(solPath, IncludeBackgroundOption.INCLUDE, false, true, 1.0);
        erf.updateForecast();
    }
}

