/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.data;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.opensha.commons.data.Container2D;
import org.opensha.commons.data.Named;

public class Container2DImpl<T>
implements Container2D<T>,
Serializable,
Named {
    private static final long serialVersionUID = 1L;
    protected static final String C = "Container2D";
    protected static final boolean D = false;
    protected Object[] data;
    protected int numRows = 0;
    protected int numCols = 0;
    protected long size = 0L;
    protected String name;
    protected static final char TAB = '\t';

    public Container2DImpl() {
        this(100, 100);
    }

    public Container2DImpl(int numRows, int numCols) {
        Preconditions.checkArgument((numRows > 0 ? 1 : 0) != 0, (Object)"Number of rows must be greater than 0");
        Preconditions.checkArgument((numCols > 0 ? 1 : 0) != 0, (Object)"Number of columns must be greater than 0");
        Preconditions.checkArgument(((long)numRows * (long)numCols < Integer.MAX_VALUE ? 1 : 0) != 0, (Object)"Container size exceeds allowable 32-bit address space");
        this.numRows = numRows;
        this.numCols = numCols;
        this.size = (long)numRows * (long)numCols;
        this.data = new Object[numRows * numCols];
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void set(int row, int column, T obj) throws ArrayIndexOutOfBoundsException {
        String S = "Container2D: set(): ";
        this.checkBounds(row, column, S);
        this.data[row * this.numCols + column] = obj;
    }

    protected void setNumRowsAndNumCols(int numRows, int numCols) {
        this.numCols = numCols;
        this.numRows = numRows;
        this.size = (long)numRows * (long)numCols;
        this.data = new Object[numRows * numCols];
    }

    @Override
    public int getNumRows() {
        return this.numRows;
    }

    @Override
    public int getNumCols() {
        return this.numCols;
    }

    @Override
    public T get(int row, int column) {
        String S = "Container2D: get(): ";
        this.checkBounds(row, column, S);
        return (T)this.data[row * this.numCols + column];
    }

    @Override
    public ListIterator<T> getColumnIterator(int row) throws ArrayIndexOutOfBoundsException {
        String S = "Container2D: getColumnIterator(): ";
        if (row >= this.numRows) {
            throw new ArrayIndexOutOfBoundsException(S + "Row cannot be greater than max index");
        }
        ColumnIterator it = new ColumnIterator(row);
        return it;
    }

    @Override
    public ListIterator<T> getRowIterator(int column) throws ArrayIndexOutOfBoundsException {
        String S = "Container2D: getRowIterator(): ";
        if (column >= this.numCols) {
            throw new ArrayIndexOutOfBoundsException(S + "Column cannot be greater than max index");
        }
        RowIterator it = new RowIterator(column);
        return it;
    }

    @Override
    public ListIterator<T> getAllByColumnsIterator() {
        AllByColumnsIterator it = new AllByColumnsIterator();
        return it;
    }

    @Override
    public ListIterator<T> getAllByRowsIterator() {
        AllByRowsIterator it = new AllByRowsIterator();
        return it;
    }

    protected void checkBounds(int row, int column, String preffix) throws ArrayIndexOutOfBoundsException {
        if (row < 0) {
            throw new ArrayIndexOutOfBoundsException(preffix + "Row cannot be less than zero");
        }
        if (column < 0) {
            throw new ArrayIndexOutOfBoundsException(preffix + "Column cannot be less than zero");
        }
        if (row >= this.numRows) {
            throw new ArrayIndexOutOfBoundsException(preffix + "Row cannot be greater than max index: " + this.numRows);
        }
        if (column >= this.numCols) {
            throw new ArrayIndexOutOfBoundsException(preffix + "Column cannot be greater than max index: " + this.numCols);
        }
    }

    @Override
    public void clear() {
        this.data = null;
        this.numRows = 0;
        this.numCols = 0;
        this.size = 0L;
    }

    @Override
    public boolean exist(int row, int column) {
        String S = "Container2D: exist(): ";
        this.checkBounds(row, column, S);
        return this.get(row, column) != null;
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public ListIterator<T> listIterator() {
        AllByRowsIterator it = new AllByRowsIterator();
        return it;
    }

    public Object[][] toJava2D() {
        Object[][] d = new Object[this.numRows][this.numCols];
        for (int j = 0; j < this.numRows; ++j) {
            for (int i = 0; i < this.numCols; ++i) {
                d[i][j] = this.get(i, j);
            }
        }
        return d;
    }

    public static void main(String[] args) {
        String S = "Container2D: Main(): ";
        System.out.println(S + "Starting");
        int xsize = 5;
        int ysize = 10;
        Container2DImpl<CallSite> con = new Container2DImpl<CallSite>(xsize, ysize);
        for (int x = 0; x < xsize; ++x) {
            for (int y = 0; y < ysize; ++y) {
                con.set(x, y, (CallSite)((Object)(x + ", " + y)));
            }
        }
        System.out.println(S + "(1,1) = " + (String)con.get(1, 1));
        System.out.println(S);
        System.out.println(S);
        System.out.println(S + "getRowIterator");
        ListIterator it = con.getRowIterator(2);
        while (it.hasNext()) {
            String obj = (String)it.next();
            System.out.println(S + obj.toString());
        }
        System.out.println(S);
        System.out.println(S);
        System.out.println(S + "getColumnIterator");
        it = con.getColumnIterator(2);
        while (it.hasNext()) {
            String obj = (String)it.next();
            System.out.println(S + obj.toString());
        }
        System.out.println(S);
        System.out.println(S);
        System.out.println(S + "getAllByColumnsIterator");
        it = con.getAllByColumnsIterator();
        while (it.hasNext()) {
            String obj = (String)it.next();
            System.out.println(S + obj.toString());
        }
        System.out.println(S);
        System.out.println(S);
        System.out.println(S + "getAllByRowsIterator");
        it = con.getAllByRowsIterator();
        while (it.hasNext()) {
            String obj = (String)it.next();
            System.out.println(S + obj.toString());
        }
        System.out.println(S);
        System.out.println(S);
        System.out.println(S + "List Iterator");
        it = con.listIterator();
        while (it.hasNext()) {
            String obj = (String)it.next();
            System.out.println(S + obj.toString());
        }
        System.out.println(S + "Ending");
    }

    @Override
    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append('\n');
        int counter = 0;
        for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.numCols; ++j) {
                b.append(i + "\t" + j + "\t");
                T obj = this.get(i, j);
                if (obj != null) {
                    b.append(obj.toString());
                    ++counter;
                } else {
                    b.append("NULL");
                }
                b.append('\n');
            }
        }
        b.append("\nNumber of Rows = " + this.numRows + "\n");
        b.append("Number of Columns = " + this.numCols + "\n");
        b.append("Size = " + this.size + "\n");
        b.append("Number of non-null objects = " + counter + "\n");
        return b.toString();
    }

    @Override
    public Iterator<T> iterator() {
        return this.listIterator();
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    class ColumnIterator
    extends Container2DListIterator {
        int pinnedRow;

        public ColumnIterator(int row) {
            this.pinnedRow = row;
            this.lastIndex = Container2DImpl.this.numCols;
        }

        @Override
        public T next() throws NoSuchElementException {
            try {
                Object object = Container2DImpl.this.data[this.pinnedRow * Container2DImpl.this.numCols + this.cursor];
                this.lastRet = this.cursor++;
                return object;
            }
            catch (IndexOutOfBoundsException e) {
                throw new NoSuchElementException("You have iterated past the last element." + e.toString());
            }
        }
    }

    class RowIterator
    extends Container2DListIterator {
        int pinnedColumn;

        public RowIterator(int column) {
            this.pinnedColumn = column;
            this.lastIndex = Container2DImpl.this.numRows;
        }

        @Override
        public T next() throws NoSuchElementException {
            try {
                Object object = Container2DImpl.this.get(this.cursor, this.pinnedColumn);
                this.lastRet = this.cursor++;
                return object;
            }
            catch (IndexOutOfBoundsException e) {
                throw new NoSuchElementException("You have iterated past the last element." + e.toString());
            }
        }
    }

    class AllByColumnsIterator
    extends Container2DListIterator {
        int currentColumn;
        int currentRow;

        public AllByColumnsIterator() {
            this.currentColumn = 0;
            this.currentRow = 0;
            this.lastIndex = Container2DImpl.this.numCols * Container2DImpl.this.numRows;
        }

        @Override
        public T next() throws NoSuchElementException {
            try {
                Object object = Container2DImpl.this.get(this.currentRow, this.currentColumn);
                ++this.currentRow;
                if (this.currentRow == Container2DImpl.this.numRows) {
                    this.currentRow = 0;
                    ++this.currentColumn;
                }
                this.lastRet = this.cursor++;
                return object;
            }
            catch (IndexOutOfBoundsException e) {
                throw new NoSuchElementException("You have iterated past the last element. " + e.toString());
            }
        }
    }

    class AllByRowsIterator
    extends Container2DListIterator {
        public AllByRowsIterator() {
            this.lastIndex = Container2DImpl.this.numCols * Container2DImpl.this.numRows;
        }

        @Override
        public T next() throws NoSuchElementException {
            try {
                int row = this.cursor / Container2DImpl.this.numCols;
                int col = this.cursor % Container2DImpl.this.numCols;
                Object object = Container2DImpl.this.get(row, col);
                this.lastRet = this.cursor++;
                return object;
            }
            catch (IndexOutOfBoundsException e) {
                throw new NoSuchElementException("You have iterated past the last element. " + e.toString());
            }
        }
    }

    abstract class Container2DListIterator
    implements ListIterator<T> {
        int cursor = 0;
        int lastRet = -1;
        int lastIndex = 0;

        @Override
        public void set(Object obj) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("set(Object obj) Not implemented.");
        }

        @Override
        public boolean hasNext() {
            return this.cursor != this.lastIndex;
        }

        @Override
        public int nextIndex() {
            return this.cursor;
        }

        @Override
        public abstract T next() throws NoSuchElementException;

        @Override
        public T previous() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("hasPrevious() Not implemented.");
        }

        @Override
        public int previousIndex() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("hasPrevious() Not implemented.");
        }

        @Override
        public boolean hasPrevious() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("hasPrevious() Not implemented.");
        }

        @Override
        public void add(Object obj) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("add(Object obj) Not implemented.");
        }

        @Override
        public void remove() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("remove() Not implemented.");
        }
    }
}

