/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.data.comcat;

import gov.usgs.earthquake.event.EventQuery;
import gov.usgs.earthquake.event.EventWebService;
import gov.usgs.earthquake.event.Format;
import gov.usgs.earthquake.event.JsonEvent;
import gov.usgs.earthquake.event.OrderBy;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.UnknownHostException;
import java.net.UnknownServiceException;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.zip.ZipException;
import javax.net.ssl.SSLException;
import org.opensha.commons.data.comcat.ComcatEventQuery;
import org.opensha.commons.data.comcat.ComcatEventWebService;
import org.opensha.commons.data.comcat.ComcatException;
import org.opensha.commons.data.comcat.ComcatRegion;
import org.opensha.commons.data.comcat.ComcatVisitor;
import org.opensha.commons.geo.GeoTools;
import org.opensha.commons.geo.Location;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.impl.StringParameter;
import org.opensha.commons.util.ExceptionUtils;
import org.opensha.sha.earthquake.observedEarthquake.ObsEqkRupList;
import org.opensha.sha.earthquake.observedEarthquake.ObsEqkRupture;

public class ComcatAccessor {
    protected boolean D = true;
    protected EventWebService service;
    protected ArrayList<Integer> http_statuses;
    protected int local_http_status;
    protected JsonEvent last_geojson;
    protected boolean refetch_secondary;
    public static final double day_millis = 8.64E7;
    public static final String PARAM_NAME_DESCRIPTION = "description";
    public static final String PARAM_NAME_IDLIST = "ids";
    public static final String PARAM_NAME_NETWORK = "net";
    public static final String PARAM_NAME_CODE = "code";
    public static final double COMCAT_MAX_DEPTH = 1000.0;
    public static final double COMCAT_MIN_DEPTH = -100.0;
    public static final int COMCAT_MAX_LIMIT = 20000;
    public static final int COMCAT_INIT_INDEX = 1;
    public static final int COMCAT_MAX_CALLS = 25;
    public static final double COMCAT_NO_MIN_MAG = -10.0;
    public static final double DEFAULT_MAX_DEPTH = 700.0;
    public static final double DEFAULT_MIN_DEPTH = -5.0;
    public static final int OVERLAP_FRACTION = 10;
    public static final int OVERLAP_MIN_LIMIT = 10000;
    public static final long OVERLAP_TIME = 60000L;
    public static final int OVERLAP_RESAMPLE = 0;
    public static final int EITMOPT_NO_CHANGE = 0;
    public static final int EITMOPT_OMIT_NULL = 1;
    public static final int EITMOPT_OMIT_EMPTY = 2;
    public static final int EITMOPT_OMIT_NULL_EMPTY = 3;
    public static final int EITMOPT_NULL_TO_EMPTY = 4;
    public static final int EITMOPT_EMPTY_TO_NULL = 5;

    public void set_verbose(boolean f_verbose) {
        this.D = f_verbose;
    }

    public ComcatAccessor() {
        this(true);
    }

    protected ComcatAccessor(boolean f_create_service) {
        if (f_create_service) {
            try {
                URL serviceURL = new URL("https://earthquake.usgs.gov/fdsnws/event/1/");
                URL feedURL = new URL("https://earthquake.usgs.gov/earthquakes/feed/v1.0/detail/");
                this.service = new ComcatEventWebService(serviceURL, feedURL);
            }
            catch (MalformedURLException e) {
                ExceptionUtils.throwAsRuntimeException(e);
            }
        }
        this.http_statuses = new ArrayList();
        this.local_http_status = -1;
        this.last_geojson = null;
        this.refetch_secondary = false;
    }

    public EventWebService getEventWebService() {
        return this.service;
    }

    public ObsEqkRupture fetchEvent(String eventID, boolean wrapLon) {
        return this.fetchEvent(eventID, wrapLon, true, false);
    }

    public ObsEqkRupture fetchEvent(String eventID, boolean wrapLon, boolean extendedInfo) {
        return this.fetchEvent(eventID, wrapLon, extendedInfo, false);
    }

    public ObsEqkRupture fetchEvent(String eventID, boolean wrapLon, boolean extendedInfo, boolean superseded) {
        List<JsonEvent> events;
        this.http_statuses.clear();
        this.local_http_status = -1;
        this.last_geojson = null;
        ComcatEventQuery query = new ComcatEventQuery();
        query.setEventId(eventID);
        if (superseded) {
            query.setIncludeSuperseded(true);
        }
        if ((events = this.getEventsFromComcat(query)).isEmpty()) {
            return null;
        }
        if (events.size() != 1) {
            this.reportQueryError("ComcatAccessor: Received more than one match, count = " + events.size(), null);
            throw new ComcatException("ComcatAccessor: Received more than one match, count = " + events.size());
        }
        JsonEvent event = events.get(0);
        if (this.refetch_secondary) {
            String auth_id = null;
            try {
                auth_id = event.getEventId().toString();
            }
            catch (Exception e) {
                auth_id = null;
            }
            if (auth_id == null || auth_id.isEmpty()) {
                return null;
            }
            if (!auth_id.equals(eventID)) {
                query = new ComcatEventQuery();
                query.setEventId(auth_id);
                if (superseded) {
                    query.setIncludeSuperseded(true);
                }
                if ((events = this.getEventsFromComcat(query)).isEmpty()) {
                    return null;
                }
                if (events.size() != 1) {
                    this.reportQueryError("ComcatAccessor: Received more than one match, count = " + events.size(), null);
                    throw new ComcatException("ComcatAccessor: Received more than one match, count = " + events.size());
                }
                event = events.get(0);
            }
        }
        this.last_geojson = event;
        ObsEqkRupture rup = null;
        try {
            rup = this.eventToObsRup(event, wrapLon, extendedInfo, eventID);
        }
        catch (Exception e) {
            rup = null;
        }
        return rup;
    }

    public ObsEqkRupList fetchAftershocks(ObsEqkRupture mainshock, double minDays, double maxDays, double minDepth, double maxDepth, ComcatRegion region, boolean wrapLon) {
        long eventTime = mainshock.getOriginTime();
        long startTime = eventTime + (long)(minDays * 8.64E7);
        long endTime = eventTime + (long)(maxDays * 8.64E7);
        String exclude_id = mainshock.getEventId();
        boolean extendedInfo = false;
        return this.fetchEventList(exclude_id, startTime, endTime, minDepth, maxDepth, region, wrapLon, extendedInfo, -10.0, 20000, 25);
    }

    public ObsEqkRupList fetchAftershocks(ObsEqkRupture mainshock, double minDays, double maxDays, double minDepth, double maxDepth, ComcatRegion region, boolean wrapLon, double minMag) {
        long eventTime = mainshock.getOriginTime();
        long startTime = eventTime + (long)(minDays * 8.64E7);
        long endTime = eventTime + (long)(maxDays * 8.64E7);
        String exclude_id = mainshock.getEventId();
        boolean extendedInfo = false;
        return this.fetchEventList(exclude_id, startTime, endTime, minDepth, maxDepth, region, wrapLon, extendedInfo, minMag, 20000, 25);
    }

    public ObsEqkRupList fetchEventList(String exclude_id, long startTime, long endTime, double minDepth, double maxDepth, ComcatRegion region, boolean wrapLon, boolean extendedInfo, double minMag, int limit_per_call, int max_calls) {
        final ObsEqkRupList rups = new ObsEqkRupList();
        ComcatVisitor visitor = new ComcatVisitor(){
            final /* synthetic */ ComcatAccessor this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public int visit(ObsEqkRupture rup, JsonEvent geojson) {
                rups.add(rup);
                return 0;
            }
        };
        String productType = null;
        boolean includeDeleted = false;
        this.visitEventList(visitor, exclude_id, startTime, endTime, minDepth, maxDepth, region, wrapLon, extendedInfo, minMag, productType, includeDeleted, limit_per_call, max_calls);
        return rups;
    }

    public ObsEqkRupList fetchEventList(String exclude_id, long startTime, long endTime, double minDepth, double maxDepth, ComcatRegion region, boolean wrapLon, boolean extendedInfo, double minMag) {
        return this.fetchEventList(exclude_id, startTime, endTime, minDepth, maxDepth, region, wrapLon, extendedInfo, minMag, 20000, 25);
    }

    public int visitEventList(ComcatVisitor visitor, String exclude_id, long startTime, long endTime, double minDepth, double maxDepth, ComcatRegion region, boolean wrapLon, boolean extendedInfo, double minMag, String productType, boolean includeDeleted, int limit_per_call, int max_calls) {
        long original_end_time;
        this.http_statuses.clear();
        this.local_http_status = -1;
        if (visitor == null) {
            throw new IllegalArgumentException("ComcatAccessor.visitEventList: No visitor supplied");
        }
        ComcatEventQuery query = new ComcatEventQuery();
        if (!(minDepth < maxDepth)) {
            throw new IllegalArgumentException("ComcatAccessor: Min depth must be less than max depth: minDepth = " + minDepth + ", maxDepth = " + maxDepth);
        }
        query.setMinDepth(new BigDecimal(String.format(Locale.US, "%.3f", minDepth)));
        query.setMaxDepth(new BigDecimal(String.format(Locale.US, "%.3f", maxDepth)));
        long timeNow = System.currentTimeMillis();
        if (startTime >= timeNow) {
            throw new IllegalArgumentException("ComcatAccessor: Start time must be less than time now: startTime = " + startTime + ", timeNow = " + timeNow);
        }
        if (startTime > endTime) {
            throw new IllegalArgumentException("ComcatAccessor: Start time must be less than end time: startTime = " + startTime + ", endTime = " + endTime);
        }
        query.setStartTime(new Date(startTime));
        if (endTime == startTime) {
            query.setEndTime(new Date(timeNow));
            original_end_time = timeNow;
        } else {
            query.setEndTime(new Date(endTime));
            original_end_time = endTime;
        }
        long current_end_time = original_end_time;
        if (region.isCircular()) {
            query.setLatitude(new BigDecimal(String.format(Locale.US, "%.5f", region.getCircleCenterLat())));
            query.setLongitude(new BigDecimal(String.format(Locale.US, "%.5f", region.getCircleCenterLon())));
            query.setMaxRadius(new BigDecimal(String.format(Locale.US, "%.5f", region.getCircleRadiusDeg())));
        } else {
            query.setMinLatitude(new BigDecimal(String.format(Locale.US, "%.5f", region.getMinLat())));
            query.setMaxLatitude(new BigDecimal(String.format(Locale.US, "%.5f", region.getMaxLat())));
            query.setMinLongitude(new BigDecimal(String.format(Locale.US, "%.5f", region.getMinLon())));
            query.setMaxLongitude(new BigDecimal(String.format(Locale.US, "%.5f", region.getMaxLon())));
        }
        boolean f_region_filter = false;
        if (!region.isRectangular() && !region.isCircular()) {
            f_region_filter = true;
        }
        if (minMag >= -9.0) {
            query.setMinMagnitude(new BigDecimal(String.format(Locale.US, "%.3f", minMag)));
        }
        if (productType != null) {
            query.setProductType(productType);
        }
        if (includeDeleted) {
            query.setIncludeDeleted(true);
        }
        query.setOrderBy(OrderBy.TIME);
        int my_limit = limit_per_call;
        if (my_limit <= 0) {
            my_limit = 20000;
        }
        query.setLimit(my_limit);
        int my_max_calls = max_calls;
        if (my_max_calls <= 0) {
            my_max_calls = 25;
        }
        int offset = 1;
        HashSet<String> event_filter = new HashSet<String>();
        if (exclude_id != null) {
            event_filter.add(exclude_id);
        }
        int total_count = 0;
        int result = 0;
        ObsEqkRupList rups = new ObsEqkRupList();
        int n_call = 1;
        while (true) {
            if (offset != 1) {
                query.setOffset(offset);
            }
            if (current_end_time != original_end_time) {
                query.setEndTime(new Date(current_end_time));
            }
            List<JsonEvent> events = this.getEventsFromComcat(query);
            int count = events.size();
            boolean f_done = false;
            if (count < my_limit) {
                f_done = true;
            }
            int filtered_count = 0;
            int filtered_by_conversion = 0;
            int filtered_by_location = 0;
            int filtered_by_id = 0;
            long last_received_time = current_end_time;
            for (JsonEvent event : events) {
                Date received_time = event.getTime();
                if (received_time != null) {
                    last_received_time = Math.min(last_received_time, received_time.getTime());
                }
                ObsEqkRupture rup = null;
                try {
                    rup = this.eventToObsRup(event, wrapLon, extendedInfo, null);
                }
                catch (Exception e) {
                    rup = null;
                }
                if (rup == null) {
                    ++filtered_by_conversion;
                    continue;
                }
                if (f_region_filter && !region.contains(rup.getHypocenterLocation())) {
                    ++filtered_by_location;
                    continue;
                }
                if (!event_filter.add(rup.getEventId())) {
                    ++filtered_by_id;
                    continue;
                }
                result = visitor.visit(rup, event);
                ++filtered_count;
                ++total_count;
                if (result == 0) continue;
                if (this.D) {
                    System.out.println("Visitor requested stop, total number of events returned = " + total_count);
                    if (filtered_by_conversion != 0 || filtered_by_location != 0 || filtered_by_id != 0) {
                        System.out.println("Events filtered due to conversion = " + filtered_by_conversion + ", location = " + filtered_by_location + ", id = " + filtered_by_id);
                    }
                }
                return result;
            }
            if (this.D) {
                System.out.println("Count of events after filtering = " + filtered_count);
                if (filtered_by_conversion != 0 || filtered_by_location != 0 || filtered_by_id != 0) {
                    System.out.println("Events filtered due to conversion = " + filtered_by_conversion + ", location = " + filtered_by_location + ", id = " + filtered_by_id);
                }
            }
            if ((current_end_time = Math.min(current_end_time - 1L, last_received_time + 60000L)) < startTime || f_done) break;
            if (n_call >= my_max_calls) {
                this.reportQueryError("ComcatAccessor: Exceeded maximum number of Comcat calls in a single operation", null);
                throw new ComcatException("ComcatAccessor: Exceeded maximum number of Comcat calls in a single operation");
            }
            ++n_call;
        }
        if (this.D) {
            System.out.println("Total number of events returned = " + total_count);
        }
        return result;
    }

    public int visitEventList(ComcatVisitor visitor, String exclude_id, long startTime, long endTime, double minDepth, double maxDepth, ComcatRegion region, boolean wrapLon, boolean extendedInfo, double minMag, String productType, boolean includeDeleted) {
        return this.visitEventList(visitor, exclude_id, startTime, endTime, minDepth, maxDepth, region, wrapLon, extendedInfo, minMag, productType, includeDeleted, 20000, 25);
    }

    protected ObsEqkRupture eventToObsRup(JsonEvent event, boolean wrapLon, boolean extendedInfo, String query_id) {
        double lat = event.getLatitude().doubleValue();
        double lon = event.getLongitude().doubleValue();
        GeoTools.validateLon(lon);
        if (wrapLon && lon < 0.0) {
            GeoTools.validateLon(lon += 360.0);
        }
        double dep = event.getDepth().doubleValue();
        Location hypo = new Location(lat, lon, dep);
        double mag = 0.0;
        try {
            mag = event.getMag().doubleValue();
        }
        catch (Exception e) {
            return null;
        }
        String event_id = event.getEventId().toString();
        if (event_id == null || event_id.isEmpty()) {
            return null;
        }
        if (query_id != null && !ComcatAccessor.idsToList(event.getIds(), event_id).contains(query_id)) {
            return null;
        }
        ObsEqkRupture rup = new ObsEqkRupture(event_id, event.getTime().getTime(), hypo, mag);
        if (extendedInfo) {
            rup.addParameter(new StringParameter(PARAM_NAME_DESCRIPTION, event.getPlace()));
            rup.addParameter(new StringParameter(PARAM_NAME_IDLIST, event.getIds()));
            rup.addParameter(new StringParameter(PARAM_NAME_NETWORK, event.getNet()));
            rup.addParameter(new StringParameter(PARAM_NAME_CODE, event.getCode()));
        }
        return rup;
    }

    public int get_http_status_code() {
        if (this.local_http_status != 0) {
            return this.local_http_status;
        }
        if (this.service instanceof ComcatEventWebService) {
            return ((ComcatEventWebService)this.service).get_http_status_code();
        }
        return -1;
    }

    public int get_http_status_count() {
        return this.http_statuses.size();
    }

    public int get_http_status_code(int i) {
        return this.http_statuses.get(i);
    }

    public URL get_last_url() {
        if (this.service instanceof ComcatEventWebService) {
            return ((ComcatEventWebService)this.service).get_last_url();
        }
        return null;
    }

    public String get_last_url_as_string() {
        URL result = this.get_last_url();
        return result == null ? "<null>" : result.toString();
    }

    public void setConnectTimeout(int the_connectTimeout) {
        if (this.service instanceof ComcatEventWebService) {
            ((ComcatEventWebService)this.service).setConnectTimeout(the_connectTimeout);
        }
    }

    public void setReadTimeout(int the_readTimeout) {
        if (this.service instanceof ComcatEventWebService) {
            ((ComcatEventWebService)this.service).setReadTimeout(the_readTimeout);
        }
    }

    public void setEnableTimeoutReadback(boolean the_enableTimeoutReadback) {
        if (this.service instanceof ComcatEventWebService) {
            ((ComcatEventWebService)this.service).setEnableTimeoutReadback(the_enableTimeoutReadback);
        }
    }

    public int getLastConnectTimeout() {
        if (this.service instanceof ComcatEventWebService) {
            return ((ComcatEventWebService)this.service).getLastConnectTimeout();
        }
        return -1;
    }

    public int getLastReadTimeout() {
        if (this.service instanceof ComcatEventWebService) {
            return ((ComcatEventWebService)this.service).getLastReadTimeout();
        }
        return -1;
    }

    public JsonEvent get_last_geojson() {
        return this.last_geojson;
    }

    public void set_refetch_secondary(boolean f_refetch_secondary) {
        this.refetch_secondary = f_refetch_secondary;
    }

    protected void reportQueryError(String message, Exception e) {
        try {
            System.out.println(message);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected List<JsonEvent> getEventsFromComcat(EventQuery query) {
        ArrayList<JsonEvent> events = null;
        this.local_http_status = 0;
        if (this.D) {
            try {
                System.out.println(this.service.getUrl(query, Format.GEOJSON));
            }
            catch (MalformedURLException e) {
                System.out.println("Comcat query with unknown URL");
            }
        }
        try {
            events = this.service.getEvents(query);
        }
        catch (SocketTimeoutException e) {
            if (this.get_http_status_code() == -1) {
                this.http_statuses.add(this.get_http_status_code());
                this.reportQueryError("ComcatAccessor: Timeout error (SocketTimeoutException) while accessing Comcat", e);
                throw new ComcatException("ComcatAccessor: Timeout error (SocketTimeoutException) while accessing Comcat", e);
            }
            if (this.get_http_status_code() == -2) {
                this.http_statuses.add(this.get_http_status_code());
                this.reportQueryError("ComcatAccessor: Timeout error (SocketTimeoutException) while connecting to Comcat", e);
                throw new ComcatException("ComcatAccessor: Timeout error (SocketTimeoutException) while connecting to Comcat", e);
            }
            this.http_statuses.add(this.get_http_status_code());
            this.reportQueryError("ComcatAccessor: Timeout error (SocketTimeoutException) while reading data from Comcat", e);
            throw new ComcatException("ComcatAccessor: Timeout error (SocketTimeoutException) while reading data from Comcat", e);
        }
        catch (UnknownServiceException e) {
            this.http_statuses.add(this.get_http_status_code());
            this.reportQueryError("ComcatAccessor: I/O error (UnknownServiceException) while accessing Comcat", e);
            throw new ComcatException("ComcatAccessor: I/O error (UnknownServiceException) while accessing Comcat", e);
        }
        catch (ZipException e) {
            this.http_statuses.add(this.get_http_status_code());
            this.reportQueryError("ComcatAccessor: Data error (ZipException) while accessing Comcat", e);
            throw new ComcatException("ComcatAccessor: Data error (ZipException) while accessing Comcat", e);
        }
        catch (UnknownHostException e) {
            this.http_statuses.add(this.get_http_status_code());
            this.reportQueryError("ComcatAccessor: Unable to find host (UnknownHostException) while accessing Comcat", e);
            throw new ComcatException("ComcatAccessor: Unable to find host (UnknownHostException) while accessing Comcat", e);
        }
        catch (SSLException e) {
            this.http_statuses.add(this.get_http_status_code());
            this.reportQueryError("ComcatAccessor: SSL error (SSLException) while accessing Comcat", e);
            throw new ComcatException("ComcatAccessor: SSL error (SSLException) while accessing Comcat", e);
        }
        catch (MalformedURLException e) {
            this.http_statuses.add(this.get_http_status_code());
            this.reportQueryError("ComcatAccessor: Bad query URL (MalformedURLException) while accessing Comcat", e);
            throw new ComcatException("ComcatAccessor: Bad query URL (MalformedURLException) while accessing Comcat", e);
        }
        catch (FileNotFoundException e) {
            if (this.get_http_status_code() == -1) {
                events = new ArrayList<JsonEvent>();
            }
            this.http_statuses.add(this.get_http_status_code());
            this.reportQueryError("ComcatAccessor: I/O error (FileNotFoundException) while accessing Comcat", e);
            throw new ComcatException("ComcatAccessor: I/O error (FileNotFoundException) while accessing Comcat", e);
        }
        catch (IOException e) {
            this.http_statuses.add(this.get_http_status_code());
            this.reportQueryError("ComcatAccessor: I/O error (IOException) while accessing Comcat", e);
            throw new ComcatException("ComcatAccessor: I/O error (IOException) while accessing Comcat", e);
        }
        catch (Exception e) {
            this.http_statuses.add(this.get_http_status_code());
            this.reportQueryError("ComcatAccessor: Data error (Exception) while accessing Comcat", e);
            throw new ComcatException("ComcatAccessor: Data error (Exception) while accessing Comcat", e);
        }
        this.http_statuses.add(this.get_http_status_code());
        if (events == null) {
            events = new ArrayList();
        }
        if (this.D) {
            System.out.println("Count of events received = " + events.size());
        }
        return events;
    }

    public static Map<String, String> extendedInfoToMap(ObsEqkRupture rup, int option) {
        HashMap<String, String> eimap = new HashMap<String, String>();
        ListIterator<Parameter<?>> iter = rup.getAddedParametersIterator();
        if (iter != null) {
            block8: while (iter.hasNext()) {
                Parameter<?> param = iter.next();
                String key = param.getName();
                String value = null;
                Object o = param.getValue();
                if (o != null) {
                    value = o.toString();
                }
                if (value == null) {
                    switch (option) {
                        case 1: 
                        case 3: {
                            continue block8;
                        }
                        case 4: {
                            value = "";
                        }
                    }
                } else if (value.isEmpty()) {
                    switch (option) {
                        case 2: 
                        case 3: {
                            continue block8;
                        }
                        case 5: {
                            value = null;
                        }
                    }
                }
                eimap.put(key, value);
            }
        }
        return eimap;
    }

    public static List<String> idsToList(String ids, String preferred_id) {
        ArrayList<String> idlist = new ArrayList<String>();
        HashSet<String> idset = new HashSet<String>();
        if (preferred_id != null && !preferred_id.isEmpty()) {
            idset.add(preferred_id);
            idlist.add(preferred_id);
        }
        if (ids != null) {
            int n = ids.length();
            int begin = 0;
            while (begin < n) {
                String id;
                int end = ids.indexOf(",", begin);
                if (end < 0) {
                    end = n;
                }
                if (!(id = ids.substring(begin, end).trim()).isEmpty() && idset.add(id)) {
                    idlist.add(id);
                }
                begin = end + 1;
            }
        }
        return idlist;
    }

    public static String rupToString(ObsEqkRupture rup) {
        StringBuilder result = new StringBuilder();
        String rup_event_id = rup.getEventId();
        long rup_time = rup.getOriginTime();
        double rup_mag = rup.getMag();
        Location hypo = rup.getHypocenterLocation();
        double rup_lat = hypo.getLatitude();
        double rup_lon = hypo.getLongitude();
        double rup_depth = hypo.getDepth();
        String rup_time_string = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss 'UTC'").withZone(ZoneOffset.UTC).format(Instant.ofEpochMilli(rup_time));
        result.append("ObsEqkRupture:\n");
        result.append("rup_event_id = " + rup_event_id + "\n");
        result.append("rup_time = " + rup_time + " (" + rup_time_string + ")\n");
        result.append("rup_mag = " + rup_mag + "\n");
        result.append("rup_lat = " + rup_lat + "\n");
        result.append("rup_lon = " + rup_lon + "\n");
        result.append("rup_depth = " + rup_depth + "\n");
        ListIterator<Parameter<?>> iter = rup.getAddedParametersIterator();
        if (iter != null) {
            while (iter.hasNext()) {
                Parameter<?> param = iter.next();
                result.append(param.getName() + " = " + String.valueOf(param.getValue()) + "\n");
            }
        }
        return result.toString();
    }
}

