/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.data.comcat;

import gov.usgs.earthquake.event.EventQuery;
import gov.usgs.earthquake.event.EventWebService;
import gov.usgs.earthquake.event.Format;
import gov.usgs.earthquake.event.ISO8601;
import gov.usgs.earthquake.event.JsonEvent;
import gov.usgs.earthquake.event.JsonUtil;
import gov.usgs.earthquake.event.UrlUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.zip.GZIPInputStream;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.opensha.commons.data.comcat.ComcatEventQuery;

public class ComcatEventWebService
extends EventWebService {
    protected int http_status_code;
    protected URL last_url;
    protected URL feedURL;
    public static final int DEFAULT_CONNECT_TIMEOUT = 15000;
    public static final int DEFAULT_READ_TIMEOUT = 300000;
    protected int connectTimeout;
    protected int readTimeout;
    protected boolean enableTimeoutReadback;
    protected int lastConnectTimeout;
    protected int lastReadTimeout;

    public int get_http_status_code() {
        return this.http_status_code;
    }

    public URL get_last_url() {
        return this.last_url;
    }

    public URL getFeedUrl() {
        return this.feedURL;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(int the_connectTimeout) {
        if (the_connectTimeout < -2) {
            throw new IllegalArgumentException("Invalid connection timeout: " + the_connectTimeout);
        }
        this.connectTimeout = the_connectTimeout == -2 ? 15000 : the_connectTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(int the_readTimeout) {
        if (the_readTimeout < -2) {
            throw new IllegalArgumentException("Invalid read timeout: " + the_readTimeout);
        }
        this.readTimeout = the_readTimeout == -2 ? 300000 : the_readTimeout;
    }

    public boolean getEnableTimeoutReadback() {
        return this.enableTimeoutReadback;
    }

    public void setEnableTimeoutReadback(boolean the_enableTimeoutReadback) {
        this.enableTimeoutReadback = the_enableTimeoutReadback;
    }

    public int getLastConnectTimeout() {
        return this.lastConnectTimeout;
    }

    public int getLastReadTimeout() {
        return this.lastReadTimeout;
    }

    public ComcatEventWebService(URL serviceURL) {
        super(serviceURL);
        this.feedURL = null;
        this.http_status_code = -1;
        this.last_url = null;
        this.connectTimeout = 15000;
        this.readTimeout = 300000;
        this.enableTimeoutReadback = false;
        this.lastConnectTimeout = -1;
        this.lastReadTimeout = -1;
    }

    public ComcatEventWebService(URL serviceURL, URL feedURL) {
        super(serviceURL);
        this.feedURL = feedURL;
        this.http_status_code = -1;
        this.last_url = null;
        this.connectTimeout = 15000;
        this.readTimeout = 300000;
        this.enableTimeoutReadback = false;
        this.lastConnectTimeout = -1;
        this.lastReadTimeout = -1;
    }

    public List<JsonEvent> getEvents(EventQuery query) throws Exception {
        URL url;
        List<JsonEvent> events = null;
        this.http_status_code = -2;
        this.lastConnectTimeout = -1;
        this.lastReadTimeout = -1;
        this.last_url = null;
        this.last_url = url = this.getUrl(query, Format.GEOJSON);
        URLConnection conn = url.openConnection();
        conn.addRequestProperty("Accept-encoding", "gzip");
        if (this.connectTimeout >= 0) {
            conn.setConnectTimeout(this.connectTimeout);
        }
        if (this.readTimeout >= 0) {
            conn.setReadTimeout(this.readTimeout);
        }
        if (this.enableTimeoutReadback) {
            this.lastConnectTimeout = conn.getConnectTimeout();
            this.lastReadTimeout = conn.getReadTimeout();
        }
        conn.connect();
        if (conn instanceof HttpURLConnection) {
            HttpURLConnection http_conn = (HttpURLConnection)conn;
            this.http_status_code = http_conn.getResponseCode();
            switch (this.http_status_code) {
                case -1: 
                case 200: 
                case 206: {
                    break;
                }
                case 204: 
                case 404: 
                case 409: {
                    return new ArrayList<JsonEvent>();
                }
                default: {
                    throw new IOException("Call to Comcat failed with HTTP status code " + this.http_status_code);
                }
            }
        } else {
            this.http_status_code = -1;
        }
        try (InputStreamHolder stream_holder = new InputStreamHolder(conn.getInputStream());){
            if ("gzip".equals(conn.getContentEncoding())) {
                GZIPInputStream zip_stream = new GZIPInputStream(stream_holder.get_stream());
                stream_holder.set_stream(zip_stream);
            }
            events = this.parseJsonEventCollection(stream_holder.get_stream());
        }
        return events;
    }

    protected List<JsonEvent> parseJsonEventCollection(InputStream input) throws Exception {
        JSONParser parser = new JSONParser();
        JSONObject feed = JsonUtil.getJsonObject((Object)parser.parse((Reader)new InputStreamReader(input, StandardCharsets.UTF_8)));
        if (feed == null) {
            throw new Exception("Expected feed object");
        }
        String type = JsonUtil.getString((Object)feed.get((Object)"type"));
        if (type == null) {
            throw new Exception("Expected geojson type");
        }
        ArrayList<JsonEvent> events = new ArrayList<JsonEvent>();
        if (type.equals("Feature")) {
            events.add(new JsonEvent(feed));
        } else if (type.equals("FeatureCollection")) {
            JSONArray features = JsonUtil.getJsonArray((Object)feed.get((Object)"features"));
            if (features == null) {
                throw new Exception("Expected features");
            }
            Iterator iter = features.iterator();
            while (iter.hasNext()) {
                JSONObject next = JsonUtil.getJsonObject(iter.next());
                if (next == null) {
                    throw new Exception("Expected feature");
                }
                events.add(new JsonEvent(next));
            }
        }
        return events;
    }

    public URL getUrl(EventQuery query, Format format) throws MalformedURLException {
        ComcatEventQuery ceq = null;
        if (query instanceof ComcatEventQuery) {
            ceq = (ComcatEventQuery)query;
        }
        if (!(this.feedURL == null || query.getEventId() == null || format != Format.GEOJSON && (format != null || query.getFormat() != Format.GEOJSON) || query.getAlertLevel() != null || query.getCatalog() != null || query.getContributor() != null || query.getEndTime() != null || query.getEventType() != null || query.getIncludeAllMagnitudes() != null || query.getIncludeAllOrigins() != null || query.getIncludeArrivals() != null || ceq != null && ceq.getIncludeDeleted() != null || ceq != null && ceq.getIncludeSuperseded() != null || query.getKmlAnimated() != null || query.getKmlColorBy() != null || query.getLatitude() != null || query.getLimit() != null || query.getLongitude() != null || query.getMagnitudeType() != null || query.getMaxCdi() != null || query.getMaxDepth() != null || query.getMaxGap() != null || query.getMaxLatitude() != null || query.getMaxLongitude() != null || query.getMaxMagnitude() != null || query.getMaxMmi() != null || query.getMaxRadius() != null || query.getMaxSig() != null || query.getMinCdi() != null || query.getMinDepth() != null || query.getMinFelt() != null || query.getMinGap() != null || query.getMinLatitude() != null || query.getMinLongitude() != null || query.getMinMagnitude() != null || query.getMinMmi() != null || query.getMinRadius() != null || query.getMinSig() != null || query.getOffset() != null || query.getOrderBy() != null || query.getProductType() != null || query.getReviewStatus() != null || query.getStartTime() != null || query.getUpdatedAfter() != null)) {
            return new URL(this.feedURL, query.getEventId() + ".geojson");
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("alertlevel", query.getAlertLevel());
        params.put("catalog", query.getCatalog());
        params.put("contributor", query.getContributor());
        params.put("endtime", ISO8601.format((Date)query.getEndTime()));
        params.put("eventid", query.getEventId());
        params.put("eventtype", query.getEventType());
        params.put("format", format == null ? query.getFormat() : format);
        params.put("includeallmagnitudes", query.getIncludeAllMagnitudes());
        params.put("includeallorigins", query.getIncludeAllOrigins());
        params.put("includearrivals", query.getIncludeArrivals());
        if (ceq != null) {
            params.put("includedeleted", ceq.getIncludeDeleted());
        }
        if (ceq != null) {
            params.put("includesuperseded", ceq.getIncludeSuperseded());
        }
        params.put("kmlanimated", query.getKmlAnimated());
        params.put("kmlcolorby", query.getKmlColorBy());
        params.put("latitude", query.getLatitude());
        params.put("limit", query.getLimit());
        params.put("longitude", query.getLongitude());
        params.put("magnitudetype", query.getMagnitudeType());
        params.put("maxcdi", query.getMaxCdi());
        params.put("maxdepth", query.getMaxDepth());
        params.put("maxgap", query.getMaxGap());
        params.put("maxlatitude", query.getMaxLatitude());
        params.put("maxlongitude", query.getMaxLongitude());
        params.put("maxmagnitude", query.getMaxMagnitude());
        params.put("maxmmi", query.getMaxMmi());
        params.put("maxradius", query.getMaxRadius());
        params.put("maxsig", query.getMaxSig());
        params.put("mincdi", query.getMinCdi());
        params.put("mindepth", query.getMinDepth());
        params.put("minfelt", query.getMinFelt());
        params.put("mingap", query.getMinGap());
        params.put("minlatitude", query.getMinLatitude());
        params.put("minlongitude", query.getMinLongitude());
        params.put("minmagnitude", query.getMinMagnitude());
        params.put("minmmi", query.getMinMmi());
        params.put("minradius", query.getMinRadius());
        params.put("minsig", query.getMinSig());
        params.put("offset", query.getOffset());
        params.put("orderby", query.getOrderBy());
        params.put("producttype", query.getProductType());
        params.put("reviewstatus", query.getReviewStatus());
        params.put("starttime", ISO8601.format((Date)query.getStartTime()));
        params.put("updatedafter", ISO8601.format((Date)query.getUpdatedAfter()));
        String queryString = UrlUtil.getQueryString(params);
        return new URL(this.getServiceUrl(), "query" + queryString);
    }

    public static class InputStreamHolder
    implements AutoCloseable {
        private InputStream stream;
        private boolean is_closed;

        public InputStreamHolder(InputStream the_stream) {
            this.stream = the_stream;
            this.is_closed = false;
        }

        public InputStream get_stream() {
            return this.stream;
        }

        public void set_stream(InputStream the_stream) {
            this.stream = the_stream;
        }

        @Override
        public void close() throws Exception {
            if (!this.is_closed) {
                if (this.stream != null) {
                    this.stream.close();
                }
                this.is_closed = true;
            }
        }
    }
}

