/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.data.comcat;

import com.google.common.base.Preconditions;
import com.google.gson.Gson;
import gov.usgs.earthquake.event.EventQuery;
import gov.usgs.earthquake.event.EventWebService;
import gov.usgs.earthquake.event.UrlUtil;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.opensha.commons.data.comcat.ComcatEventWebService;
import org.opensha.commons.data.comcat.ComcatInvertedFiniteFault;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationList;
import org.opensha.commons.geo.json.Feature;
import org.opensha.commons.geo.json.FeatureCollection;
import org.opensha.commons.geo.json.FeatureProperties;
import org.opensha.commons.geo.json.Geometry;
import org.opensha.commons.util.DataUtils;
import org.opensha.commons.util.ExceptionUtils;

public class ComcatInvertedFiniteFaultAccessor {
    private static final boolean D = true;
    private static final double MAX_GRID_SPACING = 1.0;
    private EventWebService service;

    private static EventWebService buildService() {
        try {
            URL serviceURL = new URL("https://earthquake.usgs.gov/fdsnws/event/1/");
            URL feedURL = new URL("https://earthquake.usgs.gov/earthquakes/feed/v1.0/detail/");
            return new ComcatEventWebService(serviceURL, feedURL);
        }
        catch (MalformedURLException e) {
            throw ExceptionUtils.asRuntimeException(e);
        }
    }

    public ComcatInvertedFiniteFaultAccessor() {
        this(ComcatInvertedFiniteFaultAccessor.buildService());
    }

    public ComcatInvertedFiniteFaultAccessor(EventWebService service) {
        this.service = service;
    }

    public ComcatInvertedFiniteFault fetchFiniteFault(String eventID) {
        List events;
        EventQuery query = new EventQuery();
        query.setEventId(eventID);
        try {
            events = this.service.getEvents(query);
            Preconditions.checkState((!events.isEmpty() ? 1 : 0) != 0, (Object)"Event not found");
        }
        catch (Exception e) {
            System.err.println("Could not retrieve event '" + eventID + "' from Comcat");
            throw ExceptionUtils.asRuntimeException(e);
        }
        Preconditions.checkState((events.size() == 1 ? 1 : 0) != 0, (Object)("More that 1 match? " + events.size()));
        JSONObject obj = (JSONObject)events.get(0);
        JSONObject prop = (JSONObject)obj.get((Object)"properties");
        JSONObject prods = (JSONObject)prop.get((Object)"products");
        JSONArray finites = (JSONArray)prods.get((Object)"finite-fault");
        if (finites != null) {
            JSONObject finite = (JSONObject)finites.get(0);
            JSONObject contents = (JSONObject)finite.get((Object)"contents");
            JSONObject fault = null;
            if (contents != null) {
                Set keys = contents.keySet();
                Iterator i = keys.iterator();
                while (i.hasNext()) {
                    String str = i.next().toString();
                    if (!str.toLowerCase().endsWith("ffm.geojson")) continue;
                    System.out.println(str);
                    fault = (JSONObject)contents.get((Object)str);
                    System.out.println(fault.get((Object)"url"));
                    break;
                }
                if (fault != null) {
                    URL url;
                    String urlStr = fault.get((Object)"url").toString().trim();
                    try {
                        url = new URL(urlStr);
                    }
                    catch (MalformedURLException e) {
                        System.err.println("Error resolving ComCat finite fault URL");
                        throw ExceptionUtils.asRuntimeException(e);
                    }
                    try {
                        return ComcatInvertedFiniteFaultAccessor.parseFaultJSON(url);
                    }
                    catch (IOException e) {
                        System.out.println("No Finite Fault");
                        System.err.println("Error loading ComCat finite fault file");
                        throw ExceptionUtils.asRuntimeException(e);
                    }
                }
                System.out.println("ComCat finite fault exists, but no FFM.geojson");
            }
        }
        System.out.println("No ComCat finite fault");
        return null;
    }

    private static ComcatInvertedFiniteFault parseFaultJSON(URL url) throws IOException {
        InputStream input = UrlUtil.getInputStream((URL)url);
        if (input instanceof BufferedInputStream) {
            input = new BufferedInputStream(input);
        }
        Gson gson = FeatureCollection.buildGson(Geometry.DepthSerializationType.DEPTH_M);
        FeatureCollection collection = (FeatureCollection)gson.fromJson((Reader)new InputStreamReader(input), FeatureCollection.class);
        ComcatInvertedFiniteFault ret = new ComcatInvertedFiniteFault();
        for (Feature feature : collection.features) {
            FeatureProperties props = feature.properties;
            double slip = props.getDouble("slip", 0.0);
            double moment = props.getDouble("sf_moment", 0.0);
            Geometry geom = feature.geometry;
            if (geom instanceof Geometry.Polygon) {
                Geometry.Polygon poly = (Geometry.Polygon)geom;
                if (poly.polygon == null) continue;
                ret.addRecord(poly.polygon, slip, moment);
                continue;
            }
            if (geom instanceof Geometry.MultiPolygon) {
                for (Geometry.Polygon poly : ((Geometry.MultiPolygon)geom).polygons) {
                    if (poly == null) continue;
                    ret.addRecord(poly.polygon, slip, moment);
                }
                continue;
            }
            throw new IllegalStateException("Unexpected finite fault geometry type: " + String.valueOf((Object)geom.type));
        }
        return ret;
    }

    public static void main(String[] args) {
        ComcatInvertedFiniteFaultAccessor source = new ComcatInvertedFiniteFaultAccessor();
        ComcatInvertedFiniteFault fault = source.fetchFiniteFault("ci38457511");
        DataUtils.MinMaxAveTracker zTrack = new DataUtils.MinMaxAveTracker();
        for (LocationList outline : fault.getOutlines(0.0)) {
            for (Location loc : outline) {
                zTrack.addValue(loc.getDepth());
            }
        }
        System.out.println("Depth track:\n" + String.valueOf(zTrack));
    }
}

