/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.data.function;

import com.google.common.collect.Lists;
import java.awt.geom.Point2D;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.List;
import org.opensha.commons.data.function.XY_DataSet;
import org.opensha.commons.data.function.XY_DataSetList;

public abstract class AbstractXY_DataSet
implements XY_DataSet {
    private static final long serialVersionUID = 1L;
    protected String info = "";
    protected String name = "";
    protected String xAxisName;
    protected String yAxisName;

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getInfo() {
        return this.info;
    }

    @Override
    public void setInfo(String info) {
        this.info = info;
    }

    @Override
    public void setXAxisName(String xName) {
        this.xAxisName = xName;
    }

    @Override
    public String getXAxisName() {
        return this.xAxisName;
    }

    @Override
    public void setYAxisName(String yName) {
        this.yAxisName = yName;
    }

    @Override
    public String getYAxisName() {
        return this.yAxisName;
    }

    @Override
    public double getClosestXtoY(double y) {
        double x = Double.NaN;
        double dist = Double.POSITIVE_INFINITY;
        for (int i = 0; i < this.size(); ++i) {
            double newY = this.getY(i);
            double newDist = Math.abs(newY - y);
            if (!(newDist < dist)) continue;
            dist = newDist;
            x = this.getX(i);
        }
        return x;
    }

    @Override
    public double getClosestYtoX(double x) {
        double y = Double.NaN;
        double dist = Double.POSITIVE_INFINITY;
        for (int i = 0; i < this.size(); ++i) {
            double newX = this.getX(i);
            double newDist = Math.abs(newX - x);
            if (!(newDist < dist)) continue;
            dist = newDist;
            y = this.getY(i);
        }
        return y;
    }

    @Override
    public boolean areAllXValuesInteger(double tolerance) {
        int num = this.size();
        for (int i = 0; i < num; ++i) {
            double x = this.getX(i);
            double diff = Math.abs(x - Math.rint(x));
            if (!(diff > tolerance)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Iterator<Double> getXValuesIterator() {
        return new Iterator<Double>(){
            int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < AbstractXY_DataSet.this.size();
            }

            @Override
            public Double next() {
                return AbstractXY_DataSet.this.getX(this.index++);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public Iterator<Double> getYValuesIterator() {
        return new Iterator<Double>(){
            int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < AbstractXY_DataSet.this.size();
            }

            @Override
            public Double next() {
                return AbstractXY_DataSet.this.getY(this.index++);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public Iterator<Point2D> iterator() {
        return new Iterator<Point2D>(){
            int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < AbstractXY_DataSet.this.size();
            }

            @Override
            public Point2D next() {
                return AbstractXY_DataSet.this.get(this.index++);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public List<Double> xValues() {
        return new AbstractList<Double>(){

            @Override
            public Double get(int index) {
                return AbstractXY_DataSet.this.getX(index);
            }

            @Override
            public int size() {
                return AbstractXY_DataSet.this.size();
            }

            @Override
            public Iterator<Double> iterator() {
                final Iterator<Point2D> it = AbstractXY_DataSet.this.iterator();
                return new Iterator<Double>(){
                    final /* synthetic */ 4 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    @Override
                    public boolean hasNext() {
                        return it.hasNext();
                    }

                    @Override
                    public Double next() {
                        return ((Point2D)it.next()).getX();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    @Override
    public List<Double> yValues() {
        return new AbstractList<Double>(){

            @Override
            public Double get(int index) {
                return AbstractXY_DataSet.this.getY(index);
            }

            @Override
            public int size() {
                return AbstractXY_DataSet.this.size();
            }

            @Override
            public Iterator<Double> iterator() {
                final Iterator<Point2D> it = AbstractXY_DataSet.this.iterator();
                return new Iterator<Double>(){
                    final /* synthetic */ 5 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    @Override
                    public boolean hasNext() {
                        return it.hasNext();
                    }

                    @Override
                    public Double next() {
                        return ((Point2D)it.next()).getY();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    @Override
    public XY_DataSetList getDatasetsToPlot() {
        XY_DataSetList list = new XY_DataSetList();
        list.add(this);
        return list;
    }

    @Override
    public List<Integer> getPlotNumColorList() {
        return Lists.newArrayList((Object[])new Integer[]{1});
    }
}

