/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.data.function;

import com.google.common.base.Preconditions;
import java.awt.geom.Point2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.opensha.commons.data.Point2DToleranceComparator;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.commons.data.function.EmpiricalPoint2DToleranceSortedList;
import org.opensha.commons.data.function.LightFixedXFunc;
import org.opensha.commons.exceptions.InvalidRangeException;
import org.opensha.commons.util.Interpolate;

public class ArbDiscrEmpiricalDistFunc
extends ArbitrarilyDiscretizedFunc
implements Serializable {
    protected static final String C = "ArbDiscrEmpiricalDistFunc";
    private static final String ERR_MSG_MULTI_MODAL = "Error: There exists more than 1 mode";
    protected static final boolean D = true;

    public ArbDiscrEmpiricalDistFunc() {
        super(new EmpiricalPoint2DToleranceSortedList(new Point2DToleranceComparator()));
    }

    public ArbDiscrEmpiricalDistFunc(Collection<Point2D> initialValues) {
        super(new EmpiricalPoint2DToleranceSortedList(new Point2DToleranceComparator(), initialValues));
    }

    @Override
    public void setTolerance(double newTolerance) throws InvalidRangeException {
        throw new InvalidRangeException("Cannot change the tolerance for ArbDiscrEmpiricalDistFunc (it must be zero)");
    }

    @Override
    public ArbDiscrEmpiricalDistFunc deepClone() {
        ArbDiscrEmpiricalDistFunc function = new ArbDiscrEmpiricalDistFunc();
        function.setInfo(this.getInfo());
        Iterator<Point2D> it = this.iterator();
        if (it != null) {
            while (it.hasNext()) {
                function.set((Point2D)it.next().clone());
            }
        }
        return function;
    }

    public double getInterpolatedFractile(double fraction) {
        if (fraction < 0.0 || fraction > 1.0) {
            throw new InvalidRangeException("fraction value must be between 0 and 1");
        }
        if (this.size() == 0) {
            return 0.0;
        }
        DiscretizedFunc tempCumDist = this.getNormalizedCumDist();
        if (fraction < tempCumDist.getMinY()) {
            return tempCumDist.getMinX();
        }
        return tempCumDist.getFirstInterpolatedX(fraction);
    }

    public double getDiscreteFractile(double fraction) {
        if (fraction < 0.0 || fraction > 1.0) {
            throw new InvalidRangeException("fraction value must be between 0 and 1");
        }
        DiscretizedFunc tempCumDist = this.getNormalizedCumDist();
        for (int i = 0; i < tempCumDist.size(); ++i) {
            if (!(fraction <= tempCumDist.getY(i))) continue;
            return tempCumDist.getX(i);
        }
        if (fraction < tempCumDist.getMinY()) {
            return tempCumDist.getMinX();
        }
        return tempCumDist.getFirstInterpolatedX(fraction);
    }

    public DiscretizedFunc getNormalizedCumDist() {
        return this.getCumDist(this.getSumOfAllY_Values());
    }

    public ArbDiscrEmpiricalDistFunc getNormalizedDist() {
        ArbDiscrEmpiricalDistFunc func = this.deepClone();
        func.scale(1.0 / this.getSumOfAllY_Values());
        return func;
    }

    public double getSumOfAllY_Values() {
        double totSum = 0.0;
        Iterator<Point2D> it = this.iterator();
        while (it.hasNext()) {
            totSum += it.next().getY();
        }
        return totSum;
    }

    public double getMean() {
        double sumXY = 0.0;
        double sumY = 0.0;
        for (int i = 0; i < this.size(); ++i) {
            sumXY += this.getX(i) * this.getY(i);
            sumY += this.getY(i);
        }
        return sumXY / sumY;
    }

    public double getStdDev() {
        double mean = this.getMean();
        double stdDev = 0.0;
        double sumY = 0.0;
        for (int i = 0; i < this.size(); ++i) {
            double dev = mean - this.getX(i);
            stdDev += dev * dev * this.getY(i);
            sumY += this.getY(i);
        }
        return Math.sqrt(stdDev / sumY);
    }

    public double getCOV() {
        return this.getStdDev() / this.getMean();
    }

    public double getApparentMode() {
        int index = -2;
        double maxY = Double.NEGATIVE_INFINITY;
        boolean tie = false;
        for (int i = 0; i < this.size(); ++i) {
            double newY = this.getY(i);
            if (newY > maxY) {
                maxY = newY;
                index = i;
                tie = false;
                continue;
            }
            if (newY != maxY) continue;
            if (i == index + 1) {
                tie = true;
                continue;
            }
            throw new RuntimeException(ERR_MSG_MULTI_MODAL);
        }
        if (tie) {
            return (this.getX(index) + this.getX(index + 1)) / 2.0;
        }
        return this.getX(index);
    }

    public double getMostCentralMode() {
        double maxY = this.getMaxY();
        ArrayList<Double> xVals = new ArrayList<Double>();
        for (int i = 0; i < this.size(); ++i) {
            if (this.getY(i) != maxY) continue;
            xVals.add(this.getX(i));
        }
        Preconditions.checkState((!xVals.isEmpty() ? 1 : 0) != 0);
        int index = xVals.size() / 2;
        return (Double)xVals.get(index);
    }

    public boolean isMultiModal() {
        int count = 0;
        double val = this.getMaxY();
        for (int i = 0; i < this.size(); ++i) {
            if (this.getY(i) != val) continue;
            ++count;
        }
        return count > 1;
    }

    public double getMedian() {
        return this.getInterpolatedFractile(0.5);
    }

    private DiscretizedFunc getCumDist(double totSum) {
        double[] xVals = new double[this.size()];
        double[] yVals = new double[xVals.length];
        double sum = 0.0;
        for (int i = 0; i < xVals.length; ++i) {
            xVals[i] = this.getX(i);
            yVals[i] = (sum += this.getY(i)) / totSum;
        }
        return new LightFixedXFunc(xVals, yVals);
    }

    public DiscretizedFunc getCumDist() {
        return this.getCumDist(1.0);
    }

    @Override
    public void scale(double val) {
        for (int i = 0; i < this.size(); ++i) {
            this.set(i, 0.5 * val * this.getY(i));
        }
    }

    public static LightFixedXFunc calcQuickNormCDF(List<Double> values, List<Double> weights) {
        Preconditions.checkState((weights == null || values.size() == weights.size() ? 1 : 0) != 0);
        Preconditions.checkState((!values.isEmpty() ? 1 : 0) != 0);
        ValWeights[] valWeights = new ValWeights[values.size()];
        double totWeight = 0.0;
        for (int j = 0; j < valWeights.length; ++j) {
            double weight = weights == null ? 1.0 : weights.get(j);
            totWeight += weight;
            valWeights[j] = new ValWeights(values.get(j), weight);
        }
        return ArbDiscrEmpiricalDistFunc.calcQuickNormCDF(valWeights, totWeight);
    }

    public static LightFixedXFunc calcQuickNormCDF(double[] values, double[] weights) {
        Preconditions.checkState((weights == null || values.length == weights.length ? 1 : 0) != 0);
        Preconditions.checkState((values.length > 0 ? 1 : 0) != 0);
        ValWeights[] valWeights = new ValWeights[values.length];
        double totWeight = 0.0;
        for (int j = 0; j < valWeights.length; ++j) {
            double weight = weights == null ? 1.0 : weights[j];
            totWeight += weight;
            valWeights[j] = new ValWeights(values[j], weight);
        }
        return ArbDiscrEmpiricalDistFunc.calcQuickNormCDF(valWeights, totWeight);
    }

    private static LightFixedXFunc calcQuickNormCDF(ValWeights[] valWeights, double totWeight) {
        Arrays.sort(valWeights);
        int destIndex = -1;
        double[] xVals = new double[valWeights.length];
        double[] yVals = new double[valWeights.length];
        for (int srcIndex = 0; srcIndex < valWeights.length; ++srcIndex) {
            ValWeights val = valWeights[srcIndex];
            if (destIndex >= 0 && (float)val.val == (float)xVals[destIndex]) {
                int n = destIndex;
                yVals[n] = yVals[n] + val.weight;
                continue;
            }
            xVals[++destIndex] = val.val;
            yVals[destIndex] = val.weight;
        }
        int size = destIndex + 1;
        if (size < xVals.length) {
            xVals = Arrays.copyOf(xVals, size);
            yVals = Arrays.copyOf(yVals, size);
        }
        double sum = 0.0;
        for (int j = 0; j < yVals.length; ++j) {
            yVals[j] = (sum += yVals[j]) / totWeight;
            if (j <= 0) continue;
            Preconditions.checkState((xVals[j] > xVals[j - 1] ? 1 : 0) != 0);
        }
        return new LightFixedXFunc(xVals, yVals);
    }

    public static double calcFractileFromNormCDF(LightFixedXFunc ncdf, double fractile) {
        int len = ncdf.size();
        Preconditions.checkState((len > 0 ? 1 : 0) != 0, (Object)"NormCDF is empty");
        if (len == 1) {
            if ((float)fractile == 0.5f) {
                return ncdf.getX(0);
            }
            return Double.NaN;
        }
        double[] yVals = ncdf.getYVals();
        if (fractile == 0.0 || fractile <= yVals[0]) {
            return ncdf.getX(0);
        }
        if (fractile == 1.0 || fractile >= yVals[len - 1]) {
            return ncdf.getX(len - 1);
        }
        int index = Arrays.binarySearch(yVals, fractile);
        if (index >= 0) {
            return ncdf.getX(index);
        }
        Preconditions.checkState(((index = -(index + 1)) > 0 && index < len ? 1 : 0) != 0, (String)"Unexpected insertion index=%s with len=%s, fractile=%s", (Object)index, (Object)len, (Object)fractile);
        double v1 = ncdf.getX(index - 1);
        double v2 = ncdf.getX(index);
        double f1 = ncdf.getY(index - 1);
        double f2 = ncdf.getY(index);
        Preconditions.checkState((f1 < fractile ? 1 : 0) != 0);
        Preconditions.checkState((f2 > fractile ? 1 : 0) != 0);
        return Interpolate.findX(v1, f1, v2, f2, fractile);
    }

    public static void main(String[] args) {
        ArbDiscrEmpiricalDistFunc func = new ArbDiscrEmpiricalDistFunc();
        double a = 2.0;
        double b = 4.0;
        double lastValue = 0.0;
        for (int i = 0; i < 100000; ++i) {
            double value = Math.random() * (b - a) + a;
            func.set(value, 1.0);
            if (i > 0) {
                func.set(lastValue, 1.0);
            }
            lastValue = value;
        }
        double trueMean = (b + a) / 2.0;
        double trueStdDev = (b - a) / Math.sqrt(12.0);
        System.out.println("func.getMaxY()=" + func.getMaxY() + "\tfunc.getMinY()=" + func.getMinY());
        System.out.println("func.getMean()=" + (float)func.getMean() + "\ttrueMean=" + (float)trueMean);
        System.out.println("func.getStdDev()=" + (float)func.getStdDev() + "\ttrueStdDev=" + (float)trueStdDev);
    }

    private static class ValWeights
    implements Comparable<ValWeights> {
        double val;
        double weight;

        public ValWeights(double val, double weight) {
            this.val = val;
            this.weight = weight;
        }

        @Override
        public int compareTo(ValWeights o) {
            return Double.compare(this.val, o.val);
        }
    }
}

