/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.data.function;

import java.awt.geom.Point2D;
import java.util.Arrays;
import org.apache.commons.math3.stat.StatUtils;
import org.opensha.commons.data.function.AbstractDiscretizedFunc;
import org.opensha.commons.data.function.DiscretizedFunc;

public class LightFixedXFunc
extends AbstractDiscretizedFunc {
    private double[] xVals;
    private double[] yVals;

    public LightFixedXFunc(DiscretizedFunc func) {
        this.xVals = new double[func.size()];
        this.yVals = new double[this.xVals.length];
        for (int i = 0; i < this.xVals.length; ++i) {
            Point2D pt = func.get(i);
            this.xVals[i] = pt.getX();
            this.yVals[i] = pt.getY();
        }
    }

    public LightFixedXFunc(double[] xVals, double[] yVals) {
        this.xVals = xVals;
        this.yVals = yVals;
    }

    @Override
    public double getY(double x) {
        int ind = Arrays.binarySearch(this.xVals, x);
        return this.yVals[ind];
    }

    @Override
    public int getXIndexBefore(double x) {
        int ind = Arrays.binarySearch(this.xVals, x);
        if (ind < 0) {
            return -ind - 2;
        }
        return ind - 1;
    }

    @Override
    public int getXIndex(double x) {
        return Arrays.binarySearch(this.xVals, x);
    }

    @Override
    public int getIndex(Point2D point) {
        return Arrays.binarySearch(this.xVals, point.getX());
    }

    @Override
    public DiscretizedFunc deepClone() {
        double[] yVals = Arrays.copyOf(this.yVals, this.yVals.length);
        return new LightFixedXFunc(this.xVals, yVals);
    }

    @Override
    public int size() {
        return this.xVals.length;
    }

    @Override
    public double getMinX() throws IndexOutOfBoundsException {
        return this.xVals[0];
    }

    @Override
    public double getMaxX() throws IndexOutOfBoundsException {
        return this.xVals[this.xVals.length - 1];
    }

    @Override
    public double getMinY() throws IndexOutOfBoundsException {
        return StatUtils.min((double[])this.yVals);
    }

    @Override
    public double getMaxY() throws IndexOutOfBoundsException {
        return StatUtils.max((double[])this.yVals);
    }

    @Override
    public Point2D get(int index) {
        if (index < 0 || index >= this.size()) {
            return null;
        }
        return new Point2D.Double(this.xVals[index], this.yVals[index]);
    }

    @Override
    public double getX(int index) throws IndexOutOfBoundsException {
        return this.xVals[index];
    }

    @Override
    public double getY(int index) throws IndexOutOfBoundsException {
        return this.yVals[index];
    }

    @Override
    public void set(Point2D point) {
        int ind = this.getIndex(point);
        if (ind < 0) {
            throw new IllegalArgumentException("No matching value in functions domain and can't add new points");
        }
        this.yVals[ind] = point.getY();
    }

    @Override
    public void set(double x, double y) {
        int ind = this.getXIndex(x);
        if (ind < 0) {
            throw new IllegalArgumentException("No matching value in functions domain and can't add new points");
        }
        this.yVals[ind] = y;
    }

    @Override
    public void set(int index, double Y) throws IndexOutOfBoundsException {
        this.yVals[index] = Y;
    }

    public double[] getXVals() {
        return this.xVals;
    }

    public double[] getYVals() {
        return this.yVals;
    }
}

