/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.data.function;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.opensha.commons.calc.FractileCurveCalculator;
import org.opensha.commons.data.function.AbstractXY_DataSet;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.commons.data.function.XY_DataSet;
import org.opensha.commons.data.function.XY_DataSetList;

public class WeightedFuncList {
    private List<Double> relativeWts = new ArrayList<Double>();
    private XY_DataSetList functionList = new XY_DataSetList();
    private XY_DataSetList fractileList = new XY_DataSetList();
    private AbstractXY_DataSet meanFunction;
    private static final String ERROR_WEIGHTS = "Error! Number of weights should be equal to number of curves";
    private FractileCurveCalculator fractileCalc;
    private List<Double> fractionList = new ArrayList<Double>();
    private boolean isMeanFractileCalculated = false;
    private String info = null;

    public void addList(List<Double> relWts, XY_DataSetList funcList) {
        int size = relWts.size();
        if (size != funcList.size()) {
            throw new RuntimeException(ERROR_WEIGHTS);
        }
        for (int i = 0; i < size; ++i) {
            XY_DataSet function = (XY_DataSet)funcList.get(i);
            if (!this.isFuncAllowed(function)) {
                throw new RuntimeException("Function not allowed");
            }
            this.functionList.add(function);
            this.relativeWts.add(relWts.get(i));
        }
        if (this.fractileList.size() > 0) {
            ArrayList<Double> list = new ArrayList<Double>();
            list.addAll(this.fractionList);
            this.addFractiles(list);
        }
        if (this.isMeanFractileCalculated) {
            this.addMean();
        }
        this.setInfoForWeightedFunctionList();
    }

    private void setInfoForWeightedFunctionList() {
        String funcListInfo = this.functionList.size() + " functions with relative weights: ";
        for (int i = 0; i < this.relativeWts.size(); ++i) {
            funcListInfo = funcListInfo + this.relativeWts.get(i) + ", ";
        }
        funcListInfo = funcListInfo.substring(0, funcListInfo.length() - 2) + "\n";
        this.functionList.setInfo(funcListInfo);
    }

    public void add(double relWt, DiscretizedFunc func) {
        this.relativeWts.add(relWt);
        if (!this.isFuncAllowed(func)) {
            throw new RuntimeException("Function not allowed");
        }
        this.functionList.add(func);
        if (this.fractileList.size() > 0) {
            ArrayList<Double> list = new ArrayList<Double>();
            list.addAll(this.fractionList);
            this.addFractiles(list);
        }
        if (this.isMeanFractileCalculated) {
            this.addMean();
        }
        this.setInfoForWeightedFunctionList();
    }

    public boolean isFuncAllowed(XY_DataSet function) {
        int listSize = this.functionList.size();
        if (listSize != 0) {
            int numPoints = ((DiscretizedFunc)this.functionList.get(0)).size();
            if (function.size() != numPoints) {
                return false;
            }
        }
        return true;
    }

    private void setFractileCurveCalcuations() {
        if (this.fractileCalc == null) {
            this.fractileCalc = new FractileCurveCalculator(this.functionList, this.relativeWts);
        } else {
            this.fractileCalc.set(this.functionList, this.relativeWts);
        }
    }

    public void addFractile(double fraction) {
        this.addFractiles(Lists.newArrayList((Object[])new Double[]{fraction}));
    }

    public void addFractiles(List<Double> list) {
        int size = list.size();
        this.fractileList.clear();
        this.fractionList.clear();
        this.setFractileCurveCalcuations();
        for (int i = 0; i < size; ++i) {
            this.fractionList.add(list.get(i));
            double fraction = list.get(i);
            this.fractileList.add(this.fractileCalc.getFractile(fraction));
        }
        this.setFractilesInfo();
    }

    public void addMean() {
        this.setFractileCurveCalcuations();
        this.meanFunction = this.fractileCalc.getMeanCurve();
        this.isMeanFractileCalculated = true;
        String meanInfo = "Mean\n";
        this.meanFunction.setInfo(meanInfo);
    }

    public XY_DataSetList getWeightedFunctionList() {
        return this.functionList;
    }

    public XY_DataSetList getFractileList() {
        if (this.fractileList.size() > 0) {
            return this.fractileList;
        }
        return null;
    }

    public List<Double> getFractileValuesList() {
        return this.fractionList;
    }

    public AbstractXY_DataSet getMean() {
        if (this.isMeanFractileCalculated) {
            return this.meanFunction;
        }
        return null;
    }

    public List<Double> getRelativeWtList() {
        return this.relativeWts;
    }

    public int getNumWeightedFunctions() {
        return this.functionList.size();
    }

    public int getNumFractileFunctions() {
        return this.fractileList.size();
    }

    public void removeAllFractiles() {
        this.fractionList.clear();
        this.fractileList.clear();
    }

    public void removeMean() {
        if (this.isMeanFractileCalculated) {
            this.meanFunction = null;
            this.isMeanFractileCalculated = false;
        }
    }

    public void clearWeightedFunctionList() {
        this.relativeWts.clear();
        this.functionList.clear();
    }

    public boolean isMeanFunctionCalculated() {
        return this.isMeanFractileCalculated;
    }

    public void setInfo(String info) {
        this.info = info;
    }

    public String getInfo() {
        return this.info;
    }

    private void setFractilesInfo() {
        Object fractileInfo = "Fractiles: ";
        for (int i = 0; i < this.fractionList.size(); ++i) {
            fractileInfo = (String)fractileInfo + this.fractionList.get(i) + ", ";
        }
        fractileInfo = ((String)fractileInfo).substring(0, ((String)fractileInfo).length() - 2) + "\n";
        this.fractileList.setInfo((String)fractileInfo);
    }

    public String getFractileInfo() {
        return this.fractileList.getInfo();
    }

    public String getFunctionTraceInfo() {
        return this.functionList.getInfo();
    }

    public String getMeanFunctionInfo() {
        return this.meanFunction.getInfo();
    }
}

