/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.data.siteData;

import java.io.IOException;
import java.util.ArrayList;
import org.dom4j.Element;
import org.opensha.commons.data.siteData.SiteData;
import org.opensha.commons.data.siteData.SiteDataValue;
import org.opensha.commons.data.siteData.SiteDataValueList;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationList;
import org.opensha.commons.geo.Region;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.ParameterList;
import org.opensha.commons.param.editor.impl.ParameterListEditor;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeListener;

public class CachedSiteDataWrapper<Element>
implements SiteData<Element>,
ParameterChangeListener {
    private static final long serialVersionUID = 1L;
    protected static final boolean D = false;
    private int cacheSize;
    private int cacheSizeMinusOne;
    private SiteData<Element> provider;
    private ArrayList<Location> locsCache = new ArrayList();
    private ArrayList<Element> dataCache = new ArrayList();

    public CachedSiteDataWrapper(SiteData<Element> provider) {
        this(provider, 5);
    }

    public CachedSiteDataWrapper(SiteData<Element> provider, int cacheSize) {
        this.cacheSize = cacheSize;
        this.cacheSizeMinusOne = cacheSize - 1;
        this.provider = provider;
        ParameterList params = this.provider.getAdjustableParameterList();
        for (Parameter<?> param : params) {
            param.addParameterChangeListener(this);
        }
    }

    @Override
    public SiteDataValue<Element> getAnnotatedValue(Location loc) throws IOException {
        Element val = this.getValue(loc);
        return new SiteDataValue<Element>(this.provider.getDataType(), this.provider.getDataMeasurementType(), val, this.provider.getName());
    }

    @Override
    public Element getValue(Location loc) throws IOException {
        int size = this.locsCache.size();
        for (int i = 0; i < size; ++i) {
            Location dataLoc = this.locsCache.get(i);
            if (!loc.equals(dataLoc)) continue;
            if (i > 0) {
                Element data = this.dataCache.remove(i);
                this.locsCache.remove(i);
                this.dataCache.add(i, data);
                this.locsCache.add(i, dataLoc);
                return data;
            }
            return this.dataCache.get(i);
        }
        Element data = this.provider.getValue(loc);
        if (size == this.cacheSize) {
            this.locsCache.remove(this.cacheSizeMinusOne);
            this.dataCache.remove(this.cacheSizeMinusOne);
        }
        this.locsCache.add(0, loc);
        this.dataCache.add(0, data);
        return data;
    }

    public void clearCache() {
        this.locsCache.clear();
        this.dataCache.clear();
    }

    @Override
    public ArrayList<Element> getValues(LocationList locs) throws IOException {
        return this.provider.getValues(locs);
    }

    @Override
    public ParameterList getAdjustableParameterList() {
        return this.provider.getAdjustableParameterList();
    }

    @Override
    public Region getApplicableRegion() {
        return this.provider.getApplicableRegion();
    }

    @Override
    public Location getClosestDataLocation(Location loc) throws IOException {
        return this.provider.getClosestDataLocation(loc);
    }

    @Override
    public String getMetadata() {
        return this.provider.getMetadata();
    }

    @Override
    public String getName() {
        return this.provider.getName();
    }

    @Override
    public ParameterListEditor getParameterListEditor() {
        return this.provider.getParameterListEditor();
    }

    @Override
    public double getResolution() {
        return this.provider.getResolution();
    }

    @Override
    public String getShortName() {
        return this.provider.getShortName();
    }

    @Override
    public String getDataType() {
        return this.provider.getDataType();
    }

    @Override
    public String getDataMeasurementType() {
        return this.provider.getDataMeasurementType();
    }

    @Override
    public boolean hasDataForLocation(Location loc, boolean checkValid) {
        return this.provider.hasDataForLocation(loc, checkValid);
    }

    @Override
    public boolean isValueValid(Element el) {
        return this.provider.isValueValid(el);
    }

    @Override
    public Element toXMLMetadata(Element root) {
        return this.provider.toXMLMetadata(root);
    }

    @Override
    public SiteDataValueList<Element> getAnnotatedValues(LocationList locs) throws IOException {
        return this.provider.getAnnotatedValues(locs);
    }

    @Override
    public void parameterChange(ParameterChangeEvent event) {
        this.clearCache();
    }
}

