/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.data.siteData;

import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import org.opensha.commons.data.siteData.SiteData;
import org.opensha.commons.geo.BorderType;
import org.opensha.commons.geo.GriddedRegion;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationList;

public class SiteDataToXYZ {
    public static void writeXYZ(SiteData<?> data, GriddedRegion region, String fileName) throws IOException {
        SiteDataToXYZ.writeXYZ(data, region, fileName, true);
    }

    public static void writeXYZ(SiteData<?> data, double gridSpacing, String fileName) throws IOException {
        GriddedRegion region = new GriddedRegion(data.getApplicableRegion().getBorder(), BorderType.MERCATOR_LINEAR, gridSpacing, new Location(0.0, 0.0));
        SiteDataToXYZ.writeXYZ(data, region, fileName, true);
    }

    public static void writeXYZ(SiteData<?> data, GriddedRegion region, String fileName, boolean latFirst) throws IOException {
        FileWriter fw = new FileWriter(fileName);
        LocationList locs = region.getNodeList();
        ArrayList<?> vals = data.getValues(locs);
        for (int i = 0; i < locs.size(); ++i) {
            Location loc = (Location)locs.get(i);
            String str = latFirst ? loc.getLatitude() + "\t" + loc.getLongitude() + "\t" : loc.getLongitude() + "\t" + loc.getLatitude() + "\t";
            str = str + vals.get(i).toString();
            fw.write(str + "\n");
        }
        fw.close();
    }
}

