/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.data.siteData;

import java.util.Objects;
import org.dom4j.Attribute;
import org.dom4j.Element;
import org.opensha.commons.metadata.XMLSaveable;

public class SiteDataValue<Element>
implements XMLSaveable {
    public static final String XML_METADATA_NAME = "SiteDataValue";
    private String dataType;
    private String dataMeasurementType;
    private Element value;
    private String sourceName = null;

    public SiteDataValue(String dataType, String dataMeasurementType, Element value) {
        this(dataType, dataMeasurementType, value, null);
    }

    public SiteDataValue(String dataType, String dataMeasurementType, Element value, String sourceName) {
        this.dataType = dataType;
        this.dataMeasurementType = dataMeasurementType;
        this.value = value;
        this.sourceName = sourceName;
    }

    public String getDataType() {
        return this.dataType;
    }

    public String getDataMeasurementType() {
        return this.dataMeasurementType;
    }

    public Element getValue() {
        return this.value;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public String toString() {
        String str = "Type: " + this.dataType + ", Measurement Type: " + this.dataMeasurementType + ", Value: " + String.valueOf(this.value);
        if (this.sourceName != null) {
            str = str + ", Source: " + this.sourceName;
        }
        return str;
    }

    public int hashCode() {
        return Objects.hash(this.dataType, this.dataMeasurementType, this.value, this.sourceName);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SiteDataValue that = (SiteDataValue)o;
        return Objects.equals(this.dataType, that.dataType) && Objects.equals(this.dataMeasurementType, that.dataMeasurementType) && Objects.equals(this.value, that.value) && Objects.equals(this.sourceName, that.sourceName);
    }

    @Override
    public Element toXMLMetadata(Element root) {
        Element elem = root.addElement(XML_METADATA_NAME);
        elem.addAttribute("type", this.dataType);
        elem.addAttribute("measurementType", this.dataMeasurementType);
        Element valEl = elem.addElement("Value");
        if (this.value instanceof String) {
            valEl.addAttribute("stringValue", this.value.toString());
        } else if (this.value instanceof Double) {
            valEl.addAttribute("doubleValue", this.value.toString());
        } else {
            throw new RuntimeException("Type '" + this.dataType + "' cannot be saved to XML!");
        }
        return root;
    }

    public static SiteDataValue<?> fromXMLMetadata(Element dataElem) {
        Object val;
        String dataType = dataElem.attributeValue("type");
        String measurementType = dataElem.attributeValue("measurementType");
        Element valEl = dataElem.element("Value");
        Attribute strAtt = valEl.attribute("stringValue");
        Attribute doubAtt = valEl.attribute("doubleValue");
        if (strAtt != null) {
            val = strAtt.getValue();
        } else if (doubAtt != null) {
            val = Double.parseDouble(doubAtt.getValue());
        } else {
            throw new RuntimeException("Type '" + dataType + "' unknown, cannot load from XML!");
        }
        return new SiteDataValue<Object>(dataType, measurementType, val);
    }
}

