/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.data.siteData.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.opensha.commons.data.siteData.OrderedSiteDataProviderList;
import org.opensha.commons.data.siteData.SiteDataValue;
import org.opensha.commons.data.siteData.gui.BatchDownloadGUI;
import org.opensha.commons.data.siteData.gui.beans.OrderedSiteDataGUIBean;
import org.opensha.commons.geo.Location;

public class SiteDataApplet
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private OrderedSiteDataGUIBean bean;
    private JTextField latField = new JTextField("34.053", 8);
    private JTextField lonField = new JTextField("-118.243", 8);
    private JButton prefButton = new JButton("View Preffered Data");
    private String prefButtonInfo = "<html>This retrieves and displays the first valid value of each data type<br>from the currently enabled data sources, in order of priority.</html>";
    private JButton allButton = new JButton("View All Available Data");
    private String allButtonInfo = "<html>This retrieves and displays all data values from the<br>currently enabled data sources, in order of priority.</html>";
    private JButton batchButton = new JButton("Batch Download");
    private String batchButtonInfo = "<html>This retrieves site data for alist of sites.</html>";
    private BatchDownloadGUI batchGUI;

    public SiteDataApplet() {
        this.bean = new OrderedSiteDataGUIBean(OrderedSiteDataProviderList.createCachedSiteDataProviderDefaults());
        this.setLayout(new BorderLayout());
        JPanel locationPanel = new JPanel();
        locationPanel.setLayout(new BoxLayout(locationPanel, 0));
        locationPanel.add(new JLabel("Latitude: "));
        locationPanel.add(this.latField);
        locationPanel.add(new JLabel("Longitude: "));
        locationPanel.add(this.lonField);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        this.prefButton.setToolTipText(this.prefButtonInfo);
        buttonPanel.add(this.prefButton);
        this.allButton.setToolTipText(this.allButtonInfo);
        buttonPanel.add(this.allButton);
        this.batchButton.setToolTipText(this.batchButtonInfo);
        buttonPanel.add(this.batchButton);
        JPanel bottomPanel = new JPanel(new BorderLayout());
        bottomPanel.add((Component)locationPanel, "North");
        bottomPanel.add((Component)buttonPanel, "South");
        this.add((Component)this.bean, "Center");
        this.add((Component)bottomPanel, "South");
        this.prefButton.addActionListener(this);
        this.allButton.addActionListener(this);
        this.batchButton.addActionListener(this);
        this.setPreferredSize(new Dimension(500, 600));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.prefButton || e.getSource() == this.allButton) {
            Location loc;
            boolean all = e.getSource() == this.allButton;
            try {
                double lat = Double.parseDouble(this.latField.getText());
                double lon = Double.parseDouble(this.lonField.getText());
                loc = new Location(lat, lon);
            }
            catch (Exception e1) {
                JOptionPane.showMessageDialog(this, "Please enter a valid location!", "Invalid location!", 0);
                return;
            }
            OrderedSiteDataProviderList list = this.bean.getProviderList();
            ArrayList<SiteDataValue<?>> datas = all ? list.getAllAvailableData(loc) : list.getBestAvailableData(loc);
            OrderedSiteDataGUIBean.showDataDisplayDialog(datas, this, loc);
        } else if (e.getSource() == this.batchButton) {
            if (this.batchGUI == null) {
                this.batchGUI = new BatchDownloadGUI(this.bean.getProviderList());
            }
            this.batchGUI.setVisible(true);
        }
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        SiteDataApplet applet = new SiteDataApplet();
        frame.setContentPane(applet);
        frame.setDefaultCloseOperation(3);
        frame.setSize(applet.getPreferredSize());
        frame.setVisible(true);
    }
}

