/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.data.siteData.impl;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.opensha.commons.data.CSVFile;
import org.opensha.commons.data.siteData.AbstractSiteData;
import org.opensha.commons.data.siteData.impl.TectonicRegime;
import org.opensha.commons.data.siteData.servlet.SiteDataServletAccessor;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationList;
import org.opensha.commons.geo.Region;
import org.opensha.commons.util.RunScript;
import org.opensha.commons.util.ServerPrefUtils;

public class STREC_DataWrapper
extends AbstractSiteData<TectonicRegime> {
    private static final boolean D = true;
    private File pythonScript;
    private SiteDataServletAccessor<TectonicRegime> accessor;
    private Region region = Region.getGlobalRegion();
    public static final String SERVLET_URL = ServerPrefUtils.SERVER_PREFS.getServletBaseURL() + "SiteData/STREC_DataWrapper";

    public STREC_DataWrapper(File pythonScript) {
        Preconditions.checkState((boolean)pythonScript.exists(), (String)"Python script doesn't exist: %s", (Object)pythonScript.getAbsolutePath());
        this.pythonScript = pythonScript;
    }

    public STREC_DataWrapper() {
        this.accessor = new SiteDataServletAccessor<TectonicRegime>(this, SERVLET_URL);
    }

    @Override
    public Region getApplicableRegion() {
        return this.region;
    }

    @Override
    public double getResolution() {
        return 0.0;
    }

    @Override
    public String getName() {
        return "STREC Tectonic Regime Wrapper";
    }

    @Override
    public String getShortName() {
        return "STREC_DataWrapper";
    }

    @Override
    public String getDataType() {
        return "Tectonic Regime";
    }

    @Override
    public String getDataMeasurementType() {
        return "Inferred";
    }

    @Override
    public Location getClosestDataLocation(Location loc) throws IOException {
        return loc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ArrayList<TectonicRegime> getValues(LocationList locs) throws IOException {
        for (int i = 0; i < locs.size(); ++i) {
            while (((Location)locs.get(i)).getLongitude() > 180.0) {
                Location loc = (Location)locs.get(i);
                locs.set(i, new Location(loc.getLatitude(), loc.getLongitude() - 360.0, loc.getDepth()));
            }
        }
        if (this.accessor != null) {
            return this.accessor.getValues(locs);
        }
        if (locs.isEmpty()) {
            return new ArrayList<TectonicRegime>();
        }
        File tempDir = null;
        ArrayList ret = null;
        try {
            tempDir = new File("/tmp/opensha_" + System.currentTimeMillis());
            tempDir.mkdir();
            System.out.println("Temp dir: " + tempDir.getAbsolutePath());
            Object args = "--csv-out";
            if (locs.size() > 1) {
                File inputFile = new File(tempDir, "input.txt");
                FileWriter fw = new FileWriter(inputFile);
                for (Location loc : locs) {
                    fw.write(loc.getLatitude() + " " + loc.getLongitude() + " " + loc.getDepth() + " 7.0\n");
                }
                fw.close();
                args = (String)args + " --batch-input " + inputFile.getAbsolutePath();
            } else {
                Location loc = (Location)locs.get(0);
                args = (String)args + " " + loc.getLatitude() + " " + loc.getLongitude() + " " + loc.getDepth() + " 7.0";
            }
            File outputFile = new File(tempDir, "output.txt");
            File runScript = new File(tempDir, "runSTREC.sh");
            FileWriter fw = new FileWriter(runScript);
            fw.write("#!/bin/bash\n");
            fw.write("\n");
            fw.write(this.pythonScript.getAbsolutePath() + " " + (String)args + " > " + outputFile.getAbsolutePath() + "\n");
            fw.close();
            String[] command = new String[]{"sh", "-c", "sh " + runScript.getAbsolutePath()};
            System.out.println("Running script: " + runScript.getAbsolutePath());
            RunScript.runScript(command);
            Preconditions.checkState((boolean)outputFile.exists());
            ret = Lists.newArrayList();
            CSVFile<String> csv = CSVFile.readFile(outputFile, false);
            for (int row = 0; row < csv.getNumRows(); ++row) {
                String regimeStr = csv.get(row, 10);
                Preconditions.checkNotNull((Object)regimeStr);
                TectonicRegime regime = TectonicRegime.forName(regimeStr.trim());
                Preconditions.checkNotNull((Object)((Object)regime), (String)"No mapping found for regime %s", (Object)regimeStr);
                ret.add(regime);
            }
            Preconditions.checkState((ret.size() == locs.size() ? 1 : 0) != 0, (Object)"Bad output size");
        }
        finally {
            if (tempDir != null) {
                System.out.println("Deleting " + tempDir.getAbsolutePath());
                FileUtils.deleteDirectory((File)tempDir);
            }
        }
        return ret;
    }

    @Override
    public TectonicRegime getValue(Location loc) throws IOException {
        LocationList locs = new LocationList();
        locs.add(loc);
        return this.getValues(locs).get(0);
    }

    @Override
    public boolean isValueValid(TectonicRegime el) {
        return el != null;
    }

    @Override
    public String getMetadata() {
        return "Java wrapper to F-E region Perl Script, updated for Garcia subregions";
    }

    public static void main(String[] args) {
        STREC_DataWrapper strec = new STREC_DataWrapper();
        LocationList locs = new LocationList();
        locs.add(new Location(28.2305, 84.7314, 8.22));
        locs.add(new Location(35.0, -118.0, 7.0));
        locs.add(new Location(35.0, -50.0, 7.0));
        for (int i = 0; i < 100; ++i) {
            double lat = 180.0 * Math.random() - 90.0;
            double lon = 360.0 * Math.random() - 180.0;
            double depth = 20.0 * Math.random();
            locs.add(new Location(lat, lon, depth));
        }
        try {
            Stopwatch watch = Stopwatch.createStarted();
            ArrayList<TectonicRegime> vals = strec.getValues(locs);
            watch.stop();
            for (int i = 0; i < locs.size(); ++i) {
                System.out.println(String.valueOf(locs.get(i)) + ": " + String.valueOf(vals.get(i)));
            }
            System.out.println("Took " + watch.elapsed(TimeUnit.SECONDS) + " s");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

