/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.data.siteData.impl;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import org.dom4j.Element;
import org.opensha.commons.data.siteData.AbstractSiteData;
import org.opensha.commons.data.siteData.servlet.SiteDataServletAccessor;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationList;
import org.opensha.commons.geo.Region;
import org.opensha.commons.util.ServerPrefUtils;
import org.opensha.commons.util.binFile.BinaryMesh2DCalculator;
import org.opensha.commons.util.binFile.GeolocatedRectangularBinaryMesh2DCalculator;

public class ThompsonVs30_2018
extends AbstractSiteData<Double> {
    public static final int nx = 4993;
    public static final int ny = 4609;
    public static final double spacingX = 0.00208333333306629;
    public static final double spacingY = 0.00208333333304404;
    public static final double startLon = -124.500000000333;
    public static final double startLat = 42.1000000003335;
    public static final boolean startBottom = false;
    public static final boolean startLeft = true;
    public static final String NAME = "Thompson VS30 Map (2018)";
    public static final String SHORT_NAME = "Thompson2018";
    public static final String SERVER_BIN_FILE = ServerPrefUtils.SERVER_PREFS.getDataDir().getAbsolutePath() + File.separator + "siteData" + File.separator + "thompson_vs30" + File.separator + "2018_01_24" + File.separator + "California_vs30_Wills15_hybrid_7p5c.flt";
    public static final String SERVLET_URL = ServerPrefUtils.SERVER_PREFS.getServletBaseURL() + "SiteData/Thompson2018";
    private Region applicableRegion;
    private RandomAccessFile file = null;
    private String fileName = null;
    private byte[] recordBuffer = null;
    private FloatBuffer floatBuff = null;
    private GeolocatedRectangularBinaryMesh2DCalculator calc = null;
    private boolean useServlet;
    private SiteDataServletAccessor<Double> servlet = null;

    public ThompsonVs30_2018() throws IOException {
        this(true, null);
    }

    public ThompsonVs30_2018(String dataFile) throws IOException {
        this(false, dataFile);
    }

    private ThompsonVs30_2018(boolean useServlet, String dataFile) throws IOException {
        this(useServlet, dataFile, new GeolocatedRectangularBinaryMesh2DCalculator(BinaryMesh2DCalculator.DataType.FLOAT, 4993, 4609, 42.1000000003335, -124.500000000333, false, true, 0.00208333333306629, 0.00208333333304404));
    }

    public ThompsonVs30_2018(String dataFile, GeolocatedRectangularBinaryMesh2DCalculator calc) throws IOException {
        this(false, dataFile, calc);
    }

    private ThompsonVs30_2018(boolean useServlet, String dataFile, GeolocatedRectangularBinaryMesh2DCalculator calc) throws IOException {
        this.useServlet = useServlet;
        this.fileName = dataFile;
        this.calc = calc;
        this.applicableRegion = calc.getApplicableRegion();
        if (useServlet) {
            this.servlet = new SiteDataServletAccessor<Double>(this, SERVLET_URL);
        } else {
            this.file = new RandomAccessFile(new File(dataFile), "r");
            this.recordBuffer = new byte[4];
            Preconditions.checkState((calc.getMaxFilePos() + (long)this.recordBuffer.length == this.file.length() ? 1 : 0) != 0, (String)"Mesh calculator and file inconsistent: calc.getMaxFilePos()=%s, file.length()=%s", (long)calc.getMaxFilePos(), (long)this.file.length());
            ByteBuffer record = ByteBuffer.wrap(this.recordBuffer);
            record.order(ByteOrder.LITTLE_ENDIAN);
            this.floatBuff = record.asFloatBuffer();
        }
        this.initDefaultVS30Params();
        this.paramList.addParameter(this.minVs30Param);
        this.paramList.addParameter(this.maxVs30Param);
    }

    @Override
    public Region getApplicableRegion() {
        return this.applicableRegion;
    }

    @Override
    public Location getClosestDataLocation(Location loc) {
        return this.calc.calcClosestLocation(loc);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getShortName() {
        return SHORT_NAME;
    }

    @Override
    public String getMetadata() {
        return "Vs30 values as described in:\n\nThompson, E.M., 2018, An Updated Vs30 Map for California with Geologic and Topographic Constraints: U.S. Geological Survey data release, https://doi.org/10.5066/F7JQ108S.\nData converted from GeoTIFF to FLT with the 'gdal_translate' linux command, GDAL 2.3.2. It has a grid spacing of 0.0020833333330551648 degrees";
    }

    @Override
    public double getResolution() {
        return 0.0020833333330551648;
    }

    @Override
    public String getDataType() {
        return "Vs30";
    }

    @Override
    public String getDataMeasurementType() {
        return "Inferred";
    }

    @Override
    public Double getValue(Location loc) throws IOException {
        if (this.useServlet) {
            return this.certifyMinMaxVs30(this.servlet.getValue(loc));
        }
        long pos = this.calc.calcClosestLocationFileIndex(loc);
        if (pos < 0L || pos > this.calc.getMaxFilePos()) {
            return Double.NaN;
        }
        this.file.seek(pos);
        this.file.read(this.recordBuffer);
        double val = this.floatBuff.get(0);
        if ((float)val <= 0.0f || Double.isNaN(val)) {
            return Double.NaN;
        }
        Preconditions.checkState((Double.isNaN(val) || val > 0.0 ? 1 : 0) != 0, (String)"Bad value! %s", (Object)val);
        double roundVal = (double)Math.round(val * 100.0) / 100.0;
        Preconditions.checkState((Double.isNaN(roundVal) || roundVal > 0.0 ? 1 : 0) != 0, (String)"Bad rounded value: %s (orig: %s)", (Object)roundVal, (Object)val);
        double boundsVal = this.certifyMinMaxVs30(roundVal);
        Preconditions.checkState((Double.isNaN(boundsVal) || boundsVal > 0.0 ? 1 : 0) != 0, (String)"Bad bounds val! %s (rounded: %s, orig %s)", (Object)boundsVal, (Object)roundVal, (Object)val);
        return roundVal;
    }

    @Override
    public ArrayList<Double> getValues(LocationList locs) throws IOException {
        if (this.useServlet) {
            ArrayList<Double> vals = this.servlet.getValues(locs);
            for (int i = 0; i < vals.size(); ++i) {
                vals.set(i, this.certifyMinMaxVs30(vals.get(i)));
            }
            return vals;
        }
        return super.getValues(locs);
    }

    @Override
    public boolean isValueValid(Double val) {
        return val != null && !Double.isNaN(val) && val > 0.0;
    }

    @Override
    protected Element addXMLParameters(Element paramsEl) {
        paramsEl.addAttribute("useServlet", "" + this.useServlet);
        paramsEl.addAttribute("fileName", this.fileName);
        return super.addXMLParameters(paramsEl);
    }

    public static ThompsonVs30_2018 fromXMLParams(Element paramsElem) throws IOException {
        boolean useServlet = Boolean.parseBoolean(paramsElem.attributeValue("useServlet"));
        String fileName = paramsElem.attributeValue("fileName");
        return new ThompsonVs30_2018(useServlet, fileName);
    }

    public static void main(String[] args) throws IOException {
        ThompsonVs30_2018 map = new ThompsonVs30_2018("/tmp/thompson_vs30/California_vs30_Wills15_hybrid_7p5c.flt");
        LocationList locs = new LocationList();
        locs.add(new Location(34.0192, -118.288));
        locs.add(new Location(34.9192, -118.32));
        locs.add(new Location(34.78192, -118.886));
        locs.add(new Location(34.2192, -118.386));
        locs.add(new Location(34.6192, -118.186));
        ArrayList<Double> vals = map.getValues(locs);
        for (double val : vals) {
            System.out.println(val);
        }
    }
}

