/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.data.siteData.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opensha.commons.data.siteData.ServletEnabledSiteData;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationList;
import org.opensha.commons.param.ParameterList;
import org.opensha.commons.util.ServerPrefUtils;

public abstract class AbstractSiteDataServlet<Element>
extends HttpServlet {
    public static String OP_GET_CLOSEST = "Get Closest Location";
    private ServletEnabledSiteData<Element> data;
    private String debugName;

    public AbstractSiteDataServlet(ServletEnabledSiteData<Element> data) {
        this.data = data;
        this.debugName = data.getShortName() + " servlet";
    }

    public AbstractSiteDataServlet() {
    }

    public void setData(ServletEnabledSiteData<Element> data) {
        this.data = data;
        this.debugName = data.getShortName() + " servlet";
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    private Location getLocation(double[] pt) {
        if (pt.length == 2) {
            return new Location(pt[0], pt[1]);
        }
        if (pt.length == 3) {
            return new Location(pt[0], pt[1], pt[2]);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.debug("Handling GET");
        ObjectInputStream in = new ObjectInputStream((InputStream)request.getInputStream());
        ObjectOutputStream out = new ObjectOutputStream((OutputStream)response.getOutputStream());
        try {
            Location loc;
            Object obj = in.readObject();
            ParameterList serverParams = this.data.getServerSideParams();
            if (serverParams != null && serverParams.size() > 0) {
                List incomingParamVals;
                if (!(obj instanceof List)) {
                    this.fail(out, this.data.getShortName() + " requires " + serverParams.size() + ", none given");
                }
                if ((incomingParamVals = (List)obj).size() != serverParams.size()) {
                    this.fail(out, this.data.getShortName() + " requires " + serverParams.size() + ", " + incomingParamVals.size() + " given");
                }
                for (int i = 0; i < serverParams.size(); ++i) {
                    serverParams.getByIndex(i).setValue(incomingParamVals.get(i));
                }
                obj = in.readObject();
            }
            if (obj instanceof Location) {
                loc = (Location)obj;
                Object e = this.data.getValue(loc);
                out.writeObject(e);
            } else if (obj instanceof LocationList) {
                LocationList locs = (LocationList)obj;
                ArrayList e = this.data.getValues(locs);
                out.writeObject(e);
            } else if (obj instanceof double[]) {
                loc = this.getLocation((double[])obj);
                if (loc == null) {
                    this.fail(out, "Invalid location!");
                }
                Object e = this.data.getValue(loc);
                out.writeObject(e);
            } else if (obj instanceof List) {
                List pts = (List)obj;
                LocationList locs = new LocationList();
                for (double[] pt : pts) {
                    Location loc2 = this.getLocation(pt);
                    if (loc2 == null) {
                        this.fail(out, "Invalid location!");
                    }
                    locs.add(loc2);
                }
                ArrayList e = this.data.getValues(locs);
                out.writeObject(e);
            } else {
                if (!(obj instanceof String)) {
                    this.fail(out, "You must give either a Location or a LocationList!");
                    return;
                }
                String op = (String)obj;
                if (!op.equals(OP_GET_CLOSEST)) {
                    this.fail(out, "Unknown operation: " + op);
                    return;
                }
                obj = in.readObject();
                if (!(obj instanceof Location)) {
                    this.fail(out, "A location must be given for closest location operation");
                    return;
                }
                Location loc3 = (Location)obj;
                Location close = this.data.getClosestDataLocation(loc3);
                out.writeObject(close);
            }
            out.flush();
            out.close();
            return;
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            this.fail(out, "Servlet Exception: " + e.getMessage());
        }
    }

    protected void fail(ObjectOutputStream out, String message) throws IOException {
        ServerPrefUtils.fail(out, this.debugName, message);
    }

    protected void debug(String message) {
        ServerPrefUtils.debug(this.debugName, message);
    }
}

