/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.data.uncertainty;

import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.commons.data.uncertainty.UncertainBoundedDiscretizedFunc;
import org.opensha.commons.data.uncertainty.UncertaintyBoundType;

public interface UncertainDiscretizedFunc
extends DiscretizedFunc {
    public DiscretizedFunc getStdDevs();

    default public double getMaxStdDev() {
        return this.getStdDevs().getMaxY();
    }

    default public double getMinStdDev() {
        return this.getStdDevs().getMinY();
    }

    default public double getStdDev(int index) {
        return this.getStdDevs().getY(index);
    }

    default public double getStdDev(double x) {
        return this.getStdDevs().getY(x);
    }

    public UncertainBoundedDiscretizedFunc estimateBounds(UncertaintyBoundType var1);

    @Override
    default public void scale(double scale) {
        throw new UnsupportedOperationException("scale not supported by underlying UncertainDiscretizedFunc implementation");
    }
}

