/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.data.uncertainty;

import com.google.common.base.Preconditions;
import org.apache.commons.math3.distribution.NormalDistribution;
import org.opensha.commons.data.uncertainty.BoundedUncertainty;

public enum UncertaintyBoundType {
    TWO_SIGMA("\u00b1 2\u03c3", 2.0),
    CONF_95("95% bounds", new NormalDistribution(0.0, 1.0).inverseCumulativeProbability(0.975)),
    ONE_SIGMA("\u00b1 \u03c3", 1.0),
    CONF_68("68% bounds", new NormalDistribution(0.0, 1.0).inverseCumulativeProbability(0.8400000000000001)),
    HALF_SIGMA("\u00b1 \u03c3/2", 0.5);

    private String label;
    public final double z;

    private UncertaintyBoundType(String label, double z) {
        this.label = label;
        Preconditions.checkState((z > 0.0 ? 1 : 0) != 0, (Object)"z must be positive");
        this.z = z;
    }

    public double estimateStdDev(double lowerBound, double upperBound) {
        Preconditions.checkState((upperBound >= lowerBound ? 1 : 0) != 0);
        return (upperBound - lowerBound) / (2.0 * this.z);
    }

    public BoundedUncertainty estimate(double bestEstimate, double stdDev) {
        return new BoundedUncertainty(this, bestEstimate - this.z * stdDev, bestEstimate + this.z * stdDev, stdDev);
    }

    public String toString() {
        return this.label;
    }

    public static void main(String[] args) {
        for (UncertaintyBoundType type : UncertaintyBoundType.values()) {
            System.out.println(type.label + "; z=" + (float)type.z);
        }
    }
}

