/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.eq.cat;

import java.lang.reflect.Array;
import java.util.EnumSet;
import org.opensha.commons.eq.cat.Catalog;
import org.opensha.commons.eq.cat.util.DataType;
import org.opensha.commons.util.DataUtils;

public class CatTools {
    public static final double MAG_MIN = -2.0;
    public static final double MAG_MAX = 10.0;

    public static final void validateMags(double[] mags) {
        DataUtils.validate(-2.0, 10.0, mags);
    }

    public static final void validateMag(double mag) {
        DataUtils.validate(-2.0, 10.0, mag);
    }

    public static final String toJSON(Catalog catalog) {
        EnumSet<DataType> types = EnumSet.of(DataType.TIME, DataType.LONGITUDE, DataType.LATITUDE, DataType.DEPTH, DataType.MAGNITUDE);
        StringBuilder json = new StringBuilder("{");
        for (DataType type : types) {
            json.append("\"" + type.toString().toLowerCase() + "s\":");
            json.append(CatTools.buildArray(catalog.getData(type)));
            json.append(type == DataType.MAGNITUDE ? "}" : ",");
        }
        return json.toString();
    }

    private static String buildArray(Object array) {
        String delim = ",";
        StringBuilder sb = new StringBuilder("[");
        int len = Array.getLength(array);
        for (int i = 0; i < len; ++i) {
            sb.append(Array.get(array, i));
            if (i == len - 1) continue;
            sb.append(delim);
        }
        sb.append("]");
        return sb.toString();
    }
}

