/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.eq.cat;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Doubles;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.apache.commons.io.IOUtils;
import org.dom4j.Element;
import org.dom4j.tree.DefaultElement;
import org.opensha.commons.eq.cat.CatTools;
import org.opensha.commons.eq.cat.Catalog;
import org.opensha.commons.eq.cat.io.CatalogReader;
import org.opensha.commons.eq.cat.io.CatalogWriter;
import org.opensha.commons.eq.cat.util.DataType;
import org.opensha.commons.geo.GeoTools;
import org.opensha.commons.util.DataUtils;

public class DefaultCatalog
implements Catalog {
    private Map<DataType, Object> dataMap;
    private boolean readable = false;
    private int size = -1;
    private Date minDate = null;
    private Date maxDate = null;
    private Map<DataType, Double> minVals = new HashMap<DataType, Double>();
    private Map<DataType, Double> maxVals = new HashMap<DataType, Double>();
    private Set<DataType> minMaxTypes = EnumSet.of(DataType.LATITUDE, DataType.LONGITUDE, DataType.DEPTH, DataType.MAGNITUDE);
    private static SimpleDateFormat eventSDF = new SimpleDateFormat("MM/dd/yyyy  HH:mm:ss  z");
    static final String XML_ELEM_CATALOG_DATA = "catalogData";
    static final String XML_ELEM_CATALOG_DATA_FIELDS = "dataFields";
    static final String XML_ELEM_CATALOG_FIELD = "field";
    static final String XML_ELEM_CATALOG_DATA_BOUNDS = "dataBounds";
    static final String XML_ELEM_CATALOG_BOUND = "bound";
    static final String EVENT_COUNT = "eventCount";
    static final String MIN_LAT = "minLat";
    static final String MAX_LAT = "maxLat";
    static final String MIN_LON = "minLon";
    static final String MAX_LON = "maxLon";
    static final String MIN_DEPTH = "minDepth";
    static final String MAX_DEPTH = "maxDepth";
    static final String MIN_MAG = "minMag";
    static final String MAX_MAG = "maxMag";
    static final String MIN_DATE = "minDate";
    static final String MAX_DATE = "maxDate";

    public DefaultCatalog() {
        this.dataMap = new HashMap<DataType, Object>();
    }

    public DefaultCatalog(File file, CatalogReader reader) throws IOException {
        this();
        Preconditions.checkNotNull((Object)file, (Object)"Supplied file is null");
        Preconditions.checkNotNull((Object)reader, (Object)"Supplied catalog reader is null");
        reader.process(file, this);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean contains(DataType type) {
        return this.dataMap.containsKey((Object)type);
    }

    public Object clone() {
        DefaultCatalog clone = new DefaultCatalog();
        for (DataType type : this.dataMap.keySet()) {
            clone.addData(type, this.duplicateArray(this.dataMap.get((Object)type)));
        }
        return clone;
    }

    protected void setReadable(boolean readable) {
        this.readable = readable;
    }

    @Override
    public boolean readable() {
        return this.readable;
    }

    @Override
    public void addData(DataType type, Object data) {
        Preconditions.checkNotNull((Object)((Object)type), (Object)"Data type is null");
        Preconditions.checkArgument((!this.contains(type) ? 1 : 0) != 0, (Object)"Catalog already contains supplied data type");
        Preconditions.checkNotNull((Object)data, (Object)"Data array is null");
        Preconditions.checkArgument((boolean)data.getClass().isArray(), (Object)"Supplied 'data' is not an array");
        Preconditions.checkArgument((boolean)type.clazz().equals(data.getClass()), (Object)"Supplied data array class is not of the required type");
        Preconditions.checkArgument((Array.getLength(data) != 0 ? 1 : 0) != 0, (Object)"Supplied data array is empty");
        Preconditions.checkArgument((Array.getLength(data) <= 800000 ? 1 : 0) != 0, (Object)"Supplied data array exceeds catalog size limit");
        if (this.size != -1) {
            Preconditions.checkArgument((Array.getLength(data) == this.size ? 1 : 0) != 0, (Object)"Supplied data array size does not match catalog size");
        }
        if (type == DataType.TIME) {
            Preconditions.checkArgument((boolean)this.checkTimesSorted((long[])data), (Object)"Event times are not sorted ascending");
        }
        if (type == DataType.LONGITUDE) {
            GeoTools.validateLons((double[])data);
        }
        if (type == DataType.LATITUDE) {
            GeoTools.validateLats((double[])data);
        }
        if (type == DataType.DEPTH) {
            GeoTools.validateDepths((double[])data);
        }
        if (type == DataType.MAGNITUDE) {
            CatTools.validateMags((double[])data);
        }
        this.runMinMax(type, data);
        this.dataMap.put(type, data);
        if (this.size == -1) {
            this.size = Array.getLength(data);
        }
    }

    @Override
    public Object getData(DataType type) {
        return this.readable ? this.dataMap.get((Object)type) : this.copyData(type);
    }

    public Object copyData(DataType type) {
        return this.duplicateArray(this.dataMap.get((Object)type));
    }

    public Set<DataType> getDataTypes() {
        return ImmutableSet.copyOf(this.dataMap.keySet());
    }

    public Object deriveData(DataType type, int[] indices) {
        if (!this.contains(type)) {
            return null;
        }
        return DataUtils.arraySelect(this.dataMap.get((Object)type), indices);
    }

    public Catalog deriveCatalog(int[] indices, Catalog catalog) {
        for (DataType type : this.dataMap.keySet()) {
            if (!this.contains(type)) continue;
            catalog.addData(type, this.deriveData(type, indices));
        }
        return catalog;
    }

    public void writeCatalog(File file, CatalogWriter writer) throws IOException {
        writer.process(this, file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Element writeCatalog(File file) throws IOException {
        Preconditions.checkNotNull((Object)file, (Object)"Supplied file is null");
        DefaultElement catData = new DefaultElement(XML_ELEM_CATALOG_DATA);
        DefaultElement fields = new DefaultElement(XML_ELEM_CATALOG_DATA_FIELDS);
        catData.add((Element)fields);
        ObjectOutputStream out = null;
        try {
            out = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
            for (DataType type : this.dataMap.keySet()) {
                DefaultElement field = new DefaultElement(XML_ELEM_CATALOG_FIELD);
                field.setText(type.toString());
                field.addAttribute("id", type.name());
                fields.add((Element)field);
                out.writeObject(this.dataMap.get((Object)type));
            }
            catData.add(this.createBoundsData());
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(out);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)out);
        return catData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readCatalog(File file, Element meta) throws IOException, ClassNotFoundException {
        Preconditions.checkNotNull((Object)file, (Object)"Supplied file is null");
        Preconditions.checkNotNull((Object)meta, (Object)"Supplied metadata is null");
        ObjectInputStream in = null;
        try {
            in = new ObjectInputStream(new BufferedInputStream(new FileInputStream(file)));
            for (Object obj : meta.elements(XML_ELEM_CATALOG_FIELD)) {
                Element e = (Element)obj;
                DataType type = Enum.valueOf(DataType.class, e.attributeValue("id"));
                this.addData(type, in.readObject());
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(in);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)in);
    }

    @Override
    public String getEventString(int index) {
        return "(M " + this.getValue(DataType.MAGNITUDE, index) + ")   " + eventSDF.format(this.getDate(index));
    }

    @Override
    public String getEventStringWithID(int index) {
        return this.getEventString(index) + "   ID:" + this.getEventID(index);
    }

    @Override
    public int getEventID(int index) {
        Preconditions.checkPositionIndex((int)index, (int)this.size, (String)"Requested index");
        Preconditions.checkState((this.dataMap.get((Object)DataType.EVENT_ID) != null ? 1 : 0) != 0, (Object)"Catalog is missing event ID values");
        return ((int[])this.dataMap.get((Object)DataType.EVENT_ID))[index];
    }

    @Override
    public long getTime(int index) {
        Preconditions.checkPositionIndex((int)index, (int)this.size, (String)"Requested index");
        return ((long[])this.dataMap.get((Object)DataType.TIME))[index];
    }

    @Override
    public Date getDate(int index) {
        return new Date(this.getTime(index));
    }

    @Override
    public Date minDate() {
        return this.minDate;
    }

    @Override
    public Date maxDate() {
        return this.maxDate;
    }

    @Override
    public double getValue(DataType type, int index) {
        Preconditions.checkNotNull((Object)((Object)type), (Object)"Data type is null");
        Preconditions.checkArgument((boolean)this.minMaxTypes.contains((Object)type), (Object)"Invalid data type");
        Preconditions.checkPositionIndex((int)index, (int)this.size, (String)"Requested index");
        Preconditions.checkState((this.dataMap.get((Object)type) != null ? 1 : 0) != 0, (String)"Catalog is missing %s values", (Object)((Object)type));
        return ((double[])this.dataMap.get((Object)type))[index];
    }

    @Override
    public double minForType(DataType type) {
        Preconditions.checkNotNull((Object)((Object)type), (Object)"Data type is null");
        Preconditions.checkArgument((boolean)this.minMaxTypes.contains((Object)type), (Object)"Invalid data type");
        Preconditions.checkState((this.dataMap.get((Object)type) != null ? 1 : 0) != 0, (String)"Catalog is missing %s values", (Object)((Object)type));
        return this.minVals.get((Object)type);
    }

    @Override
    public double maxForType(DataType type) {
        Preconditions.checkNotNull((Object)((Object)type), (Object)"Data type is null");
        Preconditions.checkArgument((boolean)this.minMaxTypes.contains((Object)type), (Object)"Invalid data type");
        Preconditions.checkState((this.dataMap.get((Object)type) != null ? 1 : 0) != 0, (String)"Catalog is missing %s values", (Object)((Object)type));
        return this.maxVals.get((Object)type);
    }

    private void runMinMax(DataType type, Object data) {
        if (type == DataType.TIME) {
            this.minDate = new Date(((long[])data)[0]);
            this.maxDate = new Date(((long[])data)[Array.getLength(data) - 1]);
        } else if (this.minMaxTypes.contains((Object)type)) {
            this.minVals.put(type, Doubles.min((double[])((double[])data)));
            this.maxVals.put(type, Doubles.max((double[])((double[])data)));
        }
    }

    private Object duplicateArray(Object data) {
        int size = Array.getLength(data);
        Object out = Array.newInstance(data.getClass().getComponentType(), size);
        System.arraycopy(data, 0, out, 0, size);
        return out;
    }

    private boolean checkTimesSorted(long[] times) {
        long[] timesCopy = (long[])this.duplicateArray(times);
        Arrays.sort(timesCopy);
        return Arrays.equals(timesCopy, times);
    }

    @Deprecated
    public static Map<String, String> getBoundsData(Element data) {
        HashMap<String, String> bounds = new HashMap<String, String>();
        for (Object obj : data.elements(XML_ELEM_CATALOG_BOUND)) {
            Element e = (Element)obj;
            bounds.put(e.attributeValue("name"), e.attributeValue("value"));
        }
        if (bounds.size() == 0) {
            return null;
        }
        return bounds;
    }

    private Element createBoundsData() {
        DefaultElement e = new DefaultElement(XML_ELEM_CATALOG_DATA_BOUNDS);
        SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss z");
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        e.addAttribute(EVENT_COUNT, Integer.toString(this.size));
        e.add(this.createBoundElement(MIN_LAT, this.minVals.get((Object)DataType.LATITUDE).toString()));
        e.add(this.createBoundElement(MAX_LAT, this.maxVals.get((Object)DataType.LATITUDE).toString()));
        e.add(this.createBoundElement(MIN_LON, this.minVals.get((Object)DataType.LONGITUDE).toString()));
        e.add(this.createBoundElement(MAX_LON, this.maxVals.get((Object)DataType.LONGITUDE).toString()));
        e.add(this.createBoundElement(MIN_DEPTH, this.minVals.get((Object)DataType.DEPTH).toString()));
        e.add(this.createBoundElement(MAX_DEPTH, this.maxVals.get((Object)DataType.DEPTH).toString()));
        e.add(this.createBoundElement(MIN_MAG, this.minVals.get((Object)DataType.MAGNITUDE).toString()));
        e.add(this.createBoundElement(MAX_MAG, this.maxVals.get((Object)DataType.MAGNITUDE).toString()));
        e.add(this.createBoundElement(MIN_DATE, sdf.format(this.minDate)));
        e.add(this.createBoundElement(MAX_DATE, sdf.format(this.maxDate)));
        return e;
    }

    private Element createBoundElement(String name, String value) {
        DefaultElement e = new DefaultElement(XML_ELEM_CATALOG_BOUND);
        e.addAttribute("name", name);
        e.addAttribute("value", value);
        return e;
    }

    static {
        eventSDF.setTimeZone(TimeZone.getTimeZone("UTC"));
    }
}

