/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.eq.cat.db;

import com.google.common.primitives.Doubles;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.TimeZone;
import org.apache.commons.lang3.StringUtils;
import org.opensha.commons.eq.cat.MutableCatalog;
import org.opensha.commons.eq.cat.io.AbstractReader;
import org.opensha.commons.eq.cat.util.DataType;

public class STP_Reader
extends AbstractReader {
    private static final String NAME = "STP (Seismic Transfer Protocol) Reader";
    private static final String DESC = "Reads ID, date, lat, lon, depth, and magnitude from STP data stream";
    private static final String STP_DATE_FORMAT = "yyyy/MM/dd,kk:mm:ss.SSS";
    private SimpleDateFormat stpDateFormat;
    private int count = 0;

    public STP_Reader(int size) {
        super(NAME, DESC, size);
        this.catalog = new MutableCatalog();
        this.stpDateFormat = new SimpleDateFormat(STP_DATE_FORMAT);
        this.stpDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.initReader();
    }

    public MutableCatalog getCatalog() {
        this.loadData();
        return (MutableCatalog)this.catalog;
    }

    @Override
    public void initReader() {
        this.count = 0;
        this.dat_eventIDs = new ArrayList(this.size);
        this.dat_dates = new ArrayList(this.size);
        this.dat_longitudes = new ArrayList(this.size);
        this.dat_latitudes = new ArrayList(this.size);
        this.dat_depths = new ArrayList(this.size);
        this.dat_magnitudes = new ArrayList(this.size);
    }

    @Override
    public void loadData() {
        this.catalog.addData(DataType.EVENT_ID, Ints.toArray((Collection)this.dat_eventIDs));
        this.catalog.addData(DataType.TIME, Longs.toArray((Collection)this.dat_dates));
        this.catalog.addData(DataType.LONGITUDE, Doubles.toArray((Collection)this.dat_longitudes));
        this.catalog.addData(DataType.LATITUDE, Doubles.toArray((Collection)this.dat_latitudes));
        this.catalog.addData(DataType.DEPTH, Doubles.toArray((Collection)this.dat_depths));
        this.catalog.addData(DataType.MAGNITUDE, Doubles.toArray((Collection)this.dat_magnitudes));
    }

    @Override
    public void parseLine(String line) {
        String[] event_dat = StringUtils.split((String)line);
        try {
            ++this.count;
            this.cal.setTime(this.stpDateFormat.parse(event_dat[2]));
            this.dat_dates.add(this.cal.getTimeInMillis());
            this.dat_eventIDs.add(Integer.parseInt(event_dat[0]));
            this.dat_longitudes.add(Double.parseDouble(event_dat[4]));
            this.dat_latitudes.add(Double.parseDouble(event_dat[3]));
            this.dat_depths.add(Double.parseDouble(event_dat[5]));
            this.dat_magnitudes.add(Double.parseDouble(event_dat[6]));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error reading catalog file format at line: " + this.count);
        }
    }
}

