/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.eq.cat.filters;

import java.util.Arrays;
import java.util.BitSet;
import java.util.EnumSet;
import java.util.Map;
import org.opensha.commons.eq.cat.CatTools;
import org.opensha.commons.eq.cat.MutableCatalog;
import org.opensha.commons.eq.cat.util.DataType;
import org.opensha.commons.geo.GeoTools;
import org.opensha.commons.util.DataUtils;

public class CatalogBrush {
    private MutableCatalog catalog;
    private EnumSet<DataType> brushables = EnumSet.of(DataType.TIME, DataType.LATITUDE, DataType.LONGITUDE, DataType.DEPTH, DataType.MAGNITUDE);
    private Map<DataType, double[]> sortedSources;
    private Map<DataType, int[]> sourceIndices;
    private Map<DataType, Integer> minCarets;
    private Map<DataType, Integer> maxCarets;
    private BitSet selectionChange;
    private BitSet selection;

    public CatalogBrush(MutableCatalog catalog) {
        this.catalog = catalog;
        this.brushables.retainAll(catalog.getDataTypes());
        this.selectionChange = new BitSet(catalog.size());
        this.selection = new BitSet(catalog.size());
        this.selection.set(0, this.selection.length());
        this.initMaps();
    }

    public BitSet selection() {
        return this.selection;
    }

    public BitSet selectionChange() {
        return this.selectionChange;
    }

    public SelectionChange adjust(LimitKey key, long value) {
        return SelectionChange.NONE;
    }

    public SelectionChange adjust(DataType type, LimitKey key, double newValue) {
        this.selectionChange.clear();
        if (!this.brushables.contains((Object)type)) {
            return SelectionChange.NONE;
        }
        if (!this.validateValue(type, newValue)) {
            return SelectionChange.NONE;
        }
        SelectionChange change = key == LimitKey.MIN ? this.adjustMin(type, newValue) : this.adjustMax(type, newValue);
        if (change == SelectionChange.ADD) {
            this.selection.or(this.selectionChange);
        } else {
            this.selection.andNot(this.selectionChange);
        }
        return change;
    }

    private SelectionChange adjustMin(DataType type, double newValue) {
        double oldValue;
        int maxCaret;
        int minCaret;
        double[] source = this.sortedSources.get((Object)type);
        int idx = CatalogBrush.calcMinCaret(source, minCaret = this.minCarets.get((Object)type).intValue(), maxCaret = this.maxCarets.get((Object)type).intValue(), oldValue = source[minCaret], newValue);
        if (idx == -1) {
            return SelectionChange.NONE;
        }
        int minSelect = idx < minCaret ? idx : minCaret;
        int maxSelect = idx < minCaret ? minCaret : idx;
        this.minCarets.put(type, idx);
        this.updateSelection(type, minSelect, maxSelect);
        return idx < minCaret || idx > maxCaret ? SelectionChange.ADD : SelectionChange.REMOVE;
    }

    private SelectionChange adjustMax(DataType type, double newValue) {
        double oldValue;
        int maxCaret;
        int minCaret;
        double[] source = this.sortedSources.get((Object)type);
        int idx = CatalogBrush.calcMaxCaret(source, minCaret = this.minCarets.get((Object)type).intValue(), maxCaret = this.maxCarets.get((Object)type).intValue(), oldValue = source[maxCaret], newValue);
        if (idx == -1) {
            return SelectionChange.NONE;
        }
        int minSelect = idx < maxCaret ? idx : maxCaret;
        int maxSelect = idx < maxCaret ? maxCaret : idx;
        this.minCarets.put(type, idx);
        this.updateSelection(type, minSelect, maxSelect);
        return idx < minCaret || idx > maxCaret ? SelectionChange.ADD : SelectionChange.REMOVE;
    }

    static int calcMinCaret(double[] data, int minCaret, int maxCaret, double oldValue, double newValue) {
        int idx;
        if (oldValue == newValue) {
            return -1;
        }
        int n = idx = newValue > oldValue ? Arrays.binarySearch(data, minCaret, maxCaret, newValue) : Arrays.binarySearch(data, 0, minCaret, newValue);
        idx = idx == -1 ? 0 : (idx < -1 ? -idx - 1 : idx);
        int n2 = idx = idx >= maxCaret ? maxCaret - 1 : idx;
        while (idx != 0 && data[idx - 1] == data[idx]) {
            --idx;
        }
        return idx == minCaret ? -1 : idx;
    }

    static int calcMaxCaret(double[] data, int minCaret, int maxCaret, double oldValue, double newValue) {
        int idx;
        if (oldValue == newValue) {
            return -1;
        }
        int n = idx = newValue > oldValue ? Arrays.binarySearch(data, maxCaret, data.length, newValue) : Arrays.binarySearch(data, minCaret, maxCaret, newValue);
        idx = idx == -1 ? 0 : (idx < -1 ? -idx - 2 : idx);
        int n2 = idx = idx <= minCaret ? minCaret : idx;
        while (idx < data.length - 1 && data[idx + 1] == data[idx]) {
            ++idx;
        }
        return idx + 1 == maxCaret ? -1 : ++idx;
    }

    private void updateSelection(DataType type, int min, int max) {
        int[] indices = this.sourceIndices.get((Object)type);
        for (int i = min; i < max; ++i) {
            this.selectionChange.flip(indices[i]);
        }
    }

    private void initMaps() {
        for (DataType type : this.brushables) {
            double[] source = (double[])this.catalog.copyData(type);
            this.sourceIndices.put(type, DataUtils.indexAndSort(source));
            this.sortedSources.put(type, source);
            this.minCarets.put(type, 0);
            this.maxCarets.put(type, this.catalog.size());
        }
    }

    private boolean validateValue(DataType type, double value) {
        try {
            switch (type) {
                case LATITUDE: {
                    GeoTools.validateLat(value);
                }
                case LONGITUDE: {
                    GeoTools.validateLon(value);
                }
                case DEPTH: {
                    GeoTools.validateDepth(value);
                }
                case MAGNITUDE: {
                    CatTools.validateMag(value);
                }
            }
        }
        catch (IllegalArgumentException iae) {
            return false;
        }
        return true;
    }

    public static enum SelectionChange {
        ADD,
        REMOVE,
        NONE;

    }

    public static enum LimitKey {
        MIN,
        MAX;

    }
}

