/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.eq.cat.io;

import com.google.common.primitives.Doubles;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import java.util.ArrayList;
import java.util.Collection;
import org.opensha.commons.eq.cat.io.AbstractReader;
import org.opensha.commons.eq.cat.util.DataType;
import org.opensha.commons.eq.cat.util.EventQuality;
import org.opensha.commons.eq.cat.util.MagnitudeType;

public class Reader_SCEDC
extends AbstractReader {
    private static final String NAME = "SCEDC Readable Format";
    private static final String DESC = "Parses a Southern California Earthquake Data Center SCEDC format catalog. Reader will gather: event ID, time, longitude, latitude, depth, location quality, magnitude, and magnitude type.";
    private int count;

    public Reader_SCEDC(int size) {
        super(NAME, DESC, size);
    }

    @Override
    public void initReader() {
        this.count = 0;
        this.dat_eventIDs = new ArrayList(this.size);
        this.dat_dates = new ArrayList(this.size);
        this.dat_longitudes = new ArrayList(this.size);
        this.dat_latitudes = new ArrayList(this.size);
        this.dat_depths = new ArrayList(this.size);
        this.dat_magnitudes = new ArrayList(this.size);
        this.dat_magnitudeTypes = new ArrayList(this.size);
        this.dat_eventQuality = new ArrayList(this.size);
    }

    @Override
    public void loadData() {
        this.catalog.addData(DataType.EVENT_ID, Ints.toArray((Collection)this.dat_eventIDs));
        this.catalog.addData(DataType.TIME, Longs.toArray((Collection)this.dat_dates));
        this.catalog.addData(DataType.LONGITUDE, Doubles.toArray((Collection)this.dat_longitudes));
        this.catalog.addData(DataType.LATITUDE, Doubles.toArray((Collection)this.dat_latitudes));
        this.catalog.addData(DataType.DEPTH, Doubles.toArray((Collection)this.dat_depths));
        this.catalog.addData(DataType.MAGNITUDE, Doubles.toArray((Collection)this.dat_magnitudes));
        this.catalog.addData(DataType.MAGNITUDE_TYPE, Ints.toArray((Collection)this.dat_magnitudeTypes));
        this.catalog.addData(DataType.QUALITY, Ints.toArray((Collection)this.dat_eventQuality));
    }

    @Override
    public void parseLine(String line) {
        try {
            ++this.count;
            if (line.startsWith("#") || line.length() < 60 || !line.substring(23, 25).equals("le")) {
                return;
            }
            this.cal.set(1, Integer.parseInt(line.substring(0, 4)));
            this.cal.set(2, Integer.parseInt(line.substring(5, 7)) - 1);
            this.cal.set(5, Integer.parseInt(line.substring(8, 10)));
            this.cal.set(11, Integer.parseInt(line.substring(11, 13)));
            this.cal.set(12, Integer.parseInt(line.substring(14, 16)));
            this.cal.set(13, Integer.parseInt(line.substring(17, 19)));
            this.cal.set(14, Integer.parseInt(line.substring(20, 22)) * 10);
            this.dat_dates.add(this.cal.getTimeInMillis());
            this.dat_magnitudes.add(Double.parseDouble(line.substring(26, 30).trim()));
            this.dat_magnitudeTypes.add(MagnitudeType.parseSCEDC(line.substring(31, 32)).id());
            this.dat_latitudes.add(Double.parseDouble(line.substring(35, 42).trim()));
            this.dat_longitudes.add(Double.parseDouble(line.substring(43, 51).trim()));
            this.dat_depths.add(Double.parseDouble(line.substring(52, 57).trim()));
            this.dat_eventQuality.add(EventQuality.parse(line.substring(58, 59)).id());
            this.dat_eventIDs.add(Integer.parseInt(line.substring(60, 68).trim()));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error reading catalog file format at line: " + this.count);
        }
    }
}

